/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.salesplan.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.salesplan.dao.SpScontractGoodsMapper;
import com.yqbsoft.laser.service.salesplan.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.salesplan.domain.SpScontractGoodsDomain;
import com.yqbsoft.laser.service.salesplan.domain.SpScontractGoodsReDomain;
import com.yqbsoft.laser.service.salesplan.model.SpScontractGoods;
import com.yqbsoft.laser.service.salesplan.service.SpScontractGoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class SpScontractGoodsServiceImpl
extends BaseServiceImpl
implements SpScontractGoodsService {
    private static final String SYS_CODE = "sp.SpScontractGoodsServiceImpl";
    private SpScontractGoodsMapper spScontractGoodsMapper;

    public void setSpScontractGoodsMapper(SpScontractGoodsMapper spScontractGoodsMapper) {
        this.spScontractGoodsMapper = spScontractGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.spScontractGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkScontractGoods(SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)spScontractGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setScontractGoodsDefault(SpScontractGoods spScontractGoods) {
        if (null == spScontractGoods) {
            return;
        }
        if (null == spScontractGoods.getDataState()) {
            spScontractGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == spScontractGoods.getGmtCreate()) {
            spScontractGoods.setGmtCreate(date);
        }
        spScontractGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)spScontractGoods.getScontractGoodsCode())) {
            spScontractGoods.setScontractGoodsCode(this.getNo(null, "SpScontractGoods", "spScontractGoods", spScontractGoods.getTenantCode()));
        }
    }

    private int getScontractGoodsMaxCode() {
        int code = 0;
        try {
            return this.spScontractGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractGoodsServiceImpl.getScontractGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setScontractGoodsUpdataDefault(SpScontractGoods spScontractGoods) {
        if (null == spScontractGoods) {
            return;
        }
        spScontractGoods.setGmtModified(this.getSysDate());
    }

    private void saveScontractGoodsModel(SpScontractGoods spScontractGoods) throws ApiException {
        if (null == spScontractGoods) {
            return;
        }
        try {
            this.spScontractGoodsMapper.insert(spScontractGoods);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.saveScontractGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveScontractGoodsBatchModel(List<SpScontractGoods> spScontractGoodsList) throws ApiException {
        if (null == spScontractGoodsList || spScontractGoodsList.isEmpty()) {
            return;
        }
        try {
            this.spScontractGoodsMapper.insertBatch(spScontractGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.saveScontractGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private SpScontractGoods getScontractGoodsModelById(Integer scontractGoodsId) {
        if (null == scontractGoodsId) {
            return null;
        }
        try {
            return this.spScontractGoodsMapper.selectByPrimaryKey(scontractGoodsId);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractGoodsServiceImpl.getScontractGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private SpScontractGoods getScontractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.spScontractGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractGoodsServiceImpl.getScontractGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delScontractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.delScontractGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.delScontractGoodsModelByCode.num");
        }
    }

    private void deleteScontractGoodsModel(Integer scontractGoodsId) throws ApiException {
        if (null == scontractGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.deleteByPrimaryKey(scontractGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.deleteScontractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.deleteScontractGoodsModel.num");
        }
    }

    private void updateScontractGoodsModel(SpScontractGoods spScontractGoods) throws ApiException {
        if (null == spScontractGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.updateByPrimaryKey(spScontractGoods);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.updateScontractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.updateScontractGoodsModel.num");
        }
    }

    private void updateNumScontractGoodsModel(Integer scontractGoodsId, BigDecimal goodsNum, BigDecimal oldGoodsNum, Map<String, Object> expmap) {
        if (null == scontractGoodsId || null == goodsNum) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scontractGoodsId", scontractGoodsId);
        map.put("goodsNum", goodsNum);
        map.put("oldGoodsNum", oldGoodsNum);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.updateNumByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.updateNumScontractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.updateNumScontractGoodsModel.null");
        }
    }

    private void updateStateScontractGoodsModel(Integer scontractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == scontractGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scontractGoodsId", scontractGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.updateStateScontractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.updateStateScontractGoodsModel.null");
        }
    }

    private void updateStateScontractGoodsModelByCode(String tenantCode, String scontractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)scontractGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractGoodsCode", scontractGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.updateStateScontractGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.updateStateScontractGoodsModelByCode.null");
        }
    }

    private SpScontractGoods makeScontractGoods(SpScontractGoodsDomain spScontractGoodsDomain, SpScontractGoods spScontractGoods) {
        if (null == spScontractGoodsDomain) {
            return null;
        }
        if (null == spScontractGoods) {
            spScontractGoods = new SpScontractGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)spScontractGoods, (Object)spScontractGoodsDomain);
            return spScontractGoods;
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractGoodsServiceImpl.makeScontractGoods", (Throwable)e);
            return null;
        }
    }

    private SpScontractGoodsReDomain makeSpScontractGoodsReDomain(SpScontractGoods spScontractGoods) {
        if (null == spScontractGoods) {
            return null;
        }
        SpScontractGoodsReDomain spScontractGoodsReDomain = new SpScontractGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)spScontractGoodsReDomain, (Object)spScontractGoods);
            return spScontractGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractGoodsServiceImpl.makeSpScontractGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SpScontractGoods> queryScontractGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.spScontractGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractGoodsServiceImpl.queryScontractGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countScontractGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractGoodsServiceImpl.countScontractGoods", (Throwable)e);
        }
        return i;
    }

    private SpScontractGoods createSpScontractGoods(SpScontractGoodsDomain spScontractGoodsDomain) {
        String msg = this.checkScontractGoods(spScontractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.saveScontractGoods.checkScontractGoods", msg);
        }
        SpScontractGoods spScontractGoods = this.makeScontractGoods(spScontractGoodsDomain, null);
        this.setScontractGoodsDefault(spScontractGoods);
        return spScontractGoods;
    }

    @Override
    public String saveScontractGoods(SpScontractGoodsDomain spScontractGoodsDomain) throws ApiException {
        SpScontractGoods spScontractGoods = this.createSpScontractGoods(spScontractGoodsDomain);
        this.saveScontractGoodsModel(spScontractGoods);
        return spScontractGoods.getScontractGoodsCode();
    }

    @Override
    public String saveScontractGoodsBatch(List<SpScontractGoodsDomain> spScontractGoodsDomainList) throws ApiException {
        if (null == spScontractGoodsDomainList || spScontractGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SpScontractGoods> spScontractGoodsList = new ArrayList<SpScontractGoods>();
        String code = "";
        for (SpScontractGoodsDomain spScontractGoodsDomain : spScontractGoodsDomainList) {
            SpScontractGoods spScontractGoods = this.createSpScontractGoods(spScontractGoodsDomain);
            code = spScontractGoods.getScontractGoodsCode();
            spScontractGoodsList.add(spScontractGoods);
        }
        this.saveScontractGoodsBatchModel(spScontractGoodsList);
        return code;
    }

    @Override
    public void updateScontractGoodsState(Integer scontractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == scontractGoodsId) {
            return;
        }
        this.updateStateScontractGoodsModel(scontractGoodsId, dataState, oldDataState, map);
    }

    @Override
    public String updateScontractGoodsNum(String ocContractBillCode, String tenantCode, Integer type) throws ApiException {
        QueryResult queryResutl;
        HashMap<String, String> qMap;
        if (StringUtils.isBlank((String)ocContractBillCode)) {
            this.logger.error("sp.SpScontractGoodsServiceImpl.updateScontractGoodsNum.ocContractBillCode");
            return "error";
        }
        this.logger.error("sp.SpScontractGoodsServiceImpl.updateScontractGoodsNum.ocContractBillCode", (Object)("ocContractBillCode:" + ocContractBillCode + "tenantCode:" + tenantCode + "type" + type));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        List queryList = null;
        if (type != null && (type / 10 == 0 || type / 10 == 2)) {
            dataMap.put("contractBillcode", ocContractBillCode);
            dataMap.put("tenantCode", tenantCode);
            qMap = new HashMap<String, String>();
            qMap.put("map", JsonUtil.buildNormalBinder().toJson(dataMap));
            queryList = (List)this.readObj("oc.contract.queryContractGoodsPageByBillCode", qMap, "list", new Object[]{OcContractGoodsDomain.class});
        } else if (type != null && type / 10 == 3) {
            dataMap.put("sendgoodsCode", ocContractBillCode);
            dataMap.put("tenantCode", tenantCode);
            qMap = new HashMap();
            qMap.put("map", JsonUtil.buildNormalBinder().toJson(dataMap));
            queryResutl = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", qMap, OcContractGoodsDomain.class);
            this.logger.error("updateScontractGoodsNum.queryResutl=========", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryResutl));
            queryList = queryResutl.getList();
        } else if (type != null && type / 10 == 1) {
            dataMap.put("refundCode", ocContractBillCode);
            dataMap.put("tenantCode", tenantCode);
            qMap = new HashMap();
            qMap.put("map", JsonUtil.buildNormalBinder().toJson(dataMap));
            queryResutl = this.getQueryResutl("oc.refund.queryRefundGoodsPage", qMap, OcContractGoodsDomain.class);
            queryList = queryResutl.getList();
        }
        if (ListUtil.isEmpty(queryList)) {
            this.logger.error("sp.SpScontractGoodsServiceImpl.updateScontractGoodsNum.queryList", (Object)JsonUtil.buildNormalBinder().toJson(dataMap));
            return "error";
        }
        boolean sendFlag = false;
        if (type / 10 == 1) {
            String contractBillcode = ((OcContractGoodsDomain)queryList.get(0)).getContractBillcode();
            dataMap.put("sendgoodsCode", contractBillcode);
            HashMap<String, String> qMap2 = new HashMap<String, String>();
            qMap2.put("map", JsonUtil.buildNormalBinder().toJson(dataMap));
            QueryResult queryResutl2 = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", qMap2, OcContractGoodsDomain.class);
            if (queryResutl2 != null && CollectionUtils.isNotEmpty((Collection)queryResutl2.getList())) {
                sendFlag = true;
            }
            dataMap = new HashMap();
            dataMap.put("contractBillcode", contractBillcode);
            qMap2 = new HashMap();
            qMap2.put("map", JsonUtil.buildNormalBinder().toJson(dataMap));
            queryResutl2 = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", qMap2, OcContractGoodsDomain.class);
            if (queryResutl2 != null && CollectionUtils.isNotEmpty((Collection)queryResutl2.getList())) {
                sendFlag = true;
            }
        }
        for (OcContractGoodsDomain goodsDomain : queryList) {
            String skuCode = goodsDomain.getSkuCode();
            String goodsContract = goodsDomain.getGoodsContract();
            String ginfoCode = goodsDomain.getGinfoCode();
            if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)goodsContract) || StringUtils.isBlank((String)ginfoCode)) {
                this.logger.error("sp.SpScontractGoodsServiceImpl.updateScontractGoodsNum.isnull", (Object)("skuCode:" + skuCode + "goodsContract:" + goodsContract + "ginfoCode:" + ginfoCode));
                continue;
            }
            HashMap<String, Object> queryMap = new HashMap<String, Object>();
            queryMap.put("skuCode", skuCode);
            queryMap.put("ginfoCode", ginfoCode);
            queryMap.put("scontractCode", goodsContract);
            queryMap.put("tenantCode", goodsDomain.getTenantCode());
            List<SpScontractGoods> spScontractGoods = this.queryScontractGoodsModelPage(queryMap);
            if (ListUtil.isEmpty(spScontractGoods) || spScontractGoods.size() == 0) continue;
            if (type == 0 && StringUtils.equals((CharSequence)"2", (CharSequence)goodsDomain.getPricesetCurrency1())) {
                this.logger.error("sp.SpScontractGoodsServiceImpl.updateScontractGoodsNum.pricesetCurrency1", (Object)("contractGoodsCode:" + goodsDomain.getContractGoodsCode() + "pricesetCurrency1" + goodsDomain.getPricesetCurrency1()));
                continue;
            }
            if (type == 34 && !StringUtils.equals((CharSequence)"2", (CharSequence)goodsDomain.getPricesetCurrency1())) {
                this.logger.error("sp.SpScontractGoodsServiceImpl.updateScontractGoodsNum.pricesetCurrency1", (Object)("contractGoodsCode:" + goodsDomain.getContractGoodsCode() + "pricesetCurrency1" + goodsDomain.getPricesetCurrency1()));
                continue;
            }
            SpScontractGoods scontractGoods = spScontractGoods.get(0);
            BigDecimal goodsNum = goodsDomain.getGoodsNum();
            HashMap<String, Object> expmap = new HashMap<String, Object>();
            if (type / 10 == 1 && sendFlag) {
                goodsNum = goodsDomain.getRefundGoodsNum();
                expmap.put("goodsRefnum", goodsNum);
                goodsNum = BigDecimal.ZERO.subtract(goodsNum);
            }
            if (type / 10 == 2) {
                goodsNum = BigDecimal.ZERO.subtract(goodsNum);
            }
            if (type == 0) {
                expmap.put("goodsCamount", goodsNum);
            } else if (type / 10 == 3) {
                expmap.put("goodsCamount", goodsNum);
            }
            this.updateNumScontractGoodsModel(scontractGoods.getScontractGoodsId(), goodsNum, scontractGoods.getGoodsSupplynum(), expmap);
        }
        return "success";
    }

    @Override
    public void updateScontractGoodsStateByCode(String tenantCode, String scontractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)scontractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateScontractGoodsModelByCode(tenantCode, scontractGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateScontractGoods(SpScontractGoodsDomain spScontractGoodsDomain) throws ApiException {
        String msg = this.checkScontractGoods(spScontractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.updateScontractGoods.checkScontractGoods", msg);
        }
        SpScontractGoods oldSpScontractGoods = this.getScontractGoodsModelById(spScontractGoodsDomain.getScontractGoodsId());
        if (null == oldSpScontractGoods) {
            throw new ApiException("sp.SpScontractGoodsServiceImpl.updateScontractGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SpScontractGoods spScontractGoods = this.makeScontractGoods(spScontractGoodsDomain, oldSpScontractGoods);
        this.setScontractGoodsUpdataDefault(spScontractGoods);
        this.updateScontractGoodsModel(spScontractGoods);
    }

    @Override
    public SpScontractGoods getScontractGoods(Integer scontractGoodsId) {
        if (null == scontractGoodsId) {
            return null;
        }
        return this.getScontractGoodsModelById(scontractGoodsId);
    }

    @Override
    public void deleteScontractGoods(Integer scontractGoodsId) throws ApiException {
        if (null == scontractGoodsId) {
            return;
        }
        this.deleteScontractGoodsModel(scontractGoodsId);
    }

    @Override
    public QueryResult<SpScontractGoods> queryScontractGoodsPage(Map<String, Object> map) {
        List<SpScontractGoods> spScontractGoodsList = this.queryScontractGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countScontractGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(spScontractGoodsList);
        return queryResult;
    }

    @Override
    public SpScontractGoods getScontractGoodsByCode(String tenantCode, String scontractGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)scontractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractGoodsCode", scontractGoodsCode);
        return this.getScontractGoodsModelByCode(map);
    }

    @Override
    public void deleteScontractGoodsByCode(String tenantCode, String scontractGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)scontractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractGoodsCode", scontractGoodsCode);
        this.delScontractGoodsModelByCode(map);
    }
}

