/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.yqbsoft.laser.service.esb.annotation.ApiMethod;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.searchengine.SearchengineConstants;
import com.yqbsoft.laser.service.searchengine.domain.AccurateQueryDomain;
import com.yqbsoft.laser.service.searchengine.domain.DataHits;
import com.yqbsoft.laser.service.searchengine.domain.EsBean;
import com.yqbsoft.laser.service.searchengine.domain.PmPromotionDomain;
import com.yqbsoft.laser.service.searchengine.domain.PmPromotionInDomain;
import com.yqbsoft.laser.service.searchengine.domain.PmPromotionRangelistDomain;
import com.yqbsoft.laser.service.searchengine.domain.RestBean;
import com.yqbsoft.laser.service.searchengine.domain.ReturnBean;
import com.yqbsoft.laser.service.searchengine.domain.SearchDomain;
import com.yqbsoft.laser.service.searchengine.domain.SortDomain;
import com.yqbsoft.laser.service.searchengine.domain.StoreDomain;
import com.yqbsoft.laser.service.searchengine.enums.ConstantEnums;
import com.yqbsoft.laser.service.searchengine.es.EsEnginePollThread;
import com.yqbsoft.laser.service.searchengine.es.EsEnginePutThread;
import com.yqbsoft.laser.service.searchengine.es.EsEngineService;
import com.yqbsoft.laser.service.searchengine.index.StoreEnum;
import com.yqbsoft.laser.service.searchengine.service.SearchengineService;
import com.yqbsoft.laser.service.searchengine.util.EsUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchengineServiceImpl
extends BaseServiceImpl
implements SearchengineService {
    private static final String SYS_CODE = "es.SearchengineServiceImpl";
    @Autowired
    EsUtil esUtil;
    private static EsEngineService esEngineService;
    private static Object lock;

    private static Collection<String> list2string(List<String> params, boolean flag) {
        if (ListUtil.isEmpty(params)) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String s : params) {
            if (StringUtils.isBlank((String)s) || "null".equals(s)) continue;
            if (!flag && null != s) {
                s = s.toLowerCase();
            }
            res.add(s);
        }
        return res;
    }

    @Override
    public boolean storeBatch(List<StoreDomain> storeDomainList) throws ApiException {
        if (ListUtil.isEmpty(storeDomainList)) {
            this.logger.error("es.SearchengineServiceImpl.storeBatch", (Object)"isnull");
            return false;
        }
        try {
            long start = System.currentTimeMillis();
            boolean flag = this.esUtil.bluk(storeDomainList);
            this.logger.info("es.SearchengineServiceImpl.storeBatch.\u8017\u65f6", (Object)(System.currentTimeMillis() - start));
            return flag;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.storeBatch.storeDomainList", (Object)JsonUtil.buildNormalBinder().toJson(storeDomainList));
            this.logger.error("es.SearchengineServiceImpl.storeBatch", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReturnBean findPolymerization(SearchDomain searchDomain) throws ApiException {
        ArrayList<Object> boolList;
        void var15_27;
        int from;
        if (null == searchDomain || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.findPolymerization.null", (Object)"null");
            return null;
        }
        String data = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("es.SearchengineServiceImpl.findPolymerization.data", (Object)"data");
            return null;
        }
        Map<String, Object> pageMap = searchDomain.getPageMap();
        Integer rows = 10;
        Integer page = 1;
        if (null != pageMap && !pageMap.isEmpty()) {
            rows = Integer.parseInt(pageMap.get("rows").toString());
            page = Integer.parseInt(pageMap.get("page").toString());
        }
        if (null == rows || rows == 0) {
            rows = 10;
        }
        if (null == page) {
            page = 1;
        }
        if ((from = (Integer.valueOf(page) - 1) * Integer.valueOf(rows)) < 0) {
            from = 0;
        }
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.from(from);
        builder.size(rows.intValue());
        if (null != searchDomain.getSortDomain()) {
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getSortField())) {
                builder.sort(SortBuilders.fieldSort((String)searchDomain.getSortDomain().getSortField()).order(SortOrder.fromString((String)searchDomain.getSortDomain().getOrder())));
            }
            if (null != searchDomain.getSortDomain() && ListUtil.isNotEmpty(searchDomain.getSortDomain().getSortDomainList())) {
                for (SortDomain sortDomain : searchDomain.getSortDomain().getSortDomainList()) {
                    builder.sort(SortBuilders.fieldSort((String)sortDomain.getSortField()).order(SortOrder.fromString((String)sortDomain.getOrder())));
                }
            }
        } else {
            builder.sort("_score", SortOrder.DESC);
        }
        BoolQueryBuilder matchQueryBuilder = null;
        ArrayList<Object> matchQueryBuilderList = null;
        if (null != searchDomain.getBoolMap() && !searchDomain.getBoolMap().isEmpty()) {
            Object obj = null;
            ArrayList<MatchPhraseQueryBuilder> match_phraseList = new ArrayList<MatchPhraseQueryBuilder>();
            ArrayList<WildcardQueryBuilder> wildcardList = new ArrayList<WildcardQueryBuilder>();
            ArrayList<MatchQueryBuilder> matchList = new ArrayList<MatchQueryBuilder>();
            for (String string : searchDomain.getBoolMap().keySet()) {
                obj = searchDomain.getBoolMap().get(string);
                if ("match_phrase".equals(searchDomain.getSearchType())) {
                    match_phraseList.add(QueryBuilders.matchPhraseQuery((String)string, (Object)obj));
                    continue;
                }
                wildcardList.add(QueryBuilders.wildcardQuery((String)(string + ".keyword"), (String)("*" + obj + "*")));
                matchList.add(QueryBuilders.matchQuery((String)(string + ".keyword"), (Object)obj));
            }
            if ("match_phrase".equals(searchDomain.getSearchType())) {
                if (StringUtils.isNotBlank((String)searchDomain.getShouldFlag())) {
                    matchQueryBuilder = QueryBuilders.boolQuery();
                    matchQueryBuilder.should().addAll(match_phraseList);
                } else {
                    matchQueryBuilderList = new ArrayList<Object>();
                    matchQueryBuilderList.addAll(wildcardList);
                    matchQueryBuilderList.addAll(matchList);
                }
            } else {
                matchQueryBuilder = QueryBuilders.boolQuery();
                matchQueryBuilder.should().addAll(wildcardList);
                matchQueryBuilder.should().addAll(matchList);
            }
        }
        ArrayList<RangeQueryBuilder> priceRangeQueryBuilderList = null;
        if (null != searchDomain.getMinPrice()) {
            priceRangeQueryBuilderList = new ArrayList<RangeQueryBuilder>();
            RangeQueryBuilder priceRangeQueryBuilder = QueryBuilders.rangeQuery((String)"pricesetNprice").gte((Object)searchDomain.getMinPrice());
            if (null != searchDomain.getMaxPrice()) {
                priceRangeQueryBuilder.lte((Object)searchDomain.getMaxPrice());
            }
            priceRangeQueryBuilderList.add(priceRangeQueryBuilder);
        }
        RangeQueryBuilder numRangeQueryBuilder = null;
        if (null != searchDomain.getMinNum() || null != searchDomain.getMaxNum()) {
            numRangeQueryBuilder = QueryBuilders.rangeQuery((String)"goodsSupplynum");
            if (null != searchDomain.getMinNum()) {
                numRangeQueryBuilder.gt((Object)searchDomain.getMinNum());
            }
            if (null != searchDomain.getMaxNum()) {
                numRangeQueryBuilder.lt((Object)searchDomain.getMaxNum());
            }
        }
        if (null != numRangeQueryBuilder) {
            priceRangeQueryBuilderList.add(numRangeQueryBuilder);
        }
        ArrayList<Object> accqueryList = new ArrayList<Object>();
        ArrayList<Object> buyAccqueryList = new ArrayList<Object>();
        if (null != searchDomain.getAccurateQueryList() && !searchDomain.getAccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getAccurateQueryList()) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    accqueryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                accqueryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        if (1 == searchDomain.getGoodsBuyType()) {
            buyAccqueryList.addAll(accqueryList);
            accqueryList.add(QueryBuilders.termQuery((String)"goodsBuyType", (int)0));
            buyAccqueryList.add(QueryBuilders.termQuery((String)"goodsBuyType", (int)1));
            if (ListUtil.isNotEmpty(searchDomain.getGoodsBuyCodeStr())) {
                buyAccqueryList.add(QueryBuilders.termsQuery((String)"goodsBuyCodeStr.keyword", SearchengineServiceImpl.list2string(searchDomain.getGoodsBuyCodeStr(), true)));
            }
        }
        ArrayList<Object> notaccqueryList = new ArrayList<Object>();
        if (null != searchDomain.getNotaccurateQueryList() && !searchDomain.getNotaccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getNotaccurateQueryList()) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    notaccqueryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                notaccqueryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        AggregationBuilder aggregationBuilder = null;
        if (MapUtil.isNotEmpty(searchDomain.getGroupListMap()) || MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
            if (MapUtil.isNotEmpty(searchDomain.getGroupListMap())) {
                if (this.isCsCliProductPool(searchDomain.getGroupListMap())) {
                    AggregationBuilder aggregationBuilder2 = this.queryCsCliProductPool(aggregationBuilder);
                } else {
                    String value = "20";
                    for (String key : searchDomain.getGroupListMap().keySet()) {
                        void var15_22;
                        value = String.valueOf(searchDomain.getGroupListMap().get(key));
                        if (null == var15_22) {
                            TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)key).field(key + ".keyword")).size(Integer.valueOf(value).intValue());
                            continue;
                        }
                        AggregationBuilder aggregationBuilder3 = var15_22.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)key).field(key + ".keyword")).size(Integer.valueOf(value).intValue()));
                    }
                }
            }
            if (MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
                for (String key : searchDomain.getGroupNumMap().keySet()) {
                    void var15_30;
                    if (null == var15_27) {
                        ValuesSourceAggregationBuilder valuesSourceAggregationBuilder = AggregationBuilders.min((String)(key + "min")).field(key);
                    } else {
                        AggregationBuilder aggregationBuilder4 = var15_27.subAggregation((AggregationBuilder)AggregationBuilders.min((String)(key + "min")).field(key));
                    }
                    AggregationBuilder aggregationBuilder7 = var15_30.subAggregation((AggregationBuilder)AggregationBuilders.max((String)(key + "max")).field(key));
                    aggregationBuilder7 = aggregationBuilder7.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)(key + "avg")).field(key));
                    aggregationBuilder7 = aggregationBuilder7.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)(key + "sum")).field(key));
                }
            }
        }
        String queryWay = ConstantEnums.must.getCode();
        if (StringUtils.isNotBlank((String)searchDomain.getQueryType())) {
            queryWay = searchDomain.getQueryType();
        }
        CollapseBuilder collapseBuilder = null;
        String collapseStr = searchDomain.getCollapseStr();
        if (StringUtils.isNotBlank((String)collapseStr)) {
            collapseBuilder = new CollapseBuilder(collapseStr);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (ListUtil.isNotEmpty(accqueryList)) {
            boolList = new ArrayList<Object>();
            BoolQueryBuilder ccboolQueryBuilder = QueryBuilders.boolQuery();
            BoolQueryBuilder cboolQueryBuilder = QueryBuilders.boolQuery();
            if (ConstantEnums.must.getCode().equals(queryWay)) {
                ccboolQueryBuilder.must().addAll(accqueryList);
                if (null != matchQueryBuilder) {
                    ccboolQueryBuilder.must().add(matchQueryBuilder);
                } else if (null != matchQueryBuilderList) {
                    ccboolQueryBuilder.must().addAll(matchQueryBuilderList);
                }
                if (ListUtil.isNotEmpty(priceRangeQueryBuilderList)) {
                    ccboolQueryBuilder.must().addAll(priceRangeQueryBuilderList);
                }
            } else {
                ccboolQueryBuilder.mustNot().addAll(accqueryList);
                if (null != matchQueryBuilder) {
                    ccboolQueryBuilder.mustNot().add(matchQueryBuilder);
                } else if (null != matchQueryBuilderList) {
                    ccboolQueryBuilder.mustNot().addAll(matchQueryBuilderList);
                }
                if (ListUtil.isNotEmpty(priceRangeQueryBuilderList)) {
                    ccboolQueryBuilder.mustNot().addAll(priceRangeQueryBuilderList);
                }
            }
            if (ListUtil.isNotEmpty(notaccqueryList)) {
                ccboolQueryBuilder.mustNot().addAll(notaccqueryList);
            }
            if (ListUtil.isNotEmpty(buyAccqueryList)) {
                BoolQueryBuilder cc1boolQueryBuilder = QueryBuilders.boolQuery();
                if (ConstantEnums.must.getCode().equals(queryWay)) {
                    cc1boolQueryBuilder.must().addAll(buyAccqueryList);
                    if (null != matchQueryBuilder) {
                        cc1boolQueryBuilder.must().add(matchQueryBuilder);
                    } else if (null != matchQueryBuilderList) {
                        cc1boolQueryBuilder.must().addAll(matchQueryBuilderList);
                    }
                    if (ListUtil.isNotEmpty(priceRangeQueryBuilderList)) {
                        cc1boolQueryBuilder.must().addAll(priceRangeQueryBuilderList);
                    }
                } else {
                    cc1boolQueryBuilder.mustNot().addAll(buyAccqueryList);
                    if (null != matchQueryBuilder) {
                        cc1boolQueryBuilder.mustNot().add(matchQueryBuilder);
                    } else if (null != matchQueryBuilderList) {
                        cc1boolQueryBuilder.mustNot().addAll(matchQueryBuilderList);
                    }
                    if (ListUtil.isNotEmpty(priceRangeQueryBuilderList)) {
                        cc1boolQueryBuilder.mustNot().addAll(priceRangeQueryBuilderList);
                    }
                }
                if (ListUtil.isNotEmpty(notaccqueryList)) {
                    cc1boolQueryBuilder.mustNot().addAll(notaccqueryList);
                }
                cboolQueryBuilder.should().add(cc1boolQueryBuilder);
            }
            cboolQueryBuilder.should().add(ccboolQueryBuilder);
            boolList.add(cboolQueryBuilder);
            boolQueryBuilder.must().addAll(boolList);
        } else {
            boolList = new ArrayList();
            if (null != matchQueryBuilder) {
                boolList.add(matchQueryBuilder);
            } else if (null != matchQueryBuilderList) {
                boolList.addAll(matchQueryBuilderList);
            }
            if (ListUtil.isNotEmpty(priceRangeQueryBuilderList)) {
                boolList.addAll(priceRangeQueryBuilderList);
            }
            if (ListUtil.isNotEmpty(notaccqueryList)) {
                boolQueryBuilder.mustNot().addAll(notaccqueryList);
            }
            if (ConstantEnums.must.getCode().equals(queryWay)) {
                boolQueryBuilder.must().addAll(boolList);
            } else {
                boolQueryBuilder.mustNot().addAll(boolList);
            }
        }
        if (StringUtils.isNotBlank((String)searchDomain.getCondition())) {
            ReturnBean returnBean;
            String bizType = searchDomain.getBizType();
            if (bizType.equals("sku")) {
                BoolQueryBuilder boolQueryBuilder1 = this.makeSkuFindPolymerization(searchDomain);
                if (null != boolQueryBuilder1) {
                    this.logger.info("es.SearchengineServiceImpl.findPolymerization.colorNumber.\u6761\u4ef6", (Object)searchDomain.getColorNumber());
                    if (StringUtils.isBlank((String)searchDomain.getColorNumber())) {
                        boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"skuShowno"));
                    }
                    boolQueryBuilder.filter((QueryBuilder)boolQueryBuilder1);
                } else {
                    returnBean = new ReturnBean();
                    this.logger.error("es.SearchengineServiceImpl.findPolymerization.boolQueryBuilder1", (Object)"isnull");
                    return returnBean;
                }
            }
            if (bizType.equals("goods")) {
                BoolQueryBuilder boolQueryBuilder2 = this.makeGoodsFindPolymerization(searchDomain);
                if (null != boolQueryBuilder2) {
                    boolQueryBuilder.filter((QueryBuilder)boolQueryBuilder2);
                } else {
                    returnBean = new ReturnBean();
                    this.logger.error("es.SearchengineServiceImpl.findPolymerization.boolQueryBuilder2", (Object)"isnull");
                    return returnBean;
                }
            }
        }
        builder.query((QueryBuilder)boolQueryBuilder);
        if (null != var15_27) {
            builder.aggregation((AggregationBuilder)var15_27);
        }
        if (null == collapseBuilder) {
            builder.collapse(collapseBuilder);
        }
        SearchResponse searchResponse = null;
        try {
            long times = System.currentTimeMillis();
            this.logger.info("es.SearchengineServiceImpl.findPolymerization.searchResponse.\u6761\u4ef6", (Object)("TenantCode:" + data + "-type:" + searchDomain.getBizType() + "-" + builder));
            searchResponse = this.esUtil.queryEs(data, searchDomain.getBizType(), builder);
            OpenPerfLogUtil.info((String)("[find]htt:{},api:" + searchDomain.getBizType()), (long)(System.currentTimeMillis() - times));
            if (null == searchResponse || null == searchResponse.getHits()) {
                this.logger.error("es.SearchengineServiceImpl.findPolymerization.searchResponse");
                searchResponse = this.esUtil.queryEs(data, searchDomain.getBizType(), builder);
                if (null == searchResponse || null == searchResponse.getHits()) {
                    this.logger.error("es.SearchengineServiceImpl.findPolymerization.searchResponse111");
                    return null;
                }
            }
            if (null == searchResponse.getHits().getHits()) {
                this.logger.info("es.SearchengineServiceImpl.findPolymerization.hits");
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            SearchHit[] list = searchResponse.getHits().getHits();
            if (null == list || list.length <= 0) {
                return null;
            }
            ArrayList<Map<String, Object>> sourcelist = new ArrayList<Map<String, Object>>();
            for (SearchHit dataHits : list) {
                HashMap<String, Float> dataHit = new HashMap<String, Float>();
                try {
                    BeanUtils.copyAllPropertys(dataHit, (Object)dataHits.getSourceAsMap());
                    dataHit.put("score", Float.valueOf(dataHits.getScore()));
                }
                catch (Exception e) {
                    this.logger.error(SYS_CODE, (Object)"findPolymerization search response convert exception:", (Throwable)e);
                }
                sourcelist.add(dataHit);
            }
            if (null != searchResponse.getAggregations() && MapUtil.isNotEmpty((Map)searchResponse.getAggregations().getAsMap())) {
                returnBean.setAggregations((Map)JSON.parseObject((String)JSON.toJSONString((Object)searchResponse.getAggregations().getAsMap()), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]));
            }
            returnBean.setSourcelist(sourcelist);
            returnBean.setCount(Integer.valueOf(String.valueOf(searchResponse.getHits().getTotalHits().value)));
            returnBean.setPage(page);
            returnBean.setRow(rows);
            return returnBean;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.findPolymerization.e", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public BoolQueryBuilder makeSkuFindPolymerization(SearchDomain searchDomain) {
        if (null == searchDomain) {
            this.logger.error("es.SearchengineServiceImpl.makeFindPolymerization.e", (Object)"isnull");
            return null;
        }
        String condition = searchDomain.getCondition();
        Map jsonToMap = (Map)JSONObject.parseObject((String)condition, (TypeReference)new TypeReference<Map<String, List<String>>>(){}, (Feature[])new Feature[0]);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            this.logger.error("es.SearchengineServiceImpl.makeFindPolymerization.jsonToMap", (Object)condition);
            return null;
        }
        List goodShownoList = (List)jsonToMap.get("goodShownoList");
        List goodShownoNotList = (List)jsonToMap.get("goodShownoNotList");
        ArrayList<Object> goodsShownoqueryList = new ArrayList<Object>();
        if (ListUtil.isNotEmpty((Collection)goodShownoList)) {
            ArrayList<AccurateQueryDomain> goodsShownoList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain3 = new AccurateQueryDomain();
            accurateQueryDomain3.setAccurateField("goodsShowno.keyword");
            accurateQueryDomain3.setAccurateFieldValues(goodShownoList);
            goodsShownoList.add(accurateQueryDomain3);
            for (AccurateQueryDomain accurateQueryDomain : goodsShownoList) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    goodsShownoqueryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                goodsShownoqueryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        ArrayList<Object> goodsShownoNotqueryList = new ArrayList<Object>();
        if (ListUtil.isNotEmpty((Collection)goodShownoNotList)) {
            ArrayList<AccurateQueryDomain> goodsShownoNotList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain2 = new AccurateQueryDomain();
            accurateQueryDomain2.setAccurateField("goodsShowno.keyword");
            accurateQueryDomain2.setAccurateFieldValues(goodShownoNotList);
            goodsShownoNotList.add(accurateQueryDomain2);
            for (AccurateQueryDomain accurateQueryDomain : goodsShownoNotList) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    goodsShownoNotqueryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                goodsShownoNotqueryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        List classtreeCodeListStr = (List)jsonToMap.get("classtreeCodeList");
        ArrayList<Object> classtreeCodequeryList = new ArrayList<Object>();
        if (ListUtil.isNotEmpty((Collection)classtreeCodeListStr)) {
            ArrayList<AccurateQueryDomain> arrayList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain4 = new AccurateQueryDomain();
            accurateQueryDomain4.setAccurateField("classtreeCode.keyword");
            accurateQueryDomain4.setAccurateFieldValues(classtreeCodeListStr);
            arrayList.add(accurateQueryDomain4);
            for (AccurateQueryDomain accurateQueryDomain : arrayList) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    classtreeCodequeryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                classtreeCodequeryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List classtreeCodeNotListStr = (List)jsonToMap.get("classtreeCodeNotList");
        if (ListUtil.isNotEmpty((Collection)classtreeCodeNotListStr)) {
            ArrayList<AccurateQueryDomain> classtreeCodeNotList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain5 = new AccurateQueryDomain();
            accurateQueryDomain5.setAccurateField("classtreeCode.keyword");
            accurateQueryDomain5.setAccurateFieldValues(classtreeCodeNotListStr);
            classtreeCodeNotList.add(accurateQueryDomain5);
            for (AccurateQueryDomain accurateQueryDomain : classtreeCodeNotList) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    arrayList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                arrayList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        List ginfoCodeListStr = (List)jsonToMap.get("ginfoCodeList");
        ArrayList<Object> ginfoCodeListqueryList = new ArrayList<Object>();
        if (ListUtil.isNotEmpty((Collection)ginfoCodeListStr)) {
            ArrayList<AccurateQueryDomain> ginfoCodeList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain51 = new AccurateQueryDomain();
            accurateQueryDomain51.setAccurateField("ginfoCode.keyword");
            accurateQueryDomain51.setAccurateFieldValues(ginfoCodeListStr);
            ginfoCodeList.add(accurateQueryDomain51);
            for (AccurateQueryDomain accurateQueryDomain : ginfoCodeList) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    ginfoCodeListqueryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                ginfoCodeListqueryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        ArrayList<Object> ginfoCode = new ArrayList<Object>();
        if (ListUtil.isNotEmpty(ginfoCodeListqueryList)) {
            ginfoCode.addAll(ginfoCodeListqueryList);
            if (ListUtil.isNotEmpty(goodsShownoNotqueryList)) {
                BoolQueryBuilder goodsShownoboolQuery = QueryBuilders.boolQuery();
                goodsShownoboolQuery.mustNot().addAll(goodsShownoNotqueryList);
                ginfoCode.add(goodsShownoboolQuery);
            }
            if (ListUtil.isNotEmpty(arrayList)) {
                BoolQueryBuilder classtreeCodeboolQuery = QueryBuilders.boolQuery();
                classtreeCodeboolQuery.mustNot().addAll(arrayList);
                ginfoCode.add(classtreeCodeboolQuery);
            }
        }
        ArrayList<BoolQueryBuilder> arrayAll = new ArrayList<BoolQueryBuilder>();
        if (ListUtil.isNotEmpty(ginfoCode)) {
            BoolQueryBuilder ginfoCodeboolQuery = QueryBuilders.boolQuery();
            ginfoCodeboolQuery.must().addAll(ginfoCode);
            arrayAll.add(ginfoCodeboolQuery);
        }
        ArrayList<Object> classtreeCodeCode = new ArrayList<Object>();
        if (ListUtil.isNotEmpty(classtreeCodequeryList)) {
            classtreeCodeCode.addAll(classtreeCodequeryList);
            if (ListUtil.isNotEmpty(goodsShownoNotqueryList)) {
                BoolQueryBuilder goodsShownoboolQueryStr = QueryBuilders.boolQuery();
                goodsShownoboolQueryStr.mustNot().addAll(goodsShownoNotqueryList);
                classtreeCodeCode.add(goodsShownoboolQueryStr);
            }
            if (ListUtil.isNotEmpty(classtreeCodeCode)) {
                BoolQueryBuilder classtreeCodeCodeboolQuery = QueryBuilders.boolQuery();
                classtreeCodeCodeboolQuery.must().addAll(classtreeCodeCode);
                arrayAll.add(classtreeCodeCodeboolQuery);
            }
        }
        if (ListUtil.isNotEmpty(goodsShownoqueryList)) {
            BoolQueryBuilder goodsShownoCodeboolQuery = QueryBuilders.boolQuery();
            goodsShownoCodeboolQuery.should().addAll(goodsShownoqueryList);
            arrayAll.add(goodsShownoCodeboolQuery);
        }
        if (ListUtil.isNotEmpty(arrayAll)) {
            boolQuery.should().addAll(arrayAll);
        }
        return boolQuery;
    }

    public BoolQueryBuilder makeGoodsFindPolymerization(SearchDomain searchDomain) {
        if (null == searchDomain) {
            this.logger.error("es.SearchengineServiceImpl.makeGoodsFindPolymerization.e", (Object)"isnull");
            return null;
        }
        String condition = searchDomain.getCondition();
        Map jsonToMap = (Map)JSONObject.parseObject((String)condition, (TypeReference)new TypeReference<Map<String, List<String>>>(){}, (Feature[])new Feature[0]);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            this.logger.error("es.SearchengineServiceImpl.makeGoodsFindPolymerization.jsonToMap", (Object)condition);
            return null;
        }
        List goodsNoList = (List)jsonToMap.get("goodsNoList");
        List goodsNoNotList = (List)jsonToMap.get("goodsNoNotList");
        ArrayList<Object> goodsNoqueryList = new ArrayList<Object>();
        if (ListUtil.isNotEmpty((Collection)goodsNoList)) {
            ArrayList<AccurateQueryDomain> goodsnoList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain3 = new AccurateQueryDomain();
            accurateQueryDomain3.setAccurateField("goodsNo.keyword");
            accurateQueryDomain3.setAccurateFieldValues(goodsNoList);
            goodsnoList.add(accurateQueryDomain3);
            for (AccurateQueryDomain accurateQueryDomain : goodsnoList) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    goodsNoqueryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                goodsNoqueryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        ArrayList<Object> goodsNoNotqueryList = new ArrayList<Object>();
        if (ListUtil.isNotEmpty((Collection)goodsNoNotList)) {
            ArrayList<AccurateQueryDomain> goodsShownoNotList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain2 = new AccurateQueryDomain();
            accurateQueryDomain2.setAccurateField("goodsNo.keyword");
            accurateQueryDomain2.setAccurateFieldValues(goodsNoNotList);
            goodsShownoNotList.add(accurateQueryDomain2);
            for (AccurateQueryDomain accurateQueryDomain : goodsShownoNotList) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    goodsNoNotqueryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                goodsNoNotqueryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        List classtreeCodeListStr = (List)jsonToMap.get("classtreeCodeList");
        ArrayList<Object> classtreeCodequeryList = new ArrayList<Object>();
        if (ListUtil.isNotEmpty((Collection)classtreeCodeListStr)) {
            ArrayList<AccurateQueryDomain> arrayList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain4 = new AccurateQueryDomain();
            accurateQueryDomain4.setAccurateField("classtreeCode.keyword");
            accurateQueryDomain4.setAccurateFieldValues(classtreeCodeListStr);
            arrayList.add(accurateQueryDomain4);
            for (AccurateQueryDomain accurateQueryDomain : arrayList) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    classtreeCodequeryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                classtreeCodequeryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List classtreeCodeNotListStr = (List)jsonToMap.get("classtreeCodeNotList");
        if (ListUtil.isNotEmpty((Collection)classtreeCodeNotListStr)) {
            ArrayList<AccurateQueryDomain> classtreeCodeNotList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain5 = new AccurateQueryDomain();
            accurateQueryDomain5.setAccurateField("classtreeCode.keyword");
            accurateQueryDomain5.setAccurateFieldValues(classtreeCodeNotListStr);
            classtreeCodeNotList.add(accurateQueryDomain5);
            for (AccurateQueryDomain accurateQueryDomain : classtreeCodeNotList) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    arrayList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                arrayList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        List ginfoCodeListStr = (List)jsonToMap.get("ginfoCodeList");
        ArrayList<Object> ginfoCodeListqueryList = new ArrayList<Object>();
        if (ListUtil.isNotEmpty((Collection)ginfoCodeListStr)) {
            ArrayList<AccurateQueryDomain> ginfoCodeList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain51 = new AccurateQueryDomain();
            accurateQueryDomain51.setAccurateField("ginfoCode.keyword");
            accurateQueryDomain51.setAccurateFieldValues(ginfoCodeListStr);
            ginfoCodeList.add(accurateQueryDomain51);
            for (AccurateQueryDomain accurateQueryDomain : ginfoCodeList) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    ginfoCodeListqueryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                ginfoCodeListqueryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        ArrayList<Object> ginfoCode = new ArrayList<Object>();
        if (ListUtil.isNotEmpty(ginfoCodeListqueryList)) {
            ginfoCode.addAll(ginfoCodeListqueryList);
            if (ListUtil.isNotEmpty(goodsNoNotqueryList)) {
                BoolQueryBuilder goodsNoNotboolQuery = QueryBuilders.boolQuery();
                goodsNoNotboolQuery.mustNot().addAll(goodsNoNotqueryList);
                ginfoCode.add(goodsNoNotboolQuery);
            }
            if (ListUtil.isNotEmpty(arrayList)) {
                BoolQueryBuilder classtreeCodeboolQuery = QueryBuilders.boolQuery();
                classtreeCodeboolQuery.mustNot().addAll(arrayList);
                ginfoCode.add(classtreeCodeboolQuery);
            }
        }
        ArrayList<BoolQueryBuilder> arrayAll = new ArrayList<BoolQueryBuilder>();
        if (ListUtil.isNotEmpty(ginfoCode)) {
            BoolQueryBuilder ginfoCodeboolQuery = QueryBuilders.boolQuery();
            ginfoCodeboolQuery.must().addAll(ginfoCode);
            arrayAll.add(ginfoCodeboolQuery);
        }
        ArrayList<Object> classtreeCodeCode = new ArrayList<Object>();
        if (ListUtil.isNotEmpty(classtreeCodequeryList)) {
            classtreeCodeCode.addAll(classtreeCodequeryList);
            if (ListUtil.isNotEmpty(goodsNoNotqueryList)) {
                BoolQueryBuilder goodsNoboolQueryStr = QueryBuilders.boolQuery();
                goodsNoboolQueryStr.mustNot().addAll(goodsNoNotqueryList);
                classtreeCodeCode.add(goodsNoboolQueryStr);
            }
            if (ListUtil.isNotEmpty(classtreeCodeCode)) {
                BoolQueryBuilder classtreeCodeCodeboolQuery = QueryBuilders.boolQuery();
                classtreeCodeCodeboolQuery.must().addAll(classtreeCodeCode);
                arrayAll.add(classtreeCodeCodeboolQuery);
            }
        }
        if (ListUtil.isNotEmpty(goodsNoqueryList)) {
            BoolQueryBuilder goodsNoCodeboolQuery = QueryBuilders.boolQuery();
            goodsNoCodeboolQuery.should().addAll(goodsNoqueryList);
            arrayAll.add(goodsNoCodeboolQuery);
        }
        if (ListUtil.isNotEmpty(arrayAll)) {
            boolQuery.should().addAll(arrayAll);
        }
        return boolQuery;
    }

    @Override
    public boolean store(StoreDomain storeDomain) throws ApiException {
        if (null == storeDomain || StringUtils.isBlank((String)storeDomain.getTenantCode()) || StringUtils.isBlank((String)storeDomain.getRequestType())) {
            return false;
        }
        ArrayList<StoreDomain> storeDomainList = new ArrayList<StoreDomain>();
        storeDomainList.add(storeDomain);
        return this.storeBatch(storeDomainList);
    }

    @Override
    public Map<String, Object> findByCode(String opcode, String bizType, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)opcode) || StringUtils.isBlank((String)bizType) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("es.SearchengineServiceImpl.findByCode.null", (Object)"null");
            return null;
        }
        try {
            long times = System.currentTimeMillis();
            String str = this.esUtil.httpUrlPoolGetByCode(tenantCode, bizType, opcode);
            this.logger.info("es.SearchengineServiceImpl.findByCode.find", (Object)(opcode + "=" + (System.currentTimeMillis() - times)));
            if (StringUtils.isBlank((String)str)) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.str", (Object)opcode);
                return null;
            }
            Map remap = (Map)JSON.parseObject((String)str, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            if (null == remap || MapUtil.isEmpty((Map)remap)) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.remap", (Object)str);
                return null;
            }
            return remap;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.findByCode.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public ReturnBean newFind(SearchDomain searchDomain) throws ApiException {
        int from;
        if (null == searchDomain || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.find.null", (Object)"null");
            return null;
        }
        this.logger.debug(SYS_CODE, (Object)("searchDomain info:" + searchDomain));
        String data = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("es.SearchengineServiceImpl.find.data", (Object)"data");
            return null;
        }
        Map<String, Object> pageMap = searchDomain.getPageMap();
        Integer rows = 10;
        Integer page = 1;
        if (null != pageMap && !pageMap.isEmpty()) {
            rows = Integer.parseInt(pageMap.get("rows").toString());
            page = Integer.parseInt(pageMap.get("page").toString());
        }
        if (null == rows || rows == 0) {
            rows = 10;
        }
        if (null == page) {
            page = 1;
        }
        if ((from = (Integer.valueOf(page) - 1) * Integer.valueOf(rows)) < 0) {
            from = 0;
        }
        String queryJson = "";
        String sortStr = "\"sort\":[";
        String sortList = "";
        if (null != searchDomain.getSortDomain()) {
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getOrder())) {
                searchDomain.getSortDomain().setOrder(searchDomain.getSortDomain().getOrder().toLowerCase());
            }
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getSortField())) {
                sortList = sortList + " { \"" + searchDomain.getSortDomain().getSortField() + "\": { \"order\": \"" + searchDomain.getSortDomain().getOrder() + "\" }}";
            }
            if (ListUtil.isEmpty(searchDomain.getSortDomain().getSortDomainList())) {
                for (SortDomain sortDomain : searchDomain.getSortDomain().getSortDomainList()) {
                    if (StringUtils.isNotBlank((String)sortList)) {
                        sortList = sortList + ",";
                    }
                    sortList = sortList + " { \"" + sortDomain.getSortField() + "\": { \"order\": \"" + sortDomain.getOrder() + "\" }}";
                }
            }
            sortStr = sortStr + sortList;
        } else {
            sortStr = sortStr + " { \"_score\": { \"order\": \"desc\" }}";
        }
        sortStr = sortStr + "]";
        String musQueryStr = "";
        String mustNotQueryStr = "";
        if (null != searchDomain.getAccurateQueryList() && !searchDomain.getAccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getAccurateQueryList()) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if ("must_not".equals(accurateQueryDomain.getAccurateFieType())) {
                    if (StringUtils.isNotBlank((String)mustNotQueryStr)) {
                        mustNotQueryStr = mustNotQueryStr + ",";
                    }
                    if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                        mustNotQueryStr = mustNotQueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag) + "}}";
                        continue;
                    }
                    if (!flag) {
                        accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                    }
                    mustNotQueryStr = mustNotQueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
                    continue;
                }
                if (StringUtils.isNotBlank((String)musQueryStr)) {
                    musQueryStr = musQueryStr + ",";
                }
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    musQueryStr = musQueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag) + "}}";
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                musQueryStr = musQueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
            }
        }
        String aggregationsStr = "";
        if (MapUtil.isNotEmpty(searchDomain.getGroupListMap()) || MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
            aggregationsStr = aggregationsStr + "\"aggregations\":{";
            String px = "";
            if (MapUtil.isNotEmpty(searchDomain.getGroupListMap())) {
                String liststr = "";
                Object value = "20";
                for (String key : searchDomain.getGroupListMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    value = String.valueOf(searchDomain.getGroupListMap().get(key));
                    liststr = liststr + "\"" + key + "\":{\"terms\":{\"field\":\"" + key + ".keyword\",\"size\":" + (String)value + "}}";
                }
                aggregationsStr = aggregationsStr + liststr;
                px = ",";
            }
            if (MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
                String liststr = "";
                for (String key : searchDomain.getGroupNumMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    liststr = liststr + "\"" + key + "min\":{\"min\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "max\":{\"max\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "avg\":{\"avg\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "sum\":{\"sum\":{\"field\":\"" + key + "\"}}";
                }
                aggregationsStr = aggregationsStr + px + liststr;
            }
            aggregationsStr = aggregationsStr + "}";
        }
        if (StringUtils.isNotBlank((String)aggregationsStr)) {
            aggregationsStr = "," + aggregationsStr;
        }
        String headStr = "{\"query\":{\"bool\":{\"";
        String endStr = "}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + aggregationsStr + "}";
        if (StringUtils.isNotBlank((String)musQueryStr)) {
            queryJson = headStr + "must\":[" + musQueryStr + "]";
        }
        if (StringUtils.isNotBlank((String)mustNotQueryStr)) {
            queryJson = queryJson + ",\"must_not\":[" + mustNotQueryStr + "]";
        }
        queryJson = queryJson + endStr;
        this.logger.error("es.SearchengineServiceImpl.newFind.queryJson", (Object)queryJson);
        try {
            long times = System.currentTimeMillis();
            String str = this.esUtil.httpUrlPoolGet(data, searchDomain.getBizType(), queryJson);
            OpenPerfLogUtil.info((String)("[find]htt:{},api:" + searchDomain.getBizType()), (long)(System.currentTimeMillis() - times));
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            RestBean restBean = (RestBean)JsonUtil.buildNormalBinder().getJsonToObject(str, RestBean.class);
            if (null == restBean || null == restBean.getHits() || null == restBean.getHits().getHits()) {
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            List<DataHits> list = restBean.getHits().getHits();
            if (null == list || list.isEmpty()) {
                return null;
            }
            ArrayList<Map<String, Object>> sourcelist = new ArrayList<Map<String, Object>>();
            for (DataHits dataHits : list) {
                HashMap<String, Double> dataHit = new HashMap<String, Double>();
                try {
                    BeanUtils.copyAllPropertys(dataHit, dataHits.get_source());
                    dataHit.put("score", dataHits.get_score());
                }
                catch (Exception e) {
                    this.logger.error(SYS_CODE, (Object)"search response convert exception:", (Throwable)e);
                }
                sourcelist.add(dataHit);
            }
            returnBean.setAggregations(restBean.getAggregations());
            returnBean.setSourcelist(sourcelist);
            returnBean.setCount(restBean.getHits().getTotal());
            returnBean.setPage(page);
            returnBean.setRow(rows);
            return returnBean;
        }
        catch (IOException e) {
            this.logger.error("es.SearchengineServiceImpl.find.e", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ApiMethod(code="es.searchengine.find", name="\u83b7\u53d6\u6570\u636e", paramStr="searchDomain", description="")
    public ReturnBean find(SearchDomain searchDomain) throws ApiException {
        ArrayList<Object> boolList;
        void var16_26;
        int from;
        if (null == searchDomain || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.find.null", (Object)"null");
            return null;
        }
        this.logger.info(SYS_CODE, (Object)("searchDomain info:" + JSON.toJSONString((Object)searchDomain)));
        String data = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("es.SearchengineServiceImpl.find.data", (Object)"data");
            return null;
        }
        Map<String, Object> pageMap = searchDomain.getPageMap();
        Integer rows = 10;
        Integer page = 1;
        if (null != pageMap && !pageMap.isEmpty()) {
            rows = Integer.parseInt(pageMap.get("rows").toString());
            page = Integer.parseInt(pageMap.get("page").toString());
        }
        if (null == rows || rows == 0) {
            rows = 10;
        }
        if (null == page) {
            page = 1;
        }
        if ((from = (Integer.valueOf(page) - 1) * Integer.valueOf(rows)) < 0) {
            from = 0;
        }
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.from(from);
        builder.size(rows.intValue());
        builder.sort("_score", SortOrder.DESC);
        SortDomain searchSortDomain = searchDomain.getSortDomain();
        if (null != searchSortDomain) {
            if (StringUtils.isNotBlank((String)searchSortDomain.getSortField())) {
                FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)searchSortDomain.getSortField());
                if (StringUtils.isNotBlank((String)searchSortDomain.getMissing())) {
                    fieldSortBuilder.missing((Object)searchSortDomain.getMissing());
                }
                if (StringUtils.isNotBlank((String)searchSortDomain.getUnmappedType())) {
                    fieldSortBuilder.unmappedType(searchSortDomain.getUnmappedType());
                }
                if (StringUtils.isNotBlank((String)searchSortDomain.getOrder())) {
                    fieldSortBuilder.order(SortOrder.fromString((String)searchSortDomain.getOrder()));
                }
                builder.sort((SortBuilder)fieldSortBuilder);
            }
            if (null != searchSortDomain && ListUtil.isNotEmpty(searchSortDomain.getSortDomainList())) {
                for (SortDomain sortDomain : searchSortDomain.getSortDomainList()) {
                    FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)sortDomain.getSortField());
                    if (StringUtils.isNotBlank((String)sortDomain.getMissing())) {
                        fieldSortBuilder.missing((Object)sortDomain.getMissing());
                    }
                    if (StringUtils.isNotBlank((String)sortDomain.getUnmappedType())) {
                        fieldSortBuilder.unmappedType(sortDomain.getUnmappedType());
                    }
                    if (StringUtils.isNotBlank((String)sortDomain.getOrder())) {
                        fieldSortBuilder.order(SortOrder.fromString((String)sortDomain.getOrder()));
                    }
                    builder.sort((SortBuilder)fieldSortBuilder);
                }
            }
        }
        BoolQueryBuilder matchQueryBuilder = null;
        ArrayList<Object> matchQueryBuilderList = null;
        if (null != searchDomain.getBoolMap() && !searchDomain.getBoolMap().isEmpty()) {
            Object obj = null;
            ArrayList<MatchPhraseQueryBuilder> match_phraseList = new ArrayList<MatchPhraseQueryBuilder>();
            ArrayList<WildcardQueryBuilder> wildcardList = new ArrayList<WildcardQueryBuilder>();
            ArrayList<MatchQueryBuilder> matchList = new ArrayList<MatchQueryBuilder>();
            for (String string : searchDomain.getBoolMap().keySet()) {
                Map<String, Object> queryMap;
                obj = searchDomain.getBoolMap().get(string);
                if ("match_phrase".equals(searchDomain.getSearchType())) {
                    MatchPhraseQueryBuilder matchPhraseQueryBuilder = QueryBuilders.matchPhraseQuery((String)string, (Object)obj);
                    queryMap = searchDomain.getQueryMap();
                    if (queryMap != null && null != queryMap.get("boost")) {
                        matchPhraseQueryBuilder.boost(((Float)queryMap.get("boost")).floatValue());
                    }
                    if (queryMap != null && null != queryMap.get("slop")) {
                        matchPhraseQueryBuilder.slop(((Integer)queryMap.get("slop")).intValue());
                    }
                    match_phraseList.add(matchPhraseQueryBuilder);
                    continue;
                }
                WildcardQueryBuilder wildcardQueryBuilder = QueryBuilders.wildcardQuery((String)(string + ".keyword"), (String)("*" + obj + "*"));
                queryMap = searchDomain.getQueryMap();
                if (queryMap != null && null != queryMap.get("boost")) {
                    wildcardQueryBuilder.boost(((Float)queryMap.get("boost")).floatValue());
                }
                wildcardList.add(wildcardQueryBuilder);
                MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchQuery((String)(string + ".keyword"), (Object)obj);
                Map<String, Object> queryMap1 = searchDomain.getQueryMap();
                if (queryMap1 != null && null != queryMap1.get("boost")) {
                    matchQueryBuilder1.boost(((Float)queryMap1.get("boost")).floatValue());
                }
                matchList.add(matchQueryBuilder1);
            }
            if ("match_phrase".equals(searchDomain.getSearchType())) {
                if (StringUtils.isNotBlank((String)searchDomain.getShouldFlag())) {
                    matchQueryBuilder = QueryBuilders.boolQuery();
                    matchQueryBuilder.should().addAll(match_phraseList);
                } else {
                    matchQueryBuilderList = new ArrayList<Object>();
                    matchQueryBuilderList.addAll(wildcardList);
                    matchQueryBuilderList.addAll(matchList);
                }
            } else {
                matchQueryBuilder = QueryBuilders.boolQuery();
                matchQueryBuilder.should().addAll(wildcardList);
                matchQueryBuilder.should().addAll(matchList);
            }
        }
        ArrayList<RangeQueryBuilder> priceRangeQueryBuilderList = null;
        if (null != searchDomain.getMinPrice()) {
            priceRangeQueryBuilderList = new ArrayList<RangeQueryBuilder>();
            RangeQueryBuilder priceRangeQueryBuilder = QueryBuilders.rangeQuery((String)"pricesetNprice").gte((Object)searchDomain.getMinPrice());
            if (null != searchDomain.getMaxPrice()) {
                priceRangeQueryBuilder.lte((Object)searchDomain.getMaxPrice());
            }
            priceRangeQueryBuilderList.add(priceRangeQueryBuilder);
        }
        RangeQueryBuilder numRangeQueryBuilder = null;
        if (null != searchDomain.getMinNum() || null != searchDomain.getMaxNum()) {
            numRangeQueryBuilder = QueryBuilders.rangeQuery((String)"goodsSupplynum");
            if (null != searchDomain.getMinNum()) {
                numRangeQueryBuilder.gt((Object)searchDomain.getMinNum());
            }
            if (null != searchDomain.getMaxNum()) {
                numRangeQueryBuilder.lt((Object)searchDomain.getMaxNum());
            }
        }
        if (null != numRangeQueryBuilder) {
            priceRangeQueryBuilderList.add(numRangeQueryBuilder);
        }
        ArrayList<Object> accqueryList = new ArrayList<Object>();
        ArrayList buyAccqueryList = new ArrayList();
        if (null != searchDomain.getAccurateQueryList() && !searchDomain.getAccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getAccurateQueryList()) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    accqueryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                accqueryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        ArrayList<Object> notaccqueryList = new ArrayList<Object>();
        if (null != searchDomain.getNotaccurateQueryList() && !searchDomain.getNotaccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getNotaccurateQueryList()) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    notaccqueryList.add(QueryBuilders.termsQuery((String)accurateQueryDomain.getAccurateField(), SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag)));
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                notaccqueryList.add(QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
            }
        }
        Object var16_21 = null;
        if (MapUtil.isNotEmpty(searchDomain.getGroupListMap()) || MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
            if (MapUtil.isNotEmpty(searchDomain.getGroupListMap())) {
                if (this.isCsCliProductPool(searchDomain.getGroupListMap())) {
                    this.queryCsCliProductPoolCopy(builder);
                } else {
                    String value = "20";
                    for (String key : searchDomain.getGroupListMap().keySet()) {
                        void var16_22;
                        value = String.valueOf(searchDomain.getGroupListMap().get(key));
                        if (null == var16_22) {
                            TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)key).field(key + ".keyword")).size(Integer.valueOf(value).intValue());
                            continue;
                        }
                        AggregationBuilder aggregationBuilder = var16_22.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)key).field(key + ".keyword")).size(Integer.valueOf(value).intValue()));
                    }
                }
            }
            if (!this.isCsCliProductPool(searchDomain.getGroupListMap()) && MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
                for (String key : searchDomain.getGroupNumMap().keySet()) {
                    void var16_29;
                    if (null == var16_26) {
                        ValuesSourceAggregationBuilder valuesSourceAggregationBuilder = AggregationBuilders.min((String)(key + "min")).field(key);
                    } else {
                        AggregationBuilder aggregationBuilder = var16_26.subAggregation((AggregationBuilder)AggregationBuilders.min((String)(key + "min")).field(key));
                    }
                    AggregationBuilder aggregationBuilder3 = var16_29.subAggregation((AggregationBuilder)AggregationBuilders.max((String)(key + "max")).field(key));
                    aggregationBuilder3 = aggregationBuilder3.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)(key + "avg")).field(key));
                    aggregationBuilder3 = aggregationBuilder3.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)(key + "sum")).field(key));
                }
            }
        }
        String queryWay = ConstantEnums.must.getCode();
        if (StringUtils.isNotBlank((String)searchDomain.getQueryType())) {
            queryWay = searchDomain.getQueryType();
        }
        CollapseBuilder collapseBuilder = null;
        String collapseStr = searchDomain.getCollapseStr();
        if (StringUtils.isNotBlank((String)collapseStr)) {
            collapseBuilder = new CollapseBuilder(collapseStr);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (ListUtil.isNotEmpty(accqueryList)) {
            boolList = new ArrayList<Object>();
            BoolQueryBuilder ccboolQueryBuilder = QueryBuilders.boolQuery();
            BoolQueryBuilder cboolQueryBuilder = QueryBuilders.boolQuery();
            if (ConstantEnums.must.getCode().equals(queryWay)) {
                ccboolQueryBuilder.must().addAll(accqueryList);
                if (null != matchQueryBuilder) {
                    ccboolQueryBuilder.must().add(matchQueryBuilder);
                } else if (null != matchQueryBuilderList) {
                    ccboolQueryBuilder.must().addAll(matchQueryBuilderList);
                }
                if (ListUtil.isNotEmpty(priceRangeQueryBuilderList)) {
                    ccboolQueryBuilder.must().addAll(priceRangeQueryBuilderList);
                }
            } else {
                ccboolQueryBuilder.mustNot().addAll(accqueryList);
                if (null != matchQueryBuilder) {
                    ccboolQueryBuilder.mustNot().add(matchQueryBuilder);
                } else if (null != matchQueryBuilderList) {
                    ccboolQueryBuilder.mustNot().addAll(matchQueryBuilderList);
                }
                if (ListUtil.isNotEmpty(priceRangeQueryBuilderList)) {
                    ccboolQueryBuilder.mustNot().addAll(priceRangeQueryBuilderList);
                }
            }
            if (ListUtil.isNotEmpty(notaccqueryList)) {
                ccboolQueryBuilder.mustNot().addAll(notaccqueryList);
            }
            if (ListUtil.isNotEmpty(buyAccqueryList)) {
                BoolQueryBuilder cc1boolQueryBuilder = QueryBuilders.boolQuery();
                if (ConstantEnums.must.getCode().equals(queryWay)) {
                    cc1boolQueryBuilder.must().addAll(buyAccqueryList);
                    if (null != matchQueryBuilder) {
                        cc1boolQueryBuilder.must().add(matchQueryBuilder);
                    } else if (null != matchQueryBuilderList) {
                        cc1boolQueryBuilder.must().addAll(matchQueryBuilderList);
                    }
                    if (ListUtil.isNotEmpty(priceRangeQueryBuilderList)) {
                        cc1boolQueryBuilder.must().addAll(priceRangeQueryBuilderList);
                    }
                } else {
                    cc1boolQueryBuilder.mustNot().addAll(buyAccqueryList);
                    if (null != matchQueryBuilder) {
                        cc1boolQueryBuilder.mustNot().add(matchQueryBuilder);
                    } else if (null != matchQueryBuilderList) {
                        cc1boolQueryBuilder.mustNot().addAll(matchQueryBuilderList);
                    }
                    if (ListUtil.isNotEmpty(priceRangeQueryBuilderList)) {
                        cc1boolQueryBuilder.mustNot().addAll(priceRangeQueryBuilderList);
                    }
                }
                if (ListUtil.isNotEmpty(notaccqueryList)) {
                    cc1boolQueryBuilder.mustNot().addAll(notaccqueryList);
                }
                cboolQueryBuilder.should().add(cc1boolQueryBuilder);
            }
            cboolQueryBuilder.should().add(ccboolQueryBuilder);
            boolList.add(cboolQueryBuilder);
            boolQueryBuilder.must().addAll(boolList);
        } else {
            boolList = new ArrayList();
            if (null != matchQueryBuilder) {
                boolList.add(matchQueryBuilder);
            } else if (null != matchQueryBuilderList) {
                boolList.addAll(matchQueryBuilderList);
            }
            if (ListUtil.isNotEmpty(priceRangeQueryBuilderList)) {
                boolList.addAll(priceRangeQueryBuilderList);
            }
            if (ListUtil.isNotEmpty(notaccqueryList)) {
                boolQueryBuilder.mustNot().addAll(notaccqueryList);
            }
            if (ConstantEnums.must.getCode().equals(queryWay)) {
                boolQueryBuilder.must().addAll(boolList);
            } else {
                boolQueryBuilder.mustNot().addAll(boolList);
            }
        }
        builder.query((QueryBuilder)boolQueryBuilder);
        if (null != var16_26) {
            builder.aggregation((AggregationBuilder)var16_26);
        }
        if (null != collapseBuilder) {
            builder.collapse(collapseBuilder);
        }
        try {
            long times = System.currentTimeMillis();
            this.logger.info("es.SearchengineServiceImpl.find.searchResponse.\u6761\u4ef6", (Object)("TenantCode:" + data + "-type:" + searchDomain.getBizType() + "-" + builder));
            SearchResponse searchResponse = this.esUtil.queryEs(data, searchDomain.getBizType(), builder);
            OpenPerfLogUtil.info((String)("[find]htt:{},api:" + searchDomain.getBizType()), (long)(System.currentTimeMillis() - times));
            if (null == searchResponse || null == searchResponse.getHits()) {
                this.logger.error("es.SearchengineServiceImpl.find.searchResponse");
                return null;
            }
            if (null == searchResponse.getHits().getHits()) {
                this.logger.info("es.SearchengineServiceImpl.find.hits");
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            SearchHit[] list = searchResponse.getHits().getHits();
            if (null == list || list.length <= 0) {
                return null;
            }
            ArrayList<Map<String, Object>> sourcelist = new ArrayList<Map<String, Object>>();
            for (SearchHit dataHits : list) {
                HashMap<String, Float> dataHit = new HashMap<String, Float>();
                try {
                    BeanUtils.copyAllPropertys(dataHit, (Object)dataHits.getSourceAsMap());
                    dataHit.put("score", Float.valueOf(dataHits.getScore()));
                }
                catch (Exception e) {
                    this.logger.error(SYS_CODE, (Object)"search response convert exception:", (Throwable)e);
                }
                sourcelist.add(dataHit);
            }
            if (null != searchResponse.getAggregations() && MapUtil.isNotEmpty((Map)searchResponse.getAggregations().getAsMap())) {
                HashMap<String, Object> aggregations = new HashMap<String, Object>();
                Map asMap = searchResponse.getAggregations().getAsMap();
                for (Map.Entry stringAggregationEntry : asMap.entrySet()) {
                    String key = (String)stringAggregationEntry.getKey();
                    HashMap subMap = new HashMap();
                    ArrayList mapList = new ArrayList();
                    Terms terms = (Terms)stringAggregationEntry.getValue();
                    for (Terms.Bucket bucket : terms.getBuckets()) {
                        String bucketKey = (String)bucket.getKey();
                        long docCount = bucket.getDocCount();
                        HashMap<String, Object> smallMap = new HashMap<String, Object>();
                        smallMap.put("key", bucketKey);
                        smallMap.put("doc_count", docCount);
                        mapList.add(smallMap);
                    }
                    subMap.put("buckets", mapList);
                    aggregations.put(key, subMap);
                }
                returnBean.setAggregations(aggregations);
            }
            returnBean.setSourcelist(sourcelist);
            returnBean.setCount(Integer.valueOf(String.valueOf(searchResponse.getHits().getTotalHits().value)));
            returnBean.setPage(page);
            returnBean.setRow(rows);
            return returnBean;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.find.e", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public boolean isCsCliProductPool(Map<String, Object> map) {
        String[] split;
        if (MapUtil.isEmpty(map)) {
            return false;
        }
        for (String key : split = "brandName,brandCode,memberCcode,memberCname,classtreeCode,classtreeName".split(",")) {
            if (map.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public void queryCsCliProductPoolCopy(SearchSourceBuilder builder) {
        String[] filterList;
        for (String filterKey : filterList = new String[]{"brandName", "brandCode", "memberCcode", "memberCname", "classtreeCode", "classtreeName"}) {
            TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)filterKey).field(filterKey + ".keyword")).size(Integer.MAX_VALUE);
            builder.aggregation((AggregationBuilder)aggregationBuilder);
        }
    }

    public AggregationBuilder queryCsCliProductPool(AggregationBuilder aggregationBuilder) {
        aggregationBuilder = null == aggregationBuilder ? ((TermsAggregationBuilder)AggregationBuilders.terms((String)"classtreeCode").script(new Script("doc['classtreeCode.keyword'] +'#'+doc['classtreeName']"))).size(Integer.MAX_VALUE) : aggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"classtreeCode").script(new Script("doc['classtreeCode.keyword'] +'#'+doc['classtreeName']"))).size(Integer.valueOf(Integer.MAX_VALUE).intValue()));
        aggregationBuilder = aggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"brandCode").script(new Script("doc['brandCode.keyword'] +'#'+doc['brandName']"))).size(Integer.valueOf(Integer.MAX_VALUE).intValue()));
        aggregationBuilder = aggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"memberCcode").script(new Script("doc['memberCcode.keyword'] +'#'+doc['memberCname']"))).size(Integer.valueOf(Integer.MAX_VALUE).intValue()));
        return aggregationBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public ReturnBean findOld(SearchDomain searchDomain) throws ApiException {
        void var18_38;
        void var13_18;
        String collapseStr;
        void var18_36;
        int from;
        if (null == searchDomain || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.find.null", (Object)"null");
            return null;
        }
        this.logger.debug(SYS_CODE, (Object)("searchDomain info:" + searchDomain));
        String data = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("es.SearchengineServiceImpl.find.data", (Object)"data");
            return null;
        }
        Map<String, Object> pageMap = searchDomain.getPageMap();
        Integer rows = 10;
        Integer page = 1;
        if (null != pageMap && !pageMap.isEmpty()) {
            rows = Integer.parseInt(pageMap.get("rows").toString());
            page = Integer.parseInt(pageMap.get("page").toString());
        }
        if (null == rows || rows == 0) {
            rows = 10;
        }
        if (null == page) {
            page = 1;
        }
        if ((from = (Integer.valueOf(page) - 1) * Integer.valueOf(rows)) < 0) {
            from = 0;
        }
        String queryStr = "";
        String matchQuery = "";
        String queryJson = "";
        String sortStr = "\"sort\":[";
        String sortList = "";
        if (null != searchDomain.getSortDomain()) {
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getSortField())) {
                sortList = sortList + " { \"" + searchDomain.getSortDomain().getSortField() + "\": { \"order\": \"" + searchDomain.getSortDomain().getOrder() + "\" }}";
            }
            if (null != searchDomain.getSortDomain() && ListUtil.isNotEmpty(searchDomain.getSortDomain().getSortDomainList())) {
                for (SortDomain sortDomain : searchDomain.getSortDomain().getSortDomainList()) {
                    if (StringUtils.isNotBlank((String)sortList)) {
                        sortList = sortList + ",";
                    }
                    sortList = sortList + " { \"" + sortDomain.getSortField() + "\": { \"order\": \"" + sortDomain.getOrder() + "\" }}";
                }
            }
            sortStr = sortStr + sortList;
        } else {
            sortStr = sortStr + " { \"_score\": { \"order\": \"desc\" }}";
        }
        sortStr = sortStr + "]";
        if (null != searchDomain.getBoolMap() && !searchDomain.getBoolMap().isEmpty()) {
            Object obj = null;
            for (String key : searchDomain.getBoolMap().keySet()) {
                if (StringUtils.isNotBlank((String)matchQuery)) {
                    matchQuery = matchQuery + ",";
                }
                obj = searchDomain.getBoolMap().get(key);
                if ("match_phrase".equals(searchDomain.getSearchType())) {
                    matchQuery = matchQuery + "{\"match_phrase\":{\"" + key + "\":{\"query\":\"" + obj + "\"}}}";
                    continue;
                }
                matchQuery = matchQuery + "{\"wildcard\": { \"" + key + ".keyword\":\"*" + obj + "*\"}},";
                matchQuery = matchQuery + "{\"match\": { \"" + key + "\":\"" + obj + "\"}}";
            }
            queryStr = "match_phrase".equals(searchDomain.getSearchType()) ? (StringUtils.isNotBlank((String)searchDomain.getShouldFlag()) ? "{\"bool\":{\"should\":[" + matchQuery + "]}}" : matchQuery) : "{\"bool\":{\"should\":[" + matchQuery + "]}}";
        }
        if (null == searchDomain.getMinPrice()) {
            searchDomain.setMinPrice(Double.valueOf("0"));
        }
        String range = "{      \"pricesetNprice\": {        \"gte\": " + searchDomain.getMinPrice() + "      }}";
        if (null != searchDomain.getMaxPrice()) {
            range = "      {\"pricesetNprice\": {        \"gte\": " + searchDomain.getMinPrice() + ",        \"lte\": " + searchDomain.getMaxPrice() + "      }}";
        }
        String string = ",{\"range\":" + range + "}";
        String rangenum = "";
        if (null != searchDomain.getMinNum() || null != searchDomain.getMaxNum()) {
            rangenum = rangenum + "{      \"goodsSupplynum\": {";
            if (null != searchDomain.getMinNum()) {
                rangenum = rangenum + "        \"gt\": " + searchDomain.getMinNum() + "";
            }
            if (null != searchDomain.getMaxNum()) {
                if (null != searchDomain.getMinNum()) {
                    rangenum = rangenum + ",";
                }
                rangenum = rangenum + "        \"lt\": " + searchDomain.getMaxNum() + "";
            }
            rangenum = rangenum + "      }    }";
        }
        if (StringUtils.isNotBlank((String)rangenum)) {
            String string2 = string + ",{\"range\":" + rangenum + "}";
        }
        String accqueryStr = "";
        String buyAccqueryStr = "";
        if (null != searchDomain.getAccurateQueryList() && !searchDomain.getAccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getAccurateQueryList()) {
                boolean flag;
                if (StringUtils.isNotBlank((String)accqueryStr)) {
                    accqueryStr = accqueryStr + ",";
                }
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    accqueryStr = accqueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag) + "}}";
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                accqueryStr = accqueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
            }
        }
        if (1 == searchDomain.getGoodsBuyType()) {
            buyAccqueryStr = accqueryStr;
            if (StringUtils.isNotBlank((String)accqueryStr)) {
                accqueryStr = accqueryStr + ",";
            }
            accqueryStr = accqueryStr + "{\"term\" : {\"goodsBuyType\":\"0\"}}";
            if (StringUtils.isNotBlank((String)buyAccqueryStr)) {
                buyAccqueryStr = buyAccqueryStr + ",";
            }
            buyAccqueryStr = buyAccqueryStr + "{\"term\" : {\"goodsBuyType\":\"1\"}}";
            if (ListUtil.isNotEmpty(searchDomain.getGoodsBuyCodeStr())) {
                buyAccqueryStr = buyAccqueryStr + ",{\"terms\" : {\"goodsBuyCodeStr.keyword\":" + SearchengineServiceImpl.list2string(searchDomain.getGoodsBuyCodeStr(), true) + "}}";
            }
        }
        String notaccqueryStr = "";
        if (null != searchDomain.getNotaccurateQueryList() && !searchDomain.getNotaccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getNotaccurateQueryList()) {
                boolean flag;
                if (StringUtils.isNotBlank((String)notaccqueryStr)) {
                    notaccqueryStr = notaccqueryStr + ",";
                }
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    notaccqueryStr = notaccqueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag) + "}}";
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                notaccqueryStr = notaccqueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
            }
        }
        String string3 = "";
        if (MapUtil.isNotEmpty(searchDomain.getGroupListMap()) || MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
            void var18_34;
            String string4 = string3 + "\"aggregations\":{";
            String px = "";
            if (MapUtil.isNotEmpty(searchDomain.getGroupListMap())) {
                String liststr = "";
                Object value = "20";
                for (String key : searchDomain.getGroupListMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    value = String.valueOf(searchDomain.getGroupListMap().get(key));
                    liststr = liststr + "\"" + key + "\":{\"terms\":{\"field\":\"" + key + ".keyword\",\"size\":" + (String)value + "}}";
                }
                String string5 = string4 + liststr;
                px = ",";
            }
            if (MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
                void var18_32;
                String liststr = "";
                for (String key : searchDomain.getGroupNumMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    liststr = liststr + "\"" + key + "min\":{\"min\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "max\":{\"max\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "avg\":{\"avg\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "sum\":{\"sum\":{\"field\":\"" + key + "\"}}";
                }
                String string6 = (String)var18_32 + px + liststr;
            }
            String string7 = (String)var18_34 + "}";
        }
        if (StringUtils.isNotBlank((String)var18_36)) {
            String string8 = "," + (String)var18_36;
        }
        String queryWay = ConstantEnums.must.getCode();
        if (StringUtils.isNotBlank((String)searchDomain.getQueryType())) {
            queryWay = searchDomain.getQueryType();
        }
        collapseStr = StringUtils.isNotBlank((String)(collapseStr = searchDomain.getCollapseStr())) ? "," + collapseStr : "";
        if (StringUtils.isNotBlank((String)accqueryStr)) {
            if (StringUtils.isNotBlank((String)queryStr)) {
                queryStr = "," + queryStr;
            }
            queryJson = StringUtils.isNotBlank((String)buyAccqueryStr) ? "{\"query\":{\"bool\":{\"must\" : [{\"bool\":{\"should\":[{\"bool\":{\"" + queryWay + "\":[" + accqueryStr + queryStr + (String)var13_18 + "]}},{\"bool\":{\"" + queryWay + "\":[" + buyAccqueryStr + queryStr + (String)var13_18 + "]}}]}}]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var18_38 + collapseStr + "}" : "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + accqueryStr + queryStr + (String)var13_18 + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var18_38 + collapseStr + "}";
            if (StringUtils.isNotBlank((String)notaccqueryStr)) {
                queryJson = StringUtils.isNotBlank((String)buyAccqueryStr) ? "{\"query\":{\"bool\":{\"must\" : [{\"bool\":{\"should\":[{\"bool\":{\"" + queryWay + "\":[" + accqueryStr + queryStr + (String)var13_18 + "],\"must_not\":[" + notaccqueryStr + "]}},{\"bool\":{\"" + queryWay + "\":[" + buyAccqueryStr + queryStr + (String)var13_18 + "],\"must_not\":[" + notaccqueryStr + "]}}]}}]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var18_38 + collapseStr + "}" : "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + accqueryStr + queryStr + (String)var13_18 + "],\"must_not\":[" + notaccqueryStr + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var18_38 + collapseStr + "}";
            }
        } else {
            void var13_21;
            if (!StringUtils.isNotBlank((String)queryStr)) {
                String string10 = var13_18.trim();
                string10 = string10.substring(1);
            }
            queryJson = "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + queryStr + (String)var13_21 + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var18_38 + collapseStr + "}";
            if (StringUtils.isNotBlank((String)notaccqueryStr)) {
                queryJson = "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + queryStr + (String)var13_21 + "],\"must_not\":[" + notaccqueryStr + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var18_38 + collapseStr + "}";
            }
        }
        try {
            long times = System.currentTimeMillis();
            String str = this.esUtil.httpUrlPoolGet(data, searchDomain.getBizType(), queryJson);
            OpenPerfLogUtil.info((String)("[find]htt:{},api:" + searchDomain.getBizType()), (long)(System.currentTimeMillis() - times));
            if (StringUtils.isBlank((String)str)) {
                this.logger.error("es.SearchengineServiceImpl.str", (Object)queryJson);
                return null;
            }
            RestBean restBean = (RestBean)JsonUtil.buildNormalBinder().getJsonToObject(str, RestBean.class);
            if (null == restBean || null == restBean.getHits()) {
                this.logger.error("es.SearchengineServiceImpl.queryJson", (Object)queryJson);
                this.logger.error("es.SearchengineServiceImpl.restBean", (Object)str);
                return null;
            }
            if (null == restBean.getHits().getHits()) {
                this.logger.info("es.SearchengineServiceImpl.hits", (Object)queryJson);
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            List<DataHits> list = restBean.getHits().getHits();
            if (null == list || list.isEmpty()) {
                return null;
            }
            ArrayList<Map<String, Object>> sourcelist = new ArrayList<Map<String, Object>>();
            for (DataHits dataHits : list) {
                HashMap<String, Double> dataHit = new HashMap<String, Double>();
                try {
                    BeanUtils.copyAllPropertys(dataHit, dataHits.get_source());
                    dataHit.put("score", dataHits.get_score());
                }
                catch (Exception e) {
                    this.logger.error(SYS_CODE, (Object)"search response convert exception:", (Throwable)e);
                }
                sourcelist.add(dataHit);
            }
            returnBean.setAggregations(restBean.getAggregations());
            returnBean.setSourcelist(sourcelist);
            returnBean.setCount(restBean.getHits().getTotal());
            returnBean.setPage(page);
            returnBean.setRow(rows);
            return returnBean;
        }
        catch (IOException e) {
            this.logger.error("es.SearchengineServiceImpl.find.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public void refresh(SearchDomain searchDomain) throws ApiException {
    }

    @Override
    public String deletePm(PmPromotionDomain pmPromotionDomain) {
        if (null == pmPromotionDomain) {
            return "error";
        }
        return this.makePm(pmPromotionDomain, true);
    }

    @Override
    public String updatePm(PmPromotionDomain pmPromotionDomain) {
        if (null == pmPromotionDomain) {
            return "error";
        }
        return this.makePm(pmPromotionDomain, false);
    }

    @Override
    public String insertPm(PmPromotionDomain pmPromotionDomain) {
        if (null == pmPromotionDomain) {
            return "error";
        }
        return this.makePm(pmPromotionDomain, false);
    }

    public String makePm(PmPromotionDomain pmPromotionDomain, boolean delflag) {
        if (null == pmPromotionDomain) {
            return "error";
        }
        String tenantCode = pmPromotionDomain.getTenantCode();
        Integer rows = 50;
        Integer page = 1;
        SearchDomain searchDomain = new SearchDomain();
        searchDomain.setTenantCode(tenantCode);
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        pageMap.put("rows", rows);
        pageMap.put("page", page);
        searchDomain.setPageMap(pageMap);
        this.makeEsquery(pmPromotionDomain, searchDomain);
        searchDomain.setBizType("goods");
        this.query(rows, searchDomain, pmPromotionDomain, delflag);
        searchDomain.setBizType("sku");
        this.query(rows, searchDomain, pmPromotionDomain, delflag);
        return "success";
    }

    private void query(Integer rows, SearchDomain searchDomain, PmPromotionDomain pmPromotionDomain, boolean delflag) {
        boolean flag = true;
        Integer page = 1;
        int errorCount = 0;
        do {
            try {
                HashMap<String, Object> pageMap = new HashMap<String, Object>();
                pageMap.put("rows", rows);
                pageMap.put("page", page);
                searchDomain.setPageMap(pageMap);
                ReturnBean returnBean = this.find(searchDomain);
                if (null == returnBean || ListUtil.isEmpty(returnBean.getSourcelist())) {
                    this.logger.error("es.SearchengineServiceImpl.query.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)searchDomain));
                    flag = false;
                } else {
                    SearchengineServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(SearchengineServiceImpl.getEsEngineService(), returnBean.getSourcelist(), pmPromotionDomain, delflag, searchDomain.getBizType()));
                    if (returnBean.getSourcelist().size() != SearchengineServiceImpl.getEsEngineService().getPage()) {
                        flag = false;
                    }
                }
                Integer n = page;
                Integer n2 = page = Integer.valueOf(page + 1);
            }
            catch (Exception e) {
                this.logger.error("es.SearchengineServiceImpl.query.e", (Throwable)e);
                e.printStackTrace();
                if (errorCount != 5) continue;
                flag = false;
            }
        } while (flag);
        SearchengineServiceImpl.getEsEngineService().initStartRow();
    }

    private SearchDomain makeEsquery(PmPromotionDomain pmPromotionDomain, SearchDomain searchDomain) {
        List<PmPromotionRangelistDomain> pmPromotionRangeList;
        AccurateQueryDomain accurateQueryDomain;
        if (null == pmPromotionDomain || null == searchDomain) {
            this.logger.error("es.SearchengineServiceImpl.makeEsquery.pmPromotionInDomain");
            return searchDomain;
        }
        String memberCcode = pmPromotionDomain.getMemberCcode();
        String channelCode = pmPromotionDomain.getChannelCode();
        List<AccurateQueryDomain> accurateQueryList = new ArrayList<AccurateQueryDomain>();
        searchDomain.setAccurateQueryList(accurateQueryList);
        if (StringUtils.isNotBlank((String)memberCcode)) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("memberCcode.keyword");
            accurateQueryDomain.setAccurateFieldValue(memberCcode);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (StringUtils.isNotBlank((String)channelCode)) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("channelCode.keyword");
            accurateQueryDomain.setAccurateFieldValue(channelCode);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (ListUtil.isEmpty(pmPromotionRangeList = pmPromotionDomain.getPmPromotionRangeList())) {
            this.logger.error("es.SearchengineServiceImpl.makeEsquery.pmPromotionRangeList");
            return searchDomain;
        }
        String value = "";
        String valueList = "";
        if (pmPromotionDomain.getRangeType().intValue() != SearchengineConstants.RANGE_TYPE_1.intValue()) {
            if (pmPromotionDomain.getRangeType().intValue() == SearchengineConstants.RANGE_TYPE_2.intValue()) {
                value = "pntreeCode";
            } else if (pmPromotionDomain.getRangeType().intValue() == SearchengineConstants.RANGE_TYPE_3.intValue()) {
                value = "brandCode";
            } else if (pmPromotionDomain.getRangeType().intValue() == SearchengineConstants.RANGE_TYPE_4.intValue()) {
                value = "classtreeCode";
            } else if (pmPromotionDomain.getRangeType().intValue() == SearchengineConstants.RANGE_TYPE_5.intValue()) {
                value = "skuNo";
                valueList = "skuNoList";
            }
        }
        String term = "";
        ArrayList<String> accurateFieldValues = new ArrayList<String>();
        ArrayList<String> notaccurateFieldValues = new ArrayList<String>();
        for (PmPromotionRangelistDomain pmPromotionRangelistDomain : pmPromotionRangeList) {
            if (1 == pmPromotionRangelistDomain.getPprlType()) continue;
            term = pmPromotionRangelistDomain.getPprlTerm();
            if (StringUtils.isBlank((String)term)) {
                term = "=";
            }
            if ("=".equals(term)) {
                accurateFieldValues.add(pmPromotionRangelistDomain.getRangeCode());
                continue;
            }
            notaccurateFieldValues.add(pmPromotionRangelistDomain.getRangeCode());
        }
        if (ListUtil.isNotEmpty(accurateFieldValues)) {
            AccurateQueryDomain accurateQueryDomain2;
            accurateQueryList = searchDomain.getAccurateQueryList();
            if (null == accurateQueryList) {
                accurateQueryList = new ArrayList();
                searchDomain.setAccurateQueryList(accurateQueryList);
            }
            if (StringUtils.isNotBlank((String)value)) {
                accurateQueryDomain2 = new AccurateQueryDomain();
                accurateQueryDomain2.setAccurateField(value + ".keyword");
                accurateQueryDomain2.setAccurateFieldValues(accurateFieldValues);
                accurateQueryList.add(accurateQueryDomain2);
            }
            if (StringUtils.isNotBlank((String)valueList)) {
                accurateQueryDomain2 = new AccurateQueryDomain();
                accurateQueryDomain2.setAccurateField(valueList + ".keyword");
                accurateQueryDomain2.setAccurateFieldValues(accurateFieldValues);
                accurateQueryList.add(accurateQueryDomain2);
            }
        }
        if (ListUtil.isNotEmpty(notaccurateFieldValues)) {
            AccurateQueryDomain accurateQueryDomain3;
            ArrayList<AccurateQueryDomain> notaccurateQueryList = new ArrayList<AccurateQueryDomain>();
            if (StringUtils.isNotBlank((String)value)) {
                accurateQueryDomain3 = new AccurateQueryDomain();
                accurateQueryDomain3.setAccurateField(value + ".keyword");
                accurateQueryDomain3.setAccurateFieldValues(notaccurateFieldValues);
                notaccurateQueryList.add(accurateQueryDomain3);
                searchDomain.setNotaccurateQueryList(notaccurateQueryList);
            }
            if (StringUtils.isNotBlank((String)valueList)) {
                accurateQueryDomain3 = new AccurateQueryDomain();
                accurateQueryDomain3.setAccurateField(valueList + ".keyword");
                accurateQueryDomain3.setAccurateFieldValues(accurateFieldValues);
                notaccurateQueryList.add(accurateQueryDomain3);
            }
        }
        return searchDomain;
    }

    @Override
    public String updateStore(EsBean esBean) throws ApiException {
        if (null == esBean || null == esBean.getPmPromotionDomain() || null == esBean.getRsData()) {
            this.logger.error("es.SearchengineServiceImpl.updateStore.null");
            return null;
        }
        try {
            return this.updateStoreEs(esBean);
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.updateStore.e", (Throwable)e);
            return null;
        }
    }

    public String updateStoreEs(EsBean esBean) throws ApiException {
        if (null == esBean || null == esBean.getPmPromotionDomain() || null == esBean.getRsData()) {
            this.logger.error("es.SearchengineServiceImpl.updateStore.null");
            return null;
        }
        this.logger.error("es.SearchengineServiceImpl.updateStoreEs.esBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)esBean));
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setBizType(esBean.getBizType());
        storeDomain.setTenantCode(esBean.getPmPromotionDomain().getTenantCode());
        storeDomain.setRequestType(StoreEnum.ESUPDATE.getType());
        if ("goods".equals(storeDomain.getBizType())) {
            storeDomain.setBizId(esBean.getPmPromotionDomain().getTenantCode() + (String)esBean.getRsData().get("goodsCode"));
        } else {
            storeDomain.setBizId(esBean.getPmPromotionDomain().getTenantCode() + (String)esBean.getRsData().get("skuCode"));
        }
        if (!esBean.isDelflag()) {
            List<PmPromotionRangelistDomain> pmPromotionRangeList;
            if ("5".equals(esBean.getPmPromotionDomain().getPromotionInType()) && ListUtil.isNotEmpty(esBean.getPmPromotionDomain().getPmPromotionDiscountList()) && ListUtil.isNotEmpty(pmPromotionRangeList = esBean.getPmPromotionDomain().getPmPromotionRangeList())) {
                BigDecimal pricesetNprice = new BigDecimal(String.valueOf(esBean.getRsData().get("pricesetNprice")));
                for (PmPromotionRangelistDomain pmPromotionDiscountlistDomain : pmPromotionRangeList) {
                    if (null == pmPromotionDiscountlistDomain.getDiscountAmount1()) {
                        pmPromotionDiscountlistDomain.setDiscountAmount1(BigDecimal.ZERO);
                    }
                    if (pricesetNprice.compareTo(pmPromotionDiscountlistDomain.getDiscountAmount1()) <= 0) continue;
                    esBean.getRsData().put("minPricesetNprice", pmPromotionDiscountlistDomain.getDiscountAmount1());
                    esBean.getRsData().put("pricesetNprice", pmPromotionDiscountlistDomain.getDiscountAmount1());
                }
            }
            List pmListdata = (List)esBean.getRsData().get("pmPromotionDomainList");
            ArrayList<Map> newpmListdata = new ArrayList<Map>();
            HashMap<String, String> pb = new HashMap<String, String>();
            boolean add = false;
            if (ListUtil.isNotEmpty((Collection)pmListdata)) {
                for (Map map2 : pmListdata) {
                    if (((String)map2.get("promotionCode")).equals(esBean.getPmPromotionDomain().getPromotionCode())) {
                        add = true;
                        PmPromotionInDomain pmPromotionInDomain = new PmPromotionInDomain();
                        try {
                            BeanUtils.copyAllPropertys((Object)pmPromotionInDomain, (Object)esBean.getPmPromotionDomain());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        map2 = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)pmPromotionInDomain), String.class, Object.class);
                    }
                    newpmListdata.add(map2);
                    pb.put((String)map2.get("pbCode"), (String)map2.get("pbName"));
                }
            }
            if (!add) {
                Map map2;
                PmPromotionInDomain pmPromotionInDomain = new PmPromotionInDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)pmPromotionInDomain, (Object)esBean.getPmPromotionDomain());
                }
                catch (Exception map2) {
                    // empty catch block
                }
                map2 = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)pmPromotionInDomain), String.class, Object.class);
                newpmListdata.add(map2);
            }
            this.logger.error("es.SearchengineServiceImpl.updateStoreEs.newpmListdata", (Object)JsonUtil.buildNormalBinder().toJson(newpmListdata));
            if (ListUtil.isEmpty(newpmListdata)) {
                esBean.getRsData().put("pmflag", 0);
            } else {
                esBean.getRsData().put("pmflag", 1);
            }
            ArrayList pmbaseFlag = new ArrayList();
            if (MapUtil.isNotEmpty(pb)) {
                for (String key : pb.keySet()) {
                    HashMap<String, String> pmap = new HashMap<String, String>();
                    pmap.put("pbCode", key);
                    pmap.put("pbName", (String)pb.get(key));
                    pmbaseFlag.add(pmap);
                }
            }
            esBean.getRsData().put("pmbaseFlag", pmbaseFlag);
            esBean.getRsData().put("pmPromotionDomainList", newpmListdata);
        } else {
            List pmListdata = (List)esBean.getRsData().get("pmPromotionDomainList");
            if (ListUtil.isNotEmpty((Collection)pmListdata)) {
                ArrayList<Map> newpmListdata = new ArrayList<Map>();
                HashMap<String, String> pb = new HashMap<String, String>();
                for (Map map : pmListdata) {
                    if (((String)map.get("promotionCode")).equals(esBean.getPmPromotionDomain().getPromotionCode())) continue;
                    newpmListdata.add(map);
                    pb.put((String)map.get("pbCode"), (String)map.get("pbName"));
                }
                if (ListUtil.isEmpty(newpmListdata)) {
                    esBean.getRsData().put("pmflag", 0);
                }
                this.logger.error("es.SearchengineServiceImpl.updateStoreEs.newpmListdata", (Object)JsonUtil.buildNormalBinder().toJson(newpmListdata));
                ArrayList pmbaseFlag = new ArrayList();
                if (MapUtil.isNotEmpty(pb)) {
                    for (String key : pb.keySet()) {
                        HashMap<String, String> pmap = new HashMap<String, String>();
                        pmap.put("pbCode", key);
                        pmap.put("pbName", (String)pb.get(key));
                        pmbaseFlag.add(pmap);
                    }
                }
                esBean.getRsData().put("pmbaseFlag", pmbaseFlag);
                esBean.getRsData().put("pmPromotionDomainList", newpmListdata);
            }
        }
        storeDomain.setStoreObj(JSON.toJSONString(esBean.getRsData()));
        this.logger.error("es.SearchengineServiceImpl.updateStoreEs.storeDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        if (!this.store(storeDomain)) {
            this.logger.error("es.SearchengineServiceImpl.updateStore.store", storeDomain.getStoreObj());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsEngineService getEsEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 100; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    static {
        lock = new Object();
    }
}

