/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.service.impl;

import com.yqbsoft.laser.service.esb.annotation.ApiMethod;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.searchengine.domain.AccurateQueryDomain;
import com.yqbsoft.laser.service.searchengine.domain.DataHits;
import com.yqbsoft.laser.service.searchengine.domain.RestBean;
import com.yqbsoft.laser.service.searchengine.domain.ReturnBean;
import com.yqbsoft.laser.service.searchengine.domain.SearchDomain;
import com.yqbsoft.laser.service.searchengine.domain.SortDomain;
import com.yqbsoft.laser.service.searchengine.domain.StoreDomain;
import com.yqbsoft.laser.service.searchengine.enums.ConstantEnums;
import com.yqbsoft.laser.service.searchengine.index.StoreEnum;
import com.yqbsoft.laser.service.searchengine.service.SearchengineService;
import com.yqbsoft.laser.service.searchengine.util.EsUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchengineServiceImpl
extends BaseServiceImpl
implements SearchengineService {
    private static final String SYS_CODE = "es.SearchengineServiceImpl";
    @Autowired
    EsUtil esUtil;

    private static String list2string(List<String> params) {
        String result = "";
        String res = "";
        for (String s : params) {
            res = res + "\"" + s + "\",";
        }
        result = "[" + res.substring(0, res.length() - 1) + "]";
        return result;
    }

    @Override
    @ApiMethod(code="es.searchengine.store", name="\u6570\u636e\u5b58\u50a8", paramStr="storeDomain", description="")
    public boolean store(StoreDomain storeDomain) throws ApiException {
        if (null == storeDomain || StringUtils.isBlank((String)storeDomain.getTenantCode()) || StringUtils.isBlank((String)storeDomain.getRequestType())) {
            return false;
        }
        this.logger.debug(SYS_CODE, (Object)("storeDomain info:" + storeDomain));
        String id = storeDomain.getBizId();
        if (StringUtils.isBlank((String)id)) {
            return false;
        }
        String type = storeDomain.getBizType();
        if (StringUtils.isBlank((String)type)) {
            return false;
        }
        String requestType = storeDomain.getRequestType();
        String method = "POST";
        String data = storeDomain.getTenantCode();
        this.logger.error("es.SearchengineServiceImpl.requestType", (Object)(requestType + "=" + storeDomain.getBizId()));
        if (StoreEnum.INSERT.getType().equals(requestType) || StoreEnum.SKUINSERT.getType().equals(requestType) || StoreEnum.SKUADD.getType().equals(requestType)) {
            method = "POST";
        } else if (StoreEnum.ESUPDATE.getType().equals(requestType) || StoreEnum.UPDATE.getType().equals(requestType) || StoreEnum.EDIT.getType().equals(requestType)) {
            method = "UPDATE";
        } else if (StoreEnum.DELETE.getType().equals(requestType) || StoreEnum.DELETEOP.getType().equals(requestType) || StoreEnum.SKUDELETE.getType().equals(requestType) || StoreEnum.SKUDELETEOP.getType().equals(requestType) || StoreEnum.SKUDOWN.getType().equals(requestType) || StoreEnum.DOWN.getType().equals(requestType)) {
            method = "DELETE";
        } else {
            this.logger.error("es.SearchengineServiceImpl.requestType.return", (Object)(requestType + "=" + storeDomain.getBizId()));
            return true;
        }
        String queryParamJson = "";
        if (null != storeDomain.getStoreObj()) {
            queryParamJson = storeDomain.getStoreObj().toString();
        }
        try {
            this.esUtil.httpUrlInsert(queryParamJson, method, data, type, id);
            return true;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.store", (Throwable)e);
            return false;
        }
    }

    @Override
    public Map<String, Object> findByCode(String opcode, String bizType, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)opcode) || StringUtils.isBlank((String)bizType) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("es.SearchengineServiceImpl.findByCode.null", (Object)"null");
            return null;
        }
        try {
            long times = System.currentTimeMillis();
            String str = this.esUtil.httpUrlPoolGetByCode(tenantCode, bizType, opcode);
            this.logger.info("es.SearchengineServiceImpl.findByCode.find", (Object)(opcode + "=" + (System.currentTimeMillis() - times)));
            if (StringUtils.isBlank((String)str)) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.str", (Object)opcode);
                return null;
            }
            DataHits remap = (DataHits)JsonUtil.buildNormalBinder().getJsonToObject(str, DataHits.class);
            if (null == remap || MapUtil.isEmpty(remap.get_source())) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.remap", (Object)str);
                return null;
            }
            return remap.get_source();
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.findByCode.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public ReturnBean newFind(SearchDomain searchDomain) throws ApiException {
        int from;
        if (null == searchDomain || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.find.null", (Object)"null");
            return null;
        }
        this.logger.debug(SYS_CODE, (Object)("searchDomain info:" + searchDomain));
        String data = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("es.SearchengineServiceImpl.find.data", (Object)"data");
            return null;
        }
        Map<String, Object> pageMap = searchDomain.getPageMap();
        Integer rows = 10;
        Integer page = 1;
        if (null != pageMap && !pageMap.isEmpty()) {
            rows = Integer.parseInt(pageMap.get("rows").toString());
            page = Integer.parseInt(pageMap.get("page").toString());
        }
        if (null == rows || rows == 0) {
            rows = 10;
        }
        if (null == page) {
            page = 1;
        }
        if ((from = (Integer.valueOf(page) - 1) * Integer.valueOf(rows)) < 0) {
            from = 0;
        }
        String queryJson = "";
        String sortStr = "\"sort\":[";
        String sortList = "";
        if (null != searchDomain.getSortDomain()) {
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getOrder())) {
                searchDomain.getSortDomain().setOrder(searchDomain.getSortDomain().getOrder().toLowerCase());
            }
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getSortField())) {
                sortList = sortList + " { \"" + searchDomain.getSortDomain().getSortField() + "\": { \"order\": \"" + searchDomain.getSortDomain().getOrder() + "\" }}";
            }
            if (ListUtil.isEmpty(searchDomain.getSortDomain().getSortDomainList())) {
                for (SortDomain sortDomain : searchDomain.getSortDomain().getSortDomainList()) {
                    if (StringUtils.isNotBlank((String)sortList)) {
                        sortList = sortList + ",";
                    }
                    sortList = sortList + " { \"" + sortDomain.getSortField() + "\": { \"order\": \"" + sortDomain.getOrder() + "\" }}";
                }
            }
            sortStr = sortStr + sortList;
        } else {
            sortStr = sortStr + " { \"_score\": { \"order\": \"desc\" }}";
        }
        sortStr = sortStr + "]";
        String musQueryStr = "";
        String mustNotQueryStr = "";
        if (null != searchDomain.getAccurateQueryList() && !searchDomain.getAccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getAccurateQueryList()) {
                if ("must_not".equals(accurateQueryDomain.getAccurateFieType())) {
                    if (StringUtils.isNotBlank((String)mustNotQueryStr)) {
                        mustNotQueryStr = mustNotQueryStr + ",";
                    }
                    if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                        mustNotQueryStr = mustNotQueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues()) + "}}";
                        continue;
                    }
                    mustNotQueryStr = mustNotQueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
                    continue;
                }
                if (StringUtils.isNotBlank((String)musQueryStr)) {
                    musQueryStr = musQueryStr + ",";
                }
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    musQueryStr = musQueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues()) + "}}";
                    continue;
                }
                musQueryStr = musQueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
            }
        }
        String aggregationsStr = "";
        if (MapUtil.isNotEmpty(searchDomain.getGroupListMap()) || MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
            String liststr;
            aggregationsStr = aggregationsStr + "\"aggregations\":{";
            String px = "";
            if (MapUtil.isNotEmpty(searchDomain.getGroupListMap())) {
                liststr = "";
                Object value = "20";
                for (String key : searchDomain.getGroupListMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    value = String.valueOf(searchDomain.getGroupListMap().get(key));
                    liststr = liststr + "\"" + key + "\":{\"terms\":{\"field\":\"" + key + ".keyword\",\"size\":" + (String)value + "}}";
                }
                aggregationsStr = aggregationsStr + liststr;
                px = ",";
            }
            if (MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
                liststr = "";
                for (String key : searchDomain.getGroupNumMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    liststr = liststr + "\"" + key + "min\":{\"min\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "max\":{\"max\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "avg\":{\"avg\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "sum\":{\"sum\":{\"field\":\"" + key + "\"}}";
                }
                aggregationsStr = aggregationsStr + px + liststr;
            }
            aggregationsStr = aggregationsStr + "}";
        }
        if (StringUtils.isNotBlank((String)aggregationsStr)) {
            aggregationsStr = "," + aggregationsStr;
        }
        String headStr = "{\"query\":{\"bool\":{\"";
        String endStr = "}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + aggregationsStr + "}";
        if (StringUtils.isNotBlank((String)musQueryStr)) {
            queryJson = headStr + "must\":[" + musQueryStr + "]";
        }
        if (StringUtils.isNotBlank((String)mustNotQueryStr)) {
            queryJson = queryJson + ",\"must_not\":[" + mustNotQueryStr + "]";
        }
        queryJson = queryJson + endStr;
        this.logger.error("es.SearchengineServiceImpl.newFind.queryJson", (Object)queryJson);
        try {
            long times = System.currentTimeMillis();
            String str = this.esUtil.httpUrlPoolGet(data, searchDomain.getBizType(), queryJson);
            OpenPerfLogUtil.info((String)("[find]htt:{},api:" + searchDomain.getBizType()), (long)(System.currentTimeMillis() - times));
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            RestBean restBean = (RestBean)JsonUtil.buildNormalBinder().getJsonToObject(str, RestBean.class);
            if (null == restBean || null == restBean.getHits() || null == restBean.getHits().getHits()) {
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            List<DataHits> list = restBean.getHits().getHits();
            if (null == list || list.isEmpty()) {
                return null;
            }
            ArrayList<Map<String, Object>> sourcelist = new ArrayList<Map<String, Object>>();
            for (DataHits dataHits : list) {
                HashMap<String, Double> dataHit = new HashMap<String, Double>();
                try {
                    BeanUtils.copyAllPropertys(dataHit, dataHits.get_source());
                    dataHit.put("score", dataHits.get_score());
                }
                catch (Exception e) {
                    this.logger.error(SYS_CODE, (Object)"search response convert exception:", (Throwable)e);
                }
                sourcelist.add(dataHit);
            }
            returnBean.setAggregations(restBean.getAggregations());
            returnBean.setSourcelist(sourcelist);
            returnBean.setCount(restBean.getHits().getTotal());
            returnBean.setPage(page);
            returnBean.setRow(rows);
            return returnBean;
        }
        catch (IOException e) {
            this.logger.error("es.SearchengineServiceImpl.find.e", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ApiMethod(code="es.searchengine.find", name="\u83b7\u53d6\u6570\u636e", paramStr="searchDomain", description="")
    public ReturnBean find(SearchDomain searchDomain) throws ApiException {
        void var14_35;
        void var14_33;
        void var13_17;
        int from;
        if (null == searchDomain || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.find.null", (Object)"null");
            return null;
        }
        this.logger.debug(SYS_CODE, (Object)("searchDomain info:" + searchDomain));
        String data = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("es.SearchengineServiceImpl.find.data", (Object)"data");
            return null;
        }
        Map<String, Object> pageMap = searchDomain.getPageMap();
        Integer rows = 10;
        Integer page = 1;
        if (null != pageMap && !pageMap.isEmpty()) {
            rows = Integer.parseInt(pageMap.get("rows").toString());
            page = Integer.parseInt(pageMap.get("page").toString());
        }
        if (null == rows || rows == 0) {
            rows = 10;
        }
        if (null == page) {
            page = 1;
        }
        if ((from = (Integer.valueOf(page) - 1) * Integer.valueOf(rows)) < 0) {
            from = 0;
        }
        String queryStr = "";
        String matchQuery = "";
        String queryJson = "";
        String sortStr = "\"sort\":[";
        String sortList = "";
        if (null != searchDomain.getSortDomain()) {
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getSortField())) {
                sortList = sortList + " { \"" + searchDomain.getSortDomain().getSortField() + "\": { \"order\": \"" + searchDomain.getSortDomain().getOrder() + "\" }}";
            }
            if (ListUtil.isEmpty(searchDomain.getSortDomain().getSortDomainList())) {
                for (SortDomain sortDomain : searchDomain.getSortDomain().getSortDomainList()) {
                    if (StringUtils.isNotBlank((String)sortList)) {
                        sortList = sortList + ",";
                    }
                    sortList = sortList + " { \"" + sortDomain.getSortField() + "\": { \"order\": \"" + sortDomain.getOrder() + "\" }}";
                }
            }
            sortStr = sortStr + sortList;
        } else {
            sortStr = sortStr + " { \"_score\": { \"order\": \"desc\" }}";
        }
        sortStr = sortStr + "]";
        if (null != searchDomain.getBoolMap() && !searchDomain.getBoolMap().isEmpty()) {
            Object obj = null;
            for (String string : searchDomain.getBoolMap().keySet()) {
                if (StringUtils.isNotBlank((String)matchQuery)) {
                    matchQuery = matchQuery + ",";
                }
                obj = searchDomain.getBoolMap().get(string);
                if ("match_phrase".equals(searchDomain.getSearchType())) {
                    matchQuery = matchQuery + "{\"match_phrase\":{\"" + string + "\":{\"query\":\"" + obj + "\"}}}";
                    continue;
                }
                matchQuery = matchQuery + "{\"wildcard\": { \"" + string + ".keyword\":\"*" + obj + "*\"}},";
                matchQuery = matchQuery + "{\"match\": { \"" + string + "\":\"" + obj + "\"}}";
            }
            queryStr = "match_phrase".equals(searchDomain.getSearchType()) ? matchQuery : "{\"bool\":{\"should\":[" + matchQuery + "]}}";
        }
        String priceRangeQuery = ",{\"range\": {\n      \"pricesetNprice\": {\n        \"gte\": " + searchDomain.getMinPrice() + "      }\n    }}";
        if (null != searchDomain.getMaxPrice()) {
            priceRangeQuery = ",{\"range\": {\n      \"pricesetNprice\": {\n        \"gte\": " + searchDomain.getMinPrice() + ",\n        \"lte\": " + searchDomain.getMaxPrice() + "\n      }\n    }}";
        }
        String string = "";
        if (null != searchDomain.getAccurateQueryList() && !searchDomain.getAccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getAccurateQueryList()) {
                void var13_19;
                if (StringUtils.isNotBlank((String)var13_17)) {
                    String string2 = (String)var13_17 + ",";
                }
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    String string3 = (String)var13_19 + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues()) + "}}";
                    continue;
                }
                String string4 = (String)var13_19 + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
            }
        }
        String string5 = "";
        if (MapUtil.isNotEmpty(searchDomain.getGroupListMap()) || MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
            void var14_31;
            String liststr;
            String string6 = string5 + "\"aggregations\":{";
            String px = "";
            if (MapUtil.isNotEmpty(searchDomain.getGroupListMap())) {
                liststr = "";
                String value = "20";
                for (String key : searchDomain.getGroupListMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    value = String.valueOf(searchDomain.getGroupListMap().get(key));
                    liststr = liststr + "\"" + key + "\":{\"terms\":{\"field\":\"" + key + ".keyword\",\"size\":" + value + "}}";
                }
                String string7 = string6 + liststr;
                px = ",";
            }
            if (MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
                void var14_29;
                liststr = "";
                for (String key : searchDomain.getGroupNumMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    liststr = liststr + "\"" + key + "min\":{\"min\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "max\":{\"max\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "avg\":{\"avg\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "sum\":{\"sum\":{\"field\":\"" + key + "\"}}";
                }
                String string8 = (String)var14_29 + px + liststr;
            }
            String string9 = (String)var14_31 + "}";
        }
        if (StringUtils.isNotBlank((String)var14_33)) {
            String string10 = "," + (String)var14_33;
        }
        String queryWay = ConstantEnums.must.getCode();
        if (StringUtils.isNotBlank((String)searchDomain.getQueryType())) {
            queryWay = searchDomain.getQueryType();
        }
        this.logger.error("es.SearchengineServiceImpl.find.queryWay", (Object)queryWay);
        if (StringUtils.isNotBlank((String)var13_17)) {
            queryJson = StringUtils.isNotBlank((String)queryStr) ? "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + (String)var13_17 + "," + queryStr + priceRangeQuery + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var14_35 + "}" : "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + (String)var13_17 + priceRangeQuery + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var14_35 + "}";
        } else if (StringUtils.isNotBlank((String)queryStr)) {
            queryJson = "match_phrase".equals(searchDomain.getSearchType()) ? "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + queryStr + priceRangeQuery + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var14_35 + "}" : "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + queryStr + priceRangeQuery + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var14_35 + "}";
        } else {
            priceRangeQuery = priceRangeQuery.replace(",", "");
            queryJson = "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + priceRangeQuery + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var14_35 + "}";
        }
        try {
            long times = System.currentTimeMillis();
            String str = this.esUtil.httpUrlPoolGet(data, searchDomain.getBizType(), queryJson);
            OpenPerfLogUtil.info((String)("[find]htt:{},api:" + searchDomain.getBizType()), (long)(System.currentTimeMillis() - times));
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            RestBean restBean = (RestBean)JsonUtil.buildNormalBinder().getJsonToObject(str, RestBean.class);
            if (null == restBean || null == restBean.getHits() || null == restBean.getHits().getHits()) {
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            List<DataHits> list = restBean.getHits().getHits();
            if (null == list || list.isEmpty()) {
                return null;
            }
            ArrayList<Map<String, Object>> sourcelist = new ArrayList<Map<String, Object>>();
            for (DataHits dataHits : list) {
                HashMap<String, Double> dataHit = new HashMap<String, Double>();
                try {
                    BeanUtils.copyAllPropertys(dataHit, dataHits.get_source());
                    dataHit.put("score", dataHits.get_score());
                }
                catch (Exception e) {
                    this.logger.error(SYS_CODE, (Object)"search response convert exception:", (Throwable)e);
                }
                sourcelist.add(dataHit);
            }
            returnBean.setAggregations(restBean.getAggregations());
            returnBean.setSourcelist(sourcelist);
            returnBean.setCount(restBean.getHits().getTotal());
            returnBean.setPage(page);
            returnBean.setRow(rows);
            return returnBean;
        }
        catch (IOException e) {
            this.logger.error("es.SearchengineServiceImpl.find.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public void refresh(SearchDomain searchDomain) throws ApiException {
    }
}

