/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.util;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.searchengine.util.ElasticConfig;
import com.yqbsoft.laser.service.searchengine.util.EshttpUtils;
import com.yqbsoft.laser.service.searchengine.util.HttpClientPoolHelper;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"elasticConfig"})
public class EsUtil {
    private static final SupperLogUtil logger = new SupperLogUtil(EsUtil.class);
    private static HttpClientPoolHelper httpcph = HttpClientPoolHelper.getInstance();
    private static String bash_searchurl;
    private static String bash_user;
    private static String bash_pw;
    @Autowired
    private ElasticConfig elasticConfig;

    public static void main(String[] args) {
        try {
            System.out.println(EshttpUtils.processPostJson("http://www.baidu.com", null, null, null, "TLSv1.2"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initBash() {
        if (StringUtils.isBlank((String)bash_searchurl)) {
            try {
                bash_searchurl = this.elasticConfig.getUrl();
                bash_user = this.elasticConfig.getUsername();
                bash_pw = this.elasticConfig.getPassword();
            }
            catch (Exception e) {
                logger.error("httpUrlInsert resourceBundle.getString() Exception:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpUrlPoolGetByCode(String data, String type, String opcode) throws IOException {
        BufferedReader br = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        this.initBash();
        String searchurl = bash_searchurl;
        String user = bash_user;
        String pw = bash_pw;
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/" + opcode;
            logger.debug("esEsUtil.httpUrlPoolGetByCode", (Object)("searchurl:" + searchurl));
        }
        try {
            logger.debug("es.httpUrlPoolGetByCode", (Object)("searchurl:" + searchurl + ", opcode:" + opcode));
            String input = "";
            if (StringUtils.isNotBlank((String)pw)) {
                input = user + ":" + pw;
            }
            String string = httpcph.getRequest(searchurl, input);
            return string;
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlPoolGetByCode.e", (Object)searchurl, (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpUrlPoolGet(String data, String type, String queryParamJson) throws IOException {
        BufferedReader br = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        this.initBash();
        String searchurl = bash_searchurl;
        String user = bash_user;
        String pw = bash_pw;
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/_search";
            logger.debug("esEsUtil.httpUrlPoolGet", (Object)("searchurl:" + searchurl));
        }
        if (null == queryParamJson) {
            queryParamJson = "";
        }
        try {
            String input = "";
            if (StringUtils.isNotBlank((String)pw)) {
                input = user + ":" + pw;
            }
            logger.debug("es.find", (Object)("searchurl:" + searchurl + ", queryParamJson:" + queryParamJson));
            String string = httpcph.postRequest(searchurl, queryParamJson, input);
            return string;
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e", (Object)searchurl, (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpUrlGet(String data, String type, String queryParamJson) throws IOException {
        String method = "GET";
        BufferedReader br = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        this.initBash();
        String searchurl = bash_searchurl;
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/_search";
            logger.info("EsUtil.httpUrlGet.searchurl", (Object)searchurl);
        }
        StringBuilder resultBuilder = new StringBuilder();
        if (null == queryParamJson) {
            queryParamJson = "";
        }
        try {
            String line;
            URL url = new URL(searchurl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method.toUpperCase());
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            conn.setRequestProperty("Content-Length", Integer.toString(queryParamJson.getBytes().length));
            conn.setRequestProperty("Content-Language", "zh-cn");
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            if (StringUtils.isNotBlank((String)queryParamJson)) {
                out = conn.getOutputStream();
                out.write(queryParamJson.getBytes());
            }
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = br.readLine()) != null) {
                resultBuilder.append(line);
                resultBuilder.append('\r');
            }
            String string = resultBuilder.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e", (Object)searchurl, (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    public HttpsURLConnection getEsSSL(String method, String data, String type, String id, Integer len) {
        this.initBash();
        String searchurl = bash_searchurl;
        String username = bash_user;
        String password = bash_pw;
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/" + id;
        }
        if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
            method = "POST";
            searchurl = searchurl + "/_update";
        }
        String input = "";
        if (StringUtils.isNotBlank((String)password)) {
            input = username + ":" + password;
        }
        HttpURLConnection connHttps = null;
        String protocol = "TLSv1.2";
        try {
            URL url = new URL(searchurl);
            if ("https".equals(url.getProtocol())) {
                SSLContext ctx = null;
                try {
                    if (StringUtils.isBlank((String)protocol)) {
                        protocol = "TLS";
                    }
                    ctx = SSLContext.getInstance(protocol);
                    ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                connHttps = (HttpsURLConnection)url.openConnection();
                ((HttpsURLConnection)connHttps).setSSLSocketFactory(ctx.getSocketFactory());
                ((HttpsURLConnection)connHttps).setHostnameVerifier(new EshttpUtils.TrustAnyHostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            if (StringUtils.isNotBlank((String)password)) {
                input = username + ":" + password;
            }
            if (StringUtils.isNotBlank((String)input)) {
                Base64 base = new Base64();
                String encodedPassword = Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
                connHttps.setRequestProperty("Authorization", "Basic " + encodedPassword);
            }
            connHttps.setRequestMethod(method.toUpperCase());
            connHttps.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connHttps.setRequestProperty("Content-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
            connHttps.setUseCaches(false);
            connHttps.setDoOutput(true);
            connHttps.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
            logger.error("=========", (Object)searchurl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connHttps;
    }

    public HttpURLConnection getEs(String method, String data, String type, String id, Integer len) {
        this.initBash();
        String searchurl = bash_searchurl;
        if (StringUtils.isBlank((String)searchurl)) {
            logger.error("EsUtil.getEs.searchurl");
        }
        String username = bash_user;
        String password = bash_pw;
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/" + id;
        }
        if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
            method = "POST";
            searchurl = searchurl + "/_update";
        }
        String input = "";
        if (StringUtils.isNotBlank((String)password)) {
            input = username + ":" + password;
        }
        HttpURLConnection connHttps = null;
        try {
            URL url = new URL(searchurl);
            if (!"https".equals(url.getProtocol())) {
                connHttps = (HttpURLConnection)url.openConnection();
            }
            if (StringUtils.isNotBlank((String)password)) {
                input = username + ":" + password;
            }
            if (StringUtils.isNotBlank((String)input)) {
                Base64 base = new Base64();
                String encodedPassword = Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
                connHttps.setRequestProperty("Authorization", "Basic " + encodedPassword);
            }
            connHttps.setRequestMethod(method.toUpperCase());
            connHttps.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connHttps.setRequestProperty("Content-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
            connHttps.setUseCaches(false);
            connHttps.setDoOutput(true);
            connHttps.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
        }
        catch (Exception e) {
            logger.error("====e=====", (Throwable)e);
        }
        return connHttps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void httpUrlInsert(String dataParamJson, String method, String data, String type, String id) throws Exception {
        if (null == dataParamJson) {
            dataParamJson = "";
        }
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        String searchurl = "";
        try {
            String responseResult;
            if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
                dataParamJson = "{\"doc\":" + dataParamJson + "}";
            }
            if ("DELETE".equals(method.toUpperCase())) {
                dataParamJson = "";
            }
            this.initBash();
            searchurl = bash_searchurl;
            if (StringUtils.isBlank((String)searchurl)) {
                logger.error("EsUtil.getEs.searchurl");
            }
            String username = bash_user;
            String password = bash_pw;
            if (StringUtils.isNotBlank((String)searchurl)) {
                searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/" + id;
            }
            if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
                method = "POST";
                searchurl = searchurl + "/_update";
            }
            String input = "";
            if (StringUtils.isNotBlank((String)password)) {
                input = username + ":" + password;
            }
            if (!StringUtils.isNotBlank((String)(responseResult = httpcph.postRequest(searchurl, dataParamJson, "application/json;charset=UTF-8", input))) || responseResult.indexOf("error") >= 0) {
                logger.error("es.httpUrlInsert.error", (Object)(searchurl + "=" + method.toUpperCase() + "==" + responseResult));
                throw new ApiException("es", "Failed : HTTP error code : " + responseResult);
            }
            logger.info("es.httpUrlInsert.sucess", (Object)(searchurl + "=" + method.toUpperCase()));
        }
        catch (ApiException e) {
            logger.error("es.apiException", (Object)(searchurl + "=" + method.toUpperCase() + "="), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("es.exception", (Object)(searchurl + "=" + method.toUpperCase() + "="), (Throwable)e);
        }
    }

    private class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

