/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.util;

import com.yqbsoft.laser.service.searchengine.util.EshttpUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.FileItem;
import com.yqbsoft.laser.service.tool.util.HttpConnectionThreadLocal;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class EshttpUtils {
    private static final SupperLogUtil logger = new SupperLogUtil(EshttpUtils.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_DELETE = "DELETE";
    public static final String ACCEPT_JSON = "application/json";
    public static HttpClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getHttpClient() {
        String string = "application/json";
        synchronized ("application/json") {
            if (null == client) {
                try {
                    SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
                    X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                    SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)hostnameVerifier);
                    Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
                    PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                    connManager.setMaxTotal(200);
                    connManager.setDefaultMaxPerRoute(15);
                    1 connectionKeepAliveStrategy = new /* Unavailable Anonymous Inner Class!! */;
                    client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).setKeepAliveStrategy((ConnectionKeepAliveStrategy)connectionKeepAliveStrategy).build();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private EshttpUtils() {
    }

    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return EshttpUtils.doPost((String)url, params, (String)"UTF-8", (int)connectTimeout, (int)readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout, String authorization) throws IOException {
        return EshttpUtils.doPost((String)url, params, (String)"UTF-8", (int)connectTimeout, (int)readTimeout, (String)authorization);
    }

    public static String doJsonPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return EshttpUtils.doPost((String)url, params, (String)"UTF-8", (String)"application/json", (int)connectTimeout, (int)readTimeout);
    }

    public static String doPostByJson(String url, Map<String, Object> params, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=UTF-8";
        byte[] content = JsonUtil.buildNormalBinder().toJson(params).getBytes("UTF-8");
        return EshttpUtils.doPost((String)url, (String)"application/json", (String)ctype, (byte[])content, (int)connectTimeout, (int)readTimeout, null);
    }

    public static String doPostJson(String url, Map<String, Object> params, int connectTimeout, int readTimeout, String authorization) throws IOException {
        String ctype = "application/json;charset=UTF-8";
        String json = JsonUtil.buildNormalBinder().toJson(params);
        byte[] content = json.getBytes("UTF-8");
        return EshttpUtils.doPost((String)url, (String)"application/json", (String)ctype, (byte[])content, (int)connectTimeout, (int)readTimeout, null);
    }

    public static String doPostJson(String url, Map<String, Object> params, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/json;charset=UTF-8";
        byte[] content = JsonUtil.buildNormalBinder().toJson(params).getBytes("UTF-8");
        return EshttpUtils.doPost((String)url, (String)"application/json", (String)ctype, (byte[])content, (int)connectTimeout, (int)readTimeout, null);
    }

    public static byte[] doPostReByte(String url, String accept, String ctype, byte[] content, int connectTimeout, int readTimeout, String authorization) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            conn = EshttpUtils.getConnection((URL)new URL(url), (String)"POST", (String)accept, (String)ctype, null, (String)authorization);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            byte[] e = EshttpUtils.getResponseAsStringReByte((HttpURLConnection)conn);
            return e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static byte[] doPostJsonReByte(String url, Map<String, Object> params, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/json;charset=UTF-8";
        byte[] content = JsonUtil.buildNormalBinder().toJson(params).getBytes("UTF-8");
        return EshttpUtils.doPostReByte((String)url, (String)"application/json", (String)ctype, (byte[])content, (int)connectTimeout, (int)readTimeout, null);
    }

    public static <T> T postForObject(String url, String json, Class<T> clazz, int connectTimeout, int readTimeout) throws IOException {
        if (StringUtils.hasBlank((String[])new String[]{url, json})) {
            return null;
        }
        String ctype = "application/x-www-form-urlencoded;charset=UTF-8";
        byte[] content = json.getBytes("UTF-8");
        String resultStr = EshttpUtils.doPost((String)url, (String)"application/json", (String)ctype, (byte[])content, (int)connectTimeout, (int)readTimeout, null);
        return (T)JsonUtil.buildNonDefaultBinder().getJsonToObject(resultStr, clazz);
    }

    public static String doDelete(String url, int connectTimeout, int readTimeout) throws IOException {
        return EshttpUtils.doDelete((String)url, (String)"UTF-8", (int)connectTimeout, (int)readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout) {
        try {
            return EshttpUtils.doPost((String)url, params, (String)charset, (int)connectTimeout, (int)readTimeout, null);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String doPost(String url, String ctype, Map<String, String> params, String charset, int connectTimeout, int readTimeout, String authorization) throws IOException {
        if (StringUtils.isBlank((String)charset)) {
            charset = "UTF-8";
        }
        String query = EshttpUtils.buildQuery(params, (String)charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return EshttpUtils.doPost((String)url, (String)ctype, (byte[])content, (int)connectTimeout, (int)readTimeout, (String)authorization);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, String authorization) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = EshttpUtils.buildQuery(params, (String)charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return EshttpUtils.doPost((String)url, (String)ctype, (byte[])content, (int)connectTimeout, (int)readTimeout, (String)authorization);
    }

    public static String doPost(String url, Map<String, String> params, String charset, String accept, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = EshttpUtils.buildQuery(params, (String)charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return EshttpUtils.doPost((String)url, (String)accept, (String)ctype, (byte[])content, (int)connectTimeout, (int)readTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doDelete(String url, String charset, int connectTimeout, int readTimeout, String authorization) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = EshttpUtils.getConnection((URL)new URL(url), (String)"DELETE", (String)ctype, null, (String)authorization);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            rsp = EshttpUtils.getResponseAsString((HttpURLConnection)conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout) throws IOException {
        return EshttpUtils.doPost((String)url, (String)ctype, (byte[])content, (int)connectTimeout, (int)readTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, String authorization) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = EshttpUtils.getConnection((URL)new URL(url), (String)"POST", (String)ctype, null, (String)authorization);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = EshttpUtils.getResponseAsString((HttpURLConnection)conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String processHttpRequest(String url, String requestMethod, Map<String, String> paramsMap, int connectTimeout, int readTimeout, String accept, String ctype, String user_agent) {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        if ("POST".equals(requestMethod.toUpperCase())) {
            HttpPost httppost = new HttpPost(url);
            httppost.setHeader("Content-Type", ctype);
            httppost.setHeader("User-Agent", user_agent);
            for (String key : paramsMap.keySet()) {
                String value = paramsMap.get(key);
                formparams.add(new BasicNameValuePair(key, value));
            }
            return EshttpUtils.doRequest((HttpPost)httppost, null, formparams, (int)connectTimeout, (int)readTimeout, (String)accept);
        }
        if ("GET".equals(requestMethod)) {
            HttpGet httppost = new HttpGet(url);
            httppost.setHeader("Content-Type", ctype);
            httppost.setHeader("User-Agent", user_agent);
            for (String key : paramsMap.keySet()) {
                String value = paramsMap.get(key);
                formparams.add(new BasicNameValuePair(key, value));
            }
            return EshttpUtils.doRequest(null, (HttpGet)httppost, formparams, (int)connectTimeout, (int)readTimeout, (String)accept);
        }
        return "";
    }

    public static String processPostJson(String postUrl, String json, String username, String password, String protocol) throws ClientProtocolException, Exception {
        String str;
        block12: {
            str = "";
            try {
                URL url = new URL(postUrl);
                if ("https".equals(url.getProtocol())) {
                    HttpsURLConnection connHttps = null;
                    SSLContext ctx = null;
                    try {
                        if (StringUtils.isBlank((String)protocol)) {
                            protocol = "TLS";
                        }
                        ctx = SSLContext.getInstance(protocol);
                        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager(null)}, new SecureRandom());
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    connHttps = (HttpsURLConnection)url.openConnection();
                    connHttps.setSSLSocketFactory(ctx.getSocketFactory());
                    connHttps.setHostnameVerifier((HostnameVerifier)new /* Unavailable Anonymous Inner Class!! */);
                    String input = "";
                    if (StringUtils.isNotBlank((String)password)) {
                        input = username + ":" + password;
                    }
                    if (StringUtils.isNotBlank((String)input)) {
                        Base64 base = new Base64();
                        String encodedPassword = Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
                        connHttps.setRequestProperty("Authorization", "Basic " + encodedPassword);
                    }
                    connHttps.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
                    connHttps.setRequestProperty("Content-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
                    connHttps.setUseCaches(false);
                    connHttps.setDoOutput(true);
                    connHttps.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
                    if (StringUtils.isNotBlank((String)json)) {
                        OutputStream out = connHttps.getOutputStream();
                        out.write(json.getBytes());
                    }
                    str = EshttpUtils.convertStreamToString((InputStream)connHttps.getInputStream());
                    break block12;
                }
                HttpURLConnection connHttps = (HttpURLConnection)url.openConnection();
                String input = "";
                if (StringUtils.isNotBlank((String)password)) {
                    input = username + ":" + password;
                }
                if (StringUtils.isNotBlank((String)input)) {
                    Base64 base = new Base64();
                    String encodedPassword = Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
                    connHttps.setRequestProperty("Authorization", "Basic " + encodedPassword);
                }
                connHttps.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
                connHttps.setRequestProperty("Content-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
                connHttps.setUseCaches(false);
                connHttps.setDoOutput(true);
                connHttps.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
                if (StringUtils.isNotBlank((String)json)) {
                    OutputStream out = connHttps.getOutputStream();
                    out.write(json.getBytes());
                }
                str = EshttpUtils.convertStreamToString((InputStream)connHttps.getInputStream());
            }
            catch (Exception e) {
                logger.error("EshttpUtils.postUrl.e", (Object)postUrl, (Throwable)e);
            }
        }
        return str;
    }

    public static String processGetJson(String postUrl, String json) throws ClientProtocolException, Exception {
        HttpGet post = new HttpGet(postUrl);
        post.setHeader("Content-Type", "application/json;charset=UTF-8");
        String str = null;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
        post.setConfig(requestConfig);
        HttpResponse response = EshttpUtils.getHttpClient().execute((HttpUriRequest)post);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream instreams = entity.getContent();
            str = EshttpUtils.convertStreamToString((InputStream)instreams);
            post.abort();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String doRequest(HttpPost httpPost, HttpGet httpGet, List<BasicNameValuePair> formparams, int connectTimeout, int readTimeout, String accept) {
        try {
            CloseableHttpResponse response = null;
            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(formparams);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).build();
            if (null != httpPost) {
                uefEntity.setContentEncoding((Header)new BasicHeader("Accept", accept));
                httpPost.setEntity((HttpEntity)uefEntity);
                httpPost.setConfig(requestConfig);
                response = (CloseableHttpResponse)EshttpUtils.getHttpClient().execute((HttpUriRequest)httpPost);
            } else {
                httpGet.setConfig(requestConfig);
                response = (CloseableHttpResponse)EshttpUtils.getHttpClient().execute((HttpUriRequest)httpGet);
            }
            HttpEntity entity = response.getEntity();
            String str = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (null == str) return "";
            if ("".equals(str)) return "";
            return str;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String accept, String ctype, byte[] content, int connectTimeout, int readTimeout, String authorization) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = EshttpUtils.getConnection((URL)new URL(url), (String)"POST", (String)accept, (String)ctype, null, (String)authorization);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = EshttpUtils.getResponseAsString((HttpURLConnection)conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPostByThreadLocal(String url, Map<String, String> params, int connectTimeout, int readTimeout, boolean isThreadLocal) throws IOException {
        return EshttpUtils.doPostByThreadLocal((String)url, params, (String)"UTF-8", (int)connectTimeout, (int)readTimeout, (boolean)isThreadLocal);
    }

    public static String doPostByThreadLocal(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, boolean isThreadLocal) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = EshttpUtils.buildQuery(params, (String)charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return EshttpUtils.doPostByThreadLocal((String)url, (String)ctype, (byte[])content, (int)connectTimeout, (int)readTimeout, (boolean)isThreadLocal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostByThreadLocal(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, boolean isThreadLocal, String authorization) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = EshttpUtils.getConnection((URL)new URL(url), (String)"POST", (String)ctype, null, (String)authorization);
            if (HttpConnectionThreadLocal.get() != null) {
                Map<String, List<String>> map = HttpConnectionThreadLocal.get().getHeaderFields();
                List<String> server = map.get("Set-Cookie");
                conn.addRequestProperty("Cookie", server.get(0));
            }
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = EshttpUtils.getResponseAsString((HttpURLConnection)conn);
            if (isThreadLocal) {
                HttpConnectionThreadLocal.set((HttpURLConnection)conn);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, int connectTimeout, int readTimeout) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            return EshttpUtils.doPost((String)url, params, (String)"UTF-8", (int)connectTimeout, (int)readTimeout, null);
        }
        return EshttpUtils.doPost((String)url, params, fileParams, (String)"UTF-8", (int)connectTimeout, (int)readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout) throws IOException {
        return EshttpUtils.doPost((String)url, params, fileParams, (String)charset, (int)connectTimeout, (int)readTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, String authorization) throws IOException {
        if (StringUtils.isBlank((String)charset)) {
            charset = "UTF-8";
        }
        if (fileParams == null || fileParams.isEmpty()) {
            return EshttpUtils.doPost((String)url, params, (String)charset, (int)connectTimeout, (int)readTimeout, (String)authorization);
        }
        String boundary = System.currentTimeMillis() + "";
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            String ctype = "multipart/form-data;boundary=" + boundary + ";charset=" + charset;
            conn = EshttpUtils.getConnection((URL)new URL(url), (String)"POST", (String)ctype, null, (String)authorization);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(charset);
            Set<Map.Entry<String, String>> textEntrySet = params.entrySet();
            for (Map.Entry<String, String> entry : textEntrySet) {
                byte[] byArray = EshttpUtils.getTextEntry((String)entry.getKey(), (String)entry.getValue(), (String)charset);
                out.write(entryBoundaryBytes);
                out.write(byArray);
            }
            Set<Map.Entry<String, FileItem>> fileEntrySet = fileParams.entrySet();
            for (Map.Entry<String, FileItem> entry : fileEntrySet) {
                FileItem fileItem = entry.getValue();
                byte[] fileBytes = EshttpUtils.getFileEntry((String)entry.getKey(), (String)fileItem.getFileName(), (String)fileItem.getMimeType(), (String)charset);
                out.write(entryBoundaryBytes);
                out.write(fileBytes);
                out.write(fileItem.getContent());
            }
            byte[] byArray = ("\r\n--" + boundary + "--\r\n").getBytes(charset);
            out.write(byArray);
            rsp = EshttpUtils.getResponseAsString((HttpURLConnection)conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    public static String doGet(String url, Map<String, String> params) throws IOException {
        return EshttpUtils.doGet((String)url, params, (String)"UTF-8", null, null, (int)0, (int)0);
    }

    public static String doGet(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return EshttpUtils.doGet((String)url, params, (String)"UTF-8", null, null, (int)connectTimeout, (int)readTimeout);
    }

    public static String doGet(String url, Map<String, String> params, String user_agent) throws IOException {
        return EshttpUtils.doGet((String)url, params, (String)"UTF-8", (String)user_agent, null, (int)0, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, String charset, String user_agent, String authorization, int connectTimeout, int readTimeout) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = EshttpUtils.buildQuery(params, (String)charset);
            conn = EshttpUtils.getConnection((URL)EshttpUtils.buildGetUrl((String)url, (String)query), (String)"GET", (String)ctype, (String)user_agent, (String)authorization);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            rsp = EshttpUtils.getResponseAsString((HttpURLConnection)conn);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, String user_agent, String authorization) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx = null;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager(null)}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier((HostnameVerifier)new /* Unavailable Anonymous Inner Class!! */);
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        if (StringUtils.isNotBlank((String)authorization)) {
            conn.setRequestProperty("Authorization", "Basic " + authorization);
        }
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
        if (StringUtils.isBlank((String)user_agent)) {
            user_agent = "aop-sdk-java";
        }
        conn.setRequestProperty("User-Agent", user_agent);
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }

    private static HttpURLConnection getConnection(URL url, String method, String accept, String ctype, String user_agent, String authorization) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx = null;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager(null)}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier((HostnameVerifier)new /* Unavailable Anonymous Inner Class!! */);
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        if (StringUtils.isNotBlank((String)authorization)) {
            conn.setRequestProperty("Authorization", "Basic " + authorization);
        }
        conn.setRequestProperty("Accept", accept);
        if (StringUtils.isBlank((String)user_agent)) {
            user_agent = "aop-sdk-java";
        }
        conn.setRequestProperty("User-Agent", user_agent);
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty((String)query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty((String)url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty((String[])new String[]{name, value = entry.getValue()})) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = EshttpUtils.getResponseCharset((String)conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return EshttpUtils.getStreamAsString((InputStream)conn.getInputStream(), (String)charset);
        }
        String msg = EshttpUtils.getStreamAsString((InputStream)es, (String)charset);
        if (StringUtils.isEmpty((String)msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    protected static byte[] getResponseAsStringReByte(HttpURLConnection conn) throws IOException {
        InputStream es = conn.getErrorStream();
        if (es == null) {
            es = conn.getInputStream();
        }
        byte[] buffer = new byte[es.read()];
        int numRead = 0;
        for (int offset = 0; offset < buffer.length && (numRead = es.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = "UTF-8";
        if (!StringUtils.isEmpty((String)ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty((String)pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return EshttpUtils.decode((String)value, (String)"UTF-8");
    }

    public static String encode(String value) {
        return EshttpUtils.encode((String)value, (String)"UTF-8");
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty((String)value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty((String)value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Map<String, String> getParamsFromUrl(String url) {
        Map map = null;
        if (url != null && url.indexOf(63) != -1) {
            map = EshttpUtils.splitUrlQuery((String)url.substring(url.indexOf(63) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }
}

