/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.util;

import com.yqbsoft.laser.service.searchengine.util.HttpClientPoolHelper;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.codec.Base64;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class HttpClientPoolHelper {
    private static SupperLogUtil logger = new SupperLogUtil(HttpClientPoolHelper.class);
    private static HttpClientPoolHelper httpClientPoolHelper = new HttpClientPoolHelper();
    private CloseableHttpClient httpClient;
    private RequestConfig requestConfig;
    private int retryCount = 3;
    private int maxTotal = 2000;
    private int defaultMaxPerRoute = 1000;
    private int connectionRequestTimeout = 20000;
    private int connectTimeout = 20000;
    private int socketTimeout = 20000;

    public static HttpClientPoolHelper getInstance() {
        return httpClientPoolHelper;
    }

    public HttpClientPoolHelper() {
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager(null)}, new SecureRandom());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)new /* Unavailable Anonymous Inner Class!! */);
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sf).build();
        2 httpRequestRetryHandler = new /* Unavailable Anonymous Inner Class!! */;
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(true).build());
        cm.setMaxTotal(this.maxTotal);
        cm.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler((HttpRequestRetryHandler)httpRequestRetryHandler).build();
        this.requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.connectionRequestTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequest(String targetUrl, String input) throws Exception {
        long start = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)targetUrl)) {
            throw new IllegalArgumentException("\u8c03\u7528getRequest\u65b9\u6cd5\uff0ctargetUrl\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String responseResult = null;
        try (CloseableHttpResponse response = null;){
            HttpGet httpget = new HttpGet(targetUrl);
            httpget.setConfig(this.requestConfig);
            if (StringUtils.isNotBlank((CharSequence)input)) {
                Base64 base = new Base64();
                String encodedPassword = Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
                httpget.setHeader("Authorization", "Basic " + encodedPassword);
            }
            httpget.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpget.setHeader("Content-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
            httpget.setHeader("Accept", "text/xml,text/javascript,text/html,application/json");
            response = this.httpClient.execute((HttpUriRequest)httpget);
            responseResult = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        long end = System.currentTimeMillis();
        logger.info("getRequest " + targetUrl + " elapse " + (end - start) + " ms ");
        return responseResult;
    }

    public String postRequest(String targetUrl, String requestContent, String input) throws Exception {
        return this.postRequest(targetUrl, requestContent, null, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postRequest(String targetUrl, String requestContent, String contentType, String input) throws Exception {
        long start = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)targetUrl)) {
            throw new IllegalArgumentException("\u8c03\u7528postRequest\u65b9\u6cd5\uff0ctargetUrl\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String responseResult = null;
        try (CloseableHttpResponse response = null;){
            HttpPost httppost = new HttpPost(targetUrl);
            httppost.setConfig(this.requestConfig);
            if (!StringUtils.isBlank((CharSequence)requestContent)) {
                StringEntity entity = new StringEntity(requestContent, "UTF-8");
                entity.setContentEncoding("UTF-8");
                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                    entity.setContentType(contentType);
                }
                httppost.setEntity((HttpEntity)entity);
            }
            if (StringUtils.isNotBlank((CharSequence)input)) {
                Base64 base = new Base64();
                String encodedPassword = Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
                httppost.setHeader("Authorization", "Basic " + encodedPassword);
            }
            httppost.setHeader("Content-Type", "application/json;charset=UTF-8");
            httppost.setHeader("Content-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
            httppost.setHeader("Accept", "text/xml,text/javascript,text/html,application/json");
            response = this.httpClient.execute((HttpUriRequest)httppost);
            responseResult = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        long end = System.currentTimeMillis();
        logger.info("postRequest " + targetUrl + " elapse " + (end - start) + " ms ");
        return responseResult;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    static /* synthetic */ int access$100(HttpClientPoolHelper x0) {
        return x0.retryCount;
    }
}

