/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sendgoods.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.sendgoods.dao.SgCflowMapper;
import com.yqbsoft.laser.service.sendgoods.dao.SgCflowNodeMapper;
import com.yqbsoft.laser.service.sendgoods.domain.SgCflowDomain;
import com.yqbsoft.laser.service.sendgoods.domain.SgCflowNodeDomain;
import com.yqbsoft.laser.service.sendgoods.domain.SgCflowNodeReDomain;
import com.yqbsoft.laser.service.sendgoods.domain.SgCflowReDomain;
import com.yqbsoft.laser.service.sendgoods.model.SgCflow;
import com.yqbsoft.laser.service.sendgoods.model.SgCflowNode;
import com.yqbsoft.laser.service.sendgoods.service.SgCflowService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class SgCflowServiceImpl
extends BaseServiceImpl
implements SgCflowService {
    private static final String SYS_CODE = "sg.SgCflowServiceImpl";
    public static final String CACHE_KEY_CFLOW = "sgProtCflow";
    public static final String CACHE_KEY_CFLOWNODE = "sgProtCflowNode";
    public static final String CACHE_KEY_PARENTCFLOWNODE = "sgProtCflowNodeByParent";
    private SgCflowMapper sgCflowMapper;
    private SgCflowNodeMapper sgCflowNodeMapper;

    public void setSgCflowMapper(SgCflowMapper sgCflowMapper) {
        this.sgCflowMapper = sgCflowMapper;
    }

    public void setSgCflowNodeMapper(SgCflowNodeMapper sgCflowNodeMapper) {
        this.sgCflowNodeMapper = sgCflowNodeMapper;
    }

    private Date getSysDate() {
        try {
            return this.sgCflowMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCflow(SgCflowDomain sgCflowDomain) {
        if (null == sgCflowDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sgCflowDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCflowDefault(SgCflow sgCflow) {
        if (null == sgCflow) {
            return;
        }
        if (null == sgCflow.getDataState()) {
            sgCflow.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sgCflow.getGmtCreate()) {
            sgCflow.setGmtCreate(date);
        }
        sgCflow.setGmtModified(date);
        if (StringUtils.isBlank((String)sgCflow.getCflowCode())) {
            sgCflow.setCflowCode(this.getNo(null, "SgCflow", "sgCflow", sgCflow.getTenantCode()));
        }
    }

    private int getCflowMaxCode() {
        int code = 0;
        try {
            return this.sgCflowMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.getCflowMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCflowUpdataDefault(SgCflow sgCflow) {
        if (null == sgCflow) {
            return;
        }
        sgCflow.setGmtModified(this.getSysDate());
    }

    private void saveCflowModel(SgCflow sgCflow) throws ApiException {
        if (null == sgCflow) {
            return;
        }
        try {
            this.sgCflowMapper.insert(sgCflow);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.saveCflowModel.ex", (Throwable)e);
        }
    }

    private void saveCflowBatchModel(List<SgCflow> sgCflowList) throws ApiException {
        if (null == sgCflowList || sgCflowList.isEmpty()) {
            return;
        }
        try {
            this.sgCflowMapper.insertBatch(sgCflowList);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.saveCflowBatchModel.ex", (Throwable)e);
        }
    }

    private SgCflow getCflowModelById(Integer cflowId) {
        if (null == cflowId) {
            return null;
        }
        try {
            return this.sgCflowMapper.selectByPrimaryKey(cflowId);
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.getCflowModelById", (Throwable)e);
            return null;
        }
    }

    private SgCflow getCflowModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sgCflowMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.getCflowModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCflowModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sgCflowMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.delCflowModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sg.SgCflowServiceImpl.delCflowModelByCode.num");
        }
    }

    private void deleteCflowModel(Integer cflowId) throws ApiException {
        if (null == cflowId) {
            return;
        }
        int i = 0;
        try {
            i = this.sgCflowMapper.deleteByPrimaryKey(cflowId);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.deleteCflowModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sg.SgCflowServiceImpl.deleteCflowModel.num");
        }
    }

    private void updateCflowModel(SgCflow sgCflow) throws ApiException {
        if (null == sgCflow) {
            return;
        }
        int i = 0;
        try {
            i = this.sgCflowMapper.updateByPrimaryKey(sgCflow);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.updateCflowModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sg.SgCflowServiceImpl.updateCflowModel.num");
        }
    }

    private void updateStateCflowModel(Integer cflowId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cflowId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cflowId", cflowId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sgCflowMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.updateStateCflowModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sg.SgCflowServiceImpl.updateStateCflowModel.null");
        }
    }

    private void updateStateCflowModelByCode(String tenantCode, String cflowCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cflowCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cflowCode", cflowCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sgCflowMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.updateStateCflowModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sg.SgCflowServiceImpl.updateStateCflowModelByCode.null");
        }
    }

    private SgCflow makeCflow(SgCflowDomain sgCflowDomain, SgCflow sgCflow) {
        if (null == sgCflowDomain) {
            return null;
        }
        if (null == sgCflow) {
            sgCflow = new SgCflow();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sgCflow, (Object)sgCflowDomain);
            return sgCflow;
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.makeCflow", (Throwable)e);
            return null;
        }
    }

    private SgCflowReDomain makeSgCflowReDomain(SgCflow sgCflow) {
        if (null == sgCflow) {
            return null;
        }
        SgCflowReDomain sgCflowReDomain = new SgCflowReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sgCflowReDomain, (Object)sgCflow);
            return sgCflowReDomain;
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.makeSgCflowReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SgCflow> queryCflowModelPage(Map<String, Object> parammap) {
        try {
            return this.sgCflowMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.queryCflowModel", (Throwable)e);
            return null;
        }
    }

    private int countCflow(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sgCflowMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.countCflow", (Throwable)e);
        }
        return i;
    }

    private SgCflow createSgCflow(SgCflowDomain sgCflowDomain) {
        String msg = this.checkCflow(sgCflowDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sg.SgCflowServiceImpl.saveCflow.checkCflow", msg);
        }
        SgCflow sgCflow = this.makeCflow(sgCflowDomain, null);
        this.setCflowDefault(sgCflow);
        return sgCflow;
    }

    private String checkCflowNode(SgCflowNodeDomain sgCflowNodeDomain) {
        if (null == sgCflowNodeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sgCflowNodeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCflowNodeDefault(SgCflowNode sgCflowNode) {
        if (null == sgCflowNode) {
            return;
        }
        if (null == sgCflowNode.getDataState()) {
            sgCflowNode.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sgCflowNode.getGmtCreate()) {
            sgCflowNode.setGmtCreate(date);
        }
        sgCflowNode.setGmtModified(date);
        if (StringUtils.isBlank((String)sgCflowNode.getCflowNodeCode())) {
            sgCflowNode.setCflowNodeCode(this.getNo(null, "SgCflowNode", "sgCflowNode", sgCflowNode.getTenantCode()));
        }
    }

    private int getCflowNodeMaxCode() {
        int code = 0;
        try {
            return this.sgCflowNodeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.getCflowNodeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCflowNodeUpdataDefault(SgCflowNode sgCflowNode) {
        if (null == sgCflowNode) {
            return;
        }
        sgCflowNode.setGmtModified(this.getSysDate());
    }

    private void saveCflowNodeModel(SgCflowNode sgCflowNode) throws ApiException {
        if (null == sgCflowNode) {
            return;
        }
        try {
            this.sgCflowNodeMapper.insert(sgCflowNode);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.saveCflowNodeModel.ex", (Throwable)e);
        }
    }

    private void saveCflowNodeBatchModel(List<SgCflowNode> sgCflowNodeList) throws ApiException {
        if (null == sgCflowNodeList || sgCflowNodeList.isEmpty()) {
            return;
        }
        try {
            this.sgCflowNodeMapper.insertBatch(sgCflowNodeList);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.saveCflowNodeBatchModel.ex", (Throwable)e);
        }
    }

    private SgCflowNode getCflowNodeModelById(Integer cflowNodeId) {
        if (null == cflowNodeId) {
            return null;
        }
        try {
            return this.sgCflowNodeMapper.selectByPrimaryKey(cflowNodeId);
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.getCflowNodeModelById", (Throwable)e);
            return null;
        }
    }

    private SgCflowNode getCflowNodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sgCflowNodeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.getCflowNodeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCflowNodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sgCflowNodeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.delCflowNodeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sg.SgCflowServiceImpl.delCflowNodeModelByCode.num");
        }
    }

    private void deleteCflowNodeModel(Integer cflowNodeId) throws ApiException {
        if (null == cflowNodeId) {
            return;
        }
        int i = 0;
        try {
            i = this.sgCflowNodeMapper.deleteByPrimaryKey(cflowNodeId);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.deleteCflowNodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sg.SgCflowServiceImpl.deleteCflowNodeModel.num");
        }
    }

    private void updateCflowNodeModel(SgCflowNode sgCflowNode) throws ApiException {
        if (null == sgCflowNode) {
            return;
        }
        int i = 0;
        try {
            i = this.sgCflowNodeMapper.updateByPrimaryKey(sgCflowNode);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.updateCflowNodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sg.SgCflowServiceImpl.updateCflowNodeModel.num");
        }
    }

    private void updateStateCflowNodeModel(Integer cflowNodeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cflowNodeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cflowNodeId", cflowNodeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sgCflowNodeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.updateStateCflowNodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sg.SgCflowServiceImpl.updateStateCflowNodeModel.null");
        }
    }

    private void updateStateCflowNodeModelByCode(String tenantCode, String cflowNodeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cflowNodeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cflowNodeCode", cflowNodeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sgCflowNodeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgCflowServiceImpl.updateStateCflowNodeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sg.SgCflowServiceImpl.updateStateCflowNodeModelByCode.null");
        }
    }

    private SgCflowNode makeCflowNode(SgCflowNodeDomain sgCflowNodeDomain, SgCflowNode sgCflowNode) {
        if (null == sgCflowNodeDomain) {
            return null;
        }
        if (null == sgCflowNode) {
            sgCflowNode = new SgCflowNode();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sgCflowNode, (Object)sgCflowNodeDomain);
            return sgCflowNode;
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.makeCflowNode", (Throwable)e);
            return null;
        }
    }

    private SgCflowNodeReDomain makeSgCflowNodeReDomain(SgCflowNode sgCflowNode) {
        if (null == sgCflowNode) {
            return null;
        }
        SgCflowNodeReDomain sgCflowNodeReDomain = new SgCflowNodeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sgCflowNodeReDomain, (Object)sgCflowNode);
            return sgCflowNodeReDomain;
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.makeSgCflowNodeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SgCflowNode> queryCflowNodeModelPage(Map<String, Object> parammap) {
        try {
            return this.sgCflowNodeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.queryCflowNodeModel", (Throwable)e);
            return null;
        }
    }

    private int countCflowNode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sgCflowNodeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.countCflowNode", (Throwable)e);
        }
        return i;
    }

    private SgCflowNode createSgCflowNode(SgCflowNodeDomain sgCflowNodeDomain) {
        String msg = this.checkCflowNode(sgCflowNodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sg.SgCflowServiceImpl.saveCflowNode.checkCflowNode", msg);
        }
        SgCflowNode sgCflowNode = this.makeCflowNode(sgCflowNodeDomain, null);
        this.setCflowNodeDefault(sgCflowNode);
        return sgCflowNode;
    }

    @Override
    public String saveCflow(SgCflowDomain sgCflowDomain) throws ApiException {
        SgCflow sgCflow = this.createSgCflow(sgCflowDomain);
        this.saveCflowModel(sgCflow);
        return sgCflow.getCflowCode();
    }

    @Override
    public String saveCflowBatch(List<SgCflowDomain> sgCflowDomainList) throws ApiException {
        if (null == sgCflowDomainList || sgCflowDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SgCflow> sgCflowList = new ArrayList<SgCflow>();
        String code = "";
        for (SgCflowDomain sgCflowDomain : sgCflowDomainList) {
            SgCflow sgCflow = this.createSgCflow(sgCflowDomain);
            code = sgCflow.getCflowCode();
            sgCflowList.add(sgCflow);
        }
        this.saveCflowBatchModel(sgCflowList);
        return code;
    }

    @Override
    public void updateCflowState(Integer cflowId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cflowId) {
            return;
        }
        this.updateStateCflowModel(cflowId, dataState, oldDataState, map);
    }

    @Override
    public void updateCflowStateByCode(String tenantCode, String cflowCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cflowCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCflowModelByCode(tenantCode, cflowCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCflow(SgCflowDomain sgCflowDomain) throws ApiException {
        String msg = this.checkCflow(sgCflowDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sg.SgCflowServiceImpl.updateCflow.checkCflow", msg);
        }
        SgCflow oldSgCflow = this.getCflowModelById(sgCflowDomain.getCflowId());
        if (null == oldSgCflow) {
            throw new ApiException("sg.SgCflowServiceImpl.updateCflow.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SgCflow sgCflow = this.makeCflow(sgCflowDomain, oldSgCflow);
        this.setCflowUpdataDefault(sgCflow);
        this.updateCflowModel(sgCflow);
    }

    @Override
    public SgCflow getCflow(Integer cflowId) {
        if (null == cflowId) {
            return null;
        }
        return this.getCflowModelById(cflowId);
    }

    @Override
    public void deleteCflow(Integer cflowId) throws ApiException {
        if (null == cflowId) {
            return;
        }
        this.deleteCflowModel(cflowId);
    }

    @Override
    public QueryResult<SgCflow> queryCflowPage(Map<String, Object> map) {
        List<SgCflow> sgCflowList = this.queryCflowModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCflow(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sgCflowList);
        return queryResult;
    }

    @Override
    public SgCflow getCflowByCode(String tenantCode, String cflowCode) throws ApiException {
        if (StringUtils.isBlank((String)cflowCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cflowCode", cflowCode);
        return this.getCflowModelByCode(map);
    }

    @Override
    public void deleteCflowByCode(String tenantCode, String cflowCode) throws ApiException {
        if (StringUtils.isBlank((String)cflowCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cflowCode", cflowCode);
        this.delCflowModelByCode(map);
    }

    @Override
    public String saveCflowNode(SgCflowNodeDomain sgCflowNodeDomain) throws ApiException {
        SgCflowNode sgCflowNode = this.createSgCflowNode(sgCflowNodeDomain);
        this.saveCflowNodeModel(sgCflowNode);
        return sgCflowNode.getCflowNodeCode();
    }

    @Override
    public String saveCflowNodeBatch(List<SgCflowNodeDomain> sgCflowNodeDomainList) throws ApiException {
        if (null == sgCflowNodeDomainList || sgCflowNodeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SgCflowNode> sgCflowNodeList = new ArrayList<SgCflowNode>();
        String code = "";
        for (SgCflowNodeDomain sgCflowNodeDomain : sgCflowNodeDomainList) {
            SgCflowNode sgCflowNode = this.createSgCflowNode(sgCflowNodeDomain);
            code = sgCflowNode.getCflowNodeCode();
            sgCflowNodeList.add(sgCflowNode);
        }
        this.saveCflowNodeBatchModel(sgCflowNodeList);
        return code;
    }

    @Override
    public void updateCflowNodeState(Integer cflowNodeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cflowNodeId) {
            return;
        }
        this.updateStateCflowNodeModel(cflowNodeId, dataState, oldDataState, map);
    }

    @Override
    public void updateCflowNodeStateByCode(String tenantCode, String cflowNodeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cflowNodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCflowNodeModelByCode(tenantCode, cflowNodeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCflowNode(SgCflowNodeDomain sgCflowNodeDomain) throws ApiException {
        String msg = this.checkCflowNode(sgCflowNodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sg.SgCflowServiceImpl.updateCflowNode.checkCflowNode", msg);
        }
        SgCflowNode oldSgCflowNode = this.getCflowNodeModelById(sgCflowNodeDomain.getCflowNodeId());
        if (null == oldSgCflowNode) {
            throw new ApiException("sg.SgCflowServiceImpl.updateCflowNode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SgCflowNode sgCflowNode = this.makeCflowNode(sgCflowNodeDomain, oldSgCflowNode);
        this.setCflowNodeUpdataDefault(sgCflowNode);
        this.updateCflowNodeModel(sgCflowNode);
    }

    @Override
    public SgCflowNode getCflowNode(Integer cflowNodeId) {
        if (null == cflowNodeId) {
            return null;
        }
        return this.getCflowNodeModelById(cflowNodeId);
    }

    @Override
    public void deleteCflowNode(Integer cflowNodeId) throws ApiException {
        if (null == cflowNodeId) {
            return;
        }
        this.deleteCflowNodeModel(cflowNodeId);
    }

    @Override
    public QueryResult<SgCflowNode> queryCflowNodePage(Map<String, Object> map) {
        List<SgCflowNode> sgCflowNodeList = this.queryCflowNodeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCflowNode(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sgCflowNodeList);
        return queryResult;
    }

    @Override
    public SgCflowNode getCflowNodeByCode(String tenantCode, String cflowNodeCode) throws ApiException {
        if (StringUtils.isBlank((String)cflowNodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cflowNodeCode", cflowNodeCode);
        return this.getCflowNodeModelByCode(map);
    }

    @Override
    public void deleteCflowNodeByCode(String tenantCode, String cflowNodeCode) throws ApiException {
        if (StringUtils.isBlank((String)cflowNodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cflowNodeCode", cflowNodeCode);
        this.delCflowNodeModelByCode(map);
    }

    @Override
    public void queryCflowCache() {
        this.info("sg.SgCflowServiceImpl.queryCflowCache.start", "=======\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 1L);
        List<SgCflow> cflowList = this.queryCflowModelPage(params);
        if (CollectionUtils.isEmpty(cflowList)) {
            DisUtil.delVer((String)CACHE_KEY_CFLOW);
            DisUtil.delVer((String)CACHE_KEY_CFLOWNODE);
            DisUtil.delVer((String)CACHE_KEY_PARENTCFLOWNODE);
            this.info("sg.SgCflowServiceImpl.queryCflowCache.null", "=======\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        HashMap<String, String> nodemap = new HashMap<String, String>();
        HashMap<String, String> nodeparentmap = new HashMap<String, String>();
        String key = "";
        for (SgCflow ocCflow : cflowList) {
            SgCflowReDomain ocCflowReDomain = this.makeCache(ocCflow);
            key = ocCflow.getDicPaypdCode() + "-" + ocCflow.getTenantCode();
            if (StringUtils.isNotBlank((String)ocCflowReDomain.getProappCode())) {
                key = key + "-" + ocCflowReDomain.getProappCode();
            }
            if (StringUtils.isNotBlank((String)ocCflowReDomain.getChannelCode())) {
                key = key + "-" + ocCflowReDomain.getChannelCode();
            }
            if (StringUtils.isNotBlank((String)ocCflowReDomain.getGoodsClass())) {
                key = key + "-" + ocCflowReDomain.getGoodsClass();
            }
            mmap.put(key, JsonUtil.buildNormalBinder().toJson((Object)ocCflowReDomain));
        }
        params.put("orderStr", "CFLOW_NODE_INDEX");
        params.put("order", true);
        List<SgCflowNode> nodeList = this.queryCflowNodeModelPage(params);
        if (null == nodeList || nodeList.isEmpty()) {
            DisUtil.delVer((String)CACHE_KEY_CFLOWNODE);
            DisUtil.delVer((String)CACHE_KEY_PARENTCFLOWNODE);
            return;
        }
        String nodekey = "";
        String parkey = "";
        String str = "";
        List<SgCflowNodeReDomain> nodeParentList = null;
        for (SgCflowNode ocCflowNode : nodeList) {
            nodekey = ocCflowNode.getCflowNodeCode() + "-" + ocCflowNode.getTenantCode();
            nodemap.put(nodekey, JsonUtil.buildNormalBinder().toJson((Object)ocCflowNode));
            parkey = ocCflowNode.getCflowCode() + "-" + ocCflowNode.getCflowNodeParentcode() + "-" + ocCflowNode.getTenantCode();
            str = (String)nodeparentmap.get(parkey);
            nodeParentList = StringUtils.isNotBlank((String)str) ? (List)JsonUtil.buildNormalBinder().getJsonToList(str, SgCflowNodeReDomain.class) : new ArrayList<SgCflowNodeReDomain>();
            nodeParentList.add(this.makeReCflowNode(ocCflowNode));
            nodeparentmap.put(parkey, JsonUtil.buildNormalBinder().toJson(nodeParentList));
        }
        DisUtil.setMap((String)CACHE_KEY_CFLOW, mmap);
        DisUtil.setMap((String)CACHE_KEY_CFLOWNODE, nodemap);
        DisUtil.setMap((String)CACHE_KEY_PARENTCFLOWNODE, nodeparentmap);
        this.info("sg.SgCflowServiceImpl.queryCflowCache.end", "=======\u8c03\u5ea6end=======");
    }

    private SgCflowReDomain makeCache(SgCflow sgCflow) {
        if (null == sgCflow) {
            return null;
        }
        SgCflowReDomain sgCflowReDomain = this.makeReCflow(sgCflow);
        if (null == sgCflowReDomain) {
            return null;
        }
        List<SgCflowNodeReDomain> nodeReList = this.queryNodeNext(sgCflow.getTenantCode(), sgCflowReDomain.getCflowCode(), sgCflowReDomain.getCflowCode());
        if (ListUtil.isEmpty(nodeReList) && !"00000000".equals(sgCflow.getTenantCode())) {
            nodeReList = this.queryNodeNext("00000000", sgCflowReDomain.getCflowCode(), sgCflowReDomain.getCflowCode());
        }
        sgCflowReDomain.setNodeReList(nodeReList);
        return sgCflowReDomain;
    }

    private List<SgCflowNodeReDomain> queryNodeNext(String tenantCode, String cflowNodeParentcode, String cflowCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cflowCode", cflowCode);
        map.put("cflowNodeParentcode", cflowNodeParentcode);
        map.put("orderStr", "CFLOW_NODE_INDEX");
        map.put("order", true);
        List<SgCflowNodeReDomain> nodeReList = this.makeReCflowNodeList(this.queryCflowNodeModelPage(map));
        if (null == nodeReList || nodeReList.isEmpty()) {
            return null;
        }
        return nodeReList;
    }

    private List<SgCflowNodeReDomain> makeReCflowNodeList(List<SgCflowNode> sgCflowNodeList) {
        if (null == sgCflowNodeList || sgCflowNodeList.isEmpty()) {
            return null;
        }
        ArrayList<SgCflowNodeReDomain> nodeReList = new ArrayList<SgCflowNodeReDomain>();
        for (SgCflowNode sgCflowNode : sgCflowNodeList) {
            nodeReList.add(this.makeReCflowNode(sgCflowNode));
        }
        return nodeReList;
    }

    private SgCflowNodeReDomain makeReCflowNode(SgCflowNode sgCflowNode) {
        if (null == sgCflowNode) {
            return null;
        }
        SgCflowNodeReDomain sgCflowNodeReDomain = new SgCflowNodeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sgCflowNodeReDomain, (Object)sgCflowNode);
            return sgCflowNodeReDomain;
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.makeReCflowNode", (Throwable)e);
            return null;
        }
    }

    private SgCflowReDomain makeReCflow(SgCflow sgCflow) {
        if (null == sgCflow) {
            return null;
        }
        SgCflowReDomain sgCflowReDomain = new SgCflowReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sgCflowReDomain, (Object)sgCflow);
            return sgCflowReDomain;
        }
        catch (Exception e) {
            this.logger.error("sg.SgCflowServiceImpl.makeReCflow", (Throwable)e);
            return null;
        }
    }
}

