/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tenantmanag.dao.TmLpinterConfMapper;
import com.yqbsoft.laser.service.tenantmanag.dao.TmLpinterMapper;
import com.yqbsoft.laser.service.tenantmanag.domain.TmLpinterConfDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmLpinterConfReDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmLpinterDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmLpinterReDomain;
import com.yqbsoft.laser.service.tenantmanag.model.TmLpinter;
import com.yqbsoft.laser.service.tenantmanag.model.TmLpinterConf;
import com.yqbsoft.laser.service.tenantmanag.service.TmLpinterService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TmLpinterServiceImpl
extends BaseServiceImpl
implements TmLpinterService {
    private static final String SYS_CODE = "tm.TmLpinterServiceImpl";
    private TmLpinterMapper tmLpinterMapper;
    private TmLpinterConfMapper tmLpinterConfMapper;
    private static final String cache_lpinter = "tmLpinter";
    private static final String cache_lpinter_tenant = "tmLpinterTenant";
    private static final String cache_lpinterConf = "tmLpinterConf";
    private static final String spl = "-";

    public void setTmLpinterMapper(TmLpinterMapper tmLpinterMapper) {
        this.tmLpinterMapper = tmLpinterMapper;
    }

    public void setTmLpinterConfMapper(TmLpinterConfMapper tmLpinterConfMapper) {
        this.tmLpinterConfMapper = tmLpinterConfMapper;
    }

    private Date getSysDate() {
        try {
            return this.tmLpinterMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkLpinter(TmLpinterDomain tmLpinterDomain) {
        if (null == tmLpinterDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmLpinterDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setLpinterDefault(TmLpinter tmLpinter) {
        if (null == tmLpinter) {
            return;
        }
        if (null == tmLpinter.getDataState()) {
            tmLpinter.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == tmLpinter.getGmtCreate()) {
            tmLpinter.setGmtCreate(date);
        }
        tmLpinter.setGmtModified(date);
        if (StringUtils.isBlank((String)tmLpinter.getLpinterCode())) {
            tmLpinter.setLpinterCode(this.getNo(null, "TmLpinter", cache_lpinter, tmLpinter.getTenantCode()));
        }
    }

    private int getLpinterMaxCode() {
        int code = 0;
        try {
            return this.tmLpinterMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.getLpinterMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLpinterUpdataDefault(TmLpinter tmLpinter) {
        if (null == tmLpinter) {
            return;
        }
        tmLpinter.setGmtModified(this.getSysDate());
    }

    private void saveLpinterModel(TmLpinter tmLpinter) throws ApiException {
        if (null == tmLpinter) {
            return;
        }
        try {
            this.tmLpinterMapper.insert(tmLpinter);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.saveLpinterModel.ex", (Throwable)e);
        }
    }

    private void saveLpinterBatchModel(List<TmLpinter> tmLpinterList) throws ApiException {
        if (null == tmLpinterList || tmLpinterList.isEmpty()) {
            return;
        }
        try {
            this.tmLpinterMapper.insertBatch(tmLpinterList);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.saveLpinterBatchModel.ex", (Throwable)e);
        }
    }

    private TmLpinter getLpinterModelById(Integer lpinterId) {
        if (null == lpinterId) {
            return null;
        }
        try {
            return this.tmLpinterMapper.selectByPrimaryKey(lpinterId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.getLpinterModelById", (Throwable)e);
            return null;
        }
    }

    private TmLpinter getLpinterModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmLpinterMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.getLpinterModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delLpinterModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmLpinterMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.delLpinterModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmLpinterServiceImpl.delLpinterModelByCode.num");
        }
    }

    private void deleteLpinterModel(Integer lpinterId) throws ApiException {
        if (null == lpinterId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmLpinterMapper.deleteByPrimaryKey(lpinterId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.deleteLpinterModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmLpinterServiceImpl.deleteLpinterModel.num");
        }
    }

    private void updateLpinterModel(TmLpinter tmLpinter) throws ApiException {
        if (null == tmLpinter) {
            return;
        }
        int i = 0;
        try {
            i = this.tmLpinterMapper.updateByPrimaryKey(tmLpinter);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateLpinterModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateLpinterModel.num");
        }
    }

    private void updateStateLpinterModel(Integer lpinterId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == lpinterId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lpinterId", lpinterId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmLpinterMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateStateLpinterModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateStateLpinterModel.null");
        }
    }

    private void updateStateLpinterModelByCode(String tenantCode, String lpinterCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)lpinterCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lpinterCode", lpinterCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmLpinterMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateStateLpinterModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateStateLpinterModelByCode.null");
        }
    }

    private TmLpinter makeLpinter(TmLpinterDomain tmLpinterDomain, TmLpinter tmLpinter) {
        if (null == tmLpinterDomain) {
            return null;
        }
        if (null == tmLpinter) {
            tmLpinter = new TmLpinter();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmLpinter, (Object)tmLpinterDomain);
            return tmLpinter;
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.makeLpinter", (Throwable)e);
            return null;
        }
    }

    private TmLpinterReDomain makeTmLpinterReDomain(TmLpinter tmLpinter) {
        if (null == tmLpinter) {
            return null;
        }
        TmLpinterReDomain tmLpinterReDomain = new TmLpinterReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmLpinterReDomain, (Object)tmLpinter);
            return tmLpinterReDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.makeTmLpinterReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmLpinter> queryLpinterModelPage(Map<String, Object> parammap) {
        try {
            return this.tmLpinterMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.queryLpinterModel", (Throwable)e);
            return null;
        }
    }

    private int countLpinter(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmLpinterMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.countLpinter", (Throwable)e);
        }
        return i;
    }

    private TmLpinter createTmLpinter(TmLpinterDomain tmLpinterDomain) {
        String msg = this.checkLpinter(tmLpinterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmLpinterServiceImpl.saveLpinter.checkLpinter", msg);
        }
        TmLpinter tmLpinter = this.makeLpinter(tmLpinterDomain, null);
        this.setLpinterDefault(tmLpinter);
        return tmLpinter;
    }

    private String checkLpinterConf(TmLpinterConfDomain tmLpinterConfDomain) {
        if (null == tmLpinterConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmLpinterConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setLpinterConfDefault(TmLpinterConf tmLpinterConf) {
        if (null == tmLpinterConf) {
            return;
        }
        if (null == tmLpinterConf.getDataState()) {
            tmLpinterConf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == tmLpinterConf.getGmtCreate()) {
            tmLpinterConf.setGmtCreate(date);
        }
        tmLpinterConf.setGmtModified(date);
        if (StringUtils.isBlank((String)tmLpinterConf.getLpinterConfCode())) {
            tmLpinterConf.setLpinterConfCode(this.getNo(null, "TmLpinterConf", cache_lpinterConf, tmLpinterConf.getTenantCode()));
        }
    }

    private int getLpinterConfMaxCode() {
        int code = 0;
        try {
            return this.tmLpinterConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.getLpinterConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLpinterConfUpdataDefault(TmLpinterConf tmLpinterConf) {
        if (null == tmLpinterConf) {
            return;
        }
        tmLpinterConf.setGmtModified(this.getSysDate());
    }

    private void saveLpinterConfModel(TmLpinterConf tmLpinterConf) throws ApiException {
        if (null == tmLpinterConf) {
            return;
        }
        try {
            this.tmLpinterConfMapper.insert(tmLpinterConf);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.saveLpinterConfModel.ex", (Throwable)e);
        }
    }

    private void saveLpinterConfBatchModel(List<TmLpinterConf> tmLpinterConfList) throws ApiException {
        if (null == tmLpinterConfList || tmLpinterConfList.isEmpty()) {
            return;
        }
        try {
            this.tmLpinterConfMapper.insertBatch(tmLpinterConfList);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.saveLpinterConfBatchModel.ex", (Throwable)e);
        }
    }

    private TmLpinterConf getLpinterConfModelById(Integer lpinterConfId) {
        if (null == lpinterConfId) {
            return null;
        }
        try {
            return this.tmLpinterConfMapper.selectByPrimaryKey(lpinterConfId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.getLpinterConfModelById", (Throwable)e);
            return null;
        }
    }

    private TmLpinterConf getLpinterConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmLpinterConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.getLpinterConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delLpinterConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmLpinterConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.delLpinterConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmLpinterServiceImpl.delLpinterConfModelByCode.num");
        }
    }

    private void deleteLpinterConfModel(Integer lpinterConfId) throws ApiException {
        if (null == lpinterConfId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmLpinterConfMapper.deleteByPrimaryKey(lpinterConfId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.deleteLpinterConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmLpinterServiceImpl.deleteLpinterConfModel.num");
        }
    }

    private void updateLpinterConfModel(TmLpinterConf tmLpinterConf) throws ApiException {
        if (null == tmLpinterConf) {
            return;
        }
        int i = 0;
        try {
            i = this.tmLpinterConfMapper.updateByPrimaryKey(tmLpinterConf);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateLpinterConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateLpinterConfModel.num");
        }
    }

    private void updateStateLpinterConfModel(Integer lpinterConfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == lpinterConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lpinterConfId", lpinterConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmLpinterConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateStateLpinterConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateStateLpinterConfModel.null");
        }
    }

    private void updateStateLpinterConfModelByCode(String tenantCode, String lpinterConfCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)lpinterConfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lpinterConfCode", lpinterConfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmLpinterConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateStateLpinterConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateStateLpinterConfModelByCode.null");
        }
    }

    private TmLpinterConf makeLpinterConf(TmLpinterConfDomain tmLpinterConfDomain, TmLpinterConf tmLpinterConf) {
        if (null == tmLpinterConfDomain) {
            return null;
        }
        if (null == tmLpinterConf) {
            tmLpinterConf = new TmLpinterConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmLpinterConf, (Object)tmLpinterConfDomain);
            return tmLpinterConf;
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.makeLpinterConf", (Throwable)e);
            return null;
        }
    }

    private TmLpinterConfReDomain makeTmLpinterConfReDomain(TmLpinterConf tmLpinterConf) {
        if (null == tmLpinterConf) {
            return null;
        }
        TmLpinterConfReDomain tmLpinterConfReDomain = new TmLpinterConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmLpinterConfReDomain, (Object)tmLpinterConf);
            return tmLpinterConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.makeTmLpinterConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmLpinterConf> queryLpinterConfModelPage(Map<String, Object> parammap) {
        try {
            return this.tmLpinterConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.queryLpinterConfModel", (Throwable)e);
            return null;
        }
    }

    private int countLpinterConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmLpinterConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmLpinterServiceImpl.countLpinterConf", (Throwable)e);
        }
        return i;
    }

    private TmLpinterConf createTmLpinterConf(TmLpinterConfDomain tmLpinterConfDomain) {
        String msg = this.checkLpinterConf(tmLpinterConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmLpinterServiceImpl.saveLpinterConf.checkLpinterConf", msg);
        }
        TmLpinterConf tmLpinterConf = this.makeLpinterConf(tmLpinterConfDomain, null);
        this.setLpinterConfDefault(tmLpinterConf);
        return tmLpinterConf;
    }

    @Override
    public String saveLpinter(TmLpinterDomain tmLpinterDomain) throws ApiException {
        TmLpinter tmLpinter = this.createTmLpinter(tmLpinterDomain);
        this.saveLpinterModel(tmLpinter);
        return tmLpinter.getLpinterCode();
    }

    @Override
    public String saveLpinterBatch(List<TmLpinterDomain> tmLpinterDomainList) throws ApiException {
        if (null == tmLpinterDomainList || tmLpinterDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TmLpinter> tmLpinterList = new ArrayList<TmLpinter>();
        String code = "";
        for (TmLpinterDomain tmLpinterDomain : tmLpinterDomainList) {
            TmLpinter tmLpinter = this.createTmLpinter(tmLpinterDomain);
            code = tmLpinter.getLpinterCode();
            tmLpinterList.add(tmLpinter);
        }
        this.saveLpinterBatchModel(tmLpinterList);
        return code;
    }

    @Override
    public void updateLpinterState(Integer lpinterId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == lpinterId) {
            return;
        }
        this.updateStateLpinterModel(lpinterId, dataState, oldDataState, map);
        TmLpinter tmLpinter = this.getLpinterModelById(lpinterId);
        this.reloadCache(tmLpinter);
    }

    @Override
    public void updateLpinterStateByCode(String tenantCode, String lpinterCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)lpinterCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateLpinterModelByCode(tenantCode, lpinterCode, dataState, oldDataState, map);
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("lpinterCode", lpinterCode);
        TmLpinter tmLpinter = this.getLpinterModelByCode(parammap);
        this.reloadCache(tmLpinter);
    }

    @Override
    public void updateLpinter(TmLpinterDomain tmLpinterDomain) throws ApiException {
        String msg = this.checkLpinter(tmLpinterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateLpinter.checkLpinter", msg);
        }
        TmLpinter oldTmLpinter = this.getLpinterModelById(tmLpinterDomain.getLpinterId());
        if (null == oldTmLpinter) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateLpinter.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmLpinter tmLpinter = this.makeLpinter(tmLpinterDomain, oldTmLpinter);
        this.setLpinterUpdataDefault(tmLpinter);
        this.updateLpinterModel(tmLpinter);
        this.reloadCache(tmLpinter);
    }

    @Override
    public TmLpinter getLpinter(Integer lpinterId) {
        if (null == lpinterId) {
            return null;
        }
        return this.getLpinterModelById(lpinterId);
    }

    @Override
    public void deleteLpinter(Integer lpinterId) throws ApiException {
        if (null == lpinterId) {
            return;
        }
        this.deleteLpinterModel(lpinterId);
    }

    @Override
    public QueryResult<TmLpinter> queryLpinterPage(Map<String, Object> map) {
        List<TmLpinter> tmLpinterList = this.queryLpinterModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLpinter(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmLpinterList);
        return queryResult;
    }

    @Override
    public TmLpinter getLpinterByCode(String tenantCode, String lpinterCode) throws ApiException {
        if (StringUtils.isBlank((String)lpinterCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lpinterCode", lpinterCode);
        return this.getLpinterModelByCode(map);
    }

    @Override
    public void deleteLpinterByCode(String tenantCode, String lpinterCode) throws ApiException {
        if (StringUtils.isBlank((String)lpinterCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lpinterCode", lpinterCode);
        this.delLpinterModelByCode(map);
    }

    @Override
    public String saveLpinterConf(TmLpinterConfDomain tmLpinterConfDomain) throws ApiException {
        TmLpinterConf tmLpinterConf = this.createTmLpinterConf(tmLpinterConfDomain);
        this.saveLpinterConfModel(tmLpinterConf);
        this.reloadCache(tmLpinterConf.getLpinterCode(), tmLpinterConf.getTenantCode());
        return tmLpinterConf.getLpinterConfCode();
    }

    private void reloadCache(String lpinterCode, String tenantCode) {
        if (StringUtils.isBlank((String)lpinterCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("lpinterCode", lpinterCode);
        TmLpinter tmLpinter = this.getLpinterModelByCode(parammap);
        this.reloadCache(tmLpinter);
    }

    private void reloadCache(TmLpinter tmLpinter) {
        if (null == tmLpinter) {
            return;
        }
        if (1 == tmLpinter.getDataState()) {
            this.updateCache(tmLpinter);
        } else {
            this.deleteCache(tmLpinter);
        }
    }

    @Override
    public String saveLpinterConfBatch(List<TmLpinterConfDomain> tmLpinterConfDomainList) throws ApiException {
        if (null == tmLpinterConfDomainList || tmLpinterConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TmLpinterConf> tmLpinterConfList = new ArrayList<TmLpinterConf>();
        TmLpinterConf tmLpinterConf = null;
        String code = "";
        for (TmLpinterConfDomain tmLpinterConfDomain : tmLpinterConfDomainList) {
            tmLpinterConf = this.createTmLpinterConf(tmLpinterConfDomain);
            code = tmLpinterConf.getLpinterConfCode();
            tmLpinterConfList.add(tmLpinterConf);
        }
        this.saveLpinterConfBatchModel(tmLpinterConfList);
        this.reloadCache(tmLpinterConf.getLpinterCode(), tmLpinterConf.getTenantCode());
        return code;
    }

    @Override
    public void updateLpinterConfState(Integer lpinterConfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == lpinterConfId) {
            return;
        }
        this.updateStateLpinterConfModel(lpinterConfId, dataState, oldDataState, map);
    }

    @Override
    public void updateLpinterConfStateByCode(String tenantCode, String lpinterConfCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)lpinterConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateLpinterConfModelByCode(tenantCode, lpinterConfCode, dataState, oldDataState, map);
    }

    @Override
    public void updateLpinterConf(TmLpinterConfDomain tmLpinterConfDomain) throws ApiException {
        String msg = this.checkLpinterConf(tmLpinterConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateLpinterConf.checkLpinterConf", msg);
        }
        TmLpinterConf oldTmLpinterConf = this.getLpinterConfModelById(tmLpinterConfDomain.getLpinterConfId());
        if (null == oldTmLpinterConf) {
            throw new ApiException("tm.TmLpinterServiceImpl.updateLpinterConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmLpinterConf tmLpinterConf = this.makeLpinterConf(tmLpinterConfDomain, oldTmLpinterConf);
        this.setLpinterConfUpdataDefault(tmLpinterConf);
        this.updateLpinterConfModel(tmLpinterConf);
    }

    @Override
    public TmLpinterConf getLpinterConf(Integer lpinterConfId) {
        if (null == lpinterConfId) {
            return null;
        }
        return this.getLpinterConfModelById(lpinterConfId);
    }

    @Override
    public void deleteLpinterConf(Integer lpinterConfId) throws ApiException {
        if (null == lpinterConfId) {
            return;
        }
        this.deleteLpinterConfModel(lpinterConfId);
    }

    @Override
    public QueryResult<TmLpinterConf> queryLpinterConfPage(Map<String, Object> map) {
        List<TmLpinterConf> tmLpinterConfList = this.queryLpinterConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLpinterConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmLpinterConfList);
        return queryResult;
    }

    @Override
    public TmLpinterConf getLpinterConfByCode(String tenantCode, String lpinterConfCode) throws ApiException {
        if (StringUtils.isBlank((String)lpinterConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lpinterConfCode", lpinterConfCode);
        return this.getLpinterConfModelByCode(map);
    }

    @Override
    public void deleteLpinterConfByCode(String tenantCode, String lpinterConfCode) throws ApiException {
        if (StringUtils.isBlank((String)lpinterConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lpinterConfCode", lpinterConfCode);
        this.delLpinterConfModelByCode(map);
    }

    @Override
    public String queryLpinterByConf(Map<String, String> map, String tenantCode) {
        if (MapUtil.isEmpty(map) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("tm.TmLpinterServiceImpl.queryLpinterByConf.null");
            return null;
        }
        Map tmap = DisUtil.getMapAll((String)("tmLpinter-" + tenantCode));
        if (MapUtil.isEmpty((Map)tmap)) {
            this.logger.error("tm.TmLpinterServiceImpl.queryLpinterByConf.tmap", (Object)map.toString());
            return null;
        }
        String lpinterCode = "";
        for (String key : tmap.keySet()) {
            Map cmap = DisUtil.getMapAll((String)("tmLpinterConf-" + key));
            if (MapUtil.isEmpty((Map)cmap)) {
                lpinterCode = (String)tmap.get(key);
                continue;
            }
            if (!this.checkConf(map, cmap)) continue;
            return (String)tmap.get(key);
        }
        return lpinterCode;
    }

    private boolean checkConf(Map<String, String> map, Map<String, String> cmap) {
        if (MapUtil.isEmpty(map)) {
            return false;
        }
        if (MapUtil.isEmpty(cmap)) {
            return false;
        }
        String pro = "";
        String term = "=";
        String value = "";
        for (String key : cmap.keySet()) {
            String[] keys = key.split(spl);
            pro = keys[0];
            term = keys.length > 1 ? keys[1] : "=";
            value = map.get(pro);
            if (!("=".equals(term) ? null == value || !value.equals(cmap.get(key)) : null == value || value.equals(cmap.get(key)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void queryLoadCache() {
        List<TmLpinter> tmLpinterList = this.queryLpinterModelPage(null);
        Map tmap = DisUtil.getMapAll((String)cache_lpinter_tenant);
        DisUtil.del((String)cache_lpinter_tenant);
        if (MapUtil.isNotEmpty((Map)tmap)) {
            for (String key : tmap.keySet()) {
                DisUtil.del((String)("tmLpinter-" + key));
            }
        }
        if (ListUtil.isEmpty(tmLpinterList)) {
            return;
        }
        for (TmLpinter tmLpinter : tmLpinterList) {
            this.updateCache(tmLpinter);
        }
    }

    private void deleteCache(TmLpinter tmLpinter) {
        if (null == tmLpinter) {
            return;
        }
        DisUtil.delMap((String)("tmLpinter-" + tmLpinter.getTenantCode()), (String[])new String[]{tmLpinter.getLpinterCode() + spl + tmLpinter.getTenantCode()});
        DisUtil.del((String)("tmLpinterConf-" + tmLpinter.getLpinterCode() + spl + tmLpinter.getTenantCode()));
    }

    private void updateCache(TmLpinter tmLpinter) {
        if (null == tmLpinter) {
            return;
        }
        DisUtil.setMap((String)cache_lpinter_tenant, (String)tmLpinter.getTenantCode(), (String)tmLpinter.getTenantCode());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DisUtil.setMap((String)("tmLpinter-" + tmLpinter.getTenantCode()), (String)(tmLpinter.getLpinterCode() + spl + tmLpinter.getTenantCode()), (String)tmLpinter.getLpinterCode());
        paramMap.put("lpinterCode", tmLpinter.getLpinterCode());
        paramMap.put("tenantCode", tmLpinter.getTenantCode());
        List<TmLpinterConf> confList = this.queryLpinterConfModelPage(paramMap);
        DisUtil.del((String)("tmLpinterConf-" + tmLpinter.getLpinterCode() + spl + tmLpinter.getTenantCode()));
        if (ListUtil.isEmpty(confList)) {
            return;
        }
        for (TmLpinterConf tmLpinterConf : confList) {
            DisUtil.setMap((String)("tmLpinterConf-" + tmLpinter.getLpinterCode() + spl + tmLpinter.getTenantCode()), (String)(tmLpinterConf.getLpinterConfType() + spl + tmLpinterConf.getLpinterConfTerm()), (String)tmLpinterConf.getLpinterConfValue());
        }
    }
}

