/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tenantmanag.dao.TmRolePermissionMapper;
import com.yqbsoft.laser.service.tenantmanag.domain.TmRolePermissionDomain;
import com.yqbsoft.laser.service.tenantmanag.model.TmRolePermission;
import com.yqbsoft.laser.service.tenantmanag.service.TmRolePermissionService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TmRolePermissionServiceImpl
extends BaseServiceImpl
implements TmRolePermissionService {
    public static final String SYS_CODE = "tm.TmRolePermissionServiceImpl";
    private TmRolePermissionMapper tmRolePermissionMapper;

    public void setTmRolePermissionMapper(TmRolePermissionMapper tmRolePermissionMapper) {
        this.tmRolePermissionMapper = tmRolePermissionMapper;
    }

    private Date getSysDate() {
        try {
            return this.tmRolePermissionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tm.TmRolePermissionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRolePermission(TmRolePermissionDomain tmRolePermissionDomain) {
        if (null == tmRolePermissionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmRolePermissionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmRolePermissionDomain.getProappCode())) {
            msg = msg + "ProappCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRolePermissionDefault(TmRolePermission tmRolePermission) {
        if (null == tmRolePermission) {
            return;
        }
        if (null == tmRolePermission.getDataState()) {
            tmRolePermission.setDataState(0);
        }
        if (null == tmRolePermission.getGmtCreate()) {
            tmRolePermission.setGmtCreate(this.getSysDate());
        }
        tmRolePermission.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmRolePermission.getRolePermissionCode())) {
            tmRolePermission.setRolePermissionCode(this.createUUIDString());
        }
    }

    private int getRolePermissionMaxCode() {
        int code = 0;
        try {
            return this.tmRolePermissionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmRolePermissionServiceImpl.getRolePermissionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRolePermissionUpdataDefault(TmRolePermission tmRolePermission) {
        if (null == tmRolePermission) {
            return;
        }
        tmRolePermission.setGmtModified(this.getSysDate());
    }

    private void saveRolePermissionModel(TmRolePermission tmRolePermission) throws ApiException {
        if (null == tmRolePermission) {
            return;
        }
        try {
            this.tmRolePermissionMapper.insert(tmRolePermission);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.saveRolePermissionModel.ex", (Throwable)e);
        }
    }

    private TmRolePermission getRolePermissionModelById(Integer rolePermissionId) {
        if (null == rolePermissionId) {
            return null;
        }
        try {
            return this.tmRolePermissionMapper.selectByPrimaryKey(rolePermissionId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmRolePermissionServiceImpl.getRolePermissionModelById", (Throwable)e);
            return null;
        }
    }

    public TmRolePermission getRolePermissionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmRolePermissionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmRolePermissionServiceImpl.getRolePermissionModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRolePermissionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmRolePermissionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.delRolePermissionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.delRolePermissionModelByCode.num");
        }
    }

    private void deleteRolePermissionModel(Integer rolePermissionId) throws ApiException {
        if (null == rolePermissionId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmRolePermissionMapper.deleteByPrimaryKey(rolePermissionId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.deleteRolePermissionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.deleteRolePermissionModel.num");
        }
    }

    private void updateRolePermissionModel(TmRolePermission tmRolePermission) throws ApiException {
        if (null == tmRolePermission) {
            return;
        }
        try {
            this.tmRolePermissionMapper.updateByPrimaryKeySelective(tmRolePermission);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.updateRolePermissionModel.ex", (Throwable)e);
        }
    }

    private void updateStateRolePermissionModel(Integer rolePermissionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == rolePermissionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rolePermissionId", rolePermissionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmRolePermissionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.updateStateRolePermissionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.updateStateRolePermissionModel.null");
        }
    }

    private TmRolePermission makeRolePermission(TmRolePermissionDomain tmRolePermissionDomain, TmRolePermission tmRolePermission) {
        if (null == tmRolePermissionDomain) {
            return null;
        }
        if (null == tmRolePermission) {
            tmRolePermission = new TmRolePermission();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmRolePermission, (Object)tmRolePermissionDomain);
            return tmRolePermission;
        }
        catch (Exception e) {
            this.logger.error("tm.TmRolePermissionServiceImpl.makeRolePermission", (Throwable)e);
            return null;
        }
    }

    private List<TmRolePermission> queryRolePermissionModelPage(Map<String, Object> parammap) {
        try {
            return this.tmRolePermissionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmRolePermissionServiceImpl.queryRolePermissionModel", (Throwable)e);
            return null;
        }
    }

    private int countRolePermission(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmRolePermissionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmRolePermissionServiceImpl.countRolePermission", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveRolePermission(TmRolePermissionDomain tmRolePermissionDomain) throws ApiException {
        String msg = this.checkRolePermission(tmRolePermissionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.saveRolePermission.checkRolePermission", msg);
        }
        TmRolePermission tmRolePermission = this.makeRolePermission(tmRolePermissionDomain, null);
        this.setRolePermissionDefault(tmRolePermission);
        this.saveRolePermissionModel(tmRolePermission);
    }

    @Override
    public void updateRolePermissionState(Integer rolePermissionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRolePermissionModel(rolePermissionId, dataState, oldDataState);
    }

    @Override
    public void updateRolePermission(TmRolePermissionDomain tmRolePermissionDomain) throws ApiException {
        String msg = this.checkRolePermission(tmRolePermissionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.updateRolePermission.checkRolePermission", msg);
        }
        TmRolePermission oldTmRolePermission = this.getRolePermissionModelById(tmRolePermissionDomain.getRolePermissionId());
        if (null == oldTmRolePermission) {
            throw new ApiException("tm.TmRolePermissionServiceImpl.updateRolePermission.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmRolePermission tmRolePermission = this.makeRolePermission(tmRolePermissionDomain, oldTmRolePermission);
        this.setRolePermissionUpdataDefault(tmRolePermission);
        this.updateRolePermissionModel(tmRolePermission);
    }

    @Override
    public TmRolePermission getRolePermission(Integer rolePermissionId) {
        return this.getRolePermissionModelById(rolePermissionId);
    }

    @Override
    public void deleteRolePermission(Integer rolePermissionId) throws ApiException {
        this.deleteRolePermissionModel(rolePermissionId);
    }

    @Override
    public QueryResult<TmRolePermission> queryRolePermissionPage(Map<String, Object> map) {
        List<TmRolePermission> tmRolePermissionList = this.queryRolePermissionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRolePermission(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmRolePermissionList);
        return queryResult;
    }

    @Override
    public TmRolePermission getRolePermissionByCode(Map<String, Object> map) {
        return this.getRolePermissionModelByCode(map);
    }

    @Override
    public void delRolePermissionByCode(Map<String, Object> map) throws ApiException {
        this.delRolePermissionModelByCode(map);
    }
}

