/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ul.dao.UlLevelRulenumMapper;
import com.yqbsoft.laser.service.ul.domain.UlLevelRulenumDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelRulenumReDomain;
import com.yqbsoft.laser.service.ul.es.SendRulenumPollThread;
import com.yqbsoft.laser.service.ul.es.SendRulenumPutThread;
import com.yqbsoft.laser.service.ul.es.SendRulenumService;
import com.yqbsoft.laser.service.ul.model.UlLevelRulenum;
import com.yqbsoft.laser.service.ul.service.UlLevelRulenumBaseService;
import com.yqbsoft.laser.service.ul.service.UlLevelRulenumService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UlLevelRulenumBaseServiceImpl
extends BaseServiceImpl
implements UlLevelRulenumBaseService {
    private static final String SYS_CODE = "ul.UlLevelRulenumBaseServiceImpl";
    private UlLevelRulenumMapper ulLevelRulenumMapper;
    private UlLevelRulenumService ulLevelRulenumService;
    private static SendRulenumService sendRulenumService;
    private static Object lock;

    public void setUlLevelRulenumMapper(UlLevelRulenumMapper ulLevelRulenumMapper) {
        this.ulLevelRulenumMapper = ulLevelRulenumMapper;
    }

    private Date getSysDate() {
        try {
            return this.ulLevelRulenumMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumBaseServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlLevelRulenum(UlLevelRulenumDomain ulLevelRulenumDomain) {
        if (null == ulLevelRulenumDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulLevelRulenumDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlLevelRulenumDefault(UlLevelRulenum ulLevelRulenum) {
        if (null == ulLevelRulenum) {
            return;
        }
        if (null == ulLevelRulenum.getDataState()) {
            ulLevelRulenum.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulLevelRulenum.getGmtCreate()) {
            ulLevelRulenum.setGmtCreate(date);
        }
        ulLevelRulenum.setGmtModified(date);
        if (StringUtils.isBlank((String)ulLevelRulenum.getLevelRulenumCode())) {
            ulLevelRulenum.setLevelRulenumCode(this.getNo(null, "UlLevelRulenum", "ulLevelRulenum", ulLevelRulenum.getTenantCode()));
        }
    }

    private int getUlLevelRulenumMaxCode() {
        int code = 0;
        try {
            return this.ulLevelRulenumMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumBaseServiceImpl.getUlLevelRulenumMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlLevelRulenumUpdataDefault(UlLevelRulenum ulLevelRulenum) {
        if (null == ulLevelRulenum) {
            return;
        }
        ulLevelRulenum.setGmtModified(this.getSysDate());
    }

    private void saveUlLevelRulenumModel(UlLevelRulenum ulLevelRulenum) throws ApiException {
        if (null == ulLevelRulenum) {
            return;
        }
        try {
            this.ulLevelRulenumMapper.insertSelective(ulLevelRulenum);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.saveUlLevelRulenumModel.ex", (Throwable)e);
        }
    }

    private void saveUlLevelRulenumBatchModel(List<UlLevelRulenum> ulLevelRulenumList) throws ApiException {
        if (null == ulLevelRulenumList || ulLevelRulenumList.isEmpty()) {
            return;
        }
        try {
            this.ulLevelRulenumMapper.insertBatch(ulLevelRulenumList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.saveUlLevelRulenumBatchModel.ex", (Throwable)e);
        }
    }

    private UlLevelRulenum getUlLevelRulenumModelById(Integer levelRulenumId) {
        if (null == levelRulenumId) {
            return null;
        }
        try {
            return this.ulLevelRulenumMapper.selectByPrimaryKey(levelRulenumId);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumBaseServiceImpl.getUlLevelRulenumModelById", (Throwable)e);
            return null;
        }
    }

    private UlLevelRulenum getUlLevelRulenumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelRulenumMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumBaseServiceImpl.getUlLevelRulenumModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlLevelRulenumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.delUlLevelRulenumModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.delUlLevelRulenumModelByCode.num");
        }
    }

    private void deleteUlLevelRulenumModel(Integer levelRulenumId) throws ApiException {
        if (null == levelRulenumId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.deleteByPrimaryKey(levelRulenumId);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.deleteUlLevelRulenumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.deleteUlLevelRulenumModel.num");
        }
    }

    private void updateUlLevelRulenumModel(UlLevelRulenum ulLevelRulenum) throws ApiException {
        if (null == ulLevelRulenum) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.updateByPrimaryKey(ulLevelRulenum);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.updateUlLevelRulenumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.updateUlLevelRulenumModel.num");
        }
    }

    private void updateStateUlLevelRulenumModel(Integer levelRulenumId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == levelRulenumId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelRulenumId", levelRulenumId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.updateStateUlLevelRulenumModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.updateStateUlLevelRulenumModel.null");
        }
    }

    private void updateStateUlLevelRulenumModelByCode(String tenantCode, String levelRulenumCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)levelRulenumCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelRulenumCode", levelRulenumCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.updateStateUlLevelRulenumModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.updateStateUlLevelRulenumModelByCode.null");
        }
    }

    private UlLevelRulenum makeUlLevelRulenum(UlLevelRulenumDomain ulLevelRulenumDomain, UlLevelRulenum ulLevelRulenum) {
        if (null == ulLevelRulenumDomain) {
            return null;
        }
        if (null == ulLevelRulenum) {
            ulLevelRulenum = new UlLevelRulenum();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelRulenum, (Object)ulLevelRulenumDomain);
            return ulLevelRulenum;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumBaseServiceImpl.makeUlLevelRulenum", (Throwable)e);
            return null;
        }
    }

    private UlLevelRulenumReDomain makeUlLevelRulenumReDomain(UlLevelRulenum ulLevelRulenum) {
        if (null == ulLevelRulenum) {
            return null;
        }
        UlLevelRulenumReDomain ulLevelRulenumReDomain = new UlLevelRulenumReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelRulenumReDomain, (Object)ulLevelRulenum);
            return ulLevelRulenumReDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumBaseServiceImpl.makeUlLevelRulenumReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelRulenum> queryUlLevelRulenumModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelRulenumMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumBaseServiceImpl.queryUlLevelRulenumModel", (Throwable)e);
            return null;
        }
    }

    private int countUlLevelRulenum(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumBaseServiceImpl.countUlLevelRulenum", (Throwable)e);
        }
        return i;
    }

    private UlLevelRulenum createUlLevelRulenum(UlLevelRulenumDomain ulLevelRulenumDomain) {
        String msg = this.checkUlLevelRulenum(ulLevelRulenumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.saveUlLevelRulenum.checkUlLevelRulenum", msg);
        }
        UlLevelRulenum ulLevelRulenum = this.makeUlLevelRulenum(ulLevelRulenumDomain, null);
        this.setUlLevelRulenumDefault(ulLevelRulenum);
        return ulLevelRulenum;
    }

    @Override
    public void timingUlLevelRule() {
        this.loadDb();
    }

    public void setUlLevelRulenumService(UlLevelRulenumService ulLevelRulenumService) {
        this.ulLevelRulenumService = ulLevelRulenumService;
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("levelRuleType", "1");
            QueryResult<UlLevelRulenum> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getSendRulenumService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getSendRulenumService().getPage());
                result = this.ulLevelRulenumService.queryUlLevelRulenumPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getSendRulenumService().addPutPool(new SendRulenumPutThread(this.getSendRulenumService(), result.getRows()));
                    if (result.getRows().size() == this.getSendRulenumService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getSendRulenumService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendRulenumService getSendRulenumService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendRulenumService) {
                sendRulenumService = new SendRulenumService((UlLevelRulenumService)SpringApplicationContextUtil.getBean((String)"ulLevelRulenumService"));
                for (int i = 0; i < 10; ++i) {
                    sendRulenumService.addPollPool(new SendRulenumPollThread(sendRulenumService));
                }
            }
            return sendRulenumService;
        }
    }

    static {
        lock = new Object();
    }
}

