/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.ul.domain.UlDowmDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelClearDomain;
import com.yqbsoft.laser.service.ul.es.SendRulenumPollThread;
import com.yqbsoft.laser.service.ul.es.SendRulenumService;
import com.yqbsoft.laser.service.ul.model.UlLevelRule;
import com.yqbsoft.laser.service.ul.model.UlLevelRulenum;
import com.yqbsoft.laser.service.ul.model.UlLevelUpoints;
import com.yqbsoft.laser.service.ul.service.UlLevelClearBaseService;
import com.yqbsoft.laser.service.ul.service.UlLevelRuleService;
import com.yqbsoft.laser.service.ul.service.UlLevelRulenumBaseService;
import com.yqbsoft.laser.service.ul.service.UlLevelRulenumService;
import com.yqbsoft.laser.service.ul.service.UlLevelUllistService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class UlLevelRulenumBaseServiceImpl
extends BaseServiceImpl
implements UlLevelRulenumBaseService {
    private static final String SYS_CODE = "ul.UlLevelRulenumBaseServiceImpl";
    private UlLevelRulenumService ulLevelRulenumService;
    private UlLevelClearBaseService ulLevelClearBaseService;
    private static SendRulenumService sendRulenumService;
    private static Object lock;
    UlLevelRuleService ulLevelRuleService;
    UlLevelUllistService ulLevelUllistService;

    @Override
    public void timingUlLevelRule() {
        this.loadDb();
    }

    public void setUlLevelRulenumService(UlLevelRulenumService ulLevelRulenumService) {
        this.ulLevelRulenumService = ulLevelRulenumService;
    }

    public void setUlLevelClearBaseService(UlLevelClearBaseService ulLevelClearBaseService) {
        this.ulLevelClearBaseService = ulLevelClearBaseService;
    }

    private void loadDb() {
        try {
            HashMap<String, Object> rmap = new HashMap<String, Object>();
            rmap.put("dataState", "0");
            rmap.put("levelRuleType", "1");
            QueryResult<UlLevelRule> rresult = this.ulLevelRuleService.queryUlLevelRulePage(rmap);
            if (null == rresult || ListUtil.isEmpty((Collection)rresult.getList())) {
                return;
            }
            HashMap<String, ArrayList<UlLevelRule>> rulemap = new HashMap<String, ArrayList<UlLevelRule>>();
            for (UlLevelRule ulLevelRule : rresult.getList()) {
                ArrayList<UlLevelRule> ruleList = (ArrayList<UlLevelRule>)rulemap.get(ulLevelRule.getTenantCode());
                if (null == ruleList) {
                    ruleList = new ArrayList<UlLevelRule>();
                    rulemap.put(ulLevelRule.getTenantCode(), ruleList);
                }
                ruleList.add(ulLevelRule);
            }
            if (MapUtil.isEmpty(rulemap)) {
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : rulemap.keySet()) {
                int startRow = 0;
                boolean flag = true;
                map.put("tenantCode", key);
                do {
                    startRow = this.getSendRulenumService().getStartRow();
                    map.put("startRow", startRow);
                    map.put("rows", this.getSendRulenumService().getPage());
                    QueryResult<UlLevelUpoints> result = this.ulLevelUllistService.queryUlLevelUpointsPage(map);
                    if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                        startRow = result.getPageTools().getRecordCountNo();
                        for (UlLevelUpoints ulLevelUpoints : result.getRows()) {
                            UlDowmDomain ulDowmDomain = new UlDowmDomain();
                            ulDowmDomain.setUlLevelRuleList((List)rulemap.get(key));
                            ulDowmDomain.setUlLevelUpoints(ulLevelUpoints);
                            QueryResult<UlLevelRulenum> rulenumlist = this.ulLevelRulenumService.queryUlLevelRulenumPage(this.getQueryMapParam("memberCode,tenantCode", new Object[]{ulLevelUpoints.getMemberCode(), ulLevelUpoints.getTenantCode()}));
                            if (null != rulenumlist) {
                                ulDowmDomain.setUlLevelRulenumList(rulenumlist.getList());
                            }
                            this.getSendRulenumService().putQueue(ulDowmDomain);
                        }
                        if (result.getRows().size() == this.getSendRulenumService().getPage()) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                } while (flag);
                this.getSendRulenumService().initStartRow();
            }
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumBaseServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendRulenumService getSendRulenumService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendRulenumService) {
                sendRulenumService = new SendRulenumService((UlLevelRulenumBaseService)SpringApplicationContextUtil.getBean((String)"ulLevelRulenumBaseService"));
                for (int i = 0; i < 10; ++i) {
                    sendRulenumService.addPollPool(new SendRulenumPollThread(sendRulenumService));
                }
            }
            return sendRulenumService;
        }
    }

    public void setUlLevelRuleService(UlLevelRuleService ulLevelRuleService) {
        this.ulLevelRuleService = ulLevelRuleService;
    }

    public void setUlLevelUllistService(UlLevelUllistService ulLevelUllistService) {
        this.ulLevelUllistService = ulLevelUllistService;
    }

    @Override
    public void saveDownUlLevelRule(UlDowmDomain ulDowmDomain) {
        if (null == ulDowmDomain || ListUtil.isEmpty(ulDowmDomain.getUlLevelRuleList()) || null == ulDowmDomain.getUlLevelUpoints()) {
            return;
        }
        HashMap<String, UlLevelRulenum> map = new HashMap<String, UlLevelRulenum>();
        if (ListUtil.isNotEmpty(ulDowmDomain.getUlLevelRulenumList())) {
            for (UlLevelRulenum ulLevelRulenum : ulDowmDomain.getUlLevelRulenumList()) {
                map.put(ulLevelRulenum.getLevelRuleCode(), ulLevelRulenum);
            }
        }
        for (UlLevelRule ulLevelRule : ulDowmDomain.getUlLevelRuleList()) {
            UlLevelClearDomain ulLevelClearDomain = new UlLevelClearDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ulLevelClearDomain, (Object)ulLevelRule);
            }
            catch (Exception e) {
                this.logger.error("ul.UlLevelRulenumBaseServiceImpl.makeUlLevelRulenum", (Throwable)e);
            }
            UlLevelRulenum ulLevelRulenum = (UlLevelRulenum)map.get(ulLevelRule.getLevelRuleCode());
            ulLevelClearDomain.setLevelType("0");
            ulLevelClearDomain.setLevelClearDirection("9");
            ulLevelClearDomain.setLevelUserqua(ulDowmDomain.getUlLevelUpoints().getLevelUserqua());
            ulLevelClearDomain.setMemberCode(ulDowmDomain.getUlLevelUpoints().getMemberCode());
            if (null != ulLevelRulenum) {
                ulLevelClearDomain.setLevelType(ulLevelRulenum.getLevelType());
                ulLevelClearDomain.setMemberCcode(ulLevelRulenum.getMemberCcode());
                ulLevelClearDomain.setMemberCname(ulLevelRulenum.getMemberCname());
            }
            ulLevelClearDomain.setMemberMcode(ulDowmDomain.getUlLevelUpoints().getMemberMcode());
            ulLevelClearDomain.setMemberMname(ulDowmDomain.getUlLevelUpoints().getMemberMname());
            ulLevelClearDomain.setLevelClearNum(new BigDecimal(ulLevelRule.getLevelRuleNum()));
            this.ulLevelClearBaseService.sendLevelClear(ulLevelClearDomain);
        }
    }

    static {
        lock = new Object();
    }
}

