/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ula.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ula.dao.UlaLtypeRuleMapper;
import com.yqbsoft.laser.service.ula.domain.UlaLtypeRuleDomain;
import com.yqbsoft.laser.service.ula.domain.UlaLtypeRuleReDomain;
import com.yqbsoft.laser.service.ula.model.UlaLtypeRule;
import com.yqbsoft.laser.service.ula.service.UlaLtypeRuleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UlaLtypeRuleServiceImpl
extends BaseServiceImpl
implements UlaLtypeRuleService {
    private static final String SYS_CODE = "ula.UlaLtypeRuleServiceImpl";
    private UlaLtypeRuleMapper ulaLtypeRuleMapper;

    public void setUlaLtypeRuleMapper(UlaLtypeRuleMapper ulaLtypeRuleMapper) {
        this.ulaLtypeRuleMapper = ulaLtypeRuleMapper;
    }

    private Date getSysDate() {
        try {
            return this.ulaLtypeRuleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeRuleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlaLtypeRule(UlaLtypeRuleDomain ulaLtypeRuleDomain) {
        if (null == ulaLtypeRuleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulaLtypeRuleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlaLtypeRuleDefault(UlaLtypeRule ulaLtypeRule) {
        if (null == ulaLtypeRule) {
            return;
        }
        if (null == ulaLtypeRule.getDataState()) {
            ulaLtypeRule.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulaLtypeRule.getGmtCreate()) {
            ulaLtypeRule.setGmtCreate(date);
        }
        ulaLtypeRule.setGmtModified(date);
        if (StringUtils.isBlank((String)ulaLtypeRule.getLtypeRuleCode())) {
            ulaLtypeRule.setLtypeRuleCode(this.getNo(null, "UlaLtypeRule", "ulaLtypeRule", ulaLtypeRule.getTenantCode()));
        }
    }

    private int getUlaLtypeRuleMaxCode() {
        int code = 0;
        try {
            return this.ulaLtypeRuleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeRuleServiceImpl.getUlaLtypeRuleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlaLtypeRuleUpdataDefault(UlaLtypeRule ulaLtypeRule) {
        if (null == ulaLtypeRule) {
            return;
        }
        ulaLtypeRule.setGmtModified(this.getSysDate());
    }

    private void saveUlaLtypeRuleModel(UlaLtypeRule ulaLtypeRule) throws ApiException {
        if (null == ulaLtypeRule) {
            return;
        }
        try {
            this.ulaLtypeRuleMapper.insert(ulaLtypeRule);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.saveUlaLtypeRuleModel.ex", (Throwable)e);
        }
    }

    private void saveUlaLtypeRuleBatchModel(List<UlaLtypeRule> ulaLtypeRuleList) throws ApiException {
        if (null == ulaLtypeRuleList || ulaLtypeRuleList.isEmpty()) {
            return;
        }
        try {
            this.ulaLtypeRuleMapper.insertBatch(ulaLtypeRuleList);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.saveUlaLtypeRuleBatchModel.ex", (Throwable)e);
        }
    }

    private UlaLtypeRule getUlaLtypeRuleModelById(Integer ltypeRuleId) {
        if (null == ltypeRuleId) {
            return null;
        }
        try {
            return this.ulaLtypeRuleMapper.selectByPrimaryKey(ltypeRuleId);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeRuleServiceImpl.getUlaLtypeRuleModelById", (Throwable)e);
            return null;
        }
    }

    private UlaLtypeRule getUlaLtypeRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulaLtypeRuleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeRuleServiceImpl.getUlaLtypeRuleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlaLtypeRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLtypeRuleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.delUlaLtypeRuleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.delUlaLtypeRuleModelByCode.num");
        }
    }

    private void deleteUlaLtypeRuleModel(Integer ltypeRuleId) throws ApiException {
        if (null == ltypeRuleId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLtypeRuleMapper.deleteByPrimaryKey(ltypeRuleId);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.deleteUlaLtypeRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.deleteUlaLtypeRuleModel.num");
        }
    }

    private void updateUlaLtypeRuleModel(UlaLtypeRule ulaLtypeRule) throws ApiException {
        if (null == ulaLtypeRule) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLtypeRuleMapper.updateByPrimaryKeySelective(ulaLtypeRule);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.updateUlaLtypeRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.updateUlaLtypeRuleModel.num");
        }
    }

    private void updateStateUlaLtypeRuleModel(Integer ltypeRuleId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ltypeRuleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ltypeRuleId", ltypeRuleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulaLtypeRuleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.updateStateUlaLtypeRuleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.updateStateUlaLtypeRuleModel.null");
        }
    }

    private void updateStateUlaLtypeRuleModelByCode(String tenantCode, String ltypeRuleCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ltypeRuleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltypeRuleCode", ltypeRuleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulaLtypeRuleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.updateStateUlaLtypeRuleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.updateStateUlaLtypeRuleModelByCode.null");
        }
    }

    private UlaLtypeRule makeUlaLtypeRule(UlaLtypeRuleDomain ulaLtypeRuleDomain, UlaLtypeRule ulaLtypeRule) {
        if (null == ulaLtypeRuleDomain) {
            return null;
        }
        if (null == ulaLtypeRule) {
            ulaLtypeRule = new UlaLtypeRule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulaLtypeRule, (Object)ulaLtypeRuleDomain);
            return ulaLtypeRule;
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeRuleServiceImpl.makeUlaLtypeRule", (Throwable)e);
            return null;
        }
    }

    private UlaLtypeRuleReDomain makeUlaLtypeRuleReDomain(UlaLtypeRule ulaLtypeRule) {
        if (null == ulaLtypeRule) {
            return null;
        }
        UlaLtypeRuleReDomain ulaLtypeRuleReDomain = new UlaLtypeRuleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulaLtypeRuleReDomain, (Object)ulaLtypeRule);
            return ulaLtypeRuleReDomain;
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeRuleServiceImpl.makeUlaLtypeRuleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlaLtypeRule> queryUlaLtypeRuleModelPage(Map<String, Object> parammap) {
        try {
            return this.ulaLtypeRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeRuleServiceImpl.queryUlaLtypeRuleModel", (Throwable)e);
            return null;
        }
    }

    private int countUlaLtypeRule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulaLtypeRuleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeRuleServiceImpl.countUlaLtypeRule", (Throwable)e);
        }
        return i;
    }

    private UlaLtypeRule createUlaLtypeRule(UlaLtypeRuleDomain ulaLtypeRuleDomain) {
        String msg = this.checkUlaLtypeRule(ulaLtypeRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.saveUlaLtypeRule.checkUlaLtypeRule", msg);
        }
        UlaLtypeRule ulaLtypeRule = this.makeUlaLtypeRule(ulaLtypeRuleDomain, null);
        this.setUlaLtypeRuleDefault(ulaLtypeRule);
        return ulaLtypeRule;
    }

    @Override
    public String saveUlaLtypeRule(UlaLtypeRuleDomain ulaLtypeRuleDomain) throws ApiException {
        UlaLtypeRule ulaLtypeRule = this.createUlaLtypeRule(ulaLtypeRuleDomain);
        this.saveUlaLtypeRuleModel(ulaLtypeRule);
        return ulaLtypeRule.getLtypeRuleCode();
    }

    @Override
    public String saveUlaLtypeRuleBatch(List<UlaLtypeRuleDomain> ulaLtypeRuleDomainList) throws ApiException {
        if (null == ulaLtypeRuleDomainList || ulaLtypeRuleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlaLtypeRule> ulaLtypeRuleList = new ArrayList<UlaLtypeRule>();
        String code = "";
        for (UlaLtypeRuleDomain ulaLtypeRuleDomain : ulaLtypeRuleDomainList) {
            UlaLtypeRule ulaLtypeRule = this.createUlaLtypeRule(ulaLtypeRuleDomain);
            code = ulaLtypeRule.getLtypeRuleCode();
            ulaLtypeRuleList.add(ulaLtypeRule);
        }
        this.saveUlaLtypeRuleBatchModel(ulaLtypeRuleList);
        return code;
    }

    @Override
    public void updateUlaLtypeRuleState(Integer ltypeRuleId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ltypeRuleId) {
            return;
        }
        this.updateStateUlaLtypeRuleModel(ltypeRuleId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlaLtypeRuleStateByCode(String tenantCode, String ltypeRuleCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ltypeRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlaLtypeRuleModelByCode(tenantCode, ltypeRuleCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlaLtypeRule(UlaLtypeRuleDomain ulaLtypeRuleDomain) throws ApiException {
        String msg = this.checkUlaLtypeRule(ulaLtypeRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.updateUlaLtypeRule.checkUlaLtypeRule", msg);
        }
        UlaLtypeRule oldUlaLtypeRule = this.getUlaLtypeRuleModelById(ulaLtypeRuleDomain.getLtypeRuleId());
        if (null == oldUlaLtypeRule) {
            throw new ApiException("ula.UlaLtypeRuleServiceImpl.updateUlaLtypeRule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlaLtypeRule ulaLtypeRule = this.makeUlaLtypeRule(ulaLtypeRuleDomain, oldUlaLtypeRule);
        this.setUlaLtypeRuleUpdataDefault(ulaLtypeRule);
        this.updateUlaLtypeRuleModel(ulaLtypeRule);
    }

    @Override
    public UlaLtypeRule getUlaLtypeRule(Integer ltypeRuleId) {
        if (null == ltypeRuleId) {
            return null;
        }
        return this.getUlaLtypeRuleModelById(ltypeRuleId);
    }

    @Override
    public void deleteUlaLtypeRule(Integer ltypeRuleId) throws ApiException {
        if (null == ltypeRuleId) {
            return;
        }
        this.deleteUlaLtypeRuleModel(ltypeRuleId);
    }

    @Override
    public QueryResult<UlaLtypeRule> queryUlaLtypeRulePage(Map<String, Object> map) {
        List<UlaLtypeRule> ulaLtypeRuleList = this.queryUlaLtypeRuleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlaLtypeRule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulaLtypeRuleList);
        return queryResult;
    }

    @Override
    public UlaLtypeRule getUlaLtypeRuleByCode(String tenantCode, String ltypeRuleCode) throws ApiException {
        if (StringUtils.isBlank((String)ltypeRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltypeRuleCode", ltypeRuleCode);
        return this.getUlaLtypeRuleModelByCode(map);
    }

    @Override
    public void deleteUlaLtypeRuleByCode(String tenantCode, String ltypeRuleCode) throws ApiException {
        if (StringUtils.isBlank((String)ltypeRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltypeRuleCode", ltypeRuleCode);
        this.delUlaLtypeRuleModelByCode(map);
    }

    @Override
    public List<UlaLtypeRuleDomain> queryUlaTypeRuleByLgroupCode(String lgroupCode) {
        return this.ulaLtypeRuleMapper.getByLgroupCode(lgroupCode);
    }
}

