/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.userpointsmanager.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.userpointsmanager.UserPointsManagerConstants;
import com.yqbsoft.laser.service.userpointsmanager.dao.UpmPointsRuleMapper;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsRuleDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsRuleReDomain;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmPointsRule;
import com.yqbsoft.laser.service.userpointsmanager.service.UpmPointsRuleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UpmPointsRuleServiceImpl
extends BaseServiceImpl
implements UpmPointsRuleService {
    private static final String SYS_CODE = "upm.UpmPointsRuleServiceImpl";
    private UpmPointsRuleMapper upmPointsRuleMapper;
    private String cachekey = "UpmPointsRule-api";

    public void setUpmPointsRuleMapper(UpmPointsRuleMapper upmPointsRuleMapper) {
        this.upmPointsRuleMapper = upmPointsRuleMapper;
    }

    private Date getSysDate() {
        try {
            return this.upmPointsRuleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPointsRule(UpmPointsRuleDomain upmPointsRuleDomain) {
        if (null == upmPointsRuleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upmPointsRuleDomain.getPointsRuleApi())) {
            msg = msg + "PointsRuleApi\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)upmPointsRuleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsRuleDefault(UpmPointsRule upmPointsRule) {
        if (null == upmPointsRule) {
            return;
        }
        if (null == upmPointsRule.getDataState()) {
            upmPointsRule.setDataState(0);
        }
        if (null == upmPointsRule.getGmtCreate()) {
            upmPointsRule.setGmtCreate(this.getSysDate());
        }
        upmPointsRule.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)upmPointsRule.getPointsRuleCode())) {
            upmPointsRule.setPointsRuleCode(this.createUUIDString());
        }
    }

    private int getPointsRuleMaxCode() {
        int code = 0;
        try {
            return this.upmPointsRuleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleServiceImpl.getPointsRuleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsRuleUpdataDefault(UpmPointsRule upmPointsRule) {
        if (null == upmPointsRule) {
            return;
        }
        upmPointsRule.setGmtModified(this.getSysDate());
    }

    private void savePointsRuleModel(UpmPointsRule upmPointsRule) throws ApiException {
        if (null == upmPointsRule) {
            return;
        }
        try {
            this.upmPointsRuleMapper.insert(upmPointsRule);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.savePointsRuleModel.ex", (Throwable)e);
        }
    }

    private void savePointsRuleBatchModel(List<UpmPointsRule> upmPointsRuleList) throws ApiException {
        if (null == upmPointsRuleList || upmPointsRuleList.isEmpty()) {
            return;
        }
        try {
            this.upmPointsRuleMapper.insertBatch(upmPointsRuleList);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.savePointsRuleBatchModel.ex", (Throwable)e);
        }
    }

    private UpmPointsRule getPointsRuleModelById(Integer pointsRuleId) {
        if (null == pointsRuleId) {
            return null;
        }
        try {
            return this.upmPointsRuleMapper.selectByPrimaryKey(pointsRuleId);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleServiceImpl.getPointsRuleModelById", (Throwable)e);
            return null;
        }
    }

    private UpmPointsRule getPointsRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upmPointsRuleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleServiceImpl.getPointsRuleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsRuleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.delPointsRuleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.delPointsRuleModelByCode.num");
        }
    }

    private void deletePointsRuleModel(Integer pointsRuleId) throws ApiException {
        if (null == pointsRuleId) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsRuleMapper.deleteByPrimaryKey(pointsRuleId);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.deletePointsRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.deletePointsRuleModel.num");
        }
    }

    private void updatePointsRuleModel(UpmPointsRule upmPointsRule) throws ApiException {
        if (null == upmPointsRule) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsRuleMapper.updateByPrimaryKeySelective(upmPointsRule);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.updatePointsRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.updatePointsRuleModel.num");
        }
    }

    private void updateStatePointsRuleModel(Integer pointsRuleId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == pointsRuleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsRuleId", pointsRuleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.upmPointsRuleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.updateStatePointsRuleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.updateStatePointsRuleModel.null");
        }
    }

    private void updateStatePointsRuleModelByCode(String tenantCode, String pointsRuleCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleCode", pointsRuleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.upmPointsRuleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.updateStatePointsRuleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.updateStatePointsRuleModelByCode.null");
        }
    }

    private UpmPointsRule makePointsRule(UpmPointsRuleDomain upmPointsRuleDomain, UpmPointsRule upmPointsRule) {
        if (null == upmPointsRuleDomain) {
            return null;
        }
        if (null == upmPointsRule) {
            upmPointsRule = new UpmPointsRule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upmPointsRule, (Object)upmPointsRuleDomain);
            return upmPointsRule;
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleServiceImpl.makePointsRule", (Throwable)e);
            return null;
        }
    }

    private UpmPointsRuleReDomain makeUpmPointsRuleReDomain(UpmPointsRule upmPointsRule) {
        if (null == upmPointsRule) {
            return null;
        }
        UpmPointsRuleReDomain upmPointsRuleReDomain = new UpmPointsRuleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)upmPointsRuleReDomain, (Object)upmPointsRule);
            return upmPointsRuleReDomain;
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleServiceImpl.makeUpmPointsRuleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UpmPointsRule> queryPointsRuleModelPage(Map<String, Object> parammap) {
        try {
            return this.upmPointsRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleServiceImpl.queryPointsRuleModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsRule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upmPointsRuleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleServiceImpl.countPointsRule", (Throwable)e);
        }
        return i;
    }

    private UpmPointsRule createUpmPointsRule(UpmPointsRuleDomain upmPointsRuleDomain) {
        String msg = this.checkPointsRule(upmPointsRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.savePointsRule.checkPointsRule", msg);
        }
        UpmPointsRule upmPointsRule = this.makePointsRule(upmPointsRuleDomain, null);
        this.setPointsRuleDefault(upmPointsRule);
        return upmPointsRule;
    }

    @Override
    public String savePointsRule(UpmPointsRuleDomain upmPointsRuleDomain) throws ApiException {
        UpmPointsRule upmPointsRule = this.createUpmPointsRule(upmPointsRuleDomain);
        this.savePointsRuleModel(upmPointsRule);
        return upmPointsRule.getPointsRuleCode();
    }

    @Override
    public String savePointsRuleBatch(List<UpmPointsRuleDomain> upmPointsRuleDomainList) throws ApiException {
        if (null == upmPointsRuleDomainList || upmPointsRuleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UpmPointsRule> upmPointsRuleList = new ArrayList<UpmPointsRule>();
        String code = "";
        for (UpmPointsRuleDomain upmPointsRuleDomain : upmPointsRuleDomainList) {
            UpmPointsRule upmPointsRule = this.createUpmPointsRule(upmPointsRuleDomain);
            code = upmPointsRule.getPointsRuleCode();
            upmPointsRuleList.add(upmPointsRule);
        }
        this.savePointsRuleBatchModel(upmPointsRuleList);
        return code;
    }

    @Override
    public void updatePointsRuleState(Integer pointsRuleId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePointsRuleModel(pointsRuleId, dataState, oldDataState);
        UpmPointsRule upmPointsRule = this.getPointsRule(pointsRuleId);
        this.cacheUpmPointsRule(upmPointsRule);
    }

    private void cacheUpmPointsRule(UpmPointsRule upmPointsRule) {
        if (StringUtils.isEmpty((String)upmPointsRule.getMemberMcode())) {
            upmPointsRule.setMemberMcode("all");
        }
        String key = upmPointsRule.getUpointsType() + "-" + upmPointsRule.getPointsRuleApi() + "-" + upmPointsRule.getMemberMcode() + "-" + upmPointsRule.getLevelUserqua() + "-" + upmPointsRule.getTenantCode();
        if (UserPointsManagerConstants.dataState1.equals(upmPointsRule.getDataState())) {
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)upmPointsRule));
        } else {
            DisUtil.delMap((String)this.cachekey, (String[])new String[]{key});
        }
    }

    @Override
    public void updatePointsRuleStateByCode(String tenantCode, String pointsRuleCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePointsRuleModelByCode(tenantCode, pointsRuleCode, dataState, oldDataState);
        UpmPointsRule upmPointsRule = this.getPointsRuleByCode(tenantCode, pointsRuleCode);
        this.cacheUpmPointsRule(upmPointsRule);
    }

    @Override
    public void updatePointsRule(UpmPointsRuleDomain upmPointsRuleDomain) throws ApiException {
        String msg = this.checkPointsRule(upmPointsRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.updatePointsRule.checkPointsRule", msg);
        }
        UpmPointsRule oldUpmPointsRule = this.getPointsRuleModelById(upmPointsRuleDomain.getPointsRuleId());
        if (null == oldUpmPointsRule) {
            throw new ApiException("upm.UpmPointsRuleServiceImpl.updatePointsRule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpmPointsRule upmPointsRule = this.makePointsRule(upmPointsRuleDomain, oldUpmPointsRule);
        this.setPointsRuleUpdataDefault(upmPointsRule);
        this.updatePointsRuleModel(upmPointsRule);
        this.cacheUpmPointsRule(upmPointsRule);
    }

    @Override
    public UpmPointsRule getPointsRule(Integer pointsRuleId) {
        return this.getPointsRuleModelById(pointsRuleId);
    }

    @Override
    public void deletePointsRule(Integer pointsRuleId) throws ApiException {
        this.deletePointsRuleModel(pointsRuleId);
    }

    @Override
    public QueryResult<UpmPointsRule> queryPointsRulePage(Map<String, Object> map) {
        List<UpmPointsRule> upmPointsRuleList = this.queryPointsRuleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPointsRule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upmPointsRuleList);
        return queryResult;
    }

    @Override
    public UpmPointsRule getPointsRuleByCode(String tenantCode, String pointsRuleCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleCode", pointsRuleCode);
        return this.getPointsRuleModelByCode(map);
    }

    @Override
    public void deletePointsRuleByCode(String tenantCode, String pointsRuleCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleCode", pointsRuleCode);
        this.delPointsRuleModelByCode(map);
    }

    @Override
    public void queryPointsRuleCache() {
        this.logger.info("UpmPointsRuleServiceImpl.queryPointsRuleCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", UserPointsManagerConstants.dataState1);
        List<UpmPointsRule> list = this.queryPointsRuleModelPage(parammap);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("UpmPointsRuleServiceImpl.queryPointsRuleCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (UpmPointsRule upmPointsRule : list) {
            if (StringUtils.isBlank((String)upmPointsRule.getMemberMcode())) {
                upmPointsRule.setMemberMcode("all");
            }
            if (!StringUtils.isNotBlank((String)upmPointsRule.getUpointsType())) continue;
            String key = upmPointsRule.getUpointsType() + "-" + upmPointsRule.getPointsRuleApi() + "-" + upmPointsRule.getMemberMcode() + "-" + upmPointsRule.getLevelUserqua() + "-" + upmPointsRule.getTenantCode();
            map.put(key, JsonUtil.buildNormalBinder().toJson((Object)upmPointsRule));
        }
        this.logger.info("UpmPointsRuleServiceImpl.queryPointsRuleCache", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        DisUtil.setMapVer((String)this.cachekey, map);
        this.logger.info("UpmPointsRuleServiceImpl.queryPointsRuleCache", (Object)"===========add-end==========");
    }
}

