/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.userpointsmanager.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmUpointsClearDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmUpointsGoodsDomain;
import com.yqbsoft.laser.service.userpointsmanager.es.ChannelSendPutThread;
import com.yqbsoft.laser.service.userpointsmanager.model.UmUser;
import com.yqbsoft.laser.service.userpointsmanager.model.UmUserinfo;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmChannelsend;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmPointsRule;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmUpointsClear;
import com.yqbsoft.laser.service.userpointsmanager.service.UpmUpointsClearBaseService;
import com.yqbsoft.laser.service.userpointsmanager.service.UpmUpointsClearService;
import com.yqbsoft.laser.service.userpointsmanager.service.impl.UpmChannelsendServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UpmUpointsClearBaseServiceImpl
extends BaseServiceImpl
implements UpmUpointsClearBaseService {
    private static final String SYS_CODE = "upm.UpmUpointsClearBaseServiceImpl";
    private UpmUpointsClearService upmUpointsClearService;

    public UpmUpointsClearService getUpmUpointsClearService() {
        return this.upmUpointsClearService;
    }

    public void setUpmUpointsClearService(UpmUpointsClearService upmUpointsClearService) {
        this.upmUpointsClearService = upmUpointsClearService;
    }

    @Override
    public String sendUpointsClearOne(UpmUpointsClearDomain upmUpointsClearDomain) throws ApiException {
        if (StringUtils.isNotBlank((String)upmUpointsClearDomain.getIsQueryGoods())) {
            if ("1".equals(upmUpointsClearDomain.getIsQueryGoods())) {
                this.makeContractGoods(upmUpointsClearDomain);
            } else {
                this.makeRefundGoods(upmUpointsClearDomain);
            }
        }
        this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.upmUpointsClearDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)upmUpointsClearDomain));
        List<UpmChannelsend> list = this.upmUpointsClearService.savesendUpointsClearOne(upmUpointsClearDomain);
        if (null == list) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.list");
            return "error";
        }
        if (!ListUtil.isNotEmpty(list)) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.isNotEmpty");
            return "error";
        }
        UpmChannelsendServiceImpl.getSendService().addPutPool(new ChannelSendPutThread(UpmChannelsendServiceImpl.getSendService(), list));
        this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.list", (Object)JsonUtil.buildNormalBinder().toJson(list));
        return "success";
    }

    @Override
    public String sendUpointsClearOneRF(UpmUpointsClearDomain upmUpointsClearDomain) throws ApiException {
        String result = this.internalInvoke("um.user.getUserinfoByCode", this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{upmUpointsClearDomain.getMemberCode(), upmUpointsClearDomain.getTenantCode()}));
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(result, UmUserinfo.class);
        if (null == umUserinfo) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.savesendUpointsClear.getUserinfoByCode", (Object)(upmUpointsClearDomain.getMemberCode() + "," + upmUpointsClearDomain.getTenantCode()));
            return null;
        }
        if (!umUserinfo.getUserinfoQuality().contains("dis")) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.dis", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfo));
            return "success";
        }
        if (StringUtils.isNotBlank((String)upmUpointsClearDomain.getIsQueryGoods())) {
            if ("1".equals(upmUpointsClearDomain.getIsQueryGoods())) {
                this.makeContractGoods(upmUpointsClearDomain);
            } else {
                this.makeRefundGoods(upmUpointsClearDomain);
            }
        }
        this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.upmUpointsClearDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)upmUpointsClearDomain));
        List<UpmChannelsend> list = this.upmUpointsClearService.savesendUpointsClearOneDis(upmUpointsClearDomain);
        if (null == list) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.list");
            return "error";
        }
        if (!ListUtil.isNotEmpty(list)) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.isNotEmpty");
            return "error";
        }
        UpmChannelsendServiceImpl.getSendService().addPutPool(new ChannelSendPutThread(UpmChannelsendServiceImpl.getSendService(), list));
        this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.list", (Object)JsonUtil.buildNormalBinder().toJson(list));
        return "success";
    }

    private void makeContractGoods(UpmUpointsClearDomain upmUpointsClearDomain) {
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        paramMap.put("contractBillcode", upmUpointsClearDomain.getUpointsClearOpcode());
        paramMap.put("tenantCode", upmUpointsClearDomain.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String orderGoodsJson = this.internalInvoke("oc.corderGoods.queryCorderGoodsByBillcode", map);
        if (StringUtils.isNotBlank((String)orderGoodsJson)) {
            List tempList = JsonUtil.buildNormalBinder().getJsonToList(orderGoodsJson, UpmUpointsGoodsDomain.class);
            tempList = tempList.stream().filter(t -> !"4".equals(t.getGoodsType())).collect(Collectors.toList());
            ArrayList<UpmUpointsGoodsDomain> list = new ArrayList<UpmUpointsGoodsDomain>();
            tempList.stream().forEach(l -> {
                if (l.getRefundFlag() == null || "0".equals(l.getRefundFlag())) {
                    list.add((UpmUpointsGoodsDomain)l);
                } else {
                    if (l.getContractGoodsRefnum() == null) {
                        l.setContractGoodsRefnum(BigDecimal.ZERO);
                    }
                    if (l.getGoodsNum().compareTo(l.getContractGoodsRefnum()) > 0) {
                        l.setGoodsNum(l.getGoodsNum().subtract(l.getContractGoodsRefnum()));
                        list.add((UpmUpointsGoodsDomain)l);
                    }
                }
            });
            upmUpointsClearDomain.setUpmUpointsGoodsDomainList(list);
        }
    }

    private void makeRefundGoods(UpmUpointsClearDomain upmUpointsClearDomain) {
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        paramMap.put("contractBillcode", upmUpointsClearDomain.getUpointsClearOpcode());
        paramMap.put("refundCode", upmUpointsClearDomain.getRefundCode());
        paramMap.put("tenantCode", upmUpointsClearDomain.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String goodsJson = this.internalInvoke("oc.refund.queryRefundGoodsPage", map);
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(goodsJson, QueryResult.class);
        if (ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            String jsonList = JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList());
            List tempList = JsonUtil.buildNormalBinder().getJsonToList(jsonList, UpmUpointsGoodsDomain.class);
            Map<String, UpmUpointsGoodsDomain> upmUpointsGoodsDomainMap = tempList.stream().collect(Collectors.toMap(UpmUpointsGoodsDomain::getGoodsCode, s -> s, (k1, k2) -> k1));
            JSONArray jsonArray = JSONArray.json2array((String)jsonList);
            ArrayList<UpmUpointsGoodsDomain> list = new ArrayList<UpmUpointsGoodsDomain>();
            jsonArray.stream().forEach(j -> {
                UpmUpointsGoodsDomain domain = (UpmUpointsGoodsDomain)upmUpointsGoodsDomainMap.get(j.getString("goodsCode"));
                domain.setContractGoodsPrice(j.getBigDecimal("refundGoodsPrice"));
                domain.setGoodsNum(j.getBigDecimal("refundGoodsNum"));
                list.add(domain);
            });
            upmUpointsClearDomain.setUpmUpointsGoodsDomainList(list);
        }
    }

    @Override
    public String sendUserPointsClearForChannel(UpmUpointsClearDomain upmUpointsClearDomain) throws ApiException {
        this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUserPointsClearForChannel.upmUpointsClearDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)upmUpointsClearDomain));
        List<UpmChannelsend> list = this.upmUpointsClearService.saveSendUserPointsClearForChannel(upmUpointsClearDomain);
        if (null == list) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUserPointsClearForChannel.list");
            return "error";
        }
        if (!ListUtil.isNotEmpty(list)) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUserPointsClearForChannel.isNotEmpty");
            return "error";
        }
        UpmChannelsendServiceImpl.getSendService().addPutPool(new ChannelSendPutThread(UpmChannelsendServiceImpl.getSendService(), list));
        this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUserPointsClearForChannel.list", (Object)JsonUtil.buildNormalBinder().toJson(list));
        return "success";
    }

    @Override
    public String sendUpointsClear(UpmUpointsClearDomain upmUpointsClearDomain) throws ApiException {
        List<UpmChannelsend> list = this.upmUpointsClearService.savesendUpointsClearOne(upmUpointsClearDomain);
        if (null == list) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.list");
            return "error";
        }
        if (!ListUtil.isNotEmpty(list)) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUpointsClearOne.isNotEmpty");
            return "error";
        }
        UpmChannelsendServiceImpl.getSendService().addPutPool(new ChannelSendPutThread(UpmChannelsendServiceImpl.getSendService(), list));
        return "success";
    }

    @Override
    public String sendUpointsClearToPoints(UpmUpointsClear upmUpointsClear) throws ApiException {
        List<UpmChannelsend> upmUpointsList = this.upmUpointsClearService.saveSendUpointsClearToPoints(upmUpointsClear);
        if (null == upmUpointsList) {
            return "error";
        }
        if (null != upmUpointsList) {
            ArrayList<UpmChannelsend> channelsendArrayList = new ArrayList<UpmChannelsend>();
            channelsendArrayList.addAll(upmUpointsList);
            UpmChannelsendServiceImpl.getSendService().addPutPool(new ChannelSendPutThread(UpmChannelsendServiceImpl.getSendService(), channelsendArrayList));
        }
        return "success";
    }

    @Override
    public String sendUserUpm(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        if (null == umUserinfo || null == umUser) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUserUpm.all.null");
            return "error";
        }
        String key = "0-" + optype + "-all-" + umUserinfo.getUserinfoQuality() + "-" + umUserinfo.getTenantCode();
        this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUserUpm.key", (Object)key);
        UpmPointsRule upmPointsRule = (UpmPointsRule)SupDisUtil.getMapJson((String)"UpmPointsRule-api", (String)key, UpmPointsRule.class);
        if (null == upmPointsRule) {
            this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUserUpm.upmPointsRuleDomain.null");
            return "error";
        }
        UpmUpointsClearDomain upmUpointsClearDomain = new UpmUpointsClearDomain();
        String direction = "0";
        if (optype.equals("group")) {
            direction = "7";
        }
        upmUpointsClearDomain.setUpointsClearDirection(direction);
        upmUpointsClearDomain.setUpointsClearNum(new BigDecimal(upmPointsRule.getPointsRuleNum()));
        upmUpointsClearDomain.setPointsRuleApi(upmPointsRule.getPointsRuleApi());
        upmUpointsClearDomain.setUpointsType("0");
        upmPointsRule.setLevelUserqua(umUserinfo.getUserinfoQuality());
        upmUpointsClearDomain.setTenantCode(umUserinfo.getTenantCode());
        upmUpointsClearDomain.setMemberCode(umUserinfo.getUserinfoCode());
        this.logger.error("upm.UpmUpointsClearBaseServiceImpl.sendUserUpm.upmPointsRuleDomain.upmUpointsClearDomain", (Object)JsonUtil.buildNonNullBinder().toJson((Object)upmUpointsClearDomain));
        this.sendUpointsClear(upmUpointsClearDomain);
        return "success";
    }
}

