/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.userpointsmanager.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.userpointsmanager.dao.UpmPointsListMapper;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsListDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsListReDomain;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmPointsList;
import com.yqbsoft.laser.service.userpointsmanager.service.UpmPointsListService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpmPointsListServiceImpl
extends BaseServiceImpl
implements UpmPointsListService {
    private static final String SYS_CODE = "upm.UpmPointsListServiceImpl";
    private UpmPointsListMapper upmPointsListMapper;

    public void setUpmPointsListMapper(UpmPointsListMapper upmPointsListMapper) {
        this.upmPointsListMapper = upmPointsListMapper;
    }

    private Date getSysDate() {
        try {
            return this.upmPointsListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPointsList(UpmPointsListDomain upmPointsListDomain) {
        if (null == upmPointsListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upmPointsListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsListDefault(UpmPointsList upmPointsList) {
        if (null == upmPointsList) {
            return;
        }
        if (null == upmPointsList.getDataState()) {
            upmPointsList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == upmPointsList.getGmtCreate()) {
            upmPointsList.setGmtCreate(date);
        }
        upmPointsList.setGmtModified(date);
        if (StringUtils.isBlank((String)upmPointsList.getPointsListCode())) {
            upmPointsList.setPointsListCode(this.createUUIDString());
        }
    }

    private int getPointsListMaxCode() {
        int code = 0;
        try {
            return this.upmPointsListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsListServiceImpl.getPointsListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsListUpdataDefault(UpmPointsList upmPointsList) {
        if (null == upmPointsList) {
            return;
        }
        upmPointsList.setGmtModified(this.getSysDate());
    }

    private void savePointsListModel(UpmPointsList upmPointsList) throws ApiException {
        if (null == upmPointsList) {
            return;
        }
        try {
            this.upmPointsListMapper.insert(upmPointsList);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsListServiceImpl.savePointsListModel.ex", (Throwable)e);
        }
    }

    private void savePointsListBatchModel(List<UpmPointsList> upmPointsListList) throws ApiException {
        if (null == upmPointsListList || upmPointsListList.isEmpty()) {
            return;
        }
        try {
            this.upmPointsListMapper.insertBatch(upmPointsListList);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsListServiceImpl.savePointsListBatchModel.ex", (Throwable)e);
        }
    }

    private UpmPointsList getPointsListModelById(Integer pointsListId) {
        if (null == pointsListId) {
            return null;
        }
        try {
            return this.upmPointsListMapper.selectByPrimaryKey(pointsListId);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsListServiceImpl.getPointsListModelById", (Throwable)e);
            return null;
        }
    }

    private UpmPointsList getPointsListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upmPointsListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsListServiceImpl.getPointsListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsListServiceImpl.delPointsListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsListServiceImpl.delPointsListModelByCode.num");
        }
    }

    private void deletePointsListModel(Integer pointsListId) throws ApiException {
        if (null == pointsListId) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsListMapper.deleteByPrimaryKey(pointsListId);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsListServiceImpl.deletePointsListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsListServiceImpl.deletePointsListModel.num");
        }
    }

    private void updatePointsListModel(UpmPointsList upmPointsList) throws ApiException {
        if (null == upmPointsList) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsListMapper.updateByPrimaryKey(upmPointsList);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsListServiceImpl.updatePointsListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsListServiceImpl.updatePointsListModel.num");
        }
    }

    private void updateStatePointsListModel(Integer pointsListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsListId", pointsListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upmPointsListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsListServiceImpl.updateStatePointsListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("upm.UpmPointsListServiceImpl.updateStatePointsListModel.null");
        }
    }

    private void updateStatePointsListModelByCode(String tenantCode, String pointsListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsListCode", pointsListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upmPointsListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsListServiceImpl.updateStatePointsListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("upm.UpmPointsListServiceImpl.updateStatePointsListModelByCode.null");
        }
    }

    private UpmPointsList makePointsList(UpmPointsListDomain upmPointsListDomain, UpmPointsList upmPointsList) {
        if (null == upmPointsListDomain) {
            return null;
        }
        if (null == upmPointsList) {
            upmPointsList = new UpmPointsList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upmPointsList, (Object)upmPointsListDomain);
            return upmPointsList;
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsListServiceImpl.makePointsList", (Throwable)e);
            return null;
        }
    }

    private UpmPointsListReDomain makeUpmPointsListReDomain(UpmPointsList upmPointsList) {
        if (null == upmPointsList) {
            return null;
        }
        UpmPointsListReDomain upmPointsListReDomain = new UpmPointsListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)upmPointsListReDomain, (Object)upmPointsList);
            return upmPointsListReDomain;
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsListServiceImpl.makeUpmPointsListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UpmPointsList> queryPointsListModelPage(Map<String, Object> parammap) {
        try {
            return this.upmPointsListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsListServiceImpl.queryPointsListModel", (Throwable)e);
            return null;
        }
    }

    private List<UpmPointsList> queryPointsListModelPageUl(Map<String, Object> parammap) {
        try {
            return this.upmPointsListMapper.queryUl(parammap);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsListServiceImpl.queryPointsListModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upmPointsListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsListServiceImpl.countPointsList", (Throwable)e);
        }
        return i;
    }

    private UpmPointsList createUpmPointsList(UpmPointsListDomain upmPointsListDomain) {
        String msg = this.checkPointsList(upmPointsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmPointsListServiceImpl.savePointsList.checkPointsList", msg);
        }
        UpmPointsList upmPointsList = this.makePointsList(upmPointsListDomain, null);
        this.setPointsListDefault(upmPointsList);
        return upmPointsList;
    }

    @Override
    public String savePointsList(UpmPointsListDomain upmPointsListDomain) throws ApiException {
        UpmPointsList upmPointsList = this.createUpmPointsList(upmPointsListDomain);
        this.savePointsListModel(upmPointsList);
        return upmPointsList.getPointsListCode();
    }

    @Override
    public String savePointsListBatch(List<UpmPointsListDomain> upmPointsListDomainList) throws ApiException {
        if (null == upmPointsListDomainList || upmPointsListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UpmPointsList> upmPointsListList = new ArrayList<UpmPointsList>();
        String code = "";
        HashMap<String, UpmPointsListDomain> param = new HashMap<String, UpmPointsListDomain>();
        for (UpmPointsListDomain upmPointsListDomain : upmPointsListDomainList) {
            if (StringUtils.isNotBlank((String)upmPointsListDomain.getPointsListCode())) {
                param.put(upmPointsListDomain.getPointsListCode(), upmPointsListDomain);
                this.updatePointsList(upmPointsListDomain);
                continue;
            }
            UpmPointsList upmPointsList = this.createUpmPointsList(upmPointsListDomain);
            code = upmPointsList.getPointsListCode();
            upmPointsListList.add(upmPointsList);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", upmPointsListDomainList.get(0).getTenantCode());
        map.put("pointsType", upmPointsListDomainList.get(0).getPointsType());
        map.put("pointsCode", upmPointsListDomainList.get(0).getPointsCode());
        List<UpmPointsList> upmPointsLists = this.queryPointsListModelPage(map);
        for (UpmPointsList upmPoints : upmPointsLists) {
            Object o = param.get(upmPoints.getPointsListCode());
            if (null != o) continue;
            this.deletePointsList(upmPoints.getPointsListId());
        }
        this.savePointsListBatchModel(upmPointsListList);
        return code;
    }

    @Override
    public void updatePointsListState(Integer pointsListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsListId) {
            return;
        }
        this.updateStatePointsListModel(pointsListId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsListStateByCode(String tenantCode, String pointsListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsListModelByCode(tenantCode, pointsListCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsList(UpmPointsListDomain upmPointsListDomain) throws ApiException {
        String msg = this.checkPointsList(upmPointsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmPointsListServiceImpl.updatePointsList.checkPointsList", msg);
        }
        UpmPointsList oldUpmPointsList = this.getPointsListByCode(upmPointsListDomain.getTenantCode(), upmPointsListDomain.getPointsListCode());
        if (null == oldUpmPointsList) {
            throw new ApiException("upm.UpmPointsListServiceImpl.updatePointsList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpmPointsList upmPointsList = this.makePointsList(upmPointsListDomain, oldUpmPointsList);
        this.setPointsListUpdataDefault(upmPointsList);
        this.updatePointsListModel(upmPointsList);
    }

    @Override
    public UpmPointsList getPointsList(Integer pointsListId) {
        if (null == pointsListId) {
            return null;
        }
        return this.getPointsListModelById(pointsListId);
    }

    @Override
    public void deletePointsList(Integer pointsListId) throws ApiException {
        if (null == pointsListId) {
            return;
        }
        this.deletePointsListModel(pointsListId);
    }

    @Override
    public QueryResult<UpmPointsList> queryPointsListPage(Map<String, Object> map) {
        List<UpmPointsList> upmPointsListList = this.queryPointsListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPointsList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upmPointsListList);
        return queryResult;
    }

    @Override
    public List<UpmPointsList> queryPointsListPageUl(Map<String, Object> map) {
        return this.queryPointsListModelPageUl(map);
    }

    @Override
    public UpmPointsList getPointsListByCode(String tenantCode, String pointsListCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsListCode", pointsListCode);
        return this.getPointsListModelByCode(map);
    }

    @Override
    public void deletePointsListByCode(String tenantCode, String pointsListCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsListCode", pointsListCode);
        this.delPointsListModelByCode(map);
    }
}

