/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.userrights.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.userrights.UserRightsConstants;
import com.yqbsoft.laser.service.userrights.dao.UrUserrightsGoodsMapper;
import com.yqbsoft.laser.service.userrights.dao.UrUserrightsListMapper;
import com.yqbsoft.laser.service.userrights.dao.UrUserrightsMapper;
import com.yqbsoft.laser.service.userrights.domain.RsSkuDomain;
import com.yqbsoft.laser.service.userrights.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.userrights.domain.UrDiscountPriceResDomain;
import com.yqbsoft.laser.service.userrights.domain.UrOrderDomain;
import com.yqbsoft.laser.service.userrights.domain.UrOrderGoodsDomain;
import com.yqbsoft.laser.service.userrights.domain.UrOrderUserDomain;
import com.yqbsoft.laser.service.userrights.domain.UrReOrderDomain;
import com.yqbsoft.laser.service.userrights.domain.UrUserrightsDomain;
import com.yqbsoft.laser.service.userrights.domain.UrUserrightsGoodsDomain;
import com.yqbsoft.laser.service.userrights.domain.UrUserrightsGoodsReDomain;
import com.yqbsoft.laser.service.userrights.domain.UrUserrightsListDomain;
import com.yqbsoft.laser.service.userrights.domain.UrUserrightsListReDomain;
import com.yqbsoft.laser.service.userrights.domain.UrUserrightsOplistDomain;
import com.yqbsoft.laser.service.userrights.domain.UrUserrightsReDomain;
import com.yqbsoft.laser.service.userrights.domain.UrUserruleDomain;
import com.yqbsoft.laser.service.userrights.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.userrights.model.UlLevelList;
import com.yqbsoft.laser.service.userrights.model.UmUserinfo;
import com.yqbsoft.laser.service.userrights.model.UmUserinfoQua;
import com.yqbsoft.laser.service.userrights.model.UrUserrights;
import com.yqbsoft.laser.service.userrights.model.UrUserrightsGoods;
import com.yqbsoft.laser.service.userrights.model.UrUserrightsList;
import com.yqbsoft.laser.service.userrights.model.UrUserrule;
import com.yqbsoft.laser.service.userrights.service.UrUserrightsService;
import com.yqbsoft.laser.service.userrights.service.UrUserruleService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UrUserrightsServiceImpl
extends BaseServiceImpl
implements UrUserrightsService {
    private static final String SYS_CODE = "ur.UrUserrightsServiceImpl";
    private static final String GET_USERINFO_BY_USERCODE = "um.user.getUserinfoByCode";
    private static final String GET_LEVEL_CODE_BY_CHANNEL = "ul.ulLevelUllist.getUlLevelUpointsByMember";
    private static final String GET_LEVEL_CODE_BY_LEVEL = "ul.ulLevel.queryLevelListByLevelListNum";
    private static final String QUERY_OUTER_JIFEN = "vd.faccount.queryOuterFaccount";
    private UrUserrightsMapper urUserrightsMapper;
    private UrUserrightsListMapper urUserrightsListMapper;
    private UrUserrightsGoodsMapper urUserrightsGoodsMapper;
    private UrUserruleService urUserruleService;

    public UrUserruleService getUrUserruleService() {
        return this.urUserruleService;
    }

    public void setUrUserruleService(UrUserruleService urUserruleService) {
        this.urUserruleService = urUserruleService;
    }

    public void setUrUserrightsMapper(UrUserrightsMapper urUserrightsMapper) {
        this.urUserrightsMapper = urUserrightsMapper;
    }

    public void setUrUserrightsListMapper(UrUserrightsListMapper urUserrightsListMapper) {
        this.urUserrightsListMapper = urUserrightsListMapper;
    }

    public void setUrUserrightsGoodsMapper(UrUserrightsGoodsMapper urUserrightsGoodsMapper) {
        this.urUserrightsGoodsMapper = urUserrightsGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.urUserrightsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserrights(UrUserrightsDomain urUserrightsDomain) {
        if (null == urUserrightsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)urUserrightsDomain.getUserruleCode())) {
            msg = msg + "UserruleCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)urUserrightsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserrightsDefault(UrUserrights urUserrights) {
        if (null == urUserrights) {
            return;
        }
        if (null != urUserrights.getUserruleStart() && urUserrights.getUserruleStart().getTime() > this.getSysDate().getTime()) {
            urUserrights.setDataState(1);
        }
        if (null == urUserrights.getDataState()) {
            urUserrights.setDataState(0);
        }
        if (null == urUserrights.getGmtCreate()) {
            urUserrights.setGmtCreate(this.getSysDate());
        }
        urUserrights.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)urUserrights.getUserrightsCode())) {
            urUserrights.setUserrightsCode(this.createUUIDString());
        }
    }

    private int getUserrightsMaxCode() {
        int code = 0;
        try {
            return this.urUserrightsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getUserrightsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserrightsUpdataDefault(UrUserrights urUserrights) {
        if (null == urUserrights) {
            return;
        }
        urUserrights.setGmtModified(this.getSysDate());
    }

    private void saveUserrightsModel(UrUserrights urUserrights) throws ApiException {
        if (null == urUserrights) {
            return;
        }
        try {
            this.urUserrightsMapper.insert(urUserrights);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.saveUserrightsModel.ex", (Throwable)e);
        }
    }

    private void saveUserrightsBatchModel(List<UrUserrights> urUserrightsList) throws ApiException {
        if (null == urUserrightsList || urUserrightsList.isEmpty()) {
            return;
        }
        try {
            this.urUserrightsMapper.insertBatch(urUserrightsList);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.saveUserrightsBatchModel.ex", (Throwable)e);
        }
    }

    private UrUserrights getUserrightsModelById(Integer userrightsId) {
        if (null == userrightsId) {
            return null;
        }
        try {
            return this.urUserrightsMapper.selectByPrimaryKey(userrightsId);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getUserrightsModelById", (Throwable)e);
            return null;
        }
    }

    private UrUserrights getUserrightsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.urUserrightsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getUserrightsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserrightsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserrightsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.delUserrightsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserrightsServiceImpl.delUserrightsModelByCode.num");
        }
    }

    private void deleteUserrightsModel(Integer userrightsId) throws ApiException {
        if (null == userrightsId) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserrightsMapper.deleteByPrimaryKey(userrightsId);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.deleteUserrightsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserrightsServiceImpl.deleteUserrightsModel.num");
        }
    }

    private void updateUserrightsModel(UrUserrights urUserrights) throws ApiException {
        if (null == urUserrights) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserrightsMapper.updateByPrimaryKeySelective(urUserrights);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrightsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrightsModel.num");
        }
    }

    private void updateStateUserrightsModel(Integer userrightsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userrightsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userrightsId", userrightsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.urUserrightsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsModel.null");
        }
    }

    private void updateStateUserrightsModelByCode(String tenantCode, String userrightsCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)userrightsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userrightsCode", userrightsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.urUserrightsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsModelByCode.null");
        }
    }

    private UrUserrights makeUserrights(UrUserrightsDomain urUserrightsDomain, UrUserrights urUserrights) {
        if (null == urUserrightsDomain) {
            return null;
        }
        if (null == urUserrights) {
            urUserrights = new UrUserrights();
        }
        try {
            BeanUtils.copyAllPropertys((Object)urUserrights, (Object)urUserrightsDomain);
            return urUserrights;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUserrights", (Throwable)e);
            return null;
        }
    }

    private UrUserrightsDomain makeUserrightsDomain(UrUserrightsDomain urUserrightsDomain, UrUserrights urUserrights) {
        if (null == urUserrights) {
            return null;
        }
        if (null == urUserrightsDomain) {
            urUserrightsDomain = new UrUserrightsDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)urUserrightsDomain, (Object)urUserrights);
            return urUserrightsDomain;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUserrights", (Throwable)e);
            return null;
        }
    }

    private UrUserrightsReDomain makeUrUserrightsReDomain(UrUserrights urUserrights) {
        if (null == urUserrights) {
            return null;
        }
        UrUserrightsReDomain urUserrightsReDomain = new UrUserrightsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)urUserrightsReDomain, (Object)urUserrights);
            return urUserrightsReDomain;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUrUserrightsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UrUserrights> queryUserrightsModelPage(Map<String, Object> parammap) {
        try {
            return this.urUserrightsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.queryUserrightsModel", (Throwable)e);
            return null;
        }
    }

    private int countUserrights(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.urUserrightsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.countUserrights", (Throwable)e);
        }
        return i;
    }

    private UrUserrights createUrUserrights(UrUserrightsDomain urUserrightsDomain) {
        String msg = this.checkUserrights(urUserrightsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ur.UrUserrightsServiceImpl.saveUserrights.checkUserrights", msg);
        }
        UrUserrights urUserrights = this.makeUserrights(urUserrightsDomain, null);
        this.setUserrightsDefault(urUserrights);
        return urUserrights;
    }

    private String checkUserrightsList(UrUserrightsListDomain urUserrightsListDomain) {
        if (null == urUserrightsListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)urUserrightsListDomain.getUserrightsCode())) {
            msg = msg + "UserrightsCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)urUserrightsListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserrightsListDefault(UrUserrightsList urUserrightsList) {
        if (null == urUserrightsList) {
            return;
        }
        if (null == urUserrightsList.getDataState()) {
            urUserrightsList.setDataState(0);
        }
        if (null == urUserrightsList.getGmtCreate()) {
            urUserrightsList.setGmtCreate(this.getSysDate());
        }
        urUserrightsList.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)urUserrightsList.getUserrightsListCode())) {
            urUserrightsList.setUserrightsListCode(this.createUUIDString());
        }
    }

    private int getUserrightsListMaxCode() {
        int code = 0;
        try {
            return this.urUserrightsListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getUserrightsListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserrightsListUpdataDefault(UrUserrightsList urUserrightsList) {
        if (null == urUserrightsList) {
            return;
        }
        urUserrightsList.setGmtModified(this.getSysDate());
    }

    private void saveUserrightsListModel(UrUserrightsList urUserrightsList) throws ApiException {
        if (null == urUserrightsList) {
            return;
        }
        try {
            this.urUserrightsListMapper.insert(urUserrightsList);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.saveUserrightsListModel.ex", (Throwable)e);
        }
    }

    private void saveUserrightsListBatchModel(List<UrUserrightsList> urUserrightsListList) throws ApiException {
        if (null == urUserrightsListList || urUserrightsListList.isEmpty()) {
            return;
        }
        try {
            this.urUserrightsListMapper.insertBatch(urUserrightsListList);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.saveUserrightsListBatchModel.ex", (Throwable)e);
        }
    }

    private UrUserrightsList getUserrightsListModelById(Integer userrightsListId) {
        if (null == userrightsListId) {
            return null;
        }
        try {
            return this.urUserrightsListMapper.selectByPrimaryKey(userrightsListId);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getUserrightsListModelById", (Throwable)e);
            return null;
        }
    }

    private UrUserrightsList getUserrightsListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.urUserrightsListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getUserrightsListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserrightsListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserrightsListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.delUserrightsListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserrightsServiceImpl.delUserrightsListModelByCode.num");
        }
    }

    private void deleteUserrightsListModel(Integer userrightsListId) throws ApiException {
        if (null == userrightsListId) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserrightsListMapper.deleteByPrimaryKey(userrightsListId);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.deleteUserrightsListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserrightsServiceImpl.deleteUserrightsListModel.num");
        }
    }

    private void updateUserrightsListModel(UrUserrightsList urUserrightsList) throws ApiException {
        if (null == urUserrightsList) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserrightsListMapper.updateByPrimaryKeySelective(urUserrightsList);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrightsListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrightsListModel.num");
        }
    }

    private void updateStateUserrightsListModel(Integer userrightsListId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userrightsListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userrightsListId", userrightsListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.urUserrightsListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsListModel.null");
        }
    }

    private void updateStateUserrightsListModelByCode(String tenantCode, String userrightsListCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)userrightsListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userrightsListCode", userrightsListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.urUserrightsListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsListModelByCode.null");
        }
    }

    private UrUserrightsList makeUserrightsList(UrUserrightsListDomain urUserrightsListDomain, UrUserrightsList urUserrightsList) {
        if (null == urUserrightsListDomain) {
            return null;
        }
        if (null == urUserrightsList) {
            urUserrightsList = new UrUserrightsList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)urUserrightsList, (Object)urUserrightsListDomain);
            return urUserrightsList;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUserrightsList", (Throwable)e);
            return null;
        }
    }

    private UrUserrightsListReDomain makeUrUserrightsListReDomain(UrUserrightsList urUserrightsList) {
        if (null == urUserrightsList) {
            return null;
        }
        UrUserrightsListReDomain urUserrightsListReDomain = new UrUserrightsListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)urUserrightsListReDomain, (Object)urUserrightsList);
            return urUserrightsListReDomain;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUrUserrightsListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UrUserrightsList> queryUserrightsListModelPage(Map<String, Object> parammap) {
        try {
            return this.urUserrightsListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.queryUserrightsListModel", (Throwable)e);
            return null;
        }
    }

    private int countUserrightsList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.urUserrightsListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.countUserrightsList", (Throwable)e);
        }
        return i;
    }

    private UrUserrightsList createUrUserrightsList(UrUserrightsListDomain urUserrightsListDomain) {
        String msg = this.checkUserrightsList(urUserrightsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ur.UrUserrightsServiceImpl.saveUserrightsList.checkUserrightsList", msg);
        }
        UrUserrightsList urUserrightsList = this.makeUserrightsList(urUserrightsListDomain, null);
        this.setUserrightsListDefault(urUserrightsList);
        return urUserrightsList;
    }

    private String checkUserrightsGoods(UrUserrightsGoodsDomain urUserrightsGoodsDomain) {
        if (null == urUserrightsGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)urUserrightsGoodsDomain.getUserrightsCode())) {
            msg = msg + "UserrightsCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)urUserrightsGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserrightsGoodsDefault(UrUserrightsGoods urUserrightsGoods) {
        if (null == urUserrightsGoods) {
            return;
        }
        if (null == urUserrightsGoods.getDataState()) {
            urUserrightsGoods.setDataState(0);
        }
        if (null == urUserrightsGoods.getGmtCreate()) {
            urUserrightsGoods.setGmtCreate(this.getSysDate());
        }
        urUserrightsGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)urUserrightsGoods.getUserrightsGoodsCode())) {
            urUserrightsGoods.setUserrightsGoodsCode(this.createUUIDString());
        }
    }

    private int getUserrightsGoodsMaxCode() {
        int code = 0;
        try {
            return this.urUserrightsGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getUserrightsGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserrightsGoodsUpdataDefault(UrUserrightsGoods urUserrightsGoods) {
        if (null == urUserrightsGoods) {
            return;
        }
        urUserrightsGoods.setGmtModified(this.getSysDate());
    }

    private void saveUserrightsGoodsModel(UrUserrightsGoods urUserrightsGoods) throws ApiException {
        if (null == urUserrightsGoods) {
            return;
        }
        try {
            this.urUserrightsGoodsMapper.insert(urUserrightsGoods);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.saveUserrightsGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveUserrightsGoodsBatchModel(List<UrUserrightsGoods> urUserrightsGoodsList) throws ApiException {
        if (null == urUserrightsGoodsList || urUserrightsGoodsList.isEmpty()) {
            return;
        }
        try {
            this.urUserrightsGoodsMapper.insertBatch(urUserrightsGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.saveUserrightsGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private UrUserrightsGoods getUserrightsGoodsModelById(Integer userrightsGoodsId) {
        if (null == userrightsGoodsId) {
            return null;
        }
        try {
            return this.urUserrightsGoodsMapper.selectByPrimaryKey(userrightsGoodsId);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getUserrightsGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private List<UrUserrightsGoods> getGoodsByUrCode(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        try {
            return this.urUserrightsGoodsMapper.getGoodsByURCode(map);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getGoodsByUrCode", (Throwable)e);
            return null;
        }
    }

    private UrUserrightsGoods getUserrightsGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.urUserrightsGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.getUserrightsGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserrightsGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserrightsGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.delUserrightsGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserrightsServiceImpl.delUserrightsGoodsModelByCode.num");
        }
    }

    private void deleteUserrightsGoodsModel(Integer userrightsGoodsId) throws ApiException {
        if (null == userrightsGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserrightsGoodsMapper.deleteByPrimaryKey(userrightsGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.deleteUserrightsGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserrightsServiceImpl.deleteUserrightsGoodsModel.num");
        }
    }

    private void updateUserrightsGoodsModel(UrUserrightsGoods urUserrightsGoods) throws ApiException {
        if (null == urUserrightsGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserrightsGoodsMapper.updateByPrimaryKeySelective(urUserrightsGoods);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrightsGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrightsGoodsModel.num");
        }
    }

    private void updateStateUserrightsGoodsModel(Integer userrightsGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userrightsGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userrightsGoodsId", userrightsGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.urUserrightsGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsGoodsModel.null");
        }
    }

    private void updateStateUserrightsGoodsModelByCode(String tenantCode, String userrightsGoodsCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)userrightsGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userrightsGoodsCode", userrightsGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.urUserrightsGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateStateUserrightsGoodsModelByCode.null");
        }
    }

    private UrUserrightsGoods makeUserrightsGoods(UrUserrightsGoodsDomain urUserrightsGoodsDomain, UrUserrightsGoods urUserrightsGoods) {
        if (null == urUserrightsGoodsDomain) {
            return null;
        }
        if (null == urUserrightsGoods) {
            urUserrightsGoods = new UrUserrightsGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)urUserrightsGoods, (Object)urUserrightsGoodsDomain);
            return urUserrightsGoods;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUserrightsGoods", (Throwable)e);
            return null;
        }
    }

    private UrUserrightsGoodsReDomain makeUrUserrightsGoodsReDomain(UrUserrightsGoods urUserrightsGoods) {
        if (null == urUserrightsGoods) {
            return null;
        }
        UrUserrightsGoodsReDomain urUserrightsGoodsReDomain = new UrUserrightsGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)urUserrightsGoodsReDomain, (Object)urUserrightsGoods);
            return urUserrightsGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUrUserrightsGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UrUserrightsGoods> queryUserrightsGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.urUserrightsGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.queryUserrightsGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countUserrightsGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.urUserrightsGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.countUserrightsGoods", (Throwable)e);
        }
        return i;
    }

    private UrUserrightsGoods createUrUserrightsGoods(UrUserrightsGoodsDomain urUserrightsGoodsDomain) {
        String msg = this.checkUserrightsGoods(urUserrightsGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ur.UrUserrightsServiceImpl.saveUserrightsGoods.checkUserrightsGoods", msg);
        }
        UrUserrightsGoods urUserrightsGoods = this.makeUserrightsGoods(urUserrightsGoodsDomain, null);
        this.setUserrightsGoodsDefault(urUserrightsGoods);
        return urUserrightsGoods;
    }

    @Override
    public String saveUserrights(UrUserrightsDomain urUserrightsDomain) throws ApiException {
        UrUserrights urUserrights = this.createUrUserrights(urUserrightsDomain);
        this.saveUserrightsModel(urUserrights);
        return urUserrights.getUserrightsCode();
    }

    @Override
    public String saveUserrightsBatch(List<UrUserrightsDomain> urUserrightsDomainList) throws ApiException {
        if (null == urUserrightsDomainList || urUserrightsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UrUserrights> urUserrightsList = new ArrayList<UrUserrights>();
        String code = "";
        for (UrUserrightsDomain urUserrightsDomain : urUserrightsDomainList) {
            UrUserrights urUserrights = this.createUrUserrights(urUserrightsDomain);
            code = urUserrights.getUserrightsCode();
            urUserrightsList.add(urUserrights);
        }
        this.saveUserrightsBatchModel(urUserrightsList);
        return code;
    }

    @Override
    public void updateUserrightsState(Integer userrightsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserrightsModel(userrightsId, dataState, oldDataState);
    }

    @Override
    public void updateUserrightsStateByCode(String tenantCode, String userrightsCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserrightsModelByCode(tenantCode, userrightsCode, dataState, oldDataState);
    }

    @Override
    public void updateUserrights(UrUserrightsDomain urUserrightsDomain) throws ApiException {
        String msg = this.checkUserrights(urUserrightsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrights.checkUserrights", msg);
        }
        UrUserrights oldUrUserrights = this.getUserrightsModelById(urUserrightsDomain.getUserrightsId());
        if (null == oldUrUserrights) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrights.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UrUserrights urUserrights = this.makeUserrights(urUserrightsDomain, oldUrUserrights);
        this.setUserrightsUpdataDefault(urUserrights);
        this.updateUserrightsModel(urUserrights);
    }

    @Override
    public UrUserrights getUserrights(Integer userrightsId) {
        return this.getUserrightsModelById(userrightsId);
    }

    @Override
    public void deleteUserrights(Integer userrightsId) throws ApiException {
        this.deleteUserrightsModel(userrightsId);
    }

    @Override
    public QueryResult<UrUserrights> queryUserrightsPage(Map<String, Object> map) {
        List<UrUserrights> urUserrightsList = this.queryUserrightsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserrights(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(urUserrightsList);
        return queryResult;
    }

    @Override
    public UrUserrights getUserrightsByCode(String tenantCode, String userrightsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userrightsCode", userrightsCode);
        return this.getUserrightsModelByCode(map);
    }

    @Override
    public void deleteUserrightsByCode(String tenantCode, String userrightsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userrightsCode", userrightsCode);
        this.delUserrightsModelByCode(map);
    }

    @Override
    public String saveUserrightsList(UrUserrightsListDomain urUserrightsListDomain) throws ApiException {
        UrUserrightsList urUserrightsList = this.createUrUserrightsList(urUserrightsListDomain);
        this.saveUserrightsListModel(urUserrightsList);
        return urUserrightsList.getUserrightsListCode();
    }

    @Override
    public String saveUserrightsListBatch(List<UrUserrightsListDomain> urUserrightsListDomainList) throws ApiException {
        if (null == urUserrightsListDomainList || urUserrightsListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UrUserrightsList> urUserrightsListList = new ArrayList<UrUserrightsList>();
        String code = "";
        for (UrUserrightsListDomain urUserrightsListDomain : urUserrightsListDomainList) {
            UrUserrightsList urUserrightsList = this.createUrUserrightsList(urUserrightsListDomain);
            code = urUserrightsList.getUserrightsListCode();
            urUserrightsListList.add(urUserrightsList);
        }
        this.saveUserrightsListBatchModel(urUserrightsListList);
        return code;
    }

    @Override
    public void updateUserrightsListState(Integer userrightsListId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserrightsListModel(userrightsListId, dataState, oldDataState);
    }

    @Override
    public void updateUserrightsListStateByCode(String tenantCode, String userrightsListCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserrightsListModelByCode(tenantCode, userrightsListCode, dataState, oldDataState);
    }

    @Override
    public void updateUserrightsList(UrUserrightsListDomain urUserrightsListDomain) throws ApiException {
        String msg = this.checkUserrightsList(urUserrightsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrightsList.checkUserrightsList", msg);
        }
        UrUserrightsList oldUrUserrightsList = this.getUserrightsListModelById(urUserrightsListDomain.getUserrightsListId());
        if (null == oldUrUserrightsList) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrightsList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UrUserrightsList urUserrightsList = this.makeUserrightsList(urUserrightsListDomain, oldUrUserrightsList);
        this.setUserrightsListUpdataDefault(urUserrightsList);
        this.updateUserrightsListModel(urUserrightsList);
    }

    @Override
    public UrUserrightsList getUserrightsList(Integer userrightsListId) {
        return this.getUserrightsListModelById(userrightsListId);
    }

    @Override
    public void deleteUserrightsList(Integer userrightsListId) throws ApiException {
        this.deleteUserrightsListModel(userrightsListId);
    }

    @Override
    public QueryResult<UrUserrightsList> queryUserrightsListPage(Map<String, Object> map) {
        List<UrUserrightsList> urUserrightsListList = this.queryUserrightsListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserrightsList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(urUserrightsListList);
        return queryResult;
    }

    @Override
    public UrUserrightsList getUserrightsListByCode(String tenantCode, String userrightsListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userrightsListCode", userrightsListCode);
        return this.getUserrightsListModelByCode(map);
    }

    @Override
    public void deleteUserrightsListByCode(String tenantCode, String userrightsListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userrightsListCode", userrightsListCode);
        this.delUserrightsListModelByCode(map);
    }

    @Override
    public String saveUserrightsGoods(UrUserrightsGoodsDomain urUserrightsGoodsDomain) throws ApiException {
        UrUserrightsGoods urUserrightsGoods = this.createUrUserrightsGoods(urUserrightsGoodsDomain);
        this.saveUserrightsGoodsModel(urUserrightsGoods);
        return urUserrightsGoods.getUserrightsGoodsCode();
    }

    @Override
    public String saveUserrightsGoodsBatch(List<UrUserrightsGoodsDomain> urUserrightsGoodsDomainList) throws ApiException {
        if (null == urUserrightsGoodsDomainList || urUserrightsGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UrUserrightsGoods> urUserrightsGoodsList = new ArrayList<UrUserrightsGoods>();
        String code = "";
        for (UrUserrightsGoodsDomain urUserrightsGoodsDomain : urUserrightsGoodsDomainList) {
            UrUserrightsGoods urUserrightsGoods = this.createUrUserrightsGoods(urUserrightsGoodsDomain);
            code = urUserrightsGoods.getUserrightsGoodsCode();
            urUserrightsGoodsList.add(urUserrightsGoods);
        }
        this.saveUserrightsGoodsBatchModel(urUserrightsGoodsList);
        return code;
    }

    @Override
    public void updateUserrightsGoodsState(Integer userrightsGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserrightsGoodsModel(userrightsGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateUserrightsGoodsStateByCode(String tenantCode, String userrightsGoodsCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserrightsGoodsModelByCode(tenantCode, userrightsGoodsCode, dataState, oldDataState);
    }

    @Override
    public void updateUserrightsGoods(UrUserrightsGoodsDomain urUserrightsGoodsDomain) throws ApiException {
        String msg = this.checkUserrightsGoods(urUserrightsGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrightsGoods.checkUserrightsGoods", msg);
        }
        UrUserrightsGoods oldUrUserrightsGoods = this.getUserrightsGoodsModelById(urUserrightsGoodsDomain.getUserrightsGoodsId());
        if (null == oldUrUserrightsGoods) {
            throw new ApiException("ur.UrUserrightsServiceImpl.updateUserrightsGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UrUserrightsGoods urUserrightsGoods = this.makeUserrightsGoods(urUserrightsGoodsDomain, oldUrUserrightsGoods);
        this.setUserrightsGoodsUpdataDefault(urUserrightsGoods);
        this.updateUserrightsGoodsModel(urUserrightsGoods);
    }

    @Override
    public UrUserrightsGoods getUserrightsGoods(Integer userrightsGoodsId) {
        return this.getUserrightsGoodsModelById(userrightsGoodsId);
    }

    @Override
    public void deleteUserrightsGoods(Integer userrightsGoodsId) throws ApiException {
        this.deleteUserrightsGoodsModel(userrightsGoodsId);
    }

    @Override
    public QueryResult<UrUserrightsGoods> queryUserrightsGoodsPage(Map<String, Object> map) {
        List<UrUserrightsGoods> urUserrightsGoodsList = this.queryUserrightsGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserrightsGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(urUserrightsGoodsList);
        return queryResult;
    }

    @Override
    public UrUserrightsGoods getUserrightsGoodsByCode(String tenantCode, String userrightsGoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userrightsGoodsCode", userrightsGoodsCode);
        return this.getUserrightsGoodsModelByCode(map);
    }

    @Override
    public void deleteUserrightsGoodsByCode(String tenantCode, String userrightsGoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userrightsGoodsCode", userrightsGoodsCode);
        this.delUserrightsGoodsModelByCode(map);
    }

    @Override
    public UrUserrightsOplistDomain queryUserinfo(UmUserinfoDomain umUserinfoDomain) {
        if (null == umUserinfoDomain) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        parammap.put("tenantCode", umUserinfoDomain.getTenantCode());
        List<UrUserrights> list = this.queryUserrightsModelPage(parammap);
        if (null == list || list.isEmpty()) {
            return null;
        }
        HashMap<String, Object> listparammap = new HashMap<String, Object>();
        listparammap.put("tenantCode", umUserinfoDomain.getTenantCode());
        QueryResult<UrUserrule> qrulelist = this.urUserruleService.queryUserrulePage(parammap);
        if (null == qrulelist || null == qrulelist.getRows() || qrulelist.getRows().isEmpty()) {
            return null;
        }
        Map<String, UrUserrule> map = this.getMap(qrulelist.getRows());
        UrUserrightsOplistDomain urUserrightsOplistDomain = null;
        for (UrUserrights urUserrights : list) {
            listparammap.put("userrightsCode", urUserrights.getUserrightsCode());
            List<UrUserrightsList> listList = this.queryUserrightsListModelPage(listparammap);
            urUserrightsOplistDomain = this.check(urUserrights, map.get(urUserrights.getUserruleCode()), listList, umUserinfoDomain);
            this.logger.error("urUserrightsOplistDomain---2", (Object)JsonUtil.buildNonNullBinder().toJson((Object)urUserrightsOplistDomain));
            if (null == urUserrightsOplistDomain) continue;
            return urUserrightsOplistDomain;
        }
        return null;
    }

    private UrUserrightsOplistDomain check(UrUserrights urUserrights, UrUserrule urUserrule, List<UrUserrightsList> listList, UmUserinfoDomain umUserinfoDomain) {
        if (null == urUserrights || null == urUserrule || null == umUserinfoDomain || ListUtil.isEmpty(umUserinfoDomain.getUmUserinfoQuaList())) {
            this.logger.error(SYS_CODE, (Object)"check");
            return null;
        }
        boolean flag = false;
        if (ListUtil.isEmpty(listList)) {
            flag = true;
        } else {
            String level = "";
            block0: for (UrUserrightsList urUserrightsList : listList) {
                level = urUserrightsList.getUserrightsListType();
                if (StringUtils.isNotBlank((String)level) && level.indexOf("_") > 0) {
                    for (UmUserinfoQua umUserinfoQua : umUserinfoDomain.getUmUserinfoQuaList()) {
                        if (!urUserrightsList.getUserrightsListType().equals(umUserinfoQua.getUserinfoQuaKey()) || !urUserrightsList.getUserrightsListOpcode().equals(umUserinfoQua.getUserinfoQuaVaule())) continue;
                        flag = true;
                        continue block0;
                    }
                    continue;
                }
                if (!urUserrightsList.getUserrightsListOpcode().equals(String.valueOf(umUserinfoDomain.getUserinfoLevel()))) continue;
                flag = true;
                break;
            }
        }
        if (!flag) {
            return null;
        }
        UrUserrightsOplistDomain urUserrightsOplistDomain = new UrUserrightsOplistDomain();
        urUserrightsOplistDomain.setMemberBcode(umUserinfoDomain.getUserinfoCode());
        urUserrightsOplistDomain.setMemberBname(umUserinfoDomain.getUserinfoCompname());
        urUserrightsOplistDomain.setMemberCcode(umUserinfoDomain.getUserinfoCode());
        urUserrightsOplistDomain.setMemberCname(umUserinfoDomain.getUserinfoCompname());
        urUserrightsOplistDomain.setMemberCode(umUserinfoDomain.getUserinfoCode());
        urUserrightsOplistDomain.setMemberName(umUserinfoDomain.getUserinfoCompname());
        urUserrightsOplistDomain.setTenantCode(umUserinfoDomain.getTenantCode());
        urUserrightsOplistDomain.setUserrightsCode(urUserrights.getUserrightsCode());
        urUserrightsOplistDomain.setUserrightsOplistAmt(new BigDecimal("1"));
        urUserrightsOplistDomain.setUserrightsName(urUserrights.getUserrightsName());
        urUserrightsOplistDomain.setUserrightsOplistOp(String.valueOf(umUserinfoDomain.getUserinfoLevel()));
        urUserrightsOplistDomain.setUserrightsOplistRemark("");
        urUserrightsOplistDomain.setUserrightsOplistState(0);
        urUserrightsOplistDomain.setUserrightsOplistValue(String.valueOf(umUserinfoDomain.getUserinfoLevel()));
        return urUserrightsOplistDomain;
    }

    @Override
    public UrReOrderDomain queryOrder(UrOrderDomain urOrderDomain) {
        if (null == urOrderDomain) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        parammap.put("tenantCode", urOrderDomain.getTenantCode());
        List<UrUserrights> list = this.queryUserrightsModelPage(parammap);
        if (null == list || list.isEmpty()) {
            return null;
        }
        HashMap<String, Object> listparammap = new HashMap<String, Object>();
        listparammap.put("tenantCode", urOrderDomain.getTenantCode());
        QueryResult<UrUserrule> qrulelist = this.urUserruleService.queryUserrulePage(parammap);
        if (null == qrulelist || null == qrulelist.getRows() || qrulelist.getRows().isEmpty()) {
            return null;
        }
        Map<String, UrUserrule> map = this.getMap(qrulelist.getRows());
        for (UrUserrights urUserrights : list) {
            listparammap.put("userrightsCode", urUserrights.getUserrightsCode());
            List<UrUserrightsList> listList = this.queryUserrightsListModelPage(listparammap);
            List<UrUserrightsGoods> goodsList = this.queryUserrightsGoodsModelPage(listparammap);
            UrReOrderDomain urReOrderDomain = this.check(urUserrights, map.get(urUserrights.getUserruleCode()), urOrderDomain, goodsList, listList);
            if (null == urReOrderDomain) continue;
            return urReOrderDomain;
        }
        return null;
    }

    private Map<String, UrUserrule> getMap(List<UrUserrule> list) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        HashMap<String, UrUserrule> map = new HashMap<String, UrUserrule>();
        for (UrUserrule urUserrule : list) {
            map.put(urUserrule.getUserruleCode(), urUserrule);
        }
        return map;
    }

    private UrReOrderDomain check(UrUserrights urUserrights, UrUserrule urUserrule, UrOrderDomain urOrderDomain, List<UrUserrightsGoods> goodsList, List<UrUserrightsList> listList) {
        if (null == urUserrights || null == urUserrule || null == urOrderDomain) {
            return null;
        }
        UrReOrderDomain urReOrderDomain = new UrReOrderDomain();
        urReOrderDomain.setType(urUserrule.getUserruleType());
        urReOrderDomain.setTenantCode(urOrderDomain.getTenantCode());
        urReOrderDomain.setName(urUserrights.getUserrightsName());
        BigDecimal money = BigDecimal.ZERO;
        if (null == listList && null == goodsList) {
            money = this.compute(urUserrule, urOrderDomain.getContractMoney(), urOrderDomain.getLogisticsMoney());
            urReOrderDomain.setMoney(money);
            return urReOrderDomain;
        }
        if (null == urReOrderDomain && null != listList && !listList.isEmpty()) {
            for (UrUserrightsList urUserrightsList : listList) {
                String value = (String)BeanUtils.getObjValue((Object)urOrderDomain, (String)urUserrightsList.getUserrightsListType(), (Object)"");
                if (value.equals(urUserrightsList.getUserrightsListOpcode())) continue;
                return null;
            }
            money = this.compute(urUserrule, urOrderDomain.getContractMoney(), urOrderDomain.getLogisticsMoney());
            urReOrderDomain.setMoney(money);
            return urReOrderDomain;
        }
        if (null == urOrderDomain.getUrOrderGoodsDomainList() || urOrderDomain.getUrOrderGoodsDomainList().isEmpty()) {
            return null;
        }
        for (UrOrderGoodsDomain urOrderGoodsDomain : urOrderDomain.getUrOrderGoodsDomainList()) {
            money.add(this.computeList(money, urUserrule, urOrderDomain, urOrderGoodsDomain, goodsList));
        }
        urReOrderDomain.setMoney(money);
        return urReOrderDomain;
    }

    private BigDecimal computeList(BigDecimal money, UrUserrule urUserrule, UrOrderDomain urOrderDomain, UrOrderGoodsDomain urOrderGoodsDomain, List<UrUserrightsGoods> goodsList) {
        for (UrUserrightsGoods urUserrightsGoods : goodsList) {
            String value = (String)BeanUtils.getObjValue((Object)urOrderGoodsDomain, (String)urUserrightsGoods.getUserrightsGoodsType(), (Object)"");
            if (!value.equals(urUserrightsGoods.getUserrightsGoodsOpcode())) continue;
            money.add(this.compute(urUserrule, urOrderGoodsDomain.getContractMoney(), urOrderDomain.getLogisticsMoney()));
            return money;
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal compute(UrUserrule urUserrule, BigDecimal money, BigDecimal logisticsMoney) {
        if (null == urUserrule || null == money) {
            return BigDecimal.ZERO;
        }
        String type = urUserrule.getUserruleType();
        BigDecimal rmoney = BigDecimal.ZERO;
        BigDecimal userruleNum = urUserrule.getUserruleNum();
        if (null == userruleNum) {
            userruleNum = BigDecimal.ZERO;
        }
        if ("DC".equals(type)) {
            rmoney = money.subtract(userruleNum.divide(new BigDecimal("100")).multiply(money));
        } else if (!"CO".equals(type)) {
            if ("FA".equals(type)) {
                rmoney = userruleNum;
            } else if ("FP".equals(type)) {
                rmoney = logisticsMoney;
            }
        }
        return rmoney;
    }

    private Map<String, List<UrUserrightsGoods>> makeMap(List<UrUserrightsGoods> urUserRightsGoodsList) {
        if (ListUtil.isEmpty(urUserRightsGoodsList)) {
            return null;
        }
        HashMap<String, List<UrUserrightsGoods>> map = new HashMap<String, List<UrUserrightsGoods>>();
        for (UrUserrightsGoods urUserrightsGoods : urUserRightsGoodsList) {
            ArrayList<UrUserrightsGoods> glist = (ArrayList<UrUserrightsGoods>)map.get(urUserrightsGoods.getUserrightsGoodsType());
            if (null == glist) {
                glist = new ArrayList<UrUserrightsGoods>();
                map.put(urUserrightsGoods.getUserrightsGoodsType(), glist);
            }
            glist.add(urUserrightsGoods);
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public UrDiscountPriceResDomain getTotalDiscountPrice(UrOrderUserDomain urOrderUserDomain, List<RsSkuDomain> rsSkuList) throws ApiException {
        HashMap<String, Object> urMap;
        Map<String, Object> userInfoQueMap;
        UmUserinfo umUserInfo;
        this.logger.error(SYS_CODE, (Object)("urOrderUserDomain info:" + JsonUtil.buildNormalBinder().toJson((Object)urOrderUserDomain)));
        this.logger.error(SYS_CODE, (Object)("rsSkuList info:" + JsonUtil.buildNormalBinder().toJson(rsSkuList)));
        if (null == urOrderUserDomain) {
            return null;
        }
        UrDiscountPriceResDomain urDiscountPriceResDomain = new UrDiscountPriceResDomain();
        BigDecimal totalDiscountPrice = new BigDecimal(0);
        String userinfoCode = urOrderUserDomain.getUserCode();
        String tenantCode = urOrderUserDomain.getTenantCode();
        if (StringUtils.isNotBlank((String)userinfoCode) && StringUtils.isNotBlank((String)tenantCode)) {
            HashMap<String, String> userParamMap = new HashMap<String, String>();
            userParamMap.put("userinfoCode", userinfoCode);
            userParamMap.put("tenantCode", tenantCode);
            String umUserInfoStr = (String)this.getInternalRouter().inInvoke(GET_USERINFO_BY_USERCODE, userParamMap);
            umUserInfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(umUserInfoStr, UmUserinfo.class);
            if (umUserInfo == null) {
                this.logger.error("ur.UrUserrightsServiceImplgetTotalDiscountPrice1", userParamMap);
                return urDiscountPriceResDomain;
            }
            userInfoQueMap = this.getUserInfoQueMap(umUserInfo);
            urMap = new HashMap<String, Object>();
            urMap.put("tenantCode", tenantCode);
            urMap.put("dataState", 0);
            if (StringUtils.isNotBlank((String)urOrderUserDomain.getMemberMcode())) {
                urMap.put("memberCode", urOrderUserDomain.getMemberMcode());
            }
        } else {
            this.logger.error("ur.UrUserrightsServiceImplgetTotalDiscountPrice", (Object)"isnull");
            return urDiscountPriceResDomain;
        }
        List<UrUserrights> urListResults = this.queryUserrightsModelPage(urMap);
        this.logger.error(SYS_CODE, (Object)("rsSkuList urListResults:urUserrightsListList" + urMap));
        boolean flag = true;
        Iterator<UrUserrights> iterator = urListResults.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                urDiscountPriceResDomain.setTotalDiscountPrice(totalDiscountPrice);
                return urDiscountPriceResDomain;
            }
            UrUserrights urUserrights = iterator.next();
            urMap.put("userrightsCode", urUserrights.getUserrightsCode());
            List<UrUserrightsList> urUserrightsListList = this.queryUserrightsListModelPage(urMap);
            this.logger.error(SYS_CODE, (Object)("rsSkuList urListResults:urUserrightsListList" + urMap));
            if (ListUtil.isEmpty(urUserrightsListList)) {
                flag = false;
                this.logger.error(SYS_CODE, (Object)("rsSkuList info:urUserrightsListList" + urMap));
                continue;
            }
            for (UrUserrightsList urUserrightsList : urUserrightsListList) {
                if ("jifenFlag".equals(urUserrightsList.getUserrightsListType())) {
                    HashMap<String, String> jifenMap = new HashMap<String, String>();
                    jifenMap.put("merchantCode", userinfoCode);
                    if (StringUtils.isNotBlank((String)umUserInfo.getUserinfoCode())) {
                        jifenMap.put("faccountType", umUserInfo.getUserinfoCode().substring(0, 1).concat("01"));
                    }
                    jifenMap.put("tenantCode", tenantCode);
                    String vdFaccountInfoStr = (String)this.getInternalRouter().inInvoke(QUERY_OUTER_JIFEN, jifenMap);
                    List vdFaccountInfoList = (List)JsonUtil.buildNormalBinder().getJsonToList(vdFaccountInfoStr, VdFaccountInfo.class);
                    if (!ListUtil.isNotEmpty((Collection)vdFaccountInfoList)) continue;
                    this.logger.debug(SYS_CODE, (Object)("vdFaccountInfoList info:" + vdFaccountInfoList));
                    if (BigDecimal.ZERO.compareTo(((VdFaccountInfo)vdFaccountInfoList.get(0)).getFaccountAmount()) >= 0) continue;
                    flag = false;
                    continue;
                }
                Object umUserInfoObj = BeanUtils.forceGetProperty((Object)umUserInfo, (String)urUserrightsList.getUserrightsListType());
                this.logger.error(SYS_CODE, (Object)("umUserInfoObj2" + umUserInfoObj + "urUserrightsList" + urUserrightsList.getUserrightsListId()));
                if (MapUtil.isNotEmpty(userInfoQueMap)) {
                    if (null == umUserInfoObj && ((umUserInfoObj = userInfoQueMap.get(urUserrightsList.getUserrightsListType())) == null || StringUtils.isBlank((String)umUserInfoObj.toString()))) {
                        umUserInfoObj = this.getLevelCode(urOrderUserDomain);
                        this.logger.error(SYS_CODE, (Object)("rsSkuList info:umUserInfoObj3" + umUserInfoObj + "userrightsListOpcode" + urUserrightsList.getUserrightsListOpcode()));
                    }
                } else {
                    umUserInfoObj = this.getLevelCode(urOrderUserDomain);
                    this.logger.error(SYS_CODE, (Object)("rsSkuList info:umUserInfoObj4" + umUserInfoObj + "userrightsListOpcode" + urUserrightsList.getUserrightsListOpcode()));
                }
                if (!String.valueOf(umUserInfoObj).equals(urUserrightsList.getUserrightsListOpcode())) {
                    flag = false;
                    continue;
                }
                flag = true;
                break;
            }
            this.logger.error(SYS_CODE, (Object)("rsSkuList info:flag" + flag));
            if (!flag) continue;
            HashMap<String, Object> urGoodsMap = new HashMap<String, Object>();
            urGoodsMap.put("userrightsCode", urUserrights.getUserrightsCode());
            urGoodsMap.put("tenantCode", urUserrights.getTenantCode());
            List<UrUserrightsGoods> urUserRightsGoodsList = this.getGoodsByUrCode(urGoodsMap);
            UrUserrule urUserrule = this.urUserruleService.getUserruleByCode(tenantCode, urUserrights.getUserruleCode());
            if (null != urUserrule && -1 != urUserrule.getDataState()) {
                if (!ListUtil.isNotEmpty(urUserRightsGoodsList)) {
                    for (RsSkuDomain rsSku : rsSkuList) {
                        totalDiscountPrice = totalDiscountPrice.add(this.computeDiscountPrice(rsSku, urUserrule));
                    }
                } else {
                    Map<String, List<UrUserrightsGoods>> userrightGoods = this.makeMap(urUserRightsGoodsList);
                    for (RsSkuDomain rsSku : rsSkuList) {
                        boolean skuflag = true;
                        for (String key : userrightGoods.keySet()) {
                            List<UrUserrightsGoods> urUserRightsGoodsMapList = userrightGoods.get(key);
                            skuflag = false;
                            if (ListUtil.isNotEmpty(urUserRightsGoodsMapList)) {
                                for (UrUserrightsGoods urUserrightsGoods2 : urUserRightsGoodsMapList) {
                                    Object umUserInfoObj = BeanUtils.forceGetProperty((Object)rsSku, (String)urUserrightsGoods2.getUserrightsGoodsType());
                                    if (!String.valueOf(umUserInfoObj).equals(urUserrightsGoods2.getUserrightsGoodsOpcode())) continue;
                                    skuflag = true;
                                    break;
                                }
                            } else {
                                skuflag = true;
                            }
                            if (skuflag) continue;
                        }
                        if (!skuflag) continue;
                        totalDiscountPrice = totalDiscountPrice.add(this.computeDiscountPrice(rsSku, urUserrule));
                    }
                }
            }
            urDiscountPriceResDomain.setContractSettlOpno(urUserrights.getUserrightsCode());
        }
    }

    private String getLevelCode(UrOrderUserDomain urOrderUserDomain) {
        if (StringUtils.isNotBlank((String)urOrderUserDomain.getUserCode())) {
            HashMap<String, String> paramMap = new HashMap<String, String>(8);
            paramMap.put("channelCode", urOrderUserDomain.getChannelCode());
            paramMap.put("memberCode", urOrderUserDomain.getUserCode());
            paramMap.put("tenantCode", urOrderUserDomain.getTenantCode());
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
            this.logger.error(SYS_CODE, (Object)("getLevelCode info:umUserInfoObj" + map));
            String upointStr = (String)this.getInternalRouter().inInvoke(GET_LEVEL_CODE_BY_CHANNEL, map);
            JSONObject json = JSONObject.json2object((String)upointStr);
            this.logger.error(SYS_CODE, (Object)("getLevelCode info:json" + json));
            if (json.containsKey((Object)"levelListLevel") && StringUtils.isNotBlank((String)json.getString("levelListLevel"))) {
                paramMap.clear();
                map.clear();
                paramMap.put("memberCode", urOrderUserDomain.getMemberMcode());
                paramMap.put("levelListLevel", json.getString("levelListLevel"));
                paramMap.put("tenantCode", urOrderUserDomain.getTenantCode());
                map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
                this.logger.error(SYS_CODE, (Object)("getLevelCode info:umUserInfoObj.levelStr" + map));
                String levelStr = (String)this.getInternalRouter().inInvoke(GET_LEVEL_CODE_BY_LEVEL, map);
                JSONArray jsonArray = JSONArray.json2array((String)levelStr);
                if (jsonArray != null && jsonArray.size() > 0) {
                    for (JSONObject jsonObject : jsonArray) {
                        if (!jsonObject.getString("levelListName").equals(json.getString("levelListName"))) continue;
                        return jsonObject.getString("levelListCode");
                    }
                    return jsonArray.get(0).getString("levelListCode");
                }
            }
        }
        return null;
    }

    private Map<String, Object> getUserInfoQueMap(UmUserinfo umUserInfo) {
        if (ListUtil.isEmpty(umUserInfo.getUmUserinfoQuaDomainList())) {
            return null;
        }
        HashMap<String, Object> userInfoQueMap = new HashMap<String, Object>();
        for (UmUserinfoQua umUserinfoQua : umUserInfo.getUmUserinfoQuaDomainList()) {
            userInfoQueMap.put(umUserinfoQua.getUserinfoQuaKey(), umUserinfoQua.getUserinfoQuaVaule());
        }
        return userInfoQueMap;
    }

    private BigDecimal computeDiscountPrice(RsSkuDomain rsSku, UrUserrule urUserrule) {
        this.logger.info("urUserrule-----", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)urUserrule));
        BigDecimal discountPrice = new BigDecimal(0);
        if (null == rsSku.getGoodsNum()) {
            rsSku.setGoodsNum(BigDecimal.ZERO);
        }
        if (StringUtils.isBlank((String)urUserrule.getUserruleType())) {
            return discountPrice;
        }
        BigDecimal nPrice = rsSku.getPricesetNprice().multiply(rsSku.getGoodsNum());
        switch (urUserrule.getUserruleType()) {
            case "1": {
                discountPrice = nPrice.multiply(new BigDecimal(100).subtract(urUserrule.getUserruleNum()).divide(new BigDecimal(100)));
                discountPrice = discountPrice.setScale(2, 4);
                if (nPrice.compareTo(discountPrice) == -1) {
                    discountPrice = nPrice;
                }
                break;
            }
            case "2": {
                discountPrice = rsSku.getPricesetRefrice().subtract(urUserrule.getUserruleNum()).multiply(rsSku.getGoodsNum());
                break;
            }
            case "3": {
                double random = Math.random();
                discountPrice = BigDecimal.valueOf(random).multiply(urUserrule.getUserruleMaxnum().subtract(urUserrule.getUserruleMinnum()).add(new BigDecimal(1))).add(urUserrule.getUserruleMinnum()).multiply(rsSku.getGoodsNum());
                break;
            }
            case "4": {
                discountPrice = rsSku.getPricesetAsprice().subtract(rsSku.getPricesetNprice()).subtract(rsSku.getPricesetRefrice()).multiply(rsSku.getGoodsNum());
                break;
            }
            case "5": {
                discountPrice = rsSku.getPricesetAsprice().subtract(rsSku.getPricesetNprice()).subtract(rsSku.getPricesetRefrice()).multiply(rsSku.getGoodsNum());
                break;
            }
            case "6": {
                discountPrice = nPrice.multiply(urUserrule.getUserruleNum().divide(new BigDecimal(100)));
                if (nPrice.compareTo(discountPrice) == -1) {
                    discountPrice = nPrice;
                }
                break;
            }
        }
        return discountPrice;
    }

    @Override
    public String commitOrder(UrOrderUserDomain urOrderUserDomain, List<RsSkuDomain> rsSkuList) {
        UrDiscountPriceResDomain urDiscountPriceResDomain = null;
        try {
            urDiscountPriceResDomain = this.getTotalDiscountPrice(urOrderUserDomain, rsSkuList);
        }
        catch (Exception e) {
            this.logger.error("ur.userrights.commitOrder", (Object)e.getMessage(), (Throwable)e);
            return "error";
        }
        if (urDiscountPriceResDomain.getTotalDiscountPrice().equals(urOrderUserDomain.getDiscountPrice())) {
            return "success";
        }
        this.logger.error("ur.userrights.commitOrderStr", (Object)("rsSkuList" + JsonUtil.buildNormalBinder().toJson(rsSkuList) + "urOrderUserDomain" + JsonUtil.buildNormalBinder().toJson((Object)urOrderUserDomain)));
        return "error";
    }

    @Override
    public void loadUserrightsProcess(String tenantCode) throws ApiException {
        this.saveStart(tenantCode);
        this.saveEnd(tenantCode);
    }

    @Override
    public void loadCopyUserrights(String tenantCode) throws ApiException {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        Date sysDate = this.getSysDate();
        parammap.put("userruleStartQend", sysDate);
        parammap.put("userruleEndQstart", sysDate);
        parammap.put("tenantCode", tenantCode);
        List<UrUserrights> userrightsList = this.queryUserrightsModelPage(parammap);
        if (null == userrightsList || userrightsList.isEmpty()) {
            return;
        }
        Date nextmonth = this.getMonth(sysDate, 1);
        Date nextTwemonth = this.getMonth(sysDate, 2);
        parammap = new HashMap();
        parammap.put("tenantCode", tenantCode);
        parammap.put("userruleStart", nextmonth);
        parammap.put("userruleEnd", nextTwemonth);
        List<UrUserrights> userrightlist = this.queryUserrightsModelPage(parammap);
        if (ListUtil.isNotEmpty(userrightlist)) {
            return;
        }
        for (UrUserrights userrights : userrightsList) {
            this.saveUserrightsCopy(userrights, nextmonth, nextTwemonth);
        }
    }

    private void saveUserrightsCopy(UrUserrights userrights, Date nextmonth, Date nextTwemonth) throws ApiException {
        UrUserrightsDomain urUserrightsDomain = this.makeUrUserrightsDomain(null, userrights);
        if (null == urUserrightsDomain) {
            return;
        }
        UrUserrule userrule = this.urUserruleService.getUserruleByCode(userrights.getTenantCode(), userrights.getUserruleCode());
        UrUserruleDomain urUserruleDomain = this.makeUrUserruleDomain(null, userrule);
        if (null == urUserruleDomain) {
            return;
        }
        urUserruleDomain.setUserruleCode(null);
        urUserruleDomain.setUserruleId(null);
        String userruleCode = this.urUserruleService.saveUserrule(urUserruleDomain);
        urUserrightsDomain.setUserruleCode(userruleCode);
        urUserrightsDomain.setUserrightsCode(null);
        urUserrightsDomain.setUserrightsId(null);
        urUserrightsDomain.setUserruleStart(nextmonth);
        urUserrightsDomain.setUserruleEnd(nextTwemonth);
        String userrightsCode = this.saveUserrights(urUserrightsDomain);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", userrights.getTenantCode());
        param.put("userrightsCode", userrights.getUserrightsCode());
        param.put("userruleCode", userrights.getUserruleCode());
        List<UrUserrightsList> urUserrightsLists = this.queryUserrightsListModelPage(param);
        for (UrUserrightsList urUserrightsList : urUserrightsLists) {
            UrUserrightsListDomain urUserrightsListDomain = this.makeUrUserruleListDomain(null, urUserrightsList);
            if (null == urUserrightsListDomain) {
                return;
            }
            urUserrightsListDomain.setUserrightsListId(null);
            urUserrightsListDomain.setUserrightsListCode(null);
            urUserrightsListDomain.setUserrightsCode(userrightsCode);
            urUserrightsListDomain.setUserruleCode(userruleCode);
            this.saveUserrightsList(urUserrightsListDomain);
        }
    }

    private UrUserrightsListDomain makeUrUserruleListDomain(UrUserrightsListDomain urUserrightsListDomain, UrUserrightsList urUserrightsList) {
        if (null == urUserrightsList) {
            return null;
        }
        if (null == urUserrightsListDomain) {
            urUserrightsListDomain = new UrUserrightsListDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)urUserrightsListDomain, (Object)urUserrightsList);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUrUserruleDomain", (Throwable)e);
        }
        return urUserrightsListDomain;
    }

    private UrUserruleDomain makeUrUserruleDomain(UrUserruleDomain urUserruleDomain, UrUserrule userrule) {
        if (null == userrule) {
            return null;
        }
        if (null == urUserruleDomain) {
            urUserruleDomain = new UrUserruleDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)urUserruleDomain, (Object)userrule);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUrUserruleDomain", (Throwable)e);
        }
        return urUserruleDomain;
    }

    private UrUserrightsDomain makeUrUserrightsDomain(UrUserrightsDomain urUserrightsDomain, UrUserrights userrights) {
        if (null == userrights) {
            return null;
        }
        if (null == urUserrightsDomain) {
            urUserrightsDomain = new UrUserrightsDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)urUserrightsDomain, (Object)userrights);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUrUserrightsDomain", (Throwable)e);
        }
        return urUserrightsDomain;
    }

    private Date getMonth(Date sysDate, int amount) {
        Calendar cale = Calendar.getInstance();
        cale.setTime(sysDate);
        cale.add(2, amount);
        cale.set(5, 1);
        cale.set(11, 0);
        cale.set(12, 0);
        cale.set(13, 0);
        return cale.getTime();
    }

    public static void main(String[] args) {
        JSONObject json = JSONObject.json2object((String)"");
        if (json.containsKey((Object)"levelListLevel") && StringUtils.isNotBlank((String)json.getString("levelListLevel"))) {
            System.out.println("\u89e3\u6790\u6210\u529f: levelListLevel = " + json.getString("levelListLevel"));
        }
    }

    private void saveEnd(String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", UserRightsConstants.USERRIGHTS_DATASTATE_START);
        parammap.put("tenantCode", tenantCode);
        List<UrUserrights> userrightsList = this.queryUserrightsModelPage(parammap);
        if (null == userrightsList || userrightsList.isEmpty()) {
            return;
        }
        for (UrUserrights userrights : userrightsList) {
            if (null == userrights.getUserruleEnd() || userrights.getUserruleEnd().getTime() > this.getSysDate().getTime()) continue;
            try {
                this.updateUserrightsState(userrights.getUserrightsId(), UserRightsConstants.USERRIGHTS_DATASTATE_END, UserRightsConstants.USERRIGHTS_DATASTATE_START);
            }
            catch (Exception e) {
                this.logger.error("ur.UrUserrightsServiceImpl.saveEnd.e", (Object)userrights.getUserrightsCode(), (Throwable)e);
            }
        }
    }

    private void saveStart(String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", UserRightsConstants.USERRIGHTS_DATASTATE_WAIT);
        parammap.put("tenantCode", tenantCode);
        List<UrUserrights> userrightsList = this.queryUserrightsModelPage(parammap);
        if (null == userrightsList || userrightsList.isEmpty()) {
            return;
        }
        for (UrUserrights userrights : userrightsList) {
            if (null != userrights.getUserruleStart() && userrights.getUserruleStart().getTime() > this.getSysDate().getTime()) continue;
            try {
                this.updateUserrightsState(userrights.getUserrightsId(), UserRightsConstants.USERRIGHTS_DATASTATE_START, UserRightsConstants.USERRIGHTS_DATASTATE_WAIT);
            }
            catch (Exception e) {
                this.logger.error("ur.UrUserrightsServiceImpl.saveStart.e", (Object)userrights.getUserrightsCode(), (Throwable)e);
            }
        }
    }

    @Override
    public String saveUrByDefault(List<UlLevelList> ulLevelListList) throws ApiException {
        if (ListUtil.isEmpty(ulLevelListList)) {
            this.logger.error("ur.UrUserrightsServiceImpl.saveUrByDefault", (Object)"ulLevelListList is null");
            return "error";
        }
        for (UlLevelList ulLevelList : ulLevelListList) {
            this.saveUserrightsList(ulLevelList);
        }
        return "success";
    }

    private void saveUserrightsList(UlLevelList ulLevelList) {
        if (null == ulLevelList) {
            this.logger.error("ur.UrUserrightsServiceImpl.saveUserrightsList", (Object)"ulLevelList is null");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ulLevelList.getTenantCode());
        map.put("userrightsListType", "levelListCode_" + ulLevelList.getLevelUserqua());
        map.put("userrightsListOpcode", ulLevelList.getLevelListCode());
        List<UrUserrightsList> urUserrightsLists = this.queryUserrightsListModelPage(map);
        if (ListUtil.isNotEmpty(urUserrightsLists)) {
            this.logger.error("ur.UrUserrightsServiceImpl.queryUserrightsList", (Object)((Object)map).toString());
            return;
        }
        UrUserruleDomain urUserruleDomain = new UrUserruleDomain();
        urUserruleDomain.setUserruleId(null);
        urUserruleDomain.setUserruleCode(null);
        urUserruleDomain.setTenantCode(ulLevelList.getTenantCode());
        urUserruleDomain.setUserruleMaxnum(BigDecimal.ZERO);
        urUserruleDomain.setUserruleMinnum(BigDecimal.ZERO);
        urUserruleDomain.setUserruleNum(BigDecimal.ZERO);
        urUserruleDomain.setUserruleOpcode(ulLevelList.getLevelListCode());
        urUserruleDomain.setUserruleType("6");
        urUserruleDomain.setUserrulePut("0");
        urUserruleDomain.setUserruleName(ulLevelList.getLevelListName());
        String userruleCode = this.urUserruleService.saveUserrule(urUserruleDomain);
        UrUserrightsDomain urUserrightsDomain = new UrUserrightsDomain();
        urUserrightsDomain.setUserrightsId(null);
        urUserrightsDomain.setTenantCode(ulLevelList.getTenantCode());
        urUserrightsDomain.setUserrightsCode(null);
        urUserrightsDomain.setUserruleCode(userruleCode);
        urUserrightsDomain.setUserrightsCon(0);
        urUserrightsDomain.setUserrightsName(ulLevelList.getLevelListName());
        urUserrightsDomain.setUserrightsRemark(ulLevelList.getLevelListName());
        urUserrightsDomain.setUserruleName(ulLevelList.getLevelListName());
        String userrightsCode = this.saveUserrights(urUserrightsDomain);
        UrUserrightsListDomain urUserrightsListDomain = new UrUserrightsListDomain();
        urUserrightsListDomain.setUserrightsListId(null);
        urUserrightsListDomain.setUserruleCode(userruleCode);
        urUserrightsListDomain.setUserrightsListCode(null);
        urUserrightsListDomain.setUserrightsCode(userrightsCode);
        urUserrightsListDomain.setUserruleName(ulLevelList.getLevelListName());
        urUserrightsListDomain.setTenantCode(ulLevelList.getTenantCode());
        urUserrightsListDomain.setUserrightsListOpcode(ulLevelList.getLevelListCode());
        urUserrightsListDomain.setUserrightsListOpname(ulLevelList.getLevelListName());
        urUserrightsListDomain.setUserrightsListType("levelListCode_dealer");
        this.saveUserrightsList(urUserrightsListDomain);
    }

    private void saveUr(UrUserrightsList urUserrightsList, UlLevelList ulLevelList, int i) {
        Date sysDate = this.getSysDate();
        String tenantCode = ulLevelList.getTenantCode();
        UrUserrule userruleByCode = this.urUserruleService.getUserruleByCode(urUserrightsList.getTenantCode(), urUserrightsList.getUserruleCode());
        if (null == userruleByCode) {
            this.logger.error("ur.UrUserrightsServiceImpl.saveUr.userruleByCode", (Object)(urUserrightsList.getTenantCode() + "=" + urUserrightsList.getUserruleCode()));
            return;
        }
        UrUserruleDomain urUserruleDomain = this.makeUserruleDomain(null, userruleByCode);
        urUserruleDomain.setUserruleId(null);
        urUserruleDomain.setUserruleCode(null);
        urUserruleDomain.setTenantCode(tenantCode);
        String userruleCode = this.urUserruleService.saveUserrule(urUserruleDomain);
        UrUserrights userrights = this.getUserrightsByCode(urUserrightsList.getTenantCode(), urUserrightsList.getUserrightsCode());
        UrUserrightsDomain urUserrightsDomain = this.makeUserrightsDomain(null, userrights);
        if (null == urUserrightsDomain) {
            this.logger.error("ur.UrUserrightsServiceImpl.saveUr.urUserrightsDomain", (Object)(urUserrightsList.getTenantCode() + "=" + urUserrightsList.getUserruleCode()));
            return;
        }
        urUserrightsDomain.setUserrightsId(null);
        urUserrightsDomain.setTenantCode(tenantCode);
        urUserrightsDomain.setUserrightsCode(null);
        urUserrightsDomain.setUserruleCode(userruleCode);
        urUserrightsDomain.setUserruleStart(this.getMonth(sysDate, i));
        urUserrightsDomain.setUserruleEnd(this.getMonth(sysDate, i + 1));
        String userrightsCode = this.saveUserrights(urUserrightsDomain);
        UrUserrightsListDomain urUserrightsListDomain = this.makeUserrightsDomain(null, urUserrightsList);
        urUserrightsListDomain.setUserrightsListId(null);
        urUserrightsListDomain.setUserruleCode(userruleCode);
        urUserrightsListDomain.setUserrightsListCode(null);
        urUserrightsListDomain.setUserrightsCode(userrightsCode);
        urUserrightsListDomain.setTenantCode(tenantCode);
        urUserrightsListDomain.setUserrightsListOpcode(ulLevelList.getLevelListCode());
        urUserrightsListDomain.setUserrightsListOpname(ulLevelList.getLevelListName());
        this.saveUserrightsList(urUserrightsListDomain);
    }

    private UrUserrightsListDomain makeUserrightsDomain(UrUserrightsListDomain urUserrightsListDomain, UrUserrightsList urUserrightsList) {
        if (null == urUserrightsList) {
            return null;
        }
        if (null == urUserrightsListDomain) {
            urUserrightsListDomain = new UrUserrightsListDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)urUserrightsListDomain, (Object)urUserrightsList);
            return urUserrightsListDomain;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUserrights", (Throwable)e);
            return null;
        }
    }

    private void saveUserrights(List<UrUserrights> urUserrights, String tenantCode) {
        if (ListUtil.isEmpty(urUserrights)) {
            return;
        }
        for (UrUserrights userrights : urUserrights) {
            UrUserrightsDomain urUserrightsDomain = this.makeUserrightsDomain(null, userrights);
            urUserrightsDomain.setUserrightsId(null);
            urUserrightsDomain.setTenantCode(tenantCode);
            this.saveUserrights(urUserrightsDomain);
        }
    }

    private void saveUrUserrule(List<UrUserrule> urUserrules, String tenantCode) {
        if (ListUtil.isEmpty(urUserrules)) {
            return;
        }
        for (UrUserrule urUserrule : urUserrules) {
            UrUserruleDomain urUserruleDomain = this.makeUserruleDomain(null, urUserrule);
            urUserruleDomain.setUserruleId(null);
            urUserruleDomain.setTenantCode(tenantCode);
            this.urUserruleService.saveUserrule(urUserruleDomain);
        }
    }

    private UrUserruleDomain makeUserruleDomain(UrUserruleDomain urUserruleDomain, UrUserrule urUserrule) {
        if (null == urUserrule) {
            return null;
        }
        if (null == urUserruleDomain) {
            urUserruleDomain = new UrUserruleDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)urUserruleDomain, (Object)urUserrule);
            return urUserruleDomain;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserrightsServiceImpl.makeUserrights", (Throwable)e);
            return null;
        }
    }
}

