/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhGoodsnoConfMapper;
import com.yqbsoft.laser.service.warehouse.dao.WhGoodsnoMapper;
import com.yqbsoft.laser.service.warehouse.domain.WhGoodsnoConfDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhGoodsnoConfReDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhGoodsnoDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhGoodsnoReDomain;
import com.yqbsoft.laser.service.warehouse.model.WhGoodsno;
import com.yqbsoft.laser.service.warehouse.model.WhGoodsnoConf;
import com.yqbsoft.laser.service.warehouse.service.WhGoodsnoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhGoodsnoServiceImpl
extends BaseServiceImpl
implements WhGoodsnoService {
    private static final String SYS_CODE = "wh.WhGoodsnoServiceImpl";
    private WhGoodsnoMapper whGoodsnoMapper;
    private WhGoodsnoConfMapper whGoodsnoConfMapper;

    public void setWhGoodsnoMapper(WhGoodsnoMapper whGoodsnoMapper) {
        this.whGoodsnoMapper = whGoodsnoMapper;
    }

    public void setWhGoodsnoConfMapper(WhGoodsnoConfMapper whGoodsnoConfMapper) {
        this.whGoodsnoConfMapper = whGoodsnoConfMapper;
    }

    private Date getSysDate() {
        try {
            return this.whGoodsnoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGoodsno(WhGoodsnoDomain whGoodsnoDomain) {
        if (null == whGoodsnoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whGoodsnoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGoodsnoDefault(WhGoodsno whGoodsno) {
        if (null == whGoodsno) {
            return;
        }
        if (null == whGoodsno.getDataState()) {
            whGoodsno.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whGoodsno.getGmtCreate()) {
            whGoodsno.setGmtCreate(date);
        }
        whGoodsno.setGmtModified(date);
        if (StringUtils.isBlank((String)whGoodsno.getGoodsnoCode())) {
            whGoodsno.setGoodsnoCode(this.getNo(null, "WhGoodsno", "whGoodsno", whGoodsno.getTenantCode()));
        }
    }

    private int getGoodsnoMaxCode() {
        int code = 0;
        try {
            return this.whGoodsnoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.getGoodsnoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGoodsnoUpdataDefault(WhGoodsno whGoodsno) {
        if (null == whGoodsno) {
            return;
        }
        whGoodsno.setGmtModified(this.getSysDate());
    }

    private void saveGoodsnoModel(WhGoodsno whGoodsno) throws ApiException {
        if (null == whGoodsno) {
            return;
        }
        try {
            this.whGoodsnoMapper.insert(whGoodsno);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.saveGoodsnoModel.ex", (Throwable)e);
        }
    }

    private void saveGoodsnoBatchModel(List<WhGoodsno> whGoodsnoList) throws ApiException {
        if (null == whGoodsnoList || whGoodsnoList.isEmpty()) {
            return;
        }
        try {
            this.whGoodsnoMapper.insertBatch(whGoodsnoList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.saveGoodsnoBatchModel.ex", (Throwable)e);
        }
    }

    private WhGoodsno getGoodsnoModelById(Integer goodsnoId) {
        if (null == goodsnoId) {
            return null;
        }
        try {
            return this.whGoodsnoMapper.selectByPrimaryKey(goodsnoId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.getGoodsnoModelById", (Throwable)e);
            return null;
        }
    }

    private WhGoodsno getGoodsnoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whGoodsnoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.getGoodsnoModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGoodsnoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whGoodsnoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.delGoodsnoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.delGoodsnoModelByCode.num");
        }
    }

    private void deleteGoodsnoModel(Integer goodsnoId) throws ApiException {
        if (null == goodsnoId) {
            return;
        }
        int i = 0;
        try {
            i = this.whGoodsnoMapper.deleteByPrimaryKey(goodsnoId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.deleteGoodsnoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.deleteGoodsnoModel.num");
        }
    }

    private void updateGoodsnoModel(WhGoodsno whGoodsno) throws ApiException {
        if (null == whGoodsno) {
            return;
        }
        int i = 0;
        try {
            i = this.whGoodsnoMapper.updateByPrimaryKey(whGoodsno);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateGoodsnoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateGoodsnoModel.num");
        }
    }

    private void updateStateGoodsnoModel(Integer goodsnoId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == goodsnoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsnoId", goodsnoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whGoodsnoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateStateGoodsnoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateStateGoodsnoModel.null");
        }
    }

    private void updateStateGoodsnoModelByCode(String tenantCode, String goodsnoCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)goodsnoCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsnoCode", goodsnoCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whGoodsnoMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateStateGoodsnoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateStateGoodsnoModelByCode.null");
        }
    }

    private WhGoodsno makeGoodsno(WhGoodsnoDomain whGoodsnoDomain, WhGoodsno whGoodsno) {
        if (null == whGoodsnoDomain) {
            return null;
        }
        if (null == whGoodsno) {
            whGoodsno = new WhGoodsno();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whGoodsno, (Object)whGoodsnoDomain);
            return whGoodsno;
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.makeGoodsno", (Throwable)e);
            return null;
        }
    }

    private WhGoodsnoReDomain makeWhGoodsnoReDomain(WhGoodsno whGoodsno) {
        if (null == whGoodsno) {
            return null;
        }
        WhGoodsnoReDomain whGoodsnoReDomain = new WhGoodsnoReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whGoodsnoReDomain, (Object)whGoodsno);
            return whGoodsnoReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.makeWhGoodsnoReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhGoodsno> queryGoodsnoModelPage(Map<String, Object> parammap) {
        try {
            return this.whGoodsnoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.queryGoodsnoModel", (Throwable)e);
            return null;
        }
    }

    private int countGoodsno(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whGoodsnoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.countGoodsno", (Throwable)e);
        }
        return i;
    }

    private WhGoodsno createWhGoodsno(WhGoodsnoDomain whGoodsnoDomain) {
        String msg = this.checkGoodsno(whGoodsnoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.saveGoodsno.checkGoodsno", msg);
        }
        WhGoodsno whGoodsno = this.makeGoodsno(whGoodsnoDomain, null);
        this.setGoodsnoDefault(whGoodsno);
        return whGoodsno;
    }

    private String checkGoodsnoConf(WhGoodsnoConfDomain whGoodsnoConfDomain) {
        if (null == whGoodsnoConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whGoodsnoConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGoodsnoConfDefault(WhGoodsnoConf whGoodsnoConf) {
        if (null == whGoodsnoConf) {
            return;
        }
        if (null == whGoodsnoConf.getDataState()) {
            whGoodsnoConf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whGoodsnoConf.getGmtCreate()) {
            whGoodsnoConf.setGmtCreate(date);
        }
        whGoodsnoConf.setGmtModified(date);
        if (StringUtils.isBlank((String)whGoodsnoConf.getGoodsnoConfCode())) {
            whGoodsnoConf.setGoodsnoConfCode(this.getNo(null, "WhGoodsnoConf", "whGoodsnoConf", whGoodsnoConf.getTenantCode()));
        }
    }

    private int getGoodsnoConfMaxCode() {
        int code = 0;
        try {
            return this.whGoodsnoConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.getGoodsnoConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGoodsnoConfUpdataDefault(WhGoodsnoConf whGoodsnoConf) {
        if (null == whGoodsnoConf) {
            return;
        }
        whGoodsnoConf.setGmtModified(this.getSysDate());
    }

    private void saveGoodsnoConfModel(WhGoodsnoConf whGoodsnoConf) throws ApiException {
        if (null == whGoodsnoConf) {
            return;
        }
        try {
            this.whGoodsnoConfMapper.insert(whGoodsnoConf);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.saveGoodsnoConfModel.ex", (Throwable)e);
        }
    }

    private void saveGoodsnoConfBatchModel(List<WhGoodsnoConf> whGoodsnoConfList) throws ApiException {
        if (null == whGoodsnoConfList || whGoodsnoConfList.isEmpty()) {
            return;
        }
        try {
            this.whGoodsnoConfMapper.insertBatch(whGoodsnoConfList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.saveGoodsnoConfBatchModel.ex", (Throwable)e);
        }
    }

    private WhGoodsnoConf getGoodsnoConfModelById(Integer goodsnoConfId) {
        if (null == goodsnoConfId) {
            return null;
        }
        try {
            return this.whGoodsnoConfMapper.selectByPrimaryKey(goodsnoConfId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.getGoodsnoConfModelById", (Throwable)e);
            return null;
        }
    }

    private WhGoodsnoConf getGoodsnoConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whGoodsnoConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.getGoodsnoConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGoodsnoConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whGoodsnoConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.delGoodsnoConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.delGoodsnoConfModelByCode.num");
        }
    }

    private void deleteGoodsnoConfModel(Integer goodsnoConfId) throws ApiException {
        if (null == goodsnoConfId) {
            return;
        }
        int i = 0;
        try {
            i = this.whGoodsnoConfMapper.deleteByPrimaryKey(goodsnoConfId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.deleteGoodsnoConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.deleteGoodsnoConfModel.num");
        }
    }

    private void updateGoodsnoConfModel(WhGoodsnoConf whGoodsnoConf) throws ApiException {
        if (null == whGoodsnoConf) {
            return;
        }
        int i = 0;
        try {
            i = this.whGoodsnoConfMapper.updateByPrimaryKey(whGoodsnoConf);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateGoodsnoConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateGoodsnoConfModel.num");
        }
    }

    private void updateStateGoodsnoConfModel(Integer goodsnoConfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == goodsnoConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsnoConfId", goodsnoConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whGoodsnoConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateStateGoodsnoConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateStateGoodsnoConfModel.null");
        }
    }

    private void updateStateGoodsnoConfModelByCode(String tenantCode, String goodsnoConfCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)goodsnoConfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsnoConfCode", goodsnoConfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whGoodsnoConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateStateGoodsnoConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateStateGoodsnoConfModelByCode.null");
        }
    }

    private WhGoodsnoConf makeGoodsnoConf(WhGoodsnoConfDomain whGoodsnoConfDomain, WhGoodsnoConf whGoodsnoConf) {
        if (null == whGoodsnoConfDomain) {
            return null;
        }
        if (null == whGoodsnoConf) {
            whGoodsnoConf = new WhGoodsnoConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whGoodsnoConf, (Object)whGoodsnoConfDomain);
            return whGoodsnoConf;
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.makeGoodsnoConf", (Throwable)e);
            return null;
        }
    }

    private WhGoodsnoConfReDomain makeWhGoodsnoConfReDomain(WhGoodsnoConf whGoodsnoConf) {
        if (null == whGoodsnoConf) {
            return null;
        }
        WhGoodsnoConfReDomain whGoodsnoConfReDomain = new WhGoodsnoConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whGoodsnoConfReDomain, (Object)whGoodsnoConf);
            return whGoodsnoConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.makeWhGoodsnoConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhGoodsnoConf> queryGoodsnoConfModelPage(Map<String, Object> parammap) {
        try {
            return this.whGoodsnoConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.queryGoodsnoConfModel", (Throwable)e);
            return null;
        }
    }

    private int countGoodsnoConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whGoodsnoConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhGoodsnoServiceImpl.countGoodsnoConf", (Throwable)e);
        }
        return i;
    }

    private WhGoodsnoConf createWhGoodsnoConf(WhGoodsnoConfDomain whGoodsnoConfDomain) {
        String msg = this.checkGoodsnoConf(whGoodsnoConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.saveGoodsnoConf.checkGoodsnoConf", msg);
        }
        WhGoodsnoConf whGoodsnoConf = this.makeGoodsnoConf(whGoodsnoConfDomain, null);
        this.setGoodsnoConfDefault(whGoodsnoConf);
        return whGoodsnoConf;
    }

    @Override
    public String saveGoodsno(WhGoodsnoDomain whGoodsnoDomain) throws ApiException {
        WhGoodsno whGoodsno = this.createWhGoodsno(whGoodsnoDomain);
        this.saveGoodsnoModel(whGoodsno);
        return whGoodsno.getGoodsnoCode();
    }

    @Override
    public String saveGoodsnoBatch(List<WhGoodsnoDomain> whGoodsnoDomainList) throws ApiException {
        if (null == whGoodsnoDomainList || whGoodsnoDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WhGoodsno> whGoodsnoList = new ArrayList<WhGoodsno>();
        String code = "";
        for (WhGoodsnoDomain whGoodsnoDomain : whGoodsnoDomainList) {
            WhGoodsno whGoodsno = this.createWhGoodsno(whGoodsnoDomain);
            code = whGoodsno.getGoodsnoCode();
            whGoodsnoList.add(whGoodsno);
        }
        this.saveGoodsnoBatchModel(whGoodsnoList);
        return code;
    }

    @Override
    public void updateGoodsnoState(Integer goodsnoId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == goodsnoId) {
            return;
        }
        this.updateStateGoodsnoModel(goodsnoId, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsnoStateByCode(String tenantCode, String goodsnoCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)goodsnoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGoodsnoModelByCode(tenantCode, goodsnoCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsno(WhGoodsnoDomain whGoodsnoDomain) throws ApiException {
        String msg = this.checkGoodsno(whGoodsnoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateGoodsno.checkGoodsno", msg);
        }
        WhGoodsno oldWhGoodsno = this.getGoodsnoModelById(whGoodsnoDomain.getGoodsnoId());
        if (null == oldWhGoodsno) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateGoodsno.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhGoodsno whGoodsno = this.makeGoodsno(whGoodsnoDomain, oldWhGoodsno);
        this.setGoodsnoUpdataDefault(whGoodsno);
        this.updateGoodsnoModel(whGoodsno);
    }

    @Override
    public WhGoodsno getGoodsno(Integer goodsnoId) {
        if (null == goodsnoId) {
            return null;
        }
        return this.getGoodsnoModelById(goodsnoId);
    }

    @Override
    public void deleteGoodsno(Integer goodsnoId) throws ApiException {
        if (null == goodsnoId) {
            return;
        }
        this.deleteGoodsnoModel(goodsnoId);
    }

    @Override
    public QueryResult<WhGoodsno> queryGoodsnoPage(Map<String, Object> map) {
        List<WhGoodsno> whGoodsnoList = this.queryGoodsnoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoodsno(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whGoodsnoList);
        return queryResult;
    }

    @Override
    public WhGoodsno getGoodsnoByCode(String tenantCode, String goodsnoCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsnoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsnoCode", goodsnoCode);
        return this.getGoodsnoModelByCode(map);
    }

    @Override
    public void deleteGoodsnoByCode(String tenantCode, String goodsnoCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsnoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsnoCode", goodsnoCode);
        this.delGoodsnoModelByCode(map);
    }

    @Override
    public String saveGoodsnoConf(WhGoodsnoConfDomain whGoodsnoConfDomain) throws ApiException {
        WhGoodsnoConf whGoodsnoConf = this.createWhGoodsnoConf(whGoodsnoConfDomain);
        this.saveGoodsnoConfModel(whGoodsnoConf);
        return whGoodsnoConf.getGoodsnoConfCode();
    }

    @Override
    public String saveGoodsnoConfBatch(List<WhGoodsnoConfDomain> whGoodsnoConfDomainList) throws ApiException {
        if (null == whGoodsnoConfDomainList || whGoodsnoConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WhGoodsnoConf> whGoodsnoConfList = new ArrayList<WhGoodsnoConf>();
        String code = "";
        for (WhGoodsnoConfDomain whGoodsnoConfDomain : whGoodsnoConfDomainList) {
            WhGoodsnoConf whGoodsnoConf = this.createWhGoodsnoConf(whGoodsnoConfDomain);
            code = whGoodsnoConf.getGoodsnoConfCode();
            whGoodsnoConfList.add(whGoodsnoConf);
        }
        this.saveGoodsnoConfBatchModel(whGoodsnoConfList);
        return code;
    }

    @Override
    public void updateGoodsnoConfState(Integer goodsnoConfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == goodsnoConfId) {
            return;
        }
        this.updateStateGoodsnoConfModel(goodsnoConfId, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsnoConfStateByCode(String tenantCode, String goodsnoConfCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)goodsnoConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGoodsnoConfModelByCode(tenantCode, goodsnoConfCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsnoConf(WhGoodsnoConfDomain whGoodsnoConfDomain) throws ApiException {
        String msg = this.checkGoodsnoConf(whGoodsnoConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateGoodsnoConf.checkGoodsnoConf", msg);
        }
        WhGoodsnoConf oldWhGoodsnoConf = this.getGoodsnoConfModelById(whGoodsnoConfDomain.getGoodsnoConfId());
        if (null == oldWhGoodsnoConf) {
            throw new ApiException("wh.WhGoodsnoServiceImpl.updateGoodsnoConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhGoodsnoConf whGoodsnoConf = this.makeGoodsnoConf(whGoodsnoConfDomain, oldWhGoodsnoConf);
        this.setGoodsnoConfUpdataDefault(whGoodsnoConf);
        this.updateGoodsnoConfModel(whGoodsnoConf);
    }

    @Override
    public WhGoodsnoConf getGoodsnoConf(Integer goodsnoConfId) {
        if (null == goodsnoConfId) {
            return null;
        }
        return this.getGoodsnoConfModelById(goodsnoConfId);
    }

    @Override
    public void deleteGoodsnoConf(Integer goodsnoConfId) throws ApiException {
        if (null == goodsnoConfId) {
            return;
        }
        this.deleteGoodsnoConfModel(goodsnoConfId);
    }

    @Override
    public QueryResult<WhGoodsnoConf> queryGoodsnoConfPage(Map<String, Object> map) {
        List<WhGoodsnoConf> whGoodsnoConfList = this.queryGoodsnoConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoodsnoConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whGoodsnoConfList);
        return queryResult;
    }

    @Override
    public WhGoodsnoConf getGoodsnoConfByCode(String tenantCode, String goodsnoConfCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsnoConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsnoConfCode", goodsnoConfCode);
        return this.getGoodsnoConfModelByCode(map);
    }

    @Override
    public void deleteGoodsnoConfByCode(String tenantCode, String goodsnoConfCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsnoConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsnoConfCode", goodsnoConfCode);
        this.delGoodsnoConfModelByCode(map);
    }
}

