/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.workflow.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.workflow.WorkflowConstants;
import com.yqbsoft.laser.service.workflow.dao.WfInstanceMapper;
import com.yqbsoft.laser.service.workflow.domain.WfInstanceDomain;
import com.yqbsoft.laser.service.workflow.model.WfInstance;
import com.yqbsoft.laser.service.workflow.service.WFEngineService;
import com.yqbsoft.laser.service.workflow.service.WFInstanceService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WFInstanceServiceImpl
extends BaseServiceImpl
implements WFInstanceService {
    public static final String SYS_CODE = "wf.WORKFLOW.WFInstanceServiceImpl";
    private WFEngineService wFEngineService;
    private WfInstanceMapper wfWFInstanceMapper;

    public void setwFEngineService(WFEngineService wFEngineService) {
        this.wFEngineService = wFEngineService;
    }

    public void setWfWFInstanceMapper(WfInstanceMapper wfWFInstanceMapper) {
        this.wfWFInstanceMapper = wfWFInstanceMapper;
    }

    private Date getSysDate() {
        try {
            return this.wfWFInstanceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFInstanceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkInstance(WfInstanceDomain wfWFInstanceDomain) {
        if (null == wfWFInstanceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wfWFInstanceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)wfWFInstanceDomain.getNodeCode())) {
            msg = msg + "NodeCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInstanceDefault(WfInstance wfWFInstance) {
        if (null == wfWFInstance) {
            return;
        }
        if (null == wfWFInstance.getDataState()) {
            wfWFInstance.setDataState(0);
        }
        if (null == wfWFInstance.getGmtCreate()) {
            wfWFInstance.setGmtCreate(this.getSysDate());
        }
        if (null == wfWFInstance.getInstanceDate()) {
            wfWFInstance.setInstanceDate(this.getSysDate());
        }
        wfWFInstance.setInstanceState(WorkflowConstants.STATE_WAIT_START);
        wfWFInstance.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wfWFInstance.getInstanceCode())) {
            wfWFInstance.setInstanceCode(this.getNo(null, WfInstance.class.getSimpleName(), "instanceCode", wfWFInstance.getTenantCode()));
        }
    }

    private void setInstanceUpdataDefault(WfInstance wfWFInstance) {
        if (null == wfWFInstance) {
            return;
        }
        wfWFInstance.setGmtModified(this.getSysDate());
    }

    private void saveInstanceModel(WfInstance wfWFInstance) throws ApiException {
        if (null == wfWFInstance) {
            return;
        }
        try {
            this.wfWFInstanceMapper.insert(wfWFInstance);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFInstanceServiceImpl.saveInstanceModel.ex", (Throwable)e);
            throw new ApiException("wf.WORKFLOW.WFInstanceServiceImpl.saveInstanceModel.ex");
        }
    }

    private WfInstance getInstanceModelById(Integer instanceId) {
        if (null == instanceId) {
            return null;
        }
        try {
            return this.wfWFInstanceMapper.selectByPrimaryKey(instanceId);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFInstanceServiceImpl.getInstanceModelById", (Throwable)e);
            return null;
        }
    }

    private WfInstance getInstanceModelByInstanceCode(String instanceCode, String tenantCode) {
        if (null == instanceCode) {
            return null;
        }
        try {
            return this.wfWFInstanceMapper.selectByInstanceCode(this.getQueryParamMap("instanceCode,tenantCode", new Object[]{instanceCode, tenantCode}));
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFInstanceServiceImpl.getInstanceModelById", (Throwable)e);
            return null;
        }
    }

    private WfInstance getInstanceModelByCode(String instanceCode, String tenantCode) {
        if (null == instanceCode) {
            return null;
        }
        try {
            return this.wfWFInstanceMapper.selectByCode(this.getQueryParamMap("instanceCode,tenantCode", new Object[]{instanceCode, tenantCode}));
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFInstanceServiceImpl.getInstanceModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteInstanceModel(Integer instanceId) throws ApiException {
        if (null == instanceId) {
            return;
        }
        int i = 0;
        try {
            i = this.wfWFInstanceMapper.deleteByPrimaryKey(instanceId);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFInstanceServiceImpl.deleteInstanceModel.ex");
        }
        if (1 != i) {
            throw new ApiException("wf.WORKFLOW.WFInstanceServiceImpl.deleteInstanceModel.num");
        }
    }

    private void updateInstanceModel(WfInstance wfWFInstance) throws ApiException {
        if (null == wfWFInstance) {
            return;
        }
        try {
            this.wfWFInstanceMapper.updateByPrimaryKeySelective(wfWFInstance);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFInstanceServiceImpl.updateInstanceModel.ex");
        }
    }

    private void updateStateInstanceModel(Integer instanceId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == instanceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceId", instanceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wfWFInstanceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFInstanceServiceImpl.updateStateInstanceModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("wf.WORKFLOW.WFInstanceServiceImpl.updateStateInstanceModel.null");
        }
    }

    private WfInstance makeInstance(WfInstanceDomain wfWFInstanceDomain, WfInstance wfWFInstance) {
        if (null == wfWFInstanceDomain) {
            return null;
        }
        if (null == wfWFInstance) {
            wfWFInstance = new WfInstance();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wfWFInstance, (Object)wfWFInstanceDomain);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFInstanceServiceImpl.makeInstance", (Throwable)e);
        }
        return wfWFInstance;
    }

    private List<WfInstance> queryInstanceModelPage(Map<String, Object> parammap) {
        try {
            return this.wfWFInstanceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFInstanceServiceImpl.queryInstanceModel", (Throwable)e);
            return null;
        }
    }

    private int countInstance(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wfWFInstanceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFInstanceServiceImpl.countInstance", (Throwable)e);
        }
        return i;
    }

    @Override
    public WfInstance saveInstance(WfInstanceDomain wfWFInstanceDomain) throws ApiException {
        String msg = this.checkInstance(wfWFInstanceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wf.WORKFLOW.WFInstanceServiceImpl.saveInstance.checkInstance", msg);
        }
        this.convertSpecialProperty(wfWFInstanceDomain);
        WfInstance wfWFInstance = this.makeInstance(wfWFInstanceDomain, null);
        this.setInstanceDefault(wfWFInstance);
        this.saveInstanceModel(wfWFInstance);
        return wfWFInstance;
    }

    private void convertSpecialProperty(WfInstanceDomain wfWFInstanceDomain) {
        String dataSource = wfWFInstanceDomain.getDataSource();
        if (StringUtils.isNotBlank((String)dataSource)) {
            wfWFInstanceDomain.setDataSource(dataSource.replace("#26#", "\"").replace("#34#", "\""));
        }
    }

    @Override
    public void updateInstanceState(Integer instanceId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateInstanceModel(instanceId, dataState, oldDataState);
    }

    @Override
    public void updateInstance(WfInstanceDomain wfWFInstanceDomain) throws ApiException {
        String msg = this.checkInstance(wfWFInstanceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wf.WORKFLOW.WFInstanceServiceImpl.updateInstance.checkInstance", msg);
        }
        WfInstance oldWfWFInstance = this.getInstanceModelById(wfWFInstanceDomain.getInstanceId());
        if (null == oldWfWFInstance) {
            throw new ApiException("wf.WORKFLOW.WFInstanceServiceImpl.updateInstance.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WfInstance wfWFInstance = this.makeInstance(wfWFInstanceDomain, oldWfWFInstance);
        this.setInstanceUpdataDefault(wfWFInstance);
        this.updateInstanceModel(wfWFInstance);
    }

    @Override
    public WfInstance getInstance(Integer instanceId) {
        return this.getInstanceModelById(instanceId);
    }

    @Override
    public WfInstance getInstanceByInstanceCode(String instanceCode, String tenantCode) {
        return this.getInstanceModelByInstanceCode(instanceCode, tenantCode);
    }

    @Override
    public WfInstance getInstanceByCode(String instanceCode, String tenantCode) {
        return this.getInstanceModelByCode(instanceCode, tenantCode);
    }

    @Override
    public void deleteInstance(Integer instanceId) throws ApiException {
        this.deleteInstanceModel(instanceId);
    }

    @Override
    public QueryResult<WfInstance> queryInstancePage(Map<String, Object> map) {
        List<WfInstance> wfWFInstanceList = this.queryInstanceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInstance(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wfWFInstanceList);
        return queryResult;
    }

    @Override
    public List<WfInstance> queryInstanceList(Map<String, Object> map) {
        List<WfInstance> wfWFInstanceList = this.queryInstanceModelPage(map);
        return wfWFInstanceList;
    }

    @Override
    public void autoWaitStartInstance() {
        List<WfInstance> wfWFInstanceList = this.queryInstanceModelPage(this.getQueryParamMap("instanceState", new Object[]{WorkflowConstants.STATE_WAIT_START}));
        if (ListUtil.isNotEmpty(wfWFInstanceList)) {
            for (WfInstance wfWFInstance : wfWFInstanceList) {
                try {
                    this.wFEngineService.insertWFEngine(wfWFInstance);
                }
                catch (Exception e) {
                    this.logger.error("wf.WORKFLOW.WFInstanceServiceImpl.autoWaitStartInstance", (Throwable)e);
                }
            }
        }
    }

    @Override
    public WfInstance saveInstanceSync(WfInstanceDomain wfWFInstanceDomain) throws ApiException {
        WfInstance wfWFInstance = this.saveInstance(wfWFInstanceDomain);
        this.wFEngineService.insertWFEngine(wfWFInstance);
        return wfWFInstance;
    }
}

