/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.workflow.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.workflow.dao.WfInstanceMapper;
import com.yqbsoft.laser.service.workflow.dao.WfNodeMapper;
import com.yqbsoft.laser.service.workflow.dao.WfNodeSlineMapper;
import com.yqbsoft.laser.service.workflow.dao.WfNodeStepMapper;
import com.yqbsoft.laser.service.workflow.domain.WfNodeDomain;
import com.yqbsoft.laser.service.workflow.domain.WfNodeReDomain;
import com.yqbsoft.laser.service.workflow.domain.WfNodeSlineDomain;
import com.yqbsoft.laser.service.workflow.domain.WfNodeSlineReDomain;
import com.yqbsoft.laser.service.workflow.domain.WfNodeStepDomain;
import com.yqbsoft.laser.service.workflow.domain.WfNodeStepReDomain;
import com.yqbsoft.laser.service.workflow.model.WfInstance;
import com.yqbsoft.laser.service.workflow.model.WfNode;
import com.yqbsoft.laser.service.workflow.model.WfNodeSline;
import com.yqbsoft.laser.service.workflow.model.WfNodeStep;
import com.yqbsoft.laser.service.workflow.service.WFNodeService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WFNodeServiceImpl
extends BaseServiceImpl
implements WFNodeService {
    public static final String SYS_CODE = "wf.WORKFLOW.WFNodeServiceImpl";
    private WfNodeMapper wfWFNodeMapper;
    private WfNodeStepMapper wfWFNodeStepMapper;
    private WfNodeSlineMapper wfWFNodeSlineMapper;
    private WfInstanceMapper wfWFInstanceMapper;

    public void setWfWFInstanceMapper(WfInstanceMapper wfWFInstanceMapper) {
        this.wfWFInstanceMapper = wfWFInstanceMapper;
    }

    public void setWfWFNodeStepMapper(WfNodeStepMapper wfWFNodeStepMapper) {
        this.wfWFNodeStepMapper = wfWFNodeStepMapper;
    }

    public void setWfWFNodeSlineMapper(WfNodeSlineMapper wfWFNodeSlineMapper) {
        this.wfWFNodeSlineMapper = wfWFNodeSlineMapper;
    }

    public void setWfWFNodeMapper(WfNodeMapper wfWFNodeMapper) {
        this.wfWFNodeMapper = wfWFNodeMapper;
    }

    private Date getSysDate() {
        try {
            return this.wfWFNodeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFNodeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkNode(WfNodeDomain wfWFNodeDomain) {
        if (null == wfWFNodeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setNodeDefault(WfNode wfWFNode) {
        if (null == wfWFNode) {
            return;
        }
        if (null == wfWFNode.getDataState()) {
            wfWFNode.setDataState(0);
        }
        if (null == wfWFNode.getGmtCreate()) {
            wfWFNode.setGmtCreate(this.getSysDate());
        }
        wfWFNode.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wfWFNode.getNodeCode())) {
            int code = this.getMaxCode();
            wfWFNode.setNodeCode(this.makeMaxCode8(++code));
        }
        if (StringUtils.isBlank((String)wfWFNode.getNodePcode())) {
            wfWFNode.setNodePcode(wfWFNode.getNodeCode());
        }
        wfWFNode.setNodeVersion(1);
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.wfWFNodeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFNodeServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private int getSlineMaxCode() {
        int code = 0;
        try {
            return this.wfWFNodeSlineMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFNodeServiceImpl.getSlineMaxCode", (Throwable)e);
            return code;
        }
    }

    private int getStepMaxCode() {
        int code = 0;
        try {
            return this.wfWFNodeStepMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFNodeServiceImpl.getStepMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setNodeUpdataDefault(WfNode wfWFNode) {
        if (null == wfWFNode) {
            return;
        }
        wfWFNode.setGmtModified(this.getSysDate());
    }

    private void saveNodeModel(WfNode wfWFNode) throws ApiException {
        if (null == wfWFNode) {
            return;
        }
        try {
            this.wfWFNodeMapper.insert(wfWFNode);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.saveFtpserverModel.ex");
        }
    }

    private WfNode getNodeModelById(Integer nodeId) {
        if (null == nodeId) {
            return null;
        }
        try {
            return this.wfWFNodeMapper.selectByPrimaryKey(nodeId);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFNodeServiceImpl.getNodeModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteNodeModel(Integer nodeId) throws ApiException {
        if (null == nodeId) {
            return;
        }
        int i = 0;
        try {
            i = this.wfWFNodeMapper.deleteByPrimaryKey(nodeId);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.deleteNodeModel.ex");
        }
        if (1 != i) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.deleteNodeModel.num");
        }
    }

    private void updateNodeModel(WfNode wfWFNode) throws ApiException {
        if (null == wfWFNode) {
            return;
        }
        try {
            this.wfWFNodeMapper.updateByPrimaryKeySelective(wfWFNode);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.updateNodeModel.ex");
        }
    }

    private void updateStateNodeModel(Integer nodeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == nodeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeId", nodeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wfWFNodeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.updateStateNodeModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.updateStateNodeModel.null");
        }
    }

    private WfNode makeNode(WfNodeDomain wfWFNodeDomain, WfNode wfWFNode) {
        if (null == wfWFNodeDomain) {
            return null;
        }
        if (null == wfWFNode) {
            wfWFNode = new WfNode();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wfWFNode, (Object)wfWFNodeDomain);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFNodeServiceImpl.makeNode", (Throwable)e);
        }
        return wfWFNode;
    }

    private List<WfNode> queryNodeModelPage(Map<String, Object> parammap) {
        try {
            return this.wfWFNodeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFNodeServiceImpl.queryNodeModel", (Throwable)e);
            return null;
        }
    }

    private int countNode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wfWFNodeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFNodeServiceImpl.countNode", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveNode(WfNodeDomain wfWFNodeDomain) throws ApiException {
        String msg = this.checkNode(wfWFNodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.saveNode.checkNode", msg);
        }
        WfNode wfWFNode = this.makeNode(wfWFNodeDomain, null);
        this.setNodeDefault(wfWFNode);
        this.saveNodeModel(wfWFNode);
    }

    private Map<String, String> saveNodeStep(WfNodeDomain wfWFNodeDomain, WfNode wFNode) {
        HashMap<String, String> wFNodeStepMap = new HashMap<String, String>();
        List<WfNodeStepDomain> wFNodeStepList = wfWFNodeDomain.getWfNodeStepDomainList();
        if (null == wFNodeStepList || wFNodeStepList.isEmpty()) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.saveNodeStep", "\u6d41\u7a0b\u6b65\u9aa4\u4e3a\u7a7a");
        }
        try {
            for (WfNodeStepDomain wfWFNodeStepDomain : wFNodeStepList) {
                WfNodeStep wFNodeStep = this.makeWFNodeStepModel(null, wfWFNodeStepDomain);
                wFNodeStep.setNodeCode(wFNode.getNodeCode());
                wFNodeStep.setNodeVersion(wFNode.getNodeVersion());
                this.wfWFNodeStepMapper.insert(wFNodeStep);
                wFNodeStepMap.put(wfWFNodeStepDomain.getNodeStepCode(), wFNodeStep.getNodeStepCode());
            }
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.saveNodeStep", "\u4fdd\u5b58\u6d41\u7a0b\u6b65\u9aa4\u8bbe\u7f6e\u5f02\u5e38");
        }
        return wFNodeStepMap;
    }

    private void saveNodeSline(WfNodeDomain wfWFNodeDomain, WfNode wFNode, Map<String, String> wFNodeStepMap) {
        List<WfNodeSlineDomain> wFNodeSlineList = wfWFNodeDomain.getWfNodeSlineDomainList();
        if (null == wFNodeSlineList || wFNodeSlineList.isEmpty()) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.saveNodeSline", "\u6d41\u7a0b\u6b65\u9aa4\u8fde\u7ebf\u4e3a\u7a7a");
        }
        try {
            for (WfNodeSlineDomain wfWFNodeSlineDomain : wFNodeSlineList) {
                WfNodeSline wFNodeSline = this.makeWFNodeSlineModel(null, wfWFNodeSlineDomain);
                wFNodeSline.setNodeFstepCode(wFNodeStepMap.get(wFNodeSline.getNodeFstepCode()));
                wFNodeSline.setNodeTstepCode(wFNodeStepMap.get(wFNodeSline.getNodeTstepCode()));
                wFNodeSline.setNodeCode(wFNode.getNodeCode());
                this.wfWFNodeSlineMapper.insert(wFNodeSline);
            }
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.saveNodeStep", "\u4fdd\u5b58\u8fde\u63a5\u7ebf\u8bbe\u7f6e\u5f02\u5e38");
        }
    }

    private WfNodeStep makeWFNodeStepModel(WfNodeStep wfWFNodeStep, WfNodeStepDomain wfWFNodeStepDomain) {
        if (wfWFNodeStepDomain == null) {
            return null;
        }
        if (wfWFNodeStep == null) {
            wfWFNodeStep = new WfNodeStep();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wfWFNodeStep, (Object)wfWFNodeStepDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank((String)wfWFNodeStep.getNodeStepCode())) {
            int code = this.getStepMaxCode();
            wfWFNodeStep.setNodeStepCode(this.makeMaxCode8(++code));
        }
        wfWFNodeStep.setGmtCreate(this.getSysDate());
        return wfWFNodeStep;
    }

    private WfNodeSline makeWFNodeSlineModel(WfNodeSline wFNodeSline, WfNodeSlineDomain wFNodeSlineDomain) {
        if (wFNodeSlineDomain == null) {
            return null;
        }
        if (wFNodeSline == null) {
            wFNodeSline = new WfNodeSline();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wFNodeSline, (Object)wFNodeSlineDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank((String)wFNodeSline.getNodeSlineCode())) {
            int code = this.getSlineMaxCode();
            wFNodeSline.setNodeSlineCode(this.makeMaxCode8(++code));
        }
        wFNodeSline.setGmtCreate(this.getSysDate());
        return wFNodeSline;
    }

    @Override
    public void updateNodeState(Integer nodeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateNodeModel(nodeId, dataState, oldDataState);
    }

    @Override
    public void updateNode(WfNodeDomain wfWFNodeDomain) throws ApiException {
        String msg = this.checkNode(wfWFNodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.updateNode.checkNode", msg);
        }
        WfNode oldWfWFNode = this.getNodeModelById(wfWFNodeDomain.getNodeId());
        if (null == oldWfWFNode) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.updateNode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WfNode wfWFNode = this.makeNode(wfWFNodeDomain, oldWfWFNode);
        this.setNodeUpdataDefault(wfWFNode);
        this.updateNodeModel(wfWFNode);
    }

    private void deleteNodeStepAndSline(String nodeCode) {
        try {
            this.wfWFNodeStepMapper.deleteByNodeCode(nodeCode);
            this.wfWFNodeSlineMapper.deleteByNodeCode(nodeCode);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.deleteNodeStepAndSline.ex", "\u5220\u9664\u6d41\u7a0b\u4e0b\u6b65\u9aa4\u5931\u8d25");
        }
    }

    private void updateWFNode(WfNode wFNode, WfNodeDomain wfWFNodeDomain) {
        wFNode.setNodeTitle(wfWFNodeDomain.getNodeTitle());
        wFNode.setNodeMocode(wfWFNodeDomain.getNodeMocode());
        wFNode.setNodeMoname(wfWFNodeDomain.getNodeMoname());
        wFNode.setNodeRemark(wfWFNodeDomain.getNodeRemark());
        wFNode.setGmtModified(this.getSysDate());
        try {
            this.wfWFNodeMapper.updateByPrimaryKey(wFNode);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFNodeServiceImpl.updateNode", "\u4fee\u6539\u6d41\u7a0b\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public Integer getInstanceCount(WfNode wfWFNode) {
        List<WfInstance> list = this.wfWFInstanceMapper.query(this.getQueryParamMap("nodeCode", new Object[]{wfWFNode.getNodeCode()}));
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    @Override
    public WfNodeReDomain getNode(Integer nodeId) {
        Integer dataState = 0;
        WfNode wfWFNode = this.getNodeModelById(nodeId);
        WfNodeReDomain wfWFNodeReDomain = this.makeWfWFNodeReDomain(wfWFNode);
        if (wfWFNodeReDomain == null) {
            return null;
        }
        wfWFNodeReDomain.setWfNodeStepReDomainList(this.makeWfWFNodeStepReDomainList(this.queryNodeStepModelPage(this.getQueryParamMap("nodeCode,tenantCode,dataState", new Object[]{wfWFNode.getNodeCode(), wfWFNode.getTenantCode(), dataState}))));
        wfWFNodeReDomain.setWfNodeSlineReDomainList(this.makeWfWFNodeSlineReDomainList(this.queryNodeSlineModelPage(this.getQueryParamMap("nodeCode,tenantCode,dataState", new Object[]{wfWFNode.getNodeCode(), wfWFNode.getTenantCode(), dataState}))));
        return wfWFNodeReDomain;
    }

    @Override
    public void deleteNode(Integer nodeId) throws ApiException {
        this.deleteNodeModel(nodeId);
    }

    @Override
    public QueryResult<WfNode> queryNodePage(Map<String, Object> map) {
        List<WfNode> wfWFNodeList = this.queryNodeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countNode(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wfWFNodeList);
        return queryResult;
    }

    @Override
    public List<WfNodeReDomain> queryNodeList(Map<String, Object> map) {
        List<WfNode> wfWFNodeList = this.queryNodeModelPage(map);
        List<WfNodeReDomain> wfWFNodeRetList = this.makeRetWfWFNodeList(wfWFNodeList);
        return wfWFNodeRetList;
    }

    private List<WfNodeReDomain> makeRetWfWFNodeList(List<WfNode> wfWFNodeList) {
        ArrayList<WfNodeReDomain> wfWFNodeRetList = new ArrayList<WfNodeReDomain>();
        if (null != wfWFNodeList && wfWFNodeList.size() > 0) {
            for (WfNode wfWFNode : wfWFNodeList) {
                int nodeId = wfWFNode.getNodeId();
                WfNodeReDomain wfWFNodeReDomain = this.getNode(nodeId);
                wfWFNodeRetList.add(wfWFNodeReDomain);
            }
        }
        return wfWFNodeRetList;
    }

    private List<WfNodeSline> queryNodeSlineModelPage(Map<String, Object> parammap) {
        try {
            return this.wfWFNodeSlineMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFNodeServiceImpl.queryNodeSlineModel", (Throwable)e);
            return null;
        }
    }

    private List<WfNodeStep> queryNodeStepModelPage(Map<String, Object> parammap) {
        try {
            return this.wfWFNodeStepMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFNodeServiceImpl.queryNodeStepModel", (Throwable)e);
            return null;
        }
    }

    private WfNodeReDomain makeWfWFNodeReDomain(WfNode wfWFNode) {
        if (wfWFNode == null) {
            return null;
        }
        WfNodeReDomain wfWFNodeReDomain = new WfNodeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wfWFNodeReDomain, (Object)wfWFNode);
        }
        catch (Exception e) {
            return null;
        }
        return wfWFNodeReDomain;
    }

    private WfNodeSlineReDomain makeWfWFNodeSlineReDomain(WfNodeSline wfWfNodeSline) {
        if (wfWfNodeSline == null) {
            return null;
        }
        WfNodeSlineReDomain wfWFNodeSlineReDomain = new WfNodeSlineReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wfWFNodeSlineReDomain, (Object)wfWfNodeSline);
        }
        catch (Exception e) {
            return null;
        }
        return wfWFNodeSlineReDomain;
    }

    private WfNodeStepReDomain makeWfWFNodeStepReDomain(WfNodeStep wfWFNodeStep) {
        if (wfWFNodeStep == null) {
            return null;
        }
        WfNodeStepReDomain wfWFNodeStepReDomain = new WfNodeStepReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wfWFNodeStepReDomain, (Object)wfWFNodeStep);
        }
        catch (Exception e) {
            return null;
        }
        return wfWFNodeStepReDomain;
    }

    private List<WfNodeStepReDomain> makeWfWFNodeStepReDomainList(List<WfNodeStep> wfWFNodeStepList) {
        ArrayList<WfNodeStepReDomain> list = new ArrayList<WfNodeStepReDomain>();
        if (wfWFNodeStepList != null && !wfWFNodeStepList.isEmpty()) {
            for (WfNodeStep wfWFNodeStep : wfWFNodeStepList) {
                list.add(this.makeWfWFNodeStepReDomain(wfWFNodeStep));
            }
        }
        return list;
    }

    private List<WfNodeSlineReDomain> makeWfWFNodeSlineReDomainList(List<WfNodeSline> wfWfNodeSlineList) {
        ArrayList<WfNodeSlineReDomain> list = new ArrayList<WfNodeSlineReDomain>();
        if (wfWfNodeSlineList != null && !wfWfNodeSlineList.isEmpty()) {
            for (WfNodeSline wfWFNodeSline : wfWfNodeSlineList) {
                list.add(this.makeWfWFNodeSlineReDomain(wfWFNodeSline));
            }
        }
        return list;
    }
}

