/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.dubbo;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;
import org.apache.dubbo.rpc.cluster.router.RouterResult;

public class AppRouter
extends AbstractRouter {
    private static final SupperLogUtil logger = new SupperLogUtil(AppRouter.class);
    private static final int INVOKERS_DEFAULT_PRIORITY = 180;

    public AppRouter() {
        this.setPriority(180);
    }

    public <T> RouterResult<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage) throws RpcException {
        if (ListUtil.isEmpty(invokers)) {
            return null;
        }
        Map urlMap = url.getAllParameters();
        logger.info("======1=====>", (Object)urlMap.toString());
        String appCode = RpcContext.getClientAttachment().getAttachment("application");
        String appCode1 = invocation.getAttachment("application");
        logger.info("======2=====>", (Object)(appCode + "=" + appCode1));
        ArrayList<Invoker<T>> resinvokers = new ArrayList<Invoker<T>>();
        for (Invoker<T> invoker : invokers) {
            String applicationName = invoker.getUrl().getRemoteApplication();
            logger.info("=====3======>", (Object)applicationName);
            if (!applicationName.equals(appCode)) continue;
            resinvokers.add(invoker);
        }
        return new RouterResult(resinvokers);
    }
}

