/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.dubbo;

import com.yqbsoft.laser.service.esb.core.router.ProxyInvokeSupport;
import com.yqbsoft.laser.service.esb.rest.dubboapi.service.DubboComService;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.MessageProducer;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.rpc.RpcContext;
import org.springframework.stereotype.Service;

@Service(value="dubboMessageProducer")
public class DubboMessageProducer
extends ProxyInvokeSupport
implements MessageProducer {
    @DubboReference(scope="remote", injvm=false, parameters={"router=appLocalStateRouter"})
    DubboComService dubboComService;

    public OutMessage channelSendMsg(InMessage inMessage) {
        if (null == inMessage || null == inMessage.getInvoke()) {
            return null;
        }
        inMessage.getAllParamMap().put("format", "json");
        inMessage.getAllParamMap().put("charset", "UTF-8");
        inMessage.setInvokeId(null);
        String url = "http://" + inMessage.getToRAppmanageIcode() + "/feignDirect/feign/post";
        String apiCode = (String)inMessage.getAllParamMap().get("method");
        url = url + "/" + apiCode;
        String tenantCode = (String)inMessage.getAllParamMap().get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "00000000";
        }
        url = url + "/" + tenantCode;
        long startime = System.currentTimeMillis();
        this.info("DubboMessageProducer.call.star", url);
        try {
            RpcContext.getClientAttachment().setAttachment("application", inMessage.getToRAppmanageIcode());
            OutMessage outMessage = this.dubboComService.postUrl(apiCode, tenantCode, inMessage);
            long endtime = System.currentTimeMillis();
            this.info("DubboMessageProducer.call.time", url + "\u8017\u65f6\u3010" + (endtime - startime) + "\u3011");
            return outMessage;
        }
        catch (Exception e) {
            this.logger.error("DubboMessageProducer.call.e", (Throwable)e);
            return new OutMessage("SERROR", "e");
        }
    }

    public static void main(String[] args) {
    }

    public void securityEncoder(InMessage inMessage) {
    }

    public void securityDecoder(OutMessage outMessage, InMessage inMessage) {
    }

    protected boolean isDispatchAdapter() {
        return true;
    }
}

