/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.feign;

import com.yqbsoft.laser.service.esb.core.router.ProxyInvokeSupport;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.MessageProducer;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="feignMessageProducer")
@Import(value={FeignClientsConfiguration.class})
public class FeignMessageProducer
extends ProxyInvokeSupport
implements MessageProducer {
    @Autowired
    RestTemplate restTemplate;

    public OutMessage channelSendMsg(InMessage inMessage) {
        if (null == inMessage || null == inMessage.getInvoke()) {
            return null;
        }
        HttpHeaders requestHeaders = new HttpHeaders();
        inMessage.getAllParamMap().put("format", "json");
        inMessage.getAllParamMap().put("charset", "UTF-8");
        requestHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        requestHeaders.set("Accept-Charset", "charset=UTF-8");
        requestHeaders.set("Accept", "*/*");
        HttpEntity requestEntity = new HttpEntity((Object)inMessage, (MultiValueMap)requestHeaders);
        inMessage.setInvokeId(null);
        String url = "http://" + inMessage.getToRAppmanageIcode() + "/feignDirect/feign/post";
        String apiCode = (String)inMessage.getAllParamMap().get("method");
        url = url + "/" + apiCode;
        String tenantCode = (String)inMessage.getAllParamMap().get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "00000000";
        }
        url = url + "/" + tenantCode;
        long startime = System.currentTimeMillis();
        this.info("FeignMessageProducer.call.star", url);
        try {
            OutMessage outMessage = (OutMessage)this.restTemplate.postForObject(url, (Object)requestEntity, OutMessage.class, new Object[0]);
            long endtime = System.currentTimeMillis();
            this.info("FeignMessageProducer.call.time", url + "\u8017\u65f6\u3010" + (endtime - startime) + "\u3011");
            return outMessage;
        }
        catch (Exception e) {
            this.logger.error("FeignMessageProducer.call.e", (Throwable)e);
            long endtime = System.currentTimeMillis();
            this.info("FeignMessageProducer.call.time1", url + "\u8017\u65f6\u3010" + (endtime - startime) + "\u3011");
            return new OutMessage("SERROR", "e");
        }
    }

    public static void main(String[] args) {
    }

    public void securityEncoder(InMessage inMessage) {
    }

    public void securityDecoder(OutMessage outMessage, InMessage inMessage) {
    }

    protected boolean isDispatchAdapter() {
        return true;
    }
}

