/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.feign;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.router.ProxyInvokeSupport;
import com.yqbsoft.laser.service.esb.rest.feignapi.controller.HttpFeign;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.MessageProducer;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import feign.Feign;
import feign.Request;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

@Service(value="feignMessageProducer")
@Import(value={FeignClientsConfiguration.class})
@RestController
public class FeignMessageProducer
extends ProxyInvokeSupport
implements MessageProducer {
    private static final OpenLogUtil logger = new OpenLogUtil(FeignMessageProducer.class);
    private static final String sys_code = "feign.adapter.producer";
    private Object lock = new Object();
    @Autowired
    Encoder encoder;
    @Autowired
    Decoder decoder;
    private static Map<String, HttpFeign> feignMap = new HashMap<String, HttpFeign>();

    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpFeign getHttpFeign(InMessage inMessage) {
        if (null == inMessage) {
            return null;
        }
        Invoke invoke = inMessage.getInvoke();
        String appmaagerIcode = invoke.getApiProperty().getAppmanageIcode();
        if (StringUtils.isBlank((String)appmaagerIcode)) {
            logger.error("feign.adapter.producer.getHttpFeign.appmaagerIcode", (Object)("appmaagerIcode:" + invoke.getApiRouterProperty().getAppapiCode() + "-ToRAppmanageIcode:" + inMessage.getToRAppmanageIcode() + "-ServletMain.getAppName():" + ServletMain.getAppName()));
            return null;
        }
        HttpFeign httpFeign = null;
        Object object = this.lock;
        synchronized (object) {
            httpFeign = feignMap.get(appmaagerIcode);
            if (null == httpFeign && null != (httpFeign = this.createHttpFeign(inMessage, this.encoder, this.decoder))) {
                feignMap.put(appmaagerIcode, httpFeign);
            }
        }
        return httpFeign;
    }

    public HttpFeign createHttpFeign(InMessage inMessage, Encoder encoder, Decoder decoder) {
        Feign.Builder builder = Feign.builder();
        builder = builder.encoder(encoder).decoder(decoder);
        builder = builder.options(new Request.Options(inMessage.getInvoke().getApiRouterProperty().getRouterConnecttimeout().intValue(), inMessage.getInvoke().getApiRouterProperty().getRouterReadtimeout().intValue())).retryer((Retryer)new Retryer.Default(500L, 500L, 5));
        return (HttpFeign)builder.target(HttpFeign.class, "http://" + inMessage.getToRAppmanageIcode());
    }

    public OutMessage channelSendMsg(InMessage inMessage) {
        Invoke invoke = inMessage.getInvoke();
        String api = invoke.getApiRouterProperty().getAppapiCode();
        HttpFeign httpFeign = this.getHttpFeign(inMessage);
        if (null == httpFeign) {
            return new OutMessage("feign.adapter.producer.channelSendMsg.httpFeign", "httpFeign:" + api);
        }
        return httpFeign.post(inMessage);
    }

    public void securityEncoder(InMessage inMessage) {
    }

    public void securityDecoder(OutMessage outMessage, InMessage inMessage) {
    }

    protected boolean isDispatchAdapter() {
        return true;
    }
}

