/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.http;

import com.yqbsoft.laser.service.adapter.http.OkHttpUtil;
import com.yqbsoft.laser.service.esb.core.auth.AuthUtil;
import com.yqbsoft.laser.service.esb.core.core.EsbReBean;
import com.yqbsoft.laser.service.esb.core.router.ProxyInvokeSupport;
import com.yqbsoft.laser.service.esb.core.transformer.InvokeIdParser;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.JsonReBean;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="httpTestInvokeService")
public class HttpTestInvokeService
extends ProxyInvokeSupport {
    private static final String sys_code = "adapter.http.HttpTestInvokeService";
    public static final Long REGEDIT_OVER_TIME = 60000L;

    public OutMessage channelSendMsg(InMessage inMessage) {
        if (null == inMessage || StringUtils.isBlank((String)inMessage.getLocalTestUrl())) {
            return new OutMessage("adapter.http.HttpTestInvokeService.empty", "\u4fe1\u606f\u4e3a\u7a7a");
        }
        OutMessage outMessage = new OutMessage();
        try {
            HashMap<String, String> params;
            Invoke invoke = inMessage.getInvoke();
            if (null != invoke.getRetParam()) {
                this.logger.error(sys_code, (Object)"============http request fileParams:");
            }
            if (null == (params = inMessage.getAllParamMap())) {
                params = new HashMap<String, String>();
            }
            InvokeIdParser.addInInvokeIdParamByHttp((Map)params, (InMessage)inMessage);
            String url = inMessage.getLocalTestUrl() + "/feignIr/http/post/" + invoke.getApiProperty().getAppapiCode() + "/" + "00000000";
            params.put("method", invoke.getApiProperty().getAppapiCode());
            params.put("version", "1.0");
            params.put("charset", "utf-8");
            this.logger.debug(sys_code, (Object)("http request url:" + url));
            this.logger.debug(sys_code, (Object)("http request params:" + params.keySet()));
            this.logger.debug(sys_code, (Object)("http request paramsvalue:" + JsonUtil.buildNormalBinder().toJson(params)));
            String chart = invoke.getApiRouterProperty().getRouterCharset();
            if (StringUtils.isBlank((String)chart)) {
                chart = "utf-8";
            }
            String rsp = OkHttpUtil.httpPost(url, params, "application/x-www-form-urlencoded;charset=" + chart, invoke.getApiRouterProperty().getRouterCharset(), invoke.getApiRouterProperty().getRouterConnecttimeout(), invoke.getApiRouterProperty().getRouterReadtimeout());
            this.logger.info(sys_code, (Object)("http rsp:" + rsp));
            if (StringUtils.isNotBlank((String)rsp)) {
                JsonReBean jrb = (JsonReBean)JsonUtil.buildNormalBinder().getJsonToObject(rsp, JsonReBean.class);
                if (null == jrb || !jrb.isSuccess()) {
                    outMessage.setErrorCode(jrb.getErrorCode());
                    outMessage.setMsg(jrb.getMsg());
                } else {
                    outMessage.setReObj(jrb.getDataObj());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(sys_code, (Throwable)e);
            outMessage.setErrorCode("adapter.http.HttpTestInvokeService.ex");
            outMessage.setMsg("\u8c03\u7528\u5f02\u5e38");
        }
        return outMessage;
    }

    public void securityEncoder(InMessage inMessage) {
        Map params = inMessage.getInvoke().getParams();
        if (MapUtil.isEmpty((Map)params)) {
            return;
        }
        String plainText = AuthUtil.getSignCheckContentV1((Map)params);
        String sign = AuthUtil.sendAuth((InMessage)inMessage, (String)plainText);
        inMessage.getInvoke().setSign(sign);
    }

    public void securityDecoder(OutMessage outMessage, InMessage inMessage) {
    }

    protected void handleInvokeId(InMessage inMessage, OutMessage outMessage) {
        EsbReBean jrb;
        String objectJson;
        Object reObject = outMessage.getReObj();
        if (reObject != null && StringUtils.isMapJson((String)(objectJson = reObject.toString())) && null != (jrb = (EsbReBean)JsonUtil.buildNormalBinder().getJsonToObject(objectJson, EsbReBean.class, new Class[]{String.class})) && null != jrb.getInvokeId()) {
            int level = jrb.getInvokeId().getMsgLevel();
            inMessage.getInvokeId().setMsgLevel(level);
        }
        super.handleInvokeId(inMessage, outMessage);
    }

    protected boolean isDispatchAdapter() {
        return true;
    }
}

