/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.http;

import com.yqbsoft.laser.service.esb.core.auth.AuthUtil;
import com.yqbsoft.laser.service.esb.core.core.EsbReBean;
import com.yqbsoft.laser.service.esb.core.router.ProxyInvokeSupport;
import com.yqbsoft.laser.service.esb.core.transformer.InvokeIdParser;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="httpgetInvokeService")
public class HttpgetInvokeService
extends ProxyInvokeSupport {
    private static final String sys_code = "ahttp.adapter.http.HttpInvoke";

    public OutMessage channelSendMsg(InMessage inMessage) {
        if (null == inMessage) {
            return new OutMessage("ahttp.adapter.http.HttpInvoke.empty", "\u4fe1\u606f\u4e3a\u7a7a");
        }
        OutMessage outMessage = new OutMessage();
        try {
            String rsp = null;
            Invoke invoke = inMessage.getInvoke();
            Map params = invoke.getParams();
            InvokeIdParser.addInInvokeIdParamByHttp((Map)params, (InMessage)inMessage);
            this.logger.error(sys_code, (Object)("http request url:" + invoke.getRouterServiceName()));
            this.logger.error(sys_code, (Object)("http request params:" + params));
            rsp = WebUtils.doGet((String)invoke.getRouterServiceName(), (Map)params);
            this.logger.error(sys_code, (Object)("http rsp:" + rsp));
            outMessage.setReObj((Object)rsp);
        }
        catch (Exception e) {
            this.logger.error(sys_code, (Object)("\u8c03\u7528\u5f02\u5e38,url:" + inMessage.getInvoke().getRouterServiceName() + ",param" + inMessage.getInvoke().getParams()), (Throwable)e);
            outMessage.setErrorCode("ahttp.adapter.http.HttpInvoke.ex");
            outMessage.setMsg("\u8c03\u7528\u5f02\u5e38");
        }
        return outMessage;
    }

    public void securityEncoder(InMessage inMessage) {
        Map params = inMessage.getInvoke().getParams();
        if (MapUtil.isEmpty((Map)params)) {
            return;
        }
        String plainText = AuthUtil.getSignCheckContentV1((Map)params);
        String sign = AuthUtil.sendAuth((InMessage)inMessage, (String)plainText);
        inMessage.getInvoke().setSign(sign);
    }

    public void securityDecoder(OutMessage outMessage, InMessage inMessage) {
        if (outMessage == null || inMessage == null) {
            return;
        }
        Map resultMap = null;
        if (outMessage.getReObj() == null) {
            return;
        }
        String resultJson = outMessage.getReObj().toString();
        if (!StringUtils.isMapJson((String)resultJson)) {
            return;
        }
        resultMap = JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, String.class);
        if (MapUtil.isEmpty((Map)resultMap)) {
            return;
        }
        String sign = (String)resultMap.get("sign");
        if (StringUtils.isEmpty((String)sign)) {
            this.logger.error(sys_code, (Object)"securityDecoder sign is null");
            return;
        }
        String plainText = AuthUtil.getSignCheckContentV1((Map)resultMap);
        boolean checkFlag = AuthUtil.returnAuthCheck((InMessage)inMessage, (String)plainText, (String)sign);
        if (!checkFlag) {
            this.logger.error(sys_code, (Object)("validate sign fail plainTest " + plainText));
        }
    }

    protected void handleInvokeId(InMessage inMessage, OutMessage outMessage) {
        EsbReBean jrb;
        String objectJson;
        Object reObject = outMessage.getReObj();
        if (reObject != null && StringUtils.isMapJson((String)(objectJson = reObject.toString())) && null != (jrb = (EsbReBean)JsonUtil.buildNormalBinder().getJsonToObject(objectJson, EsbReBean.class, new Class[]{String.class})) && null != jrb.getInvokeId()) {
            int level = jrb.getInvokeId().getMsgLevel();
            inMessage.getInvokeId().setMsgLevel(level);
        }
        super.handleInvokeId(inMessage, outMessage);
    }
}

