/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.http;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtil {
    protected final SupperLogUtil logger = new SupperLogUtil(OkHttpUtil.class);
    private static final MediaType FORM_CONTENT_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded;charset=utf-8");
    private static final OkHttpClient client = new OkHttpClient();

    public static String httpGet(String url, Map<String, String> httpParam, String ctype, String charset, int connectTimeout, int readTimeout) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (MapUtil.isNotEmpty(httpParam)) {
            String pstr = "";
            for (String key : httpParam.keySet()) {
                if (StringUtils.isNotBlank((String)pstr)) {
                    pstr = pstr + "&";
                }
                pstr = pstr + key + "=" + httpParam.get(key);
            }
            url = url + "?" + pstr;
        }
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request = new Request.Builder().url(url).get().addHeader("Content-Type", ctype).build();
        try {
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] args) {
    }

    public static String httpPost(String url, Map<String, String> httpParam, String ctype, String charset, int connectTimeout, int readTimeout) {
        if (ctype == null) {
            ctype = "application/x-www-form-urlencoded";
        }
        if (charset == null) {
            charset = "utf-8";
        }
        if (connectTimeout <= 0) {
            connectTimeout = 10000;
        }
        if (readTimeout <= 0) {
            readTimeout = 10000;
        }
        try {
            StringBuffer sb = new StringBuffer();
            if (httpParam != null && !httpParam.isEmpty()) {
                for (String key : httpParam.keySet()) {
                    String encodedValue = URLEncoder.encode(httpParam.get(key), charset);
                    sb.append(key + "=" + encodedValue + "&");
                }
            }
            RequestBody body = RequestBody.create((MediaType)FORM_CONTENT_TYPE, (String)sb.toString());
            Request request = new Request.Builder().post(body).addHeader("Content-Type", ctype).url(url).build();
            Response response = client.newCall(request).execute();
            return new String(response.body().bytes(), charset);
        }
        catch (IOException e) {
            throw new RuntimeException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1ahttpPost" + e);
        }
    }
}

