/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.dubboad;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.MapUtil;
import com.yqbsoft.laser.service.dubboad.PointUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.function.ThrowableConsumer;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;
import org.apache.dubbo.registry.nacos.NacosServiceDiscovery;
import org.apache.dubbo.registry.nacos.util.NacosNamingServiceUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class DubboNacosServiceDiscovery
extends NacosServiceDiscovery {
    private static final SupperLogUtil logger = new SupperLogUtil(DubboNacosServiceDiscovery.class);
    public static NacosNamingServiceWrapper namingServiceWrapper = null;
    private NacosNamingServiceWrapper namingService;
    @Autowired
    DiscoveryClient discoveryClient;

    public DubboNacosServiceDiscovery(ApplicationModel applicationModel, URL registryURL) {
        super(applicationModel, registryURL);
        namingServiceWrapper = this.namingService = NacosNamingServiceUtils.createNamingService((URL)registryURL);
    }

    public void doRegister(ServiceInstance serviceInstance) {
        ThrowableConsumer.execute((Object)this.namingService, service -> {
            Map serviceUrlMap;
            Instance instance = NacosNamingServiceUtils.toInstance((ServiceInstance)serviceInstance);
            HashMap<String, String> metadataMap = instance.getMetadata();
            if (null == metadataMap) {
                metadataMap = new HashMap<String, String>();
            }
            if (MapUtil.isEmpty((Map)(serviceUrlMap = this.getUrl().getAllParameters()))) {
                logger.error("DubboNacosServiceDiscovery.doRegister.serviceUrlMap.null");
            } else {
                block12: {
                    metadataMap.put("appTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    String appKey = (String)metadataMap.get("appKey");
                    if (StringUtils.isBlank((String)appKey)) {
                        appKey = "uuid";
                    }
                    if (appKey.indexOf("uuid") >= 0) {
                        appKey = UUID.randomUUID().toString();
                        metadataMap.put("appKey", appKey);
                    } else if (appKey.indexOf("ipPort") >= 0) {
                        // empty if block
                    }
                    metadataMap.put("type", (String)serviceUrlMap.get("type"));
                    metadataMap.put("routerDir", (String)serviceUrlMap.get("routerDir"));
                    RegeditBean regeditBean = RegeditUtil.make();
                    regeditBean.setApptype((String)serviceUrlMap.get("type"));
                    regeditBean.setRouterDir((String)serviceUrlMap.get("routerDir"));
                    regeditBean.setAppTenant("00000000");
                    regeditBean.setAppUuid(UUID.randomUUID().toString());
                    regeditBean.setAppIcode(regeditBean.getAppIcode());
                    regeditBean.setAppIp(instance.getIp());
                    regeditBean.setAppkey(appKey);
                    regeditBean.setAppPort(String.valueOf(instance.getPort()));
                    regeditBean.setAppVirIp(instance.getIp());
                    regeditBean.setLastDate(new Date());
                    try {
                        boolean postflag = PointUtils.doAddcache(regeditBean);
                        if (!postflag) {
                            logger.info("DubboNacosServiceDiscovery.doRegister.postflag", (Object)"error");
                            break block12;
                        }
                        logger.info("DubboNacosServiceDiscovery.doRegister.postflag", (Object)JsonUtil.buildNormalBinder().toJson((Object)regeditBean));
                    }
                    catch (Exception e) {
                        logger.error("DubboNacosServiceDiscovery.doRegister.e", (Throwable)e);
                    }
                }
                instance.setMetadata(metadataMap);
            }
            service.registerInstance(instance.getServiceName(), "DEFAULT_GROUP", instance);
        });
    }
}

