/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.dubboad;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.MapUtil;
import com.yqbsoft.laser.service.dubboad.DubboNacosServiceDiscovery;
import com.yqbsoft.laser.service.dubboad.PointUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.client.NopServiceDiscovery;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;
import org.apache.dubbo.registry.nacos.NacosRegistry;
import org.apache.dubbo.rpc.RpcException;

public class DubboNacosRegistry
extends NacosRegistry {
    private static final SupperLogUtil logger = new SupperLogUtil(DubboNacosRegistry.class);
    private static final String SERVICE_NAME_SEPARATOR = System.getProperty("nacos.service.name.separator", ":");
    private final NacosNamingServiceWrapper namingService;

    public DubboNacosRegistry(URL url, NacosNamingServiceWrapper namingService) {
        super(url, namingService);
        this.namingService = namingService;
    }

    private String getServiceName(URL url) {
        return this.getServiceName(url, url.getCategory("providers"));
    }

    private String getServiceName(URL url, String category) {
        return category + SERVICE_NAME_SEPARATOR + url.getColonSeparatedKey();
    }

    private Instance createInstance(URL url) {
        String category = url.getCategory("providers");
        URL newURL = url.addParameter("category", category);
        newURL = newURL.addParameter("protocol", url.getProtocol());
        newURL = newURL.addParameter("path", url.getPath());
        String ip = url.getHost();
        int port = url.getPort();
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setMetadata(new HashMap(newURL.getParameters()));
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRegister(URL url) {
        block22: {
            try {
                if ("provider".equals(url.getSide()) || this.getUrl().getParameter("register-consumer-url", false)) {
                    String serviceName = this.getServiceName(url);
                    Instance instance = this.createInstance(url);
                    List serviceDiscoveryList = this.registryManager.getServiceDiscoveries();
                    if (ListUtil.isEmpty((Collection)serviceDiscoveryList)) {
                        logger.error("DubboNacosRegistry.doRegister.serviceDiscoveryList.null");
                    }
                    DubboNacosServiceDiscovery serviceDiscoveryRegistry = null;
                    if (serviceDiscoveryList.get(0) instanceof DubboNacosServiceDiscovery) {
                        serviceDiscoveryRegistry = (DubboNacosServiceDiscovery)((Object)serviceDiscoveryList.get(0));
                    } else if (serviceDiscoveryList.get(0) instanceof NopServiceDiscovery) {
                        serviceDiscoveryRegistry = (NopServiceDiscovery)serviceDiscoveryList.get(0);
                    }
                    if (null == serviceDiscoveryRegistry) {
                        logger.error("DubboNacosRegistry.doRegister.serviceDiscoveryRegistry.null");
                    } else {
                        Map serviceUrlMap;
                        HashMap<String, String> metadataMap = instance.getMetadata();
                        if (null == metadataMap) {
                            metadataMap = new HashMap<String, String>();
                        }
                        if (MapUtil.isEmpty((Map)(serviceUrlMap = serviceDiscoveryRegistry.getUrl().getAllParameters()))) {
                            logger.error("DubboNacosRegistry.doRegister.serviceUrlMap.null");
                        } else {
                            block21: {
                                metadataMap.put("appTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                String appKey = (String)metadataMap.get("appKey");
                                if (StringUtils.isBlank((String)appKey)) {
                                    appKey = "uuid";
                                }
                                if (appKey.indexOf("uuid") >= 0) {
                                    appKey = UUID.randomUUID().toString();
                                    metadataMap.put("appKey", appKey);
                                } else if (appKey.indexOf("ipPort") >= 0) {
                                    // empty if block
                                }
                                metadataMap.put("type", (String)serviceUrlMap.get("type"));
                                metadataMap.put("routerDir", (String)serviceUrlMap.get("routerDir"));
                                RegeditBean regeditBean = RegeditUtil.make();
                                regeditBean.setApptype((String)serviceUrlMap.get("type"));
                                regeditBean.setRouterDir((String)serviceUrlMap.get("routerDir"));
                                regeditBean.setAppTenant("00000000");
                                regeditBean.setAppUuid(UUID.randomUUID().toString());
                                regeditBean.setAppIcode(regeditBean.getAppIcode());
                                regeditBean.setAppIp(instance.getIp());
                                regeditBean.setAppkey(appKey);
                                regeditBean.setAppPort(String.valueOf(instance.getPort()));
                                regeditBean.setAppVirIp(instance.getIp());
                                regeditBean.setLastDate(new Date());
                                try {
                                    boolean postflag = PointUtils.doAddcache(regeditBean);
                                    if (!postflag) {
                                        logger.info("DubboNacosRegistry.doRegister.postflag", (Object)"error");
                                        break block21;
                                    }
                                    logger.info("DubboNacosRegistry.doRegister.postflag", (Object)JsonUtil.buildNormalBinder().toJson((Object)regeditBean));
                                }
                                catch (Exception e) {
                                    logger.error("DubboNacosRegistry.doRegister.e", (Throwable)e);
                                }
                            }
                            instance.setMetadata(metadataMap);
                        }
                    }
                    this.namingService.registerInstance(serviceName, this.getUrl().getGroup("DEFAULT_GROUP"), instance);
                    break block22;
                }
                logger.info("Please set 'dubbo.registry.parameters.register-consumer-url=true' to turn on consumer url registration.");
            }
            catch (Throwable cause) {
                throw new RpcException("Failed to register " + url + " to nacos " + this.getUrl() + ", cause: " + cause.getMessage(), cause);
            }
        }
    }
}

