/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.dubboad;

import com.yqbsoft.laser.service.dubboad.PointUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;

public class ServletPoint {
    private static final SupperLogUtil logger = new SupperLogUtil(ServletPoint.class);
    @Autowired
    RegeditUtil regeditUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void contextInitialized() {
        String ip = "";
        RegeditBean regeditBean = RegeditUtil.make();
        regeditBean.setContextPath("/");
        String appkeyStr = regeditBean.getAppkey();
        if (StringUtils.isNotBlank((String)appkeyStr)) {
            Random r = new Random();
            appkeyStr = appkeyStr.replace("{ip}", ip + "-" + r.nextInt(10));
            appkeyStr = appkeyStr.replace("{uuid}", ip + "-" + r.nextInt(10));
            appkeyStr = appkeyStr.replace("{ipPort}", ip + "-" + regeditBean.getAppPort());
        } else {
            appkeyStr = ip + "-" + regeditBean.getAppPort();
        }
        regeditBean.setAppkey(appkeyStr);
        logger.info("ServletPoint", (Object)("server start appKey = " + regeditBean.getAppkey()));
        try {
            regeditBean = this.getRegeditBeanOne(regeditBean);
            boolean postflag = PointUtils.doAddcache(regeditBean);
            if (!postflag) {
                // empty if block
            }
        }
        catch (Exception sendMsg) {
        }
        finally {
            SendMsg sendMsg = new SendMsg(regeditBean);
            sendMsg.start();
        }
    }

    public RegeditBean getRegeditBeanOne(RegeditBean regeditBean) {
        if (null == regeditBean || StringUtils.isBlank((String)regeditBean.getAppIcode()) || StringUtils.isBlank((String)regeditBean.getAppkey())) {
            logger.error("ServletPoint.getRegeditBeanOne");
            return null;
        }
        List list = this.regeditUtil.getServiceInstance(regeditBean.getAppIcode());
        if (ListUtil.isEmpty((Collection)list)) {
            logger.error("ServletPoint.getRegeditBeanOne.getAppIcode", (Object)regeditBean.getAppIcode());
            return regeditBean;
        }
        String key = "";
        for (ServiceInstance serviceInstance : list) {
            key = this.regeditUtil.getAppanageKey(serviceInstance);
            if (!regeditBean.getAppkey().equals(key)) continue;
            regeditBean = new RegeditBean();
            regeditBean.setAppTenant("00000000");
            regeditBean.setAppUuid(key);
            regeditBean.setAppIcode(regeditBean.getAppIcode());
            regeditBean.setAppIp(serviceInstance.getHost());
            regeditBean.setRouterDir((String)serviceInstance.getMetadata().get("routerDir"));
            regeditBean.setAppkey(key);
            regeditBean.setAppPort(String.valueOf(serviceInstance.getPort()));
            regeditBean.setAppVirIp(serviceInstance.getHost());
            regeditBean.setLastDate(new Date());
            return regeditBean;
        }
        logger.error("ServletPoint.getRegeditBeanOne.regeditBean", (Object)(regeditBean.getAppIcode() + "=" + key));
        return regeditBean;
    }

    public String getLocalIp() {
        try {
            InetAddress inetAddress = this.getLocalHostLANAddress();
            if (null == inetAddress) {
                return null;
            }
            return inetAddress.getHostAddress();
        }
        catch (Exception e) {
            logger.error("ServletPoint.getLocalIp.e", (Throwable)e);
            return null;
        }
    }

    public InetAddress getLocalHostLANAddress() throws Exception {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            logger.error("ServletPoint.getLocalHostLANAddress.e", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            Random r = new Random();
            System.out.println(r.nextInt(10));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class SendMsg
    extends Thread {
        private RegeditBean regeditBean;

        SendMsg(RegeditBean regeditBean) {
            this.regeditBean = regeditBean;
        }

        @Override
        public void run() {
            boolean flag = true;
            while (flag) {
                try {
                    this.regeditBean.setLastDate(new Date());
                    boolean postflag = PointUtils.doAddcache(this.regeditBean);
                    if (postflag) continue;
                }
                catch (Exception exception) {}
                continue;
                finally {
                    try {
                        SendMsg.sleep(3000L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

