/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.rest.bank.controller;

import com.yqbsoft.laser.service.esb.core.netty.ConnServerProperty;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.rest.controller.HttpSupper;
import com.yqbsoft.laser.service.esb.rest.controller.HttpUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.VfinOpenConstants;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/laserBank"})
public class BankHttpController
extends HttpSupper {
    private static final SupperLogUtil logger = new SupperLogUtil(BankHttpController.class);
    private static final String ROUTER_ERROR = "-1";
    private static final long serialVersionUID = -3303989459344719626L;

    @RequestMapping(value={"/http/post/{icode}/{fchannelCode}/{fchannelConfigScope}/{tenantCode}"}, method={RequestMethod.POST})
    public void execute(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="fchannelConfigScope") String fchannelConfigScope, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, fchannelCode, fchannelConfigScope, tenantCode, resStream);
    }

    @RequestMapping(value={"/http/post/{icode}/{fchannelCode}/{tenantCode}"}, method={RequestMethod.POST})
    public void execute(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, fchannelCode, "", tenantCode, resStream);
    }

    @RequestMapping(value={"/http/post/{icode}/{fchannelCode}/{fchannelConfigScope}/{type}/{tenantCode}"}, method={RequestMethod.POST})
    public void execute(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="type") String type, @PathVariable(value="fchannelConfigScope") String fchannelConfigScope, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, fchannelCode, fchannelConfigScope, tenantCode, resStream, type, null);
    }

    @RequestMapping(value={"/httprouter/post/{icode}/{fchannelCode}/{fchannelConfigScope}/{msgType}/{tenantCode}"}, method={RequestMethod.POST})
    public void executeRouter(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="msgType") String msgType, @PathVariable(value="fchannelConfigScope") String fchannelConfigScope, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, fchannelCode, fchannelConfigScope, tenantCode, resStream, null, msgType);
    }

    private void execl(HttpServletRequest request, HttpServletResponse response, String icode, String fchannelCode, String fchannelConfigScope, String tenantCode, String resStream) {
        this.execl(request, response, icode, fchannelCode, fchannelConfigScope, tenantCode, resStream, null, null);
    }

    private void execl(HttpServletRequest request, HttpServletResponse response, String icode, String fchannelCode, String fchannelConfigScope, String tenantCode, String resStream, String type, String msgType) {
        String routerDire = this.injectionRouterDire(icode);
        logger.info("\u94f6\u884c\u56de\u8c03\uff1a[" + type + "=" + fchannelConfigScope + "]postData[" + JsonUtil.buildNormalBinder().toJson((Object)request.getParameterMap()) + "]stream:[" + resStream + "]");
        if (StringUtils.isNotBlank((String)resStream) && (fchannelCode.indexOf("wechat") > -1 || fchannelCode.indexOf("pingan") > -1 || fchannelCode.indexOf("jd") > -1 || fchannelCode.indexOf("wallet") > -1 || fchannelCode.indexOf("ccbhsbpay") > -1)) {
            request.setAttribute("resStream", (Object)this.NotifyHandler(request, fchannelCode, resStream));
        }
        request.setAttribute("resHeader", (Object)request.getHeader("x-pab-signature"));
        request.removeAttribute("app_id");
        request.setAttribute("app_id", (Object)"");
        request.setAttribute(HttpUtil.BANK_SCOPE, (Object)fchannelConfigScope);
        request.setAttribute(HttpUtil.BANK_CHANNELCODE, (Object)fchannelCode);
        request.setAttribute(HttpUtil.BANK_TENANTCODE, (Object)tenantCode);
        String api = "cmc.channelCall.bankChannelCallFormal";
        if (StringUtils.isNotBlank((String)type)) {
            api = type;
        }
        request.setAttribute("method", (Object)api);
        request.setAttribute("version", (Object)"1.0");
        request.setAttribute(HttpUtil.BANK_MSGTYPE, (Object)msgType);
        this.invoke(request, response, routerDire);
    }

    @RequestMapping(value={"/http/get/{icode}/{fchannelCode}/{fchannelConfigScope}/{type}/{tenantCode}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="type") String type, @PathVariable(value="fchannelConfigScope") String fchannelConfigScope, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, fchannelCode, fchannelConfigScope, tenantCode, resStream, type, null);
    }

    @RequestMapping(value={"/http/get/{icode}/{fchannelCode}/{fchannelConfigScope}/{tenantCode}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="fchannelConfigScope") String fchannelConfigScope, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, fchannelCode, fchannelConfigScope, tenantCode, resStream);
    }

    @RequestMapping(value={"/http/get/{icode}/{fchannelCode}/{tenantCode}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, fchannelCode, "", tenantCode, resStream);
    }

    private String injectionRouterDire(String icode) {
        if (StringUtils.isBlank((String)icode)) {
            return ROUTER_ERROR;
        }
        Map cspMap = LocalCache.getConnServerMap();
        if (MapUtil.isEmpty((Map)cspMap)) {
            return ROUTER_ERROR;
        }
        List cspList = (List)cspMap.get(VfinOpenConstants.SERVER_TYPE_HTTP);
        if (ListUtil.isEmpty((Collection)cspList)) {
            return ROUTER_ERROR;
        }
        for (ConnServerProperty connServerProperty : cspList) {
            if (!icode.equals(connServerProperty.getConnIcode())) continue;
            Integer routerDire = connServerProperty.getRouterDire();
            if (routerDire == null) {
                return ROUTER_ERROR;
            }
            return routerDire.toString();
        }
        return ROUTER_ERROR;
    }

    public Set<String> getIgnoreKey() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("app_id");
        keys.add("version");
        return keys;
    }

    private String NotifyHandler(HttpServletRequest request, String fChannelCode, String resStream) {
        if (fChannelCode.indexOf("jd") > -1 && !fChannelCode.equals("jdduolabao")) {
            HashMap<String, String> jdHeaders = new HashMap<String, String>();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                String value = request.getHeader(key);
                jdHeaders.put(key, value);
            }
            Map jsonToMap = JsonUtil.buildNonNullBinder().getJsonToMap(resStream, String.class, String.class);
            jdHeaders.put("encrypt", (String)jsonToMap.get("encrypt"));
            return JsonUtil.buildNonNullBinder().toJson(jdHeaders);
        }
        return resStream;
    }
}

