/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.plugin;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.internal.types.JavaTypeResolverDefaultImpl;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.logging.Log;
import org.mybatis.generator.logging.LogFactory;

public class MoneyResolverImpl
extends JavaTypeResolverDefaultImpl {
    protected boolean forceMoney;
    protected String moneyColumnNamePattern;
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Pattern pattern = null;

    public void addConfigurationProperties(Properties properties) {
        super.addConfigurationProperties(properties);
        this.forceMoney = StringUtility.isTrue((String)properties.getProperty("forceMoney"));
        this.moneyColumnNamePattern = properties.getProperty("moneyClumnPattern");
        if (this.moneyColumnNamePattern != null) {
            this.pattern = Pattern.compile(this.moneyColumnNamePattern);
        }
        this.log.debug("MoneyResolver,forceMoney:" + this.forceMoney);
        this.log.debug("MoneyResolver,moneyColumnNamePattern:" + this.moneyColumnNamePattern);
    }

    public FullyQualifiedJavaType calculateJavaType(IntrospectedColumn introspectedColumn) {
        Matcher matcher;
        FullyQualifiedJavaType answer = super.calculateJavaType(introspectedColumn);
        if (2 != introspectedColumn.getJdbcType() && 3 != introspectedColumn.getJdbcType() || introspectedColumn.getScale() < 2 || introspectedColumn.getLength() < 15 || !this.forceMoney || this.pattern == null || (matcher = this.pattern.matcher(introspectedColumn.getActualColumnName())).find()) {
            // empty if block
        }
        this.log.debug("answer:" + answer);
        return answer;
    }
}

