/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.pre0;

import com.yqbsoft.laser.service.esb.core.handler.InvokeContext;
import com.yqbsoft.laser.service.esb.core.handler.InvokeHandlerUnit;
import com.yqbsoft.laser.service.esb.core.handler.InvokeResult;
import com.yqbsoft.laser.service.route.rule.service.AccessLimitService;
import com.yqbsoft.laser.service.suppercore.router.ApiRouterProperty;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service(value="apiLimiterValidator")
public class ApiLimiterValidator
implements InvokeHandlerUnit {
    private Map<String, AccessLimitService> accessLimitMap = new ConcurrentHashMap<String, AccessLimitService>();

    public InvokeResult execute(InvokeContext context) throws Exception {
        String apiKey;
        AccessLimitService accessLimitService;
        if (null == context) {
            return new InvokeResult();
        }
        ApiRouterProperty apiRouterProperty = context.getApiRouterProperty();
        if (null == apiRouterProperty) {
            return new InvokeResult();
        }
        Integer routerLimiter = apiRouterProperty.getRouterLimiter();
        if (null == routerLimiter || routerLimiter <= 0) {
            new InvokeResult();
        }
        if (null == (accessLimitService = this.accessLimitMap.get(apiKey = context.getApiKey()))) {
            accessLimitService = new AccessLimitService(Double.valueOf(String.valueOf(routerLimiter)));
            this.accessLimitMap.put(apiKey, accessLimitService);
        }
        if (!accessLimitService.tryAcquire()) {
            return new InvokeResult("rorl.ROUTE.RULE.rule.check", "API\u9650\u6d41[" + routerLimiter + "]");
        }
        return new InvokeResult();
    }
}

