/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.pre0;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.handler.InvokeContext;
import com.yqbsoft.laser.service.esb.core.handler.InvokeHandlerUnit;
import com.yqbsoft.laser.service.esb.core.handler.InvokeResult;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.stereotype.Service;

@Service(value="timestampValidator")
public class TimestampValidator
implements InvokeHandlerUnit {
    private static final TimeZone defaultTimeZone = TimeZone.getTimeZone("GMT+8");

    public InvokeResult execute(InvokeContext context) throws ApiException {
        InvokeResult vr = new InvokeResult();
        InMessage inMessage = context.getInMessage();
        String timestamp = inMessage.getParam("timestamp");
        if (StringUtils.isBlank((String)timestamp)) {
            return new InvokeResult("rorl.ROUTE.RULE.rule.check", "\u65f6\u95f4\u6233\u4e3a\u7a7a\uff01");
        }
        Date inDate = null;
        try {
            inDate = DateUtils.parseDate((String)timestamp, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            throw new ApiException("rorl.ROUTE.RULE.rule.check", "\u65f6\u95f4\u89e3\u6790\u5f02\u5e38\uff01", (Throwable)e);
        }
        Calendar calendar = Calendar.getInstance(defaultTimeZone);
        Date nowDate = calendar.getTime();
        if (nowDate.getTime() - inDate.getTime() > DateUtils.MINUTES_TEN || nowDate.getTime() - inDate.getTime() < -DateUtils.MINUTES_TEN.longValue()) {
            return new InvokeResult("rorl.ROUTE.RULE.rule.check", "\u65f6\u95f4\u4e0d\u5408\u6cd5");
        }
        return vr;
    }
}

