/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.pre1;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.Auth;
import com.yqbsoft.laser.service.esb.core.auth.AuthUtil;
import com.yqbsoft.laser.service.esb.core.auth.RouteRule;
import com.yqbsoft.laser.service.esb.core.handler.InvokeContext;
import com.yqbsoft.laser.service.esb.core.handler.InvokeHandlerUnit;
import com.yqbsoft.laser.service.esb.core.handler.InvokeResult;
import com.yqbsoft.laser.service.route.rule.util.AuthHelper;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="signValidator")
public class SignValidator
implements InvokeHandlerUnit {
    public InvokeResult execute(InvokeContext context) throws ApiException {
        InvokeResult vr = new InvokeResult();
        try {
            InMessage inMessage = context.getInMessage();
            String sign_type = inMessage.getParam("sign_type");
            if (StringUtils.isBlank((String)sign_type)) {
                return new InvokeResult("rorl.ROUTE.RULE.rule.check", "sign_type is null!");
            }
            if (!sign_type.equals("RSA")) {
                return new InvokeResult();
            }
            RouteRule rule = context.getRouteRule();
            String sign = inMessage.getParam("sign");
            if (StringUtils.isBlank((String)sign)) {
                return new InvokeResult("rorl.ROUTE.RULE.rule.check", "strict validate fail,sign is null!");
            }
            Auth auth = new Auth();
            auth.setKey(AuthUtil.getSignCheckContentV1((Map)inMessage.getAllParamMap()));
            auth.setValue(sign);
            auth.setType("0");
            if (!AuthHelper.checkAuth(inMessage, auth, context.getInAppProperty(), rule.isStrict(), context.getApiAppProperty())) {
                return new InvokeResult("rorl.ROUTE.RULE.rule.check", "\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            throw new ApiException("rorl.ROUTE.RULE.rule.check", "\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38\uff01", (Throwable)e);
        }
        return vr;
    }
}

