/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.ret;

import com.yqbsoft.laser.service.esb.core.handler.InvokeContext;
import com.yqbsoft.laser.service.esb.core.handler.InvokeHandlerUnit;
import com.yqbsoft.laser.service.esb.core.handler.InvokeResult;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service(value="flowSendFilter")
public class FlowSendFilter
implements InvokeHandlerUnit {
    private static final String TRADE_TYPE_TRANS = "01";
    private static final String TRADE_TYPE_AUTH = "";
    private static final String TRADE_TYPE_STAG = "";
    private InternalRouter internalRouter;

    public void setInternalRouter(InternalRouter internalRouter) {
        this.internalRouter = internalRouter;
    }

    public InternalRouter getInternalRouter() {
        return this.internalRouter;
    }

    public InvokeResult execute(InvokeContext context) throws Exception {
        OutMessage outMessage = context.getOutMessage();
        InvokeResult vr = new InvokeResult();
        if (StringUtils.isNotBlank((String)outMessage.getErrorCode()) || StringUtils.isNotBlank((String)outMessage.getSubCode())) {
            return vr;
        }
        Map txnMsg = (Map)JsonUtil.buildNormalBinder().getJsonToMap(outMessage.getReObj().toString(), String.class, String.class);
        if (!"00".equals(txnMsg.get("respCode"))) {
            return vr;
        }
        ConcurrentHashMap<String, Object> paramMap = new ConcurrentHashMap<String, Object>();
        ConcurrentHashMap flowEventMap = new ConcurrentHashMap();
        flowEventMap.put("payee", txnMsg.get("cardAccptrId"));
        flowEventMap.put("terminalNO", txnMsg.get("cardAccptrTermnlId"));
        String transCategory = ((String)txnMsg.get("txnNum")).substring(1, 3);
        if (TRADE_TYPE_TRANS.equals(transCategory)) {
            flowEventMap.put("tradeType", "");
        } else if ("11".equals(transCategory)) {
            flowEventMap.put("tradeType", "");
        } else {
            flowEventMap.put("tradeType", TRADE_TYPE_TRANS);
        }
        String txnNumType = ((String)txnMsg.get("txnNum")).substring(0, 1);
        if ("1".equals(txnNumType)) {
            flowEventMap.put("countDirection", "P");
        } else if ("2".equals(txnNumType) || "3".equals(txnNumType) || "4".equals(txnNumType)) {
            flowEventMap.put("countDirection", "N");
        } else {
            flowEventMap.put("countDirection", "U");
        }
        paramMap.put("flowEvent", JsonUtil.buildNormalBinder().toJson(flowEventMap));
        Thread thread = new Thread(new SendThread(paramMap));
        thread.start();
        return vr;
    }

    class SendThread
    implements Runnable {
        private Map<String, Object> paramMap = new ConcurrentHashMap<String, Object>();

        public SendThread(Map<String, Object> paramMap) {
            this.paramMap = paramMap;
        }

        @Override
        public void run() {
            boolean reObject;
            Map rspMap;
            Object object = FlowSendFilter.this.internalRouter.inInvoke("rorl.integration.flow.push", "1.0", "0", this.paramMap);
            if (object == null || !MapUtil.isNotEmpty((Map)(rspMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(object.toString(), String.class, Object.class))) || !(reObject = ((Boolean)rspMap.get("success")).booleanValue())) {
                // empty if block
            }
        }
    }
}

