/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.ret;

import com.yqbsoft.laser.service.esb.core.handler.InvokeContext;
import com.yqbsoft.laser.service.esb.core.handler.InvokeHandlerUnit;
import com.yqbsoft.laser.service.esb.core.handler.InvokeResult;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.core.router.MarketApiLink;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.router.ApiProperty;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service(value="marketingProcessor")
public class MarketingProcessor
implements InvokeHandlerUnit {
    private static final OpenLogUtil logger = new OpenLogUtil(MarketingProcessor.class);
    private static final String SYS_CODE = "MarketingProcessor";
    private static final String SPLIT = ",";
    private InternalRouter internalRouter;

    public void setInternalRouter(InternalRouter internalRouter) {
        this.internalRouter = internalRouter;
    }

    public InvokeResult execute(InvokeContext context) throws Exception {
        Map marketApiLinkMap;
        InMessage inMessage = context.getInMessage();
        OutMessage outMessage = context.getOutMessage();
        logger.debug(SYS_CODE, (Object)"execute start");
        if (!outMessage.isSuccess() || !outMessage.isOpSuccess()) {
            return new InvokeResult();
        }
        String appmanageAppkey = inMessage.getParam("app_id");
        logger.debug(SYS_CODE, (Object)("appmanageAppkey = " + appmanageAppkey));
        if (StringUtils.isBlank((String)appmanageAppkey)) {
            appmanageAppkey = inMessage.getNowAppmanageIcode();
            inMessage.getAllParamMap().put("app_id", appmanageAppkey);
        }
        String nowAppicode = ServletMain.getAppName();
        AppProperty appProperty = this.getPAppProperty(context);
        if (appProperty == null) {
            logger.debug(SYS_CODE, (Object)"appProperty is null");
            return new InvokeResult();
        }
        String apiAppPcode = appProperty.getAppmanagePicode();
        logger.debug(SYS_CODE, (Object)("nowAppicode = " + nowAppicode + "&apiAppPcode = " + apiAppPcode));
        if (!nowAppicode.equals(apiAppPcode)) {
            // empty if block
        }
        if (MapUtil.isEmpty((Map)(marketApiLinkMap = LocalCache.getMarketApiLinkMap()))) {
            logger.debug(SYS_CODE, (Object)"marketApiLinkMap is null");
            return new InvokeResult();
        }
        List marketApiLinkList = (List)marketApiLinkMap.get(appmanageAppkey);
        if (ListUtil.isEmpty((Collection)marketApiLinkList)) {
            return new InvokeResult();
        }
        String nowAppapiCode = inMessage.getParam("method");
        logger.debug(SYS_CODE, (Object)("nowAppapiCode = " + nowAppapiCode));
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        HashMap<String, String> allParamMap = new HashMap<String, String>();
        allParamMap.putAll(inMessage.getSysParamMap());
        for (String key : inMessage.getAllParamMap().keySet()) {
            Object o = inMessage.getAllParamMap().get(key);
            String obj = "";
            if (!(o instanceof String)) {
                obj = o.toString();
            }
            if (StringUtils.isMapJson((String)obj)) {
                JsonUtil.buildNormalBinder();
                allParamMap.putAll(JsonUtil.getJsonToMap((String)obj));
                continue;
            }
            allParamMap.put(key, obj);
        }
        if (outMessage.getReObj() != null) {
            allParamMap.put("reObj", outMessage.getReObj().toString());
        }
        boolean flag = false;
        String ruleNo = "";
        String apilistNo = "";
        for (MarketApiLink marketApiLink : marketApiLinkList) {
            String[] appapiCodes;
            String appapiCode = marketApiLink.getAppapiCode();
            if (StringUtils.isBlank((String)appapiCode) || !marketApiLink.getTenantCode().equals(allParamMap.get("tenantCode"))) continue;
            for (String api : appapiCodes = appapiCode.split(SPLIT)) {
                if (!nowAppapiCode.equals(api)) continue;
                ruleNo = marketApiLink.getRuleNo();
                apilistNo = marketApiLink.getApilistNo();
                flag = true;
                break;
            }
            if (!flag) continue;
            break;
        }
        logger.debug(SYS_CODE, (Object)("match flag = " + flag));
        if (flag) {
            logger.debug(SYS_CODE, (Object)"execute mk.marketing.executeGenOrder");
            allParamMap.put("ruleNo", ruleNo);
            allParamMap.put("apilistNo", apilistNo);
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(allParamMap));
            logger.debug(SYS_CODE, (Object)("allParamMap = " + allParamMap));
            this.internalRouter.inAsyncInvoke("mk.marketing.executeGenOrder", "1.0", "0", paramMap);
        }
        return new InvokeResult();
    }

    private AppProperty getPAppProperty(InvokeContext context) {
        ApiProperty apiProperty = LocalCache.getApiProperty((String)context.getApiKey());
        String apiAppicode = apiProperty.getAppmanageIcode();
        List appPropList = (List)MapUtil.get((Map)LocalCache.getAppManagerMap(), (Object)apiAppicode);
        if (ListUtil.isEmpty((Collection)appPropList)) {
            return null;
        }
        AppProperty appProperty = (AppProperty)appPropList.get(0);
        return appProperty;
    }

    private boolean checkRsp(Object res) {
        logger.debug(SYS_CODE, (Object)("res =" + res));
        if (res == null) {
            return false;
        }
        boolean flag = true;
        String responseStr = null;
        responseStr = res instanceof String ? res.toString() : JsonUtil.buildNormalBinder().toJson(res);
        if (!StringUtils.isMapJson((String)responseStr)) {
            return false;
        }
        Map response = (Map)JsonUtil.buildNormalBinder().getJsonToMap(responseStr, String.class, Object.class);
        if (response == null) {
            return false;
        }
        if (response.containsKey("is_success")) {
            String is_success = (String)response.get("is_success");
            if (!"T".equals(is_success)) {
                flag = false;
            }
        } else if (response.containsKey("responseCode")) {
            String is_success = (String)response.get("responseCode");
            if (!"0".equals(is_success)) {
                flag = false;
            }
        } else {
            flag = false;
        }
        logger.debug("MarketingProcessor.check", (Object)("flag=" + flag));
        logger.debug("MarketingProcessor.res", (Object)("res=" + res));
        return flag;
    }
}

