/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.util;

import com.yqbsoft.laser.service.esb.core.auth.OauthToken;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.route.rule.pre1.TokenValidator;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class OAuthUtil {
    public static TokenValidator.TokenStatus checkToken(InMessage inMessage, String token, String apiKey, String businessType, String appType) {
        OauthToken oauthToken;
        if (apiKey == null) {
            return TokenValidator.TokenStatus.TOKEN_NOT_FOUND_OR_ILLEGAL;
        }
        String appKey = inMessage.getParam("app_id");
        String tokenKey = token + "-" + appKey;
        List tokenList = (List)LocalCache.getOAuthTokenMap().get(tokenKey);
        if (tokenList != null && tokenList.size() > 0 && (oauthToken = (OauthToken)tokenList.get(0)) != null && oauthToken.getOauthTokenState() == 2) {
            long timeout = new Date().getTime() - oauthToken.getOauthTokenUpdateTime().getTime() - (long)(oauthToken.getOauthTokenExpireIn() * 1000);
            if (timeout < 0L) {
                return TokenValidator.TokenStatus.TOKEN_EXPIRES;
            }
            Map rightsMap = LocalCache.getOAuthRightsMap();
            String api_rights_key = oauthToken.getOauthTokenId() + "-" + apiKey + "-" + (Object)((Object)RightsType.API_TYPE);
            String app_rights_key = oauthToken.getOauthTokenId() + "-" + apiKey + "-" + (Object)((Object)RightsType.APP_TYPE);
            String bus_rights_key = oauthToken.getOauthTokenId() + "-" + apiKey + "-" + (Object)((Object)RightsType.BUSINESS_TYPE);
            boolean hasData = true;
            hasData &= rightsMap.get(bus_rights_key) != null && ((List)rightsMap.get(bus_rights_key)).size() > 0;
            hasData &= rightsMap.get(app_rights_key) != null && ((List)rightsMap.get(app_rights_key)).size() > 0;
            if (hasData &= rightsMap.get(api_rights_key) != null && ((List)rightsMap.get(api_rights_key)).size() > 0) {
                return TokenValidator.TokenStatus.TOKEN_OK;
            }
        }
        return TokenValidator.TokenStatus.TOKEN_NOT_FOUND_OR_ILLEGAL;
    }

    public static enum RightsType {
        API_TYPE(1, "Rights\u4e2d\u5b58\u50a8\u7684foreign_key\u4e3aApi\u7c7b\u578b(apiKey)"),
        APP_TYPE(2, "Rights\u4e2d\u5b58\u50a8\u7684foreign_key\u4e3aApp\u7c7b\u578b(appKey)"),
        BUSINESS_TYPE(3, "Rights\u4e2d\u5b58\u50a8\u7684foreign_key\u4e3a\u4e1a\u52a1\u7c7b\u578b()");

        private int type;
        private String remark;

        private RightsType(int type, String remark) {
            this.type = type;
            this.remark = remark;
        }

        public int getType() {
            return this.type;
        }

        public String getRemark() {
            return this.remark;
        }
    }
}

