/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.util;

import com.yqbsoft.laser.service.esb.core.auth.AdapterCheck;
import com.yqbsoft.laser.service.esb.core.auth.Auth;
import com.yqbsoft.laser.service.esb.core.auth.Seclist;
import com.yqbsoft.laser.service.esb.core.auth.SupperDes;
import com.yqbsoft.laser.service.esb.core.auth.SupperSign;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.RSAUtils;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SeclistHelper {
    protected static final Log logger = LogFactory.getLog(SeclistHelper.class);
    public static final String SECLIST_TYPE_SIGN = "0";
    public static final String SECLIST_TYPE_PASSWORD = "1";
    public static final String SECLIST_TYPE_ENCRYPT = "2";
    public static final String SECLIST_TYPE_IP = "3";
    public static final String SECLIST_TYPE_ADAPTER = "4";
    public static final String SECLIST_TYPE_BASE64 = "6";
    public static final String SECLIST_SERNAME = "userName";
    public static final String SECLIST_PASSWOED = "passWord";
    public static final Integer SECLIST_DATEFLAG_NO = 0;
    public static final Integer SECLIST_DATEFLAG_YES = 1;

    public static boolean authData(Auth authVo, Map<String, List<Seclist>> secListMap, Map<String, String> pmap, boolean strict) {
        if (authVo == null) {
            return false;
        }
        if (MapUtils.isEmpty(secListMap) || CollectionUtils.isEmpty((Collection)secListMap.get(authVo.getType()))) {
            return !strict;
        }
        List<Seclist> seclistList = secListMap.get(authVo.getType());
        if (CollectionUtils.isEmpty(seclistList)) {
            return false;
        }
        if (null != seclistList && seclistList.size() > 0) {
            for (Seclist seclist : seclistList) {
                if (!SeclistHelper.isSeclistDateValid(seclist)) continue;
                SeclistHelper.trimValueToEmpty(seclist, authVo);
                if (!SeclistHelper.auth(seclist, authVo, pmap, strict)) continue;
                return true;
            }
        }
        return false;
    }

    private static void trimValueToEmpty(Seclist seclist, Auth authVo) {
        seclist.setSeclistValue1(StringUtils.trimToEmpty((String)seclist.getSeclistValue1()));
        seclist.setSeclistValue2(StringUtils.trimToEmpty((String)seclist.getSeclistValue2()));
        authVo.setKey(StringUtils.trimToEmpty((String)authVo.getKey()));
        authVo.setValue(StringUtils.trimToEmpty((String)authVo.getValue()));
    }

    private static boolean auth(Seclist seclist, Auth authVo, Map<String, String> pmap, boolean strict) {
        if (SECLIST_TYPE_PASSWORD.equals(authVo.getType())) {
            return SeclistHelper.authPassword(authVo, seclist);
        }
        if (SECLIST_TYPE_ENCRYPT.equals(authVo.getType())) {
            return SeclistHelper.authEncrypt(authVo, seclist, pmap);
        }
        if (SECLIST_TYPE_SIGN.equals(authVo.getType())) {
            return SeclistHelper.authRSA(authVo, seclist);
        }
        if (SECLIST_TYPE_ADAPTER.equals(authVo.getType())) {
            return SeclistHelper.authAdapter(authVo, seclist, pmap);
        }
        if (SECLIST_TYPE_IP.equals(authVo.getType())) {
            return SeclistHelper.authIp(authVo, seclist);
        }
        if (SECLIST_TYPE_BASE64.equals(authVo.getType())) {
            return SeclistHelper.authBase64(authVo, seclist);
        }
        return false;
    }

    public static boolean authPassword(Auth authVo, Seclist seclist) {
        return seclist.getSeclistValue1().equals(authVo.getKey()) && seclist.getSeclistValue2().equals(authVo.getValue());
    }

    public static boolean authIp(Auth authVo, Seclist seclist) {
        return SeclistHelper.authIpWildcard(authVo.getKey(), seclist.getSeclistValue1());
    }

    public static boolean authBase64(Auth authVo, Seclist seclist) {
        return SeclistHelper.authBase64(authVo.getKey(), seclist.getSeclistValue1() + ":" + seclist.getSeclistValue2());
    }

    public static boolean authBase64(String sign, String keySecret) {
        return sign.equals(Base64.encodeBase64String((byte[])keySecret.getBytes()));
    }

    public static boolean authIpWildcard(String ip, String wip) {
        String[] ip4 = ip.split("\\.");
        String[] wip4 = wip.split("\\.");
        if (ip4.length != 4 || wip4.length != 4) {
            return false;
        }
        for (int i = 0; i < ip4.length; ++i) {
            if (i > 1 && wip4[i].equals("*") || ip4[i].equals(wip4[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean authRSA(Auth authVo, Seclist seclist) {
        boolean auth = false;
        try {
            auth = RSAUtils.verify((byte[])authVo.getKey().getBytes("utf-8"), (byte[])Base64.decodeBase64((String)authVo.getValue()), (PublicKey)RSAUtils.getPublicKey((String)seclist.getSeclistValue1()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!auth) {
            logger.error((Object)("===RSA\u9a8c\u8bc1" + authVo.getKey() + "\u5931\u8d25===="));
            logger.error((Object)authVo.getKey());
            logger.error((Object)authVo.getValue());
            logger.error((Object)seclist.getSeclistValue1());
        }
        return auth;
    }

    public static boolean authAdapter(Auth authVo, Seclist seclist, Map<String, String> pmap) {
        return SeclistHelper.adapterCheck(pmap, seclist.getSeclistValue1());
    }

    public static boolean authEncrypt(Auth authVo, Seclist seclist, Map<String, String> pmap) {
        return authVo.getValue().equals(SeclistHelper.desStr(authVo.getKey(), seclist));
    }

    public static boolean authCA(Auth authVo, Seclist seclist) {
        return SeclistHelper.caVerifySign(authVo.getKey(), authVo.getValue(), seclist.getSeclistValue1());
    }

    public static String singRSA(String priKeyText, String plainText) {
        try {
            return Base64.encodeBase64String((byte[])RSAUtils.sign((byte[])plainText.getBytes(), (PrivateKey)RSAUtils.getPrivateKey((String)priKeyText)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String singCa(String plainText, Seclist seclist) {
        if (null == seclist) {
            return null;
        }
        return SeclistHelper.caSignString(plainText, seclist.getSeclistValue1());
    }

    public static void descStr(Auth authVo, Seclist seclist) {
        SeclistHelper.trimValueToEmpty(seclist, authVo);
        authVo.setKey(SeclistHelper.desDecString(authVo.getKey(), seclist.getSeclistValue1()));
    }

    public static String desStr(String plainText, Seclist seclist) {
        if (null == seclist) {
            return null;
        }
        return SeclistHelper.desString(plainText, seclist.getSeclistValue1());
    }

    private static boolean isSeclistDateValid(Seclist seclist) {
        if (!SECLIST_DATEFLAG_YES.equals(seclist.getSeclistDateflag())) {
            return true;
        }
        if (null == seclist.getSeclistSdate() || null == seclist.getSeclistEdate()) {
            return false;
        }
        Date date = new Date();
        return seclist.getSeclistSdate().getTime() - date.getTime() <= 0L && seclist.getSeclistEdate().getTime() - date.getTime() >= 0L;
    }

    public static void main(String[] args) {
        Seclist seclist = new Seclist();
        System.out.println(!SECLIST_DATEFLAG_YES.equals(seclist.getSeclistDateflag()));
    }

    private static boolean adapterCheck(Map<String, String> map, String className) {
        AdapterCheck adapterCheck = null;
        try {
            adapterCheck = (AdapterCheck)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == adapterCheck) {
            return false;
        }
        return adapterCheck.check(map);
    }

    private static boolean caVerifySign(String plainText, String signText, String className) {
        SupperSign supperSign = null;
        try {
            supperSign = (SupperSign)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == supperSign) {
            return false;
        }
        return supperSign.verifySign(plainText, signText, null);
    }

    private static String caSignString(String plainText, String className) {
        SupperSign supperSign = null;
        try {
            supperSign = (SupperSign)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == supperSign) {
            return "";
        }
        return supperSign.signString(plainText, null);
    }

    private static String desDecString(String plainText, String className) {
        SupperDes supperDes = null;
        try {
            supperDes = (SupperDes)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == supperDes) {
            return "";
        }
        return supperDes.desedeDecrypt(plainText.getBytes(), null);
    }

    private static String desString(String plainText, String className) {
        SupperDes supperDes = null;
        try {
            supperDes = (SupperDes)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == supperDes) {
            return "";
        }
        return supperDes.desedeEncrypt(plainText.getBytes(), null);
    }
}

