/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sharding.config;

import com.yqbsoft.laser.service.sharding.config.ShardingAlgorithmTool;
import com.yqbsoft.laser.service.sharding.config.enums.ShardingTableCacheEnum;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataShardingAlgorithm
implements StandardShardingAlgorithm<String> {
    private static final Logger log = LoggerFactory.getLogger(DataShardingAlgorithm.class);

    public String doSharding(Collection<String> tableNames, PreciseShardingValue<String> preciseShardingValue) {
        String resultTableName;
        String logicTableName = preciseShardingValue.getLogicTableName();
        ShardingTableCacheEnum logicTable = ShardingTableCacheEnum.of(logicTableName);
        if (logicTable == null) {
            log.error(">>>>>>>>>> \u3010ERROR\u3011\u6570\u636e\u8868\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0clogicTableNames\uff1a{}\uff0clogicTableName:{}", ShardingTableCacheEnum.logicTableNames(), (Object)logicTableName);
            throw new IllegalArgumentException("\u6570\u636e\u8868\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        log.info(">>>>>>>>>> \u3010INFO\u3011\u7cbe\u786e\u5206\u7247\uff0c\u8282\u70b9\u914d\u7f6e\u8868\u540d\uff1a{}\uff0c\u6570\u636e\u5e93\u7f13\u5b58\u8868\u540d\uff1a{}", tableNames, logicTable.resultTableNamesCache());
        String channelCode = (String)((Object)preciseShardingValue.getValue());
        if (StringUtils.isBlank((CharSequence)channelCode)) {
            log.warn(">>>>>>>>>> \u3010WARN\u3011\u7cbe\u786e\u5206\u7247\uff0c\u903b\u8f91\u8868\u540d\uff1a{}\uff0c\u5206\u7247\u952e\u503c\u4e3anull", (Object)logicTableName);
        }
        if (!tableNames.contains(resultTableName = logicTableName + "_" + channelCode)) {
            tableNames.add(resultTableName);
        }
        return ShardingAlgorithmTool.getShardingTableAndCreate(logicTable, resultTableName);
    }

    public Collection<String> doSharding(Collection<String> tableNames, RangeShardingValue<String> rangeShardingValue) {
        log.info(">>>>>>>>>> \u3010INFO\u3011\u8303\u56f4\u5206\u7247\uff0c\u8282\u70b9\u914d\u7f6e\u8868\u540d\uff1a{}", tableNames);
        return tableNames;
    }

    public void init() {
    }

    public String getType() {
        return null;
    }
}

