/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sharding.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyComplexKeysShardingAlgorithm
implements ComplexKeysShardingAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(MyComplexKeysShardingAlgorithm.class);
    private static final String col1 = "create_time";
    private static final String col2 = "channel_code";

    public Collection<String> doSharding(Collection collection, ComplexKeysShardingValue complexKeysShardingValue) {
        String logicTableName = complexKeysShardingValue.getLogicTableName();
        Map columnNameAndShardingValuesMap = complexKeysShardingValue.getColumnNameAndShardingValuesMap();
        log.info("===\u5206\u7247===:\u8868\u540d{},\u53c2\u6570\uff1a{}", (Object)collection, (Object)columnNameAndShardingValuesMap);
        Map columnNameAndRangeValuesMap = complexKeysShardingValue.getColumnNameAndRangeValuesMap();
        List c1Date = (List)columnNameAndShardingValuesMap.get(col1);
        List c2Channel = (List)columnNameAndShardingValuesMap.get(col2);
        if (Optional.ofNullable(c1Date).isPresent() || Optional.ofNullable(c2Channel).isPresent()) {
            log.info("======\u53c2\u6570\u89e3\u6790=========createTime={}=channelCode={}", (Object)c1Date, (Object)c2Channel);
            return Arrays.asList(logicTableName);
        }
        throw new RuntimeException("\u6ca1\u6709\u5f97\u5230\u5408\u9002\u7684\u5206\u7247\u7ed3\u679c");
    }

    public void init() {
    }

    public String getType() {
        return null;
    }
}

