/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sharding.config;

import com.yqbsoft.laser.service.sharding.config.enums.ShardingTableCacheEnum;
import com.yqbsoft.laser.service.sharding.utils.SpringUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sharding.algorithm.config.AlgorithmProvidedShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ShardingAlgorithmTool {
    private static final Logger log = LoggerFactory.getLogger(ShardingAlgorithmTool.class);
    public static final String TABLE_SPLIT_SYMBOL = "_";
    private static final Environment ENV = SpringUtil.getApplicationContext().getEnvironment();
    private static final String DATASOURCE_URL = ENV.getProperty("spring.shardingsphere.datasource.mydb.url");
    private static final String DATASOURCE_USERNAME = ENV.getProperty("spring.shardingsphere.datasource.mydb.username");
    private static final String DATASOURCE_PASSWORD = ENV.getProperty("spring.shardingsphere.datasource.mydb.password");
    private static final Boolean LOGICTABLE_REFRESH = (Boolean)ENV.getProperty("spring.shardingsphere.logictable.refresh", Boolean.class, (Object)true);
    private static List<String> tableNames = new ArrayList<String>();

    public static Set<String> getShardingTablesAndCreate(ShardingTableCacheEnum logicTable, Collection<String> resultTableNames) {
        return resultTableNames.stream().map(o -> ShardingAlgorithmTool.getShardingTableAndCreate(logicTable, o)).collect(Collectors.toSet());
    }

    public static String getShardingTableAndCreate(ShardingTableCacheEnum logicTable, String resultTableName) {
        if (logicTable.resultTableNamesCache().contains(resultTableName)) {
            return resultTableName;
        }
        boolean isSuccess = ShardingAlgorithmTool.createShardingTable(logicTable, resultTableName);
        return isSuccess ? resultTableName : logicTable.logicTableName();
    }

    public static void tableNameCacheReloadAll() {
        List<String> logicTableNames = ShardingAlgorithmTool.getLogicTableNames();
        for (int i = 0; i < logicTableNames.size(); ++i) {
            ShardingTableCacheEnum.addEnum(logicTableNames.get(i).replace(TABLE_SPLIT_SYMBOL, "").toUpperCase(), logicTableNames.get(i), new HashSet<String>());
        }
        Arrays.stream(ShardingTableCacheEnum.values()).forEach(o -> ShardingTableCacheEnum.valueMap.put(o.logicTableName, (ShardingTableCacheEnum)((Object)o)));
        Arrays.stream(ShardingTableCacheEnum.values()).forEach(ShardingAlgorithmTool::tableNameCacheReload);
    }

    public static void tableNameCacheReload(ShardingTableCacheEnum logicTable) {
        if (!LOGICTABLE_REFRESH.booleanValue()) {
            return;
        }
        List<String> tableNameList = ShardingAlgorithmTool.getAllTableNameBySchema(logicTable);
        logicTable.resultTableNamesCache().clear();
        logicTable.resultTableNamesCache().addAll(tableNameList);
        ShardingAlgorithmTool.actualDataNodesRefresh(logicTable);
    }

    public static List<String> getAllTableNames() {
        if (tableNames.size() > 0) {
            return tableNames;
        }
        if (StringUtils.isEmpty((CharSequence)DATASOURCE_URL) || StringUtils.isEmpty((CharSequence)DATASOURCE_USERNAME) || StringUtils.isEmpty((CharSequence)DATASOURCE_PASSWORD)) {
            log.error(">>>>>>>>>> \u3010ERROR\u3011\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0cURL:{}, username:{}, password:{}", new Object[]{DATASOURCE_URL, DATASOURCE_USERNAME, DATASOURCE_PASSWORD});
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        try (Connection conn = DriverManager.getConnection(DATASOURCE_URL, DATASOURCE_USERNAME, DATASOURCE_PASSWORD);
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery("show TABLES");){
            while (rs.next()) {
                tableNames.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            log.error(">>>>>>>>>> \u3010ERROR\u3011\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return tableNames;
    }

    public static List<String> getLogicTableNames() {
        ShardingAlgorithmTool.getAllTableNames();
        ArrayList<String> logicTableNames = new ArrayList<String>();
        for (int i = 0; i < tableNames.size(); ++i) {
            String tableName = tableNames.get(i);
            if (tableName == null || tableName.matches("^.*\\d{6}$")) continue;
            logicTableNames.add(tableName);
        }
        return logicTableNames;
    }

    public static void main(String[] args) {
        String input = "t_user";
        String regex = "^.*\\d{6}$";
        if (input.matches(regex)) {
            System.out.println("The input string matches the regex pattern.");
        } else {
            System.out.println("The input string does not match the regex pattern.");
        }
    }

    public static List<String> getAllTableNameBySchema(ShardingTableCacheEnum logicTable) {
        ArrayList<String> tableNamesBySchema = new ArrayList<String>();
        String logicTableName = logicTable.logicTableName();
        for (int i = 0; i < tableNames.size(); ++i) {
            String tableName = tableNames.get(i);
            if (tableName == null || !tableName.matches(String.format("^(%s\\d{6})$", logicTableName + TABLE_SPLIT_SYMBOL))) continue;
            tableNamesBySchema.add(tableName);
        }
        return tableNamesBySchema;
    }

    public static void actualDataNodesRefresh(ShardingTableCacheEnum logicTable) {
        try {
            String dbName = "mydb";
            String logicTableName = logicTable.logicTableName();
            Set<String> tableNamesCache = logicTable.resultTableNamesCache();
            log.info(">>>>>>>>>> \u3010INFO\u3011\u66f4\u65b0\u5206\u8868\u914d\u7f6e\uff0clogicTableName:{}\uff0ctableNamesCache:{}", (Object)logicTableName, tableNamesCache);
            String newActualDataNodes = tableNamesCache.stream().map(o -> String.format("%s.%s", dbName, o)).collect(Collectors.joining(","));
            ShardingSphereDataSource shardingSphereDataSource = SpringUtil.getBean(ShardingSphereDataSource.class);
            ShardingAlgorithmTool.updateShardRuleActualDataNodes(shardingSphereDataSource, logicTableName, newActualDataNodes);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316 \u52a8\u6001\u8868\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void updateShardRuleActualDataNodes(ShardingSphereDataSource dataSource, String logicTableName, String newActualDataNodes) {
        ContextManager contextManager = dataSource.getContextManager();
        String schemaName = "logic_db";
        LinkedList<AlgorithmProvidedShardingRuleConfiguration> newRuleConfigList = new LinkedList<AlgorithmProvidedShardingRuleConfiguration>();
        Collection oldRuleConfigList = dataSource.getContextManager().getMetaDataContexts().getMetaData(schemaName).getRuleMetaData().getConfigurations();
        for (RuleConfiguration oldRuleConfig : oldRuleConfigList) {
            if (!(oldRuleConfig instanceof AlgorithmProvidedShardingRuleConfiguration)) continue;
            AlgorithmProvidedShardingRuleConfiguration oldAlgorithmConfig = (AlgorithmProvidedShardingRuleConfiguration)oldRuleConfig;
            AlgorithmProvidedShardingRuleConfiguration newAlgorithmConfig = new AlgorithmProvidedShardingRuleConfiguration();
            LinkedList newTableRuleConfigList = new LinkedList();
            Collection oldTableRuleConfigList = oldAlgorithmConfig.getTables();
            oldTableRuleConfigList.forEach(oldTableRuleConfig -> {
                if (logicTableName.equals(oldTableRuleConfig.getLogicTable()) && null != newActualDataNodes) {
                    ShardingTableRuleConfiguration newTableRuleConfig = new ShardingTableRuleConfiguration(oldTableRuleConfig.getLogicTable(), newActualDataNodes);
                    newTableRuleConfig.setTableShardingStrategy(oldTableRuleConfig.getTableShardingStrategy());
                    newTableRuleConfig.setDatabaseShardingStrategy(oldTableRuleConfig.getDatabaseShardingStrategy());
                    newTableRuleConfig.setKeyGenerateStrategy(oldTableRuleConfig.getKeyGenerateStrategy());
                    newTableRuleConfigList.add(newTableRuleConfig);
                } else {
                    newTableRuleConfigList.add(oldTableRuleConfig);
                }
            });
            newAlgorithmConfig.setTables(newTableRuleConfigList);
            newAlgorithmConfig.setAutoTables(oldAlgorithmConfig.getAutoTables());
            newAlgorithmConfig.setBindingTableGroups(oldAlgorithmConfig.getBindingTableGroups());
            newAlgorithmConfig.setBroadcastTables(oldAlgorithmConfig.getBroadcastTables());
            newAlgorithmConfig.setDefaultDatabaseShardingStrategy(oldAlgorithmConfig.getDefaultDatabaseShardingStrategy());
            newAlgorithmConfig.setDefaultTableShardingStrategy(oldAlgorithmConfig.getDefaultTableShardingStrategy());
            newAlgorithmConfig.setDefaultKeyGenerateStrategy(oldAlgorithmConfig.getDefaultKeyGenerateStrategy());
            newAlgorithmConfig.setDefaultShardingColumn(oldAlgorithmConfig.getDefaultShardingColumn());
            newAlgorithmConfig.setShardingAlgorithms(oldAlgorithmConfig.getShardingAlgorithms());
            newAlgorithmConfig.setKeyGenerators(oldAlgorithmConfig.getKeyGenerators());
            newRuleConfigList.add(newAlgorithmConfig);
        }
        contextManager.alterRuleConfiguration(schemaName, newRuleConfigList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createShardingTable(ShardingTableCacheEnum logicTable, String resultTableName) {
        String string = logicTable.logicTableName().intern();
        synchronized (string) {
            if (logicTable.resultTableNamesCache().contains(resultTableName)) {
                return false;
            }
            ShardingAlgorithmTool.executeSql(Collections.singletonList("CREATE TABLE IF NOT EXISTS `" + resultTableName + "` LIKE `" + logicTable.logicTableName() + "`;"));
            ShardingAlgorithmTool.tableNameCacheReload(logicTable);
        }
        return true;
    }

    private static void executeSql(List<String> sqlList) {
        if (StringUtils.isEmpty((CharSequence)DATASOURCE_URL) || StringUtils.isEmpty((CharSequence)DATASOURCE_USERNAME) || StringUtils.isEmpty((CharSequence)DATASOURCE_PASSWORD)) {
            log.error(">>>>>>>>>> \u3010ERROR\u3011\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0cURL:{}, username:{}, password:{}", new Object[]{DATASOURCE_URL, DATASOURCE_USERNAME, DATASOURCE_PASSWORD});
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        try (Connection conn = DriverManager.getConnection(DATASOURCE_URL, DATASOURCE_USERNAME, DATASOURCE_PASSWORD);){
            try (Statement st = conn.createStatement();){
                conn.setAutoCommit(false);
                for (String sql : sqlList) {
                    st.execute(sql);
                }
                conn.commit();
            }
            catch (Exception e) {
                conn.rollback();
                log.error(">>>>>>>>>> \u3010ERROR\u3011\u6570\u636e\u8868\u521b\u5efa\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
                throw new IllegalArgumentException("\u6570\u636e\u8868\u521b\u5efa\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
        catch (SQLException e) {
            log.error(">>>>>>>>>> \u3010ERROR\u3011\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }
}

