/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.springcon;

import java.io.IOException;
import javax.sql.DataSource;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@EnableCaching
public class MybatisConfig {
    @Value(value="${spring.mybatis.config:com/yqbsoft/**/mysql/*.xml}")
    private String mybatisConfigFilePath;
    @Value(value="${spring.mybatis.mapperpath:com/yqbsoft/**/mysql/*.xml}")
    private String mapperPath;
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;

    @Bean(name={"sqlSessionFactoryBean"})
    public SqlSessionFactoryBean createSqlSessionFactoryBean() throws IOException {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        PathMatchingResourcePatternResolver pathMatchResolver = new PathMatchingResourcePatternResolver();
        String packageSearchPath = "classpath*:" + this.mapperPath;
        sqlSessionFactoryBean.setMapperLocations(pathMatchResolver.getResources(packageSearchPath));
        sqlSessionFactoryBean.setDataSource(this.dataSource);
        return sqlSessionFactoryBean;
    }
}

