/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class OpenUtils {
    private static String localIp;
    private static List<String> allIps;

    private OpenUtils() {
    }

    public static String getFileSuffix(byte[] bytes) {
        if (bytes == null || bytes.length < 10) {
            return null;
        }
        if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "GIF";
        }
        if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "PNG";
        }
        if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "JPG";
        }
        if (bytes[0] == 66 && bytes[1] == 77) {
            return "BMP";
        }
        return null;
    }

    public static String getMimeType(byte[] bytes) {
        String suffix = OpenUtils.getFileSuffix(bytes);
        String mimeType = "JPG".equals(suffix) ? "image/jpeg" : ("GIF".equals(suffix) ? "image/gif" : ("PNG".equals(suffix) ? "image/png" : ("BMP".equals(suffix) ? "image/bmp" : "application/octet-stream")));
        return mimeType;
    }

    public static Class classForName(String classPath) throws ClassNotFoundException {
        if (StringUtils.isBlank(classPath)) {
            return null;
        }
        if ("boolean".equals(classPath)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(classPath)) {
            return Byte.TYPE;
        }
        if ("char".equals(classPath)) {
            return Character.TYPE;
        }
        if ("short".equals(classPath)) {
            return Short.TYPE;
        }
        if ("int".equals(classPath)) {
            return Integer.TYPE;
        }
        if ("long".equals(classPath)) {
            return Long.TYPE;
        }
        if ("float".equals(classPath)) {
            return Float.TYPE;
        }
        if ("double".equals(classPath)) {
            return Double.TYPE;
        }
        if ("[Ljava.lang.String".equals(classPath)) {
            return String[].class;
        }
        if ("[Ljava.lang.Byte".equals(classPath)) {
            return Byte[].class;
        }
        if ("[Ljava.lang.Double".equals(classPath)) {
            return Double[].class;
        }
        if ("[Ljava.lang.Long".equals(classPath)) {
            return Long[].class;
        }
        if ("[Ljava.lang.Short".equals(classPath)) {
            return Short[].class;
        }
        if ("[Ljava.lang.Date".equals(classPath)) {
            return Date[].class;
        }
        if ("[Ljava.lang.Integer".equals(classPath)) {
            return Integer[].class;
        }
        if ("[Ljava.lang.Boolean".equals(classPath)) {
            return Boolean[].class;
        }
        if ("[Ljava.lang.Number".equals(classPath)) {
            return Number[].class;
        }
        if ("[Ljava.lang.Float".equals(classPath)) {
            return Float[].class;
        }
        if ("[Ljava.lang.Character".equals(classPath)) {
            return Character[].class;
        }
        return Class.forName(classPath);
    }

    public static <V> Map<String, V> cleanupMap(Map<String, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, V> result = new HashMap<String, V>(map.size());
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> entry : entries) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static String getLoaclHostname() {
        String address = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            address = addr.getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return address;
    }

    public static String getLocalNetWorkIp() {
        if (localIp != null) {
            return localIp;
        }
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                if (ni.isLoopback() || ni.isVirtual()) continue;
                Enumeration<InetAddress> addresss = ni.getInetAddresses();
                while (addresss.hasMoreElements()) {
                    InetAddress address = addresss.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    ip = address;
                    break;
                }
                if (ip == null) continue;
                break;
            }
            localIp = ip != null ? ip.getHostAddress() : "127.0.0.1";
        }
        catch (Exception e) {
            localIp = "127.0.0.1";
        }
        return localIp;
    }

    public static List<String> getAllNetWorkIp() {
        if (allIps != null) {
            return allIps;
        }
        LinkedList<String> ips = new LinkedList<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                if (ni.isLoopback() || ni.isVirtual()) continue;
                Enumeration<InetAddress> addresss = ni.getInetAddresses();
                while (addresss.hasMoreElements()) {
                    InetAddress address = addresss.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    ips.add(address.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ips.add("127.0.0.1");
        }
        allIps = ips;
        return ips;
    }

    public static void main(String[] args) {
        System.out.println(OpenUtils.getAllNetWorkIp());
    }
}

