/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.json;

import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.json.TypeCast;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class JSONArray
implements Serializable,
List<JSONObject> {
    private static final long serialVersionUID = -4317905669853990128L;
    private final List<JSONObject> list;
    protected transient Object relatedArray;
    protected transient Type componentType;

    public JSONArray() {
        this.list = new ArrayList<JSONObject>(10);
    }

    public JSONArray(List<JSONObject> list) {
        this.list = list;
    }

    public JSONArray(int initialCapacity) {
        this.list = new ArrayList<JSONObject>(initialCapacity);
    }

    public Object getRelatedArray() {
        return this.relatedArray;
    }

    public void setRelatedArray(Object relatedArray) {
        this.relatedArray = relatedArray;
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public void setComponentType(Type componentType) {
        this.componentType = componentType;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<JSONObject> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(JSONObject e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends JSONObject> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends JSONObject> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public JSONObject set(int index, JSONObject element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, JSONObject element) {
        this.list.add(index, element);
    }

    @Override
    public JSONObject remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<JSONObject> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<JSONObject> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<JSONObject> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public JSONObject get(int index) {
        return this.list.get(index);
    }

    public JSONObject getJSONObject(int index) {
        JSONObject value = this.list.get(index);
        if (value instanceof JSONObject) {
            return value;
        }
        return JsonUtil.buildNormalBinder().getJsonToObject(value.toString(), JSONObject.class);
    }

    public JSONArray getJSONArray(int index) {
        JSONObject value = this.list.get(index);
        if (value instanceof JSONArray) {
            return (JSONArray)((Object)value);
        }
        return JsonUtil.buildNormalBinder().getJsonToObject(value.toString(), JSONArray.class);
    }

    public <T> T getObject(int index, Class<T> clazz) {
        JSONObject obj = this.list.get(index);
        return JsonUtil.buildNormalBinder().getJsonToObject(obj.toString(), clazz);
    }

    public Boolean getBoolean(int index) {
        JSONObject value = this.get(index);
        if (value == null) {
            return null;
        }
        return TypeCast.castToBoolean(value);
    }

    public boolean getBooleanValue(int index) {
        JSONObject value = this.get(index);
        if (value == null) {
            return false;
        }
        return TypeCast.castToBoolean(value);
    }

    public Integer getInteger(int index) {
        JSONObject value = this.get(index);
        return TypeCast.castToInt(value);
    }

    public Long getLong(int index) {
        JSONObject value = this.get(index);
        return TypeCast.castToLong(value);
    }

    public long getLongValue(int index) {
        JSONObject value = this.get(index);
        if (value == null) {
            return 0L;
        }
        return TypeCast.castToLong(value);
    }

    public Double getDouble(int index) {
        JSONObject value = this.get(index);
        return TypeCast.castToDouble(value);
    }

    public double getDoubleValue(int index) {
        JSONObject value = this.get(index);
        if (value == null) {
            return 0.0;
        }
        return TypeCast.castToDouble(value);
    }

    public BigDecimal getBigDecimal(int index) {
        JSONObject value = this.get(index);
        return TypeCast.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(int index) {
        JSONObject value = this.get(index);
        return TypeCast.castToBigInteger(value);
    }

    public String getString(int index) {
        JSONObject value = this.get(index);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Date getDate(int index) {
        JSONObject value = this.get(index);
        return TypeCast.castToDate(value);
    }

    public Object clone() {
        return new JSONArray(new ArrayList<JSONObject>(this.list));
    }

    @Override
    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public static JSONArray json2array(String jsonStr) {
        List<JSONObject> data = JsonUtil.buildNormalBinder().getJsonToList(jsonStr, JSONObject.class);
        return new JSONArray(data);
    }

    public String array2json() {
        return JsonUtil.buildNormalBinder().toJson(this.list);
    }
}

