/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.GenericsUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BeanUtils {
    public static final String FORMAT_OBJECT = "F-JSONTO-OBJ";
    public static final String FORMAT_MAP = "F-JSONTO-MAP";
    public static final String FORMAT_LIST = "F-JSONTO-LIST";
    public static final String FORMAT_GET = "F-GET";
    public static final String TO_JSON = "TO-JSON";

    private BeanUtils() {
    }

    public static Field getDeclaredField(Object object, String propertyName) throws NoSuchFieldException {
        return BeanUtils.getDeclaredField(object.getClass(), propertyName);
    }

    public static Field getDeclaredField(Class clazz, String propertyName) {
        for (Class superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field[] s = superClass.getDeclaredFields();
                return superClass.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Object getNameProperty(Object object, String propertyName) {
        Field field = null;
        try {
            field = BeanUtils.getDeclaredField(object, propertyName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        Object result = null;
        if (null != field) {
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                result = field.get(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            field.setAccessible(accessible);
        }
        return result;
    }

    public static Object newForceGetProperty(Object object, String propertyName) {
        if (null == object) {
            return null;
        }
        if (StringUtils.isBlank(propertyName)) {
            return null;
        }
        Object obj = null;
        if (object instanceof Map) {
            obj = ((Map)object).get(propertyName);
        }
        if (obj != null) {
            return obj;
        }
        String[] s = propertyName.split("\\.");
        if (null == s) {
            return null;
        }
        for (int i = 0; i < s.length; ++i) {
            object = s[i].indexOf("F-") >= 0 ? BeanUtils.formatProperty(object, s[i]) : BeanUtils.forceGetProperty(object, s[i]);
        }
        return object;
    }

    public static Object formatProperty(Object object, String propertyName) {
        if (FORMAT_OBJECT.equals(propertyName)) {
            return JsonUtil.buildNormalBinder().getJsonToObject(object.toString(), Object.class);
        }
        if (FORMAT_MAP.equals(propertyName)) {
            return JsonUtil.buildNormalBinder().getJsonToMap(object.toString(), String.class, Object.class);
        }
        if (FORMAT_LIST.equals(propertyName)) {
            List<Object> list = JsonUtil.buildNormalBinder().getJsonToList(object.toString(), Object.class);
            return list.get(0);
        }
        if (FORMAT_GET.equals(propertyName)) {
            if (object instanceof ArrayList) {
                List list = (List)object;
                return list.get(0);
            }
            String[] str = (String[])object;
            return str[0];
        }
        return null;
    }

    public static Object forceGetProperty(Object object, String propertyName) {
        Object result = null;
        if (StringUtils.isBlank(propertyName)) {
            return null;
        }
        try {
            if (object instanceof Map) {
                result = ((Map)object).get(propertyName);
            } else if (object instanceof String) {
                if (null == object) {
                    return null;
                }
                String msg = object.toString();
                int s = msg.indexOf(propertyName);
                if (s >= 0) {
                    String nmsg = msg.substring(s);
                    int e = (nmsg = nmsg.replaceAll("\\\\", "")).substring(propertyName.length() + 3).indexOf("\"");
                    result = -1 == e ? nmsg.substring(propertyName.length() + 3) : nmsg.substring(propertyName.length() + 3, propertyName.length() + 3 + e);
                }
            } else {
                result = object instanceof List ? BeanUtils.forceGetProperty(((List)object).get(0), propertyName) : (object instanceof String[] ? BeanUtils.forceGetProperty(((String[])object)[0], propertyName) : BeanUtils.getObjValue(object, propertyName, null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void setNameProperty(Object object, String propertyName, Object newValue) throws NoSuchFieldException {
        Field field = BeanUtils.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(object, newValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        field.setAccessible(accessible);
    }

    public static void forceSetProperty(Object object, String propertyName, Object newValue) {
        if (null == object || StringUtils.isBlank(propertyName)) {
            return;
        }
        String[] s = propertyName.split("\\.");
        if (null == s) {
            return;
        }
        for (int i = 0; i < s.length - 1; ++i) {
            object = BeanUtils.forceGetProperty(object, s[i]);
        }
        try {
            if (object instanceof Map) {
                ((Map)object).put(propertyName, newValue);
            } else {
                BeanUtils.setObjValue(object, propertyName, newValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object invokePrivateMethod(Object object, String methodName, Object ... params) throws NoSuchMethodException {
        Class[] types = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = params[i].getClass();
        }
        Class<?> clazz = object.getClass();
        AccessibleObject method = null;
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                method = superClass.getDeclaredMethod(methodName, types);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("No Such Method:" + clazz.getSimpleName() + methodName);
        }
        boolean accessible = method.isAccessible();
        ((Method)method).setAccessible(true);
        Object result = null;
        try {
            result = ((Method)method).invoke(object, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Method)method).setAccessible(accessible);
        return result;
    }

    public static Method transferMethoder(String classpath, String methodname, Class[] types) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classpath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getMethod(methodname, types);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static Method transferMethoder(Object obj, String methodname, Class[] types) {
        Class<?> clazz;
        for (Class<?> superClass = clazz = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getMethod(methodname, types);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static Field[] getObjProperty(Object obj) {
        Class<?> c = obj.getClass();
        Field[] field = c.getDeclaredFields();
        return field;
    }

    public static void copySupperPropertys(Object arg0, Object arg1) throws Exception {
        if (null != arg0 && null != arg1) {
            Object value = null;
            if (arg1 instanceof Map) {
                for (String key : ((Map)arg1).keySet()) {
                    value = BeanUtils.forceGetProperty(arg1, key);
                    BeanUtils.forceSetProperty(arg0, key, value);
                }
            } else {
                Field[] field = BeanUtils.getObjSupperProperty(arg1);
                if (null != field) {
                    for (int i = 0; i < field.length; ++i) {
                        value = BeanUtils.forceGetProperty(arg1, field[i].getName());
                        BeanUtils.forceSetProperty(arg0, field[i].getName(), value);
                    }
                }
            }
        } else {
            throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    public static void copyAllPropertys(Object arg0, Object arg1) throws Exception {
        if (null != arg0 && null != arg1) {
            Object value = null;
            if (arg1 instanceof Map) {
                for (String key : ((Map)arg1).keySet()) {
                    value = BeanUtils.forceGetProperty(arg1, key);
                    BeanUtils.forceSetProperty(arg0, key, value);
                }
            } else {
                Field[] field = BeanUtils.getObjAllProperty(arg1);
                if (null != field) {
                    for (int i = 0; i < field.length; ++i) {
                        if ("serialVersionUID".equals(field[i].getName())) continue;
                        value = BeanUtils.forceGetProperty(arg1, field[i].getName());
                        BeanUtils.forceSetProperty(arg0, field[i].getName(), value);
                    }
                }
            }
        } else {
            throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    public static void copyImplPropertys(Object arg0, Object arg1) throws Exception {
        if (null != arg0 && null != arg1) {
            Object value = null;
            if (arg1 instanceof Map) {
                for (String key : ((Map)arg1).keySet()) {
                    value = BeanUtils.forceGetProperty(arg1, key);
                    BeanUtils.forceSetProperty(arg0, key, value);
                }
            } else {
                Field[] field = BeanUtils.getObjProperty(arg1);
                if (null != field) {
                    for (int i = 0; i < field.length; ++i) {
                        value = BeanUtils.forceGetProperty(arg1, field[i].getName());
                        BeanUtils.forceSetProperty(arg0, field[i].getName(), value);
                    }
                }
            }
        } else {
            throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    public static String checkImplNull(Object arg0, Map<String, String> notcl) {
        String msg;
        block6: {
            Object value;
            block5: {
                if (null == arg0) {
                    return "null";
                }
                value = null;
                msg = "";
                if (!(arg0 instanceof Map)) break block5;
                for (String key : ((Map)arg0).keySet()) {
                    if ("serialVersionUID".equals(key) || notcl.containsKey(key)) continue;
                    value = BeanUtils.forceGetProperty(arg0, key);
                    if (null == value) {
                        msg = msg + key + " is null ";
                        continue;
                    }
                    if (!(value instanceof String) || !StringUtils.isBlank(value.toString())) continue;
                    msg = msg + key + " is null ";
                }
                break block6;
            }
            Field[] field = BeanUtils.getObjProperty(arg0);
            if (null == field) break block6;
            for (int i = 0; i < field.length; ++i) {
                if ("serialVersionUID".equals(field[i].getName()) || notcl.containsKey(field[i].getName())) continue;
                value = BeanUtils.forceGetProperty(arg0, field[i].getName());
                if (null == value) {
                    msg = msg + field[i].getName() + " is null ";
                    continue;
                }
                if (!(value instanceof String) || !StringUtils.isBlank(value.toString())) continue;
                msg = msg + field[i].getName() + " is null ";
            }
        }
        return msg;
    }

    public static Field[] getObjSupperProperty(Object obj) {
        Class<?> c = obj.getClass();
        Class<?> supper = c.getSuperclass();
        ArrayList<Field> list = new ArrayList<Field>();
        if (null != supper) {
            for (Class<?> superClass = supper; superClass != Object.class; superClass = superClass.getSuperclass()) {
                Field[] fieldchild = superClass.getDeclaredFields();
                if (null == fieldchild) continue;
                for (Field field2 : fieldchild) {
                    list.add(field2);
                }
            }
        }
        Field[] field = new Field[list.size()];
        field = list.toArray(field);
        return field;
    }

    public static Field[] getObjOpSupperProperty(Object obj) {
        Class<?> c = obj.getClass();
        Class<?> supper = c.getSuperclass();
        ArrayList<Field> list = new ArrayList<Field>();
        if (null != supper) {
            for (Class<?> superClass = supper; superClass != Object.class; superClass = superClass.getSuperclass()) {
                Field[] fieldchild = superClass.getDeclaredFields();
                if (null == fieldchild) continue;
                for (Field field2 : fieldchild) {
                    list.add(field2);
                }
            }
        }
        Field[] field = new Field[list.size()];
        field = list.toArray(field);
        return field;
    }

    public static Field[] getObjAllProperty(Object obj) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            Field[] fieldchild = superClass.getDeclaredFields();
            if (null == fieldchild) continue;
            for (Field field2 : fieldchild) {
                list.add(field2);
            }
        }
        Field[] field = new Field[list.size()];
        field = list.toArray(field);
        return field;
    }

    public static Field[] getObjAllOpProperty(Object obj) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            Field[] fieldchild = superClass.getDeclaredFields();
            if (null == fieldchild) continue;
            for (Field field2 : fieldchild) {
                list.add(field2);
            }
        }
        Field[] field = new Field[list.size()];
        field = list.toArray(field);
        return field;
    }

    public static String getProNameMethod(String proName) {
        String methodName = "";
        if (StringUtils.isNotBlank(proName)) {
            methodName = "get" + StringUtils.getFirstUpper(proName);
        }
        return methodName;
    }

    public static String getProSetNameMethod(String proName) {
        String methodName = "";
        if (StringUtils.isNotBlank(proName)) {
            methodName = "set" + StringUtils.getFirstUpper(proName);
        }
        return methodName;
    }

    public static Object getObjValue(Object obj, String name, Object defObj) {
        Object valueObj = null;
        String methodName = BeanUtils.getProNameMethod(name);
        Method method = BeanUtils.transferMethoder(obj, methodName, new Class[0]);
        if (null != method) {
            try {
                valueObj = method.invoke(obj, new Object[0]);
                if (null == valueObj) {
                    valueObj = defObj;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return valueObj;
    }

    public static void setObjValue(Object obj, String name, Object defObj) {
        String methodName = BeanUtils.getProSetNameMethod(name);
        try {
            Field field = BeanUtils.getDeclaredField(obj, name);
            if (null == field) {
                return;
            }
            Class<?> fclass = field.getType();
            Object valueobj = BeanUtils.getValueByType(fclass, defObj);
            Class[] types = new Class[]{fclass};
            Method method = BeanUtils.transferMethoder(obj, methodName, types);
            if (null != method) {
                method.invoke(obj, valueobj);
            }
        }
        catch (Exception e) {
            System.out.println(name + "==" + defObj + "==");
            e.printStackTrace();
        }
    }

    public static Object getValueByType(Class cls, Object defObj) {
        Object obj = defObj;
        if (cls == null) {
            return obj;
        }
        String className = cls.getName();
        if (null == className) {
            return obj;
        }
        if (className.indexOf("[") == 0) {
            return obj;
        }
        if (null != defObj && defObj.getClass().getName().equals(className)) {
            return obj;
        }
        if (className.indexOf("String") >= 0) {
            obj = null == defObj ? null : defObj + "";
        } else if (className.indexOf("int") >= 0) {
            if (null == defObj || StringUtils.isBlank(String.valueOf(defObj))) {
                defObj = "0";
            }
            obj = Long.valueOf(String.valueOf(defObj)).intValue();
        } else if (className.indexOf("Long") >= 0 || className.indexOf("long") >= 0) {
            if (null == defObj || StringUtils.isBlank(String.valueOf(defObj))) {
                defObj = "0";
            }
            obj = Long.valueOf(String.valueOf(defObj));
        } else if (className.indexOf("Number") >= 0 || className.indexOf("number") >= 0) {
            if (null == defObj || StringUtils.isBlank(String.valueOf(defObj))) {
                defObj = "0";
            }
            obj = Long.valueOf(String.valueOf(defObj));
        } else if (className.indexOf("Double") >= 0) {
            if (null == defObj || StringUtils.isBlank(String.valueOf(defObj))) {
                defObj = "0";
            }
            obj = Double.valueOf(String.valueOf(defObj));
        } else if (className.indexOf("double") >= 0) {
            if (null == defObj || StringUtils.isBlank(String.valueOf(defObj))) {
                defObj = "0";
            }
            obj = Double.valueOf(String.valueOf(defObj));
        } else if (className.indexOf("Date") >= 0) {
            if (null != defObj && StringUtils.isNotBlank(String.valueOf(defObj)) && (obj = String.valueOf(defObj).length() > 10 ? DateUtils.getDateToString(String.valueOf(defObj), "yyyy-MM-dd HH:mm:ss") : DateUtils.getDateToString(String.valueOf(defObj), "yyyy-MM-dd")) == null) {
                obj = defObj;
            }
        } else if (className.indexOf("Integer") >= 0) {
            if (null == defObj || StringUtils.isBlank(String.valueOf(defObj))) {
                defObj = "0";
            }
            obj = Integer.valueOf(String.valueOf(defObj));
        } else if (className.indexOf("boolean") >= 0) {
            if (null == defObj || StringUtils.isBlank(String.valueOf(defObj))) {
                defObj = "false";
            }
            obj = "true".equals(String.valueOf(defObj)) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        } else if (className.indexOf("Boolean") >= 0) {
            if (null == defObj || StringUtils.isBlank(String.valueOf(defObj))) {
                defObj = "false";
            }
            obj = "true".equals(String.valueOf(defObj)) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        } else if (cls.isEnum()) {
            obj = Enum.valueOf(cls, defObj.toString());
        } else if (className.indexOf("BigDecimal") >= 0 && null != defObj && !StringUtils.isBlank(String.valueOf(defObj))) {
            obj = new BigDecimal(String.valueOf(defObj));
        }
        return obj;
    }

    public static void setObjValue(Object obj, String name, String defObj) {
        String methodName = BeanUtils.getProSetNameMethod(name);
        try {
            Field field = BeanUtils.getDeclaredField(obj, name);
            Class<?> fclass = field.getType();
            Class[] types = new Class[]{fclass};
            Method method = BeanUtils.transferMethoder(obj, methodName, types);
            if (null != method) {
                method.invoke(obj, BeanUtils.getStringToType(fclass, defObj));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Object getObject(Object obj, String name, String defObj) {
        String methodName = BeanUtils.getProSetNameMethod(name);
        try {
            Field field = BeanUtils.getDeclaredField(obj, name);
            Class<?> fclass = field.getType();
            Class[] types = new Class[]{fclass};
            return BeanUtils.getStringToType(fclass, defObj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getObjectHql(Object obj, String name, List<Object> paramlist, Object value) {
        String methodName = BeanUtils.getProSetNameMethod(name);
        try {
            Field field = BeanUtils.getDeclaredField(obj, name);
            Class<?> fclass = field.getType();
            Class[] types = new Class[]{fclass};
            return BeanUtils.getStringToHql(fclass, name, paramlist, value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getStringToType(Class typeClass, String value) {
        Object obj = null;
        if (typeClass.equals(String.class)) {
            obj = null == value || StringUtils.isBlank(value) ? "" : String.valueOf(value);
        } else if (typeClass.equals(Double.class)) {
            obj = null == value || StringUtils.isBlank(value) ? Double.valueOf(0.0) : Double.valueOf(value);
        } else if (typeClass.equals(Integer.class)) {
            obj = null == value || StringUtils.isBlank(value) ? Integer.valueOf(0) : Integer.valueOf(value);
        } else if (typeClass.equals(Date.class)) {
            obj = null == value || StringUtils.isBlank(value) ? null : DateUtils.getDateToString(value, "yyyy-MM-dd HH:mm:ss");
        } else if (typeClass.equals(Long.class)) {
            obj = null == value || StringUtils.isBlank(value) ? Long.valueOf(0L) : Long.valueOf(value);
        } else if (typeClass.equals(BigDecimal.class)) {
            if (null != value && !StringUtils.isBlank(value)) {
                obj = new BigDecimal(value);
            }
        } else {
            obj = 0;
        }
        return obj;
    }

    public static String getStringToHql(Class typeClass, String name, List<Object> paramlist, Object value) {
        String obj = null;
        if (typeClass.equals(String.class)) {
            obj = "'--'";
            paramlist.add(null == value || "".equals(value) ? "--" : value);
        } else if (typeClass.equals(Double.class)) {
            obj = "0";
            paramlist.add(null == value || "".equals(value) ? Double.valueOf(0.0) : value);
        } else if (typeClass.equals(Integer.class)) {
            obj = "0";
            paramlist.add(null == value || "".equals(value) ? Integer.valueOf(0) : value);
        } else if (typeClass.equals(Date.class)) {
            obj = "to_date('1991.01.01','yyyy.mm.dd')";
            paramlist.add(null == value || "".equals(value) ? new Date("1991.01.01") : value);
        } else if (typeClass.equals(Long.class)) {
            obj = "0";
            paramlist.add(null == value || "".equals(value) ? Long.valueOf(0L) : value);
        } else {
            obj = "0";
            paramlist.add(null == value || "".equals(value) ? Integer.valueOf(0) : value);
        }
        return obj;
    }

    public static void copyAllPropertysNotNull(Object arg0, Object arg1) throws Exception {
        if (null != arg0 && null != arg1) {
            Object value = null;
            if (arg1 instanceof Map) {
                for (String key : ((Map)arg1).keySet()) {
                    value = BeanUtils.forceGetProperty(arg1, key);
                    if (value == null) continue;
                    BeanUtils.forceSetProperty(arg0, key, value);
                }
            } else {
                Field[] field = BeanUtils.getObjAllProperty(arg1);
                if (null != field) {
                    for (int i = 0; i < field.length; ++i) {
                        value = BeanUtils.forceGetProperty(arg1, field[i].getName());
                        if (value == null) continue;
                        BeanUtils.forceSetProperty(arg0, field[i].getName(), value);
                    }
                }
            }
        } else {
            throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    private static List<Field> getFieldList(Class clazz, List<Field> fieldList) {
        Field[] fields = clazz.getDeclaredFields();
        fieldList.addAll(Arrays.asList(fields));
        Field[] pFields = clazz.getSuperclass().getDeclaredFields();
        if (pFields == null || pFields.length <= 0) {
            return fieldList;
        }
        fieldList.addAll(Arrays.asList(pFields));
        BeanUtils.getFieldList(clazz.getSuperclass(), fieldList);
        return fieldList;
    }

    public static void copyMapToObject(Object obj, Map<String, Object> kv, Map<String, Class> defineClass, Class money) throws Exception {
        try {
            if (MapUtil.isEmpty(kv)) {
                return;
            }
            if (money.getName().equals(obj.getClass().getName())) {
                Method setCentMethod = obj.getClass().getMethod("setCent", Long.TYPE);
                setCentMethod.invoke(obj, kv.get("cent"));
                return;
            }
            ArrayList<Field> fieldList = new ArrayList<Field>();
            BeanUtils.getFieldList(obj.getClass(), fieldList);
            for (Field field : fieldList) {
                Object value;
                if (field.getModifiers() != 2 && field.getModifiers() != 4) continue;
                field.setAccessible(true);
                if (MapUtil.isNotEmpty(defineClass) && defineClass.containsKey(field.getName()) && defineClass.values().contains(field.getType())) {
                    Map<String, Object> subKv = null;
                    subKv = kv.get(field.getName()) instanceof Map ? (Map<String, Object>)kv.get(field.getName()) : MapUtil.castMapByObject(kv.get(field.getName()));
                    Class clazz = defineClass.get(field.getName());
                    Object subObj = clazz.newInstance();
                    BeanUtils.copyMapToObject(subObj, subKv, defineClass, money);
                    kv.put(field.getName(), subObj);
                }
                if ((value = kv.get(field.getName())) == null) continue;
                if (field.getType().getName().equals(BigDecimal.class.getName())) {
                    value = new BigDecimal(String.valueOf(kv.get(field.getName())));
                } else if (field.getType().getName().equals(Currency.class.getName())) {
                    value = Currency.getInstance((String)value);
                } else if (field.getType().getName().equals(Long.class.getName())) {
                    value = Long.parseLong(String.valueOf(value));
                } else if (field.getType().getName().equals(Date.class.getName())) {
                    value = DateUtil.getDateToString(String.valueOf(value), "yyyy-MM-dd HH:mm:ss");
                }
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static void copyMapToObject(Object obj, Map<String, Object> kv, Map<String, Class> defineClass, Map<Class, Object> enumMap, Class money) throws Exception {
        try {
            if (MapUtil.isEmpty(kv)) {
                return;
            }
            if (money.getName().equals(obj.getClass().getName())) {
                Method setCentMethod = obj.getClass().getMethod("setCent", Long.TYPE);
                setCentMethod.invoke(obj, kv.get("cent"));
                return;
            }
            ArrayList<Field> fieldList = new ArrayList<Field>();
            BeanUtils.getFieldList(obj.getClass(), fieldList);
            for (Field field : fieldList) {
                Object value;
                if (field.getModifiers() != 2 && field.getModifiers() != 4) continue;
                field.setAccessible(true);
                if (MapUtil.isNotEmpty(defineClass) && defineClass.containsKey(field.getName()) && defineClass.values().contains(field.getType())) {
                    Map<String, Object> subKv = null;
                    subKv = kv.get(field.getName()) instanceof Map ? (Map<String, Object>)kv.get(field.getName()) : MapUtil.castMapByObject(kv.get(field.getName()));
                    Class clazz = defineClass.get(field.getName());
                    Object subObj = clazz.newInstance();
                    BeanUtils.copyMapToObject(subObj, subKv, defineClass, enumMap, money);
                    kv.put(field.getName(), subObj);
                }
                if ((value = kv.get(field.getName())) == null) continue;
                if (field.getType().getName().equals(BigDecimal.class.getName())) {
                    value = new BigDecimal(String.valueOf(kv.get(field.getName())));
                } else if (field.getType().getName().equals(Currency.class.getName())) {
                    value = Currency.getInstance((String)value);
                } else if (field.getType().getName().equals(Long.class.getName())) {
                    value = Long.parseLong(String.valueOf(value));
                } else if (field.getType().getName().equals(Date.class.getName())) {
                    value = DateUtil.getDateToString(String.valueOf(value), "yyyy-MM-dd HH:mm:ss");
                }
                if (MapUtil.isNotEmpty(enumMap) && enumMap.containsKey(field.getType())) {
                    Map enumCVMap = (Map)enumMap.get(field.getType());
                    value = enumCVMap.get(String.valueOf(value).toUpperCase());
                }
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static void copyMapToObject(Object obj, Map<String, Object> kv, Map<String, Class> defineClass, Map<Class, Object> enumMap, Map<String, Class> listValMap, Class money) throws Exception {
        try {
            if (MapUtil.isEmpty(kv)) {
                return;
            }
            if (money.getName().equals(obj.getClass().getName())) {
                Method setCentMethod = obj.getClass().getMethod("setCent", Long.TYPE);
                setCentMethod.invoke(obj, kv.get("cent"));
                return;
            }
            ArrayList<Field> fieldList = new ArrayList<Field>();
            BeanUtils.getFieldList(obj.getClass(), fieldList);
            for (Field field : fieldList) {
                Object value;
                List mapList;
                if (field.getModifiers() != 2 && field.getModifiers() != 4 && 0 != field.getModifiers()) continue;
                field.setAccessible(true);
                if (MapUtil.isNotEmpty(defineClass) && defineClass.containsKey(field.getName()) && defineClass.values().contains(field.getType())) {
                    Map<String, Object> subKv = null;
                    subKv = kv.get(field.getName()) instanceof Map ? (Map<String, Object>)kv.get(field.getName()) : MapUtil.castMapByObject(kv.get(field.getName()));
                    Class clazz = defineClass.get(field.getName());
                    Object subObj = clazz.newInstance();
                    BeanUtils.copyMapToObject(subObj, subKv, defineClass, enumMap, listValMap, money);
                    kv.put(field.getName(), subObj);
                } else if (MapUtil.isNotEmpty(listValMap) && listValMap.containsKey(field.getName()) && ListUtil.isNotEmpty(mapList = (List)(value = kv.get(field.getName())))) {
                    ArrayList valList = new ArrayList();
                    for (int i = 0; i < mapList.size(); ++i) {
                        Map map = (Map)mapList.get(i);
                        Object subObj = listValMap.get(field.getName()).newInstance();
                        BeanUtils.copyMapToObject(subObj, map, defineClass, enumMap, listValMap, money);
                        valList.add(subObj);
                    }
                    kv.put(field.getName(), valList);
                }
                if ((value = kv.get(field.getName())) == null) continue;
                if (field.getType().getName().equals(BigDecimal.class.getName())) {
                    value = new BigDecimal(String.valueOf(kv.get(field.getName())));
                } else if (field.getType().getName().equals(Currency.class.getName())) {
                    value = Currency.getInstance((String)value);
                } else if (field.getType().getName().equals(Long.class.getName())) {
                    value = Long.parseLong(String.valueOf(value));
                } else if (field.getType().getName().equals(Date.class.getName())) {
                    value = DateUtil.getDateToString(String.valueOf(value), "yyyy-MM-dd HH:mm:ss");
                }
                if (MapUtil.isNotEmpty(enumMap) && enumMap.containsKey(field.getType())) {
                    Map enumCVMap = (Map)enumMap.get(field.getType());
                    value = enumCVMap.get(String.valueOf(value).toUpperCase());
                }
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static void copyMapToObjectSN(Object obj, Map<String, Object> kv, Map<String, Class> defineClass, Map<Class, Object> enumMap, Map<String, Class[]> listValMap, Class money) throws Exception {
        try {
            if (MapUtil.isEmpty(kv)) {
                return;
            }
            if (money.getName().equals(obj.getClass().getName())) {
                Method setCentMethod = obj.getClass().getMethod("setCent", Long.TYPE);
                setCentMethod.invoke(obj, kv.get("cent"));
                return;
            }
            ArrayList<Field> fieldList = new ArrayList<Field>();
            BeanUtils.getFieldList(obj.getClass(), fieldList);
            for (Field field : fieldList) {
                Object value;
                List mapList;
                if (field.getModifiers() != 2 && field.getModifiers() != 4 && 0 != field.getModifiers()) continue;
                field.setAccessible(true);
                if (MapUtil.isNotEmpty(defineClass) && defineClass.containsKey(field.getName()) && defineClass.values().contains(field.getType())) {
                    Map<String, Object> subKv = null;
                    subKv = kv.get(field.getName()) instanceof Map ? (Map<String, Object>)kv.get(field.getName()) : MapUtil.castMapByObject(kv.get(field.getName()));
                    Class clazz = defineClass.get(field.getName());
                    Object subObj = clazz.newInstance();
                    BeanUtils.copyMapToObjectSN(subObj, subKv, defineClass, enumMap, listValMap, money);
                    kv.put(field.getName(), subObj);
                } else if (MapUtil.isNotEmpty(listValMap) && listValMap.containsKey(field.getName()) && ListUtil.isNotEmpty(mapList = (List)(value = kv.get(field.getName())))) {
                    ArrayList<Object> valList = new ArrayList<Object>();
                    for (int i = 0; i < mapList.size(); ++i) {
                        Map map = (Map)mapList.get(i);
                        Class genericsfieldType = GenericsUtils.getFieldGenericType(field);
                        Class[] classes = listValMap.get(field.getName());
                        Object subObj = null;
                        for (Class clazz : classes) {
                            if (!genericsfieldType.getName().equals(clazz.getName())) continue;
                            subObj = genericsfieldType.newInstance();
                        }
                        BeanUtils.copyMapToObjectSN(subObj, map, defineClass, enumMap, listValMap, money);
                        valList.add(subObj);
                    }
                    kv.put(field.getName(), valList);
                }
                if ((value = kv.get(field.getName())) == null) continue;
                if (field.getType().getName().equals(BigDecimal.class.getName())) {
                    value = new BigDecimal(String.valueOf(kv.get(field.getName())));
                } else if (field.getType().getName().equals(Currency.class.getName())) {
                    value = Currency.getInstance((String)value);
                } else if (field.getType().getName().equals(Long.class.getName())) {
                    value = Long.parseLong(String.valueOf(value));
                } else if (field.getType().getName().equals(Date.class.getName())) {
                    value = DateUtil.getDateToString(String.valueOf(value), "yyyy-MM-dd HH:mm:ss");
                }
                if (MapUtil.isNotEmpty(enumMap) && enumMap.containsKey(field.getType())) {
                    Map enumCVMap = (Map)enumMap.get(field.getType());
                    value = enumCVMap.get(String.valueOf(value).toUpperCase());
                }
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

