/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class DoubleUtil {
    private static final String WEIGHTFORMAT = "##,###,###,##0.000";
    private static final String WEIGHTFORMATINPUT = "##########0.000";
    private static final String QUOTIETYINPUT = "##########0.000000";
    private static final String NUMBER = "##,###,###,##0";
    private static final String NUMBERINPUT = "##########0";
    private static final String PRICE = "##,###,###,##0.00";
    private static final String PRICEINPUT = "##########0.00";

    public static String convertToWeight(Double d, String partsname) {
        if (null == d) {
            d = 0.0;
        }
        String s = DoubleUtil.convertDoubleFormat(d, WEIGHTFORMAT);
        return s;
    }

    public static String convertToWeightInput(Double d, String partsname) {
        if (null == d) {
            d = 0.0;
        }
        String s = DoubleUtil.convertDoubleFormat(d, WEIGHTFORMATINPUT);
        return s;
    }

    public static String convertToNumber(Double d, String partsname) {
        if (null == d) {
            d = 0.0;
        }
        return DoubleUtil.convertDoubleFormat(d, NUMBER);
    }

    public static String convertToNumberInput(Double d, String partsname) {
        if (null == d) {
            d = 0.0;
        }
        return DoubleUtil.convertDoubleFormat(d, NUMBERINPUT);
    }

    public static String convertToQuotiety(Double d) {
        if (null == d) {
            d = 0.0;
        }
        return DoubleUtil.convertDoubleFormat(d, QUOTIETYINPUT);
    }

    public static String convertToPrice(Double d) {
        if (null == d) {
            d = 0.0;
        }
        return DoubleUtil.convertDoubleFormat(d, PRICE);
    }

    public static String convertToPriceInput(Double d) {
        if (null == d) {
            d = 0.0;
        }
        return DoubleUtil.convertDoubleFormat(d, PRICEINPUT);
    }

    public static String convertToString(Double d) {
        if (null == d) {
            d = 0.0;
        }
        String f = "";
        for (int i = 0; i < String.valueOf(d).length(); ++i) {
            f = f + "#";
        }
        DecimalFormat df = new DecimalFormat(f);
        String s = df.format(d);
        return s;
    }

    public static String convertToString(Double d, String format) {
        if (null == d) {
            d = 0.0;
        }
        DecimalFormat df = new DecimalFormat(format);
        String s = df.format(d);
        return s;
    }

    public static String convertRToString(Double d, String rchar, int n) {
        if (null == d) {
            d = 0.0;
        }
        String f = "";
        for (int i = 0; i < n; ++i) {
            f = f + rchar;
        }
        DecimalFormat df = new DecimalFormat(f);
        String s = df.format(d);
        return s;
    }

    public static double round(Double v, int scale) {
        if (null == v) {
            v = 0.0;
        }
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static double round(String v, int scale) {
        if (null == v) {
            v = "0";
        }
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(v);
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static double preciseAdd(Double a, Double b) {
        if (null == b) {
            b = 0.0;
        }
        if (null == a) {
            a = 0.0;
        }
        BigDecimal r = new BigDecimal(Double.toString(a));
        r = r.add(new BigDecimal(Double.toString(b)));
        return r.doubleValue();
    }

    public static double preciseAdd(Double a, Double b, int scale) {
        if (null == b) {
            b = 0.0;
        }
        if (null == a) {
            a = 0.0;
        }
        BigDecimal r = new BigDecimal(Double.toString(a));
        r = r.add(new BigDecimal(Double.toString(b)));
        return DoubleUtil.round(r.doubleValue(), scale);
    }

    public static double preciseSub(Double a, Double b) {
        if (null == b) {
            b = 0.0;
        }
        if (null == a) {
            a = 0.0;
        }
        BigDecimal r = new BigDecimal(Double.toString(a));
        r = r.subtract(new BigDecimal(Double.toString(b)));
        return r.doubleValue();
    }

    public static double preciseSub(Double a, Double b, int scale) {
        if (null == b) {
            b = 0.0;
        }
        if (null == a) {
            a = 0.0;
        }
        BigDecimal r = new BigDecimal(Double.toString(a));
        r = r.subtract(new BigDecimal(Double.toString(b)));
        return DoubleUtil.round(r.doubleValue(), scale);
    }

    public static double preciseMul(Double a, Double b) {
        if (null == b || null == a) {
            return 0.0;
        }
        BigDecimal r = new BigDecimal(Double.toString(a));
        r = r.multiply(new BigDecimal(Double.toString(b)));
        return r.doubleValue();
    }

    public static double preciseMul(Double a, Double b, int scale) {
        if (null == b || null == a) {
            return 0.0;
        }
        return DoubleUtil.round(new BigDecimal(Double.toString(a)).multiply(new BigDecimal(Double.toString(b))).doubleValue(), scale);
    }

    public static double preciseDev(Double a, Double b) {
        if (null == b || b == 0.0 || null == a) {
            return 0.0;
        }
        BigDecimal r = new BigDecimal(Double.toString(a));
        r = r.divide(new BigDecimal(Double.toString(b)), 6, 4);
        return r.doubleValue();
    }

    public static double preciseDev(Double a, Double b, int scale) {
        if (null == b || b == 0.0 || null == a) {
            return 0.0;
        }
        BigDecimal r = new BigDecimal(Double.toString(a));
        r = r.divide(new BigDecimal(Double.toString(b)), scale, 4);
        return r.doubleValue();
    }

    public static String convertDoubleFormat(Double d, String f) {
        DecimalFormat df = new DecimalFormat(f);
        String s = df.format(d);
        return s;
    }

    public static String addDouble(String d1, String d2, boolean t) {
        if (DoubleUtil.isNumber(d1) && DoubleUtil.isNumber(d2)) {
            d1 = new BigDecimal(d1).add(new BigDecimal(d2)).toString();
        } else if (DoubleUtil.isNumber(d2)) {
            d1 = d2;
        }
        if (t && d1.indexOf(".") > 0) {
            d1 = d1.substring(0, d1.indexOf("."));
        }
        return d1;
    }

    public static boolean isNumber(String obj) {
        boolean t = false;
        if (StringUtils.isNotBlank(obj)) {
            try {
                if (Double.valueOf(obj) >= 0.0) {
                    t = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t;
    }

    public static boolean isNotBlank(Double obj) {
        return null != obj && !(obj <= 0.0);
    }

    public static boolean isBlank(Double obj) {
        return null == obj || obj <= 0.0;
    }

    public static boolean isNotEmpty(Double obj) {
        return null != obj && obj != 0.0;
    }

    public static boolean isEmpty(Double obj) {
        return null == obj || obj == 0.0;
    }
}

