/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastJsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(FastJsonUtil.class);
    private static FastJsonUtil allJsonUtil;
    private static FastJsonUtil notNullJsonUtil;
    private static FastJsonUtil notDefJsonUtil;
    private static FastJsonUtil notEmpJsonUtil;
    private static SerializeConfig config;
    private static final SerializerFeature[] features;

    public static FastJsonUtil getAllJsonUtil() {
        return allJsonUtil;
    }

    public static void setAllJsonUtil(FastJsonUtil allJsonUtil) {
        FastJsonUtil.allJsonUtil = allJsonUtil;
    }

    public static FastJsonUtil getNotNullJsonUtil() {
        return notNullJsonUtil;
    }

    public static void setNotNullJsonUtil(FastJsonUtil notNullJsonUtil) {
        FastJsonUtil.notNullJsonUtil = notNullJsonUtil;
    }

    public static FastJsonUtil getNotDefJsonUtil() {
        return notDefJsonUtil;
    }

    public static void setNotDefJsonUtil(FastJsonUtil notDefJsonUtil) {
        FastJsonUtil.notDefJsonUtil = notDefJsonUtil;
    }

    public static FastJsonUtil getNotEmpJsonUtil() {
        return notEmpJsonUtil;
    }

    public static void setNotEmpJsonUtil(FastJsonUtil notEmpJsonUtil) {
        FastJsonUtil.notEmpJsonUtil = notEmpJsonUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FastJsonUtil buildNormalBinder() {
        if (allJsonUtil != null) return allJsonUtil;
        Class<FastJsonUtil> clazz = FastJsonUtil.class;
        synchronized (FastJsonUtil.class) {
            if (allJsonUtil != null) return allJsonUtil;
            allJsonUtil = new FastJsonUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return allJsonUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FastJsonUtil buildNonNullBinder() {
        if (notNullJsonUtil != null) return notNullJsonUtil;
        Class<FastJsonUtil> clazz = FastJsonUtil.class;
        synchronized (FastJsonUtil.class) {
            if (notNullJsonUtil != null) return notNullJsonUtil;
            notNullJsonUtil = new FastJsonUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return notNullJsonUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FastJsonUtil buildNonDefaultBinder() {
        if (notDefJsonUtil != null) return notDefJsonUtil;
        Class<FastJsonUtil> clazz = FastJsonUtil.class;
        synchronized (FastJsonUtil.class) {
            if (notDefJsonUtil != null) return notDefJsonUtil;
            notDefJsonUtil = new FastJsonUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return notDefJsonUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FastJsonUtil buildNonEmptyBinder() {
        if (notEmpJsonUtil != null) return notEmpJsonUtil;
        Class<FastJsonUtil> clazz = FastJsonUtil.class;
        synchronized (FastJsonUtil.class) {
            if (notEmpJsonUtil != null) return notEmpJsonUtil;
            notEmpJsonUtil = new FastJsonUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return notEmpJsonUtil;
        }
    }

    public <T> T getJsonToObject(String json, Class<T> clazz) {
        T object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                return (T)JSON.parseObject((String)json, clazz);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToObject", (Throwable)e);
            }
        }
        return object;
    }

    public <T> List<T> getJsonToList(String json, Class<T> clazz) {
        if (StringUtils.isNotBlank(json)) {
            ParameterizedTypeImpl type2 = new ParameterizedTypeImpl(new Type[]{clazz}, null, List.class);
            try {
                return (List)JSON.parseObject((String)json, (Type)type2, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToObject", (Throwable)e);
            }
        }
        return null;
    }

    public <T, P extends List<T>> List<T> getList(String json, Class<P> collectionType, Class<T> clazz) {
        if (StringUtils.isNotBlank(json)) {
            ParameterizedTypeImpl type2 = new ParameterizedTypeImpl(new Type[]{clazz}, null, collectionType);
            try {
                return (List)JSON.parseObject((String)json, (Type)type2, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getList", (Throwable)e);
            }
        }
        return null;
    }

    public List<Map<?, ?>> getJsonToListByMap(String json, Class clazz) {
        if (StringUtils.isNotBlank(json)) {
            ParameterizedTypeImpl type1 = new ParameterizedTypeImpl(new Type[]{String.class, clazz}, null, Map.class);
            ParameterizedTypeImpl type2 = new ParameterizedTypeImpl(new Type[]{type1}, null, List.class);
            try {
                return (List)JSON.parseObject((String)json, (Type)type2, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToListByMap", (Throwable)e);
            }
        }
        return null;
    }

    public <T> Object[] getJsonToArray(String json, Class<T> clazz) {
        if (StringUtils.isNotBlank(json)) {
            try {
                return (Object[])JSON.parseObject((String)json, clazz);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToArray", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getJsonTobyteArray(String json) {
        if (StringUtils.isNotBlank(json)) {
            try {
                return (byte[])JSON.parseObject((String)json, byte[].class);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonTobyteArray", (Throwable)e);
            }
        }
        return null;
    }

    public static Object getValueFromJson(String json, String key) {
        try {
            if (StringUtils.isBlank(json) || StringUtils.isBlank(key)) {
                return null;
            }
            return JSON.parseObject((String)json).getString(key);
        }
        catch (Exception e) {
            logger.error("JsonUtil.getValueFromJson", (Throwable)e);
            return null;
        }
    }

    public <K, V> Map<K, V> getJsonToMap(String json, Class<K> keyclazz, Class<V> valueclazz) {
        if (StringUtils.isNotBlank(json)) {
            ParameterizedTypeImpl type2 = new ParameterizedTypeImpl(new Type[]{keyclazz, valueclazz}, null, Map.class);
            try {
                return (Map)JSON.parseObject((String)json, (Type)type2, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToMap", (Throwable)e);
            }
        }
        return null;
    }

    public <K, V> Map<K, List<V>> getJsonToMapByList(String json, Class<K> keyclazz, Class<V> valueclazz) {
        if (StringUtils.isNotBlank(json)) {
            ParameterizedTypeImpl listType = new ParameterizedTypeImpl(new Type[]{valueclazz}, null, List.class);
            ParameterizedTypeImpl type2 = new ParameterizedTypeImpl(new Type[]{keyclazz, listType}, null, Map.class);
            try {
                return (Map)JSON.parseObject((String)json, (Type)type2, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToMap", (Throwable)e);
            }
        }
        return null;
    }

    public <K, V> Map<K, Map<String, V>> getJsonToMapByMap(String json, Class<K> keyclazz, Class<V> valueclazz) {
        if (StringUtils.isNotBlank(json)) {
            ParameterizedTypeImpl listType = new ParameterizedTypeImpl(new Type[]{String.class, valueclazz}, null, Map.class);
            ParameterizedTypeImpl type2 = new ParameterizedTypeImpl(new Type[]{keyclazz, listType}, null, Map.class);
            try {
                return (Map)JSON.parseObject((String)json, (Type)type2, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToMap", (Throwable)e);
            }
        }
        return null;
    }

    public LinkedHashMap getJsonToLinkedMap(String json, Class keyclazz, Class valueclazz) {
        if (StringUtils.isNotBlank(json)) {
            ParameterizedTypeImpl type2 = new ParameterizedTypeImpl(new Type[]{keyclazz, valueclazz}, null, LinkedHashMap.class);
            try {
                return (LinkedHashMap)JSON.parseObject((String)json, (Type)type2, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToConcMap", (Throwable)e);
            }
        }
        return null;
    }

    public ConcurrentHashMap getJsonToConcMap(String json, Class keyclazz, Class valueclazz) {
        if (StringUtils.isNotBlank(json)) {
            ParameterizedTypeImpl type2 = new ParameterizedTypeImpl(new Type[]{keyclazz, valueclazz}, null, ConcurrentHashMap.class);
            try {
                return (ConcurrentHashMap)JSON.parseObject((String)json, (Type)type2, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToConcMap", (Throwable)e);
            }
        }
        return null;
    }

    public static Map<String, String> getJsonToMap(String str) {
        String[] s;
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank(str) && (s = str.split(",")).length > 0) {
            for (int i = 0; i < s.length; ++i) {
                String con = s[i];
                int s1 = con.indexOf(":");
                if (s1 > 0) {
                    map.put(con.substring(0, s1).trim().replace("\"", ""), con.substring(s1 + 1).replace("\"", ""));
                    continue;
                }
                map.put(con.trim().replace("\"", ""), "");
            }
        }
        return map;
    }

    public String getMapToJson(Map<String, String> map) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (null != map && !map.isEmpty()) {
            for (String key : map.keySet()) {
                String[] strS = new String[]{key, map.get(key)};
                list.add(strS);
            }
        }
        return this.jsonObject(list);
    }

    public String jsonObject(List list) {
        try {
            return JSON.toJSONString((Object)list, (SerializeConfig)config, (SerializerFeature[])features);
        }
        catch (Exception e) {
            logger.error("JsonUtil.jsonObject", (Throwable)e);
            return null;
        }
    }

    public Object getJsonToObject(String json, Class objclazz, Class ... pclazz) {
        if (StringUtils.isNotBlank(json)) {
            ParameterizedTypeImpl type2 = new ParameterizedTypeImpl((Type[])pclazz, null, (Type)objclazz);
            try {
                return JSON.parseObject((String)json, (Type)type2, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToObject", (Throwable)e);
            }
        }
        return null;
    }

    public <T> Object getJsonToObject(String json, TypeReference<T> typeReference) {
        if (StringUtils.isNotBlank(json)) {
            try {
                return JSON.parseObject((String)json, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("JsonUtil.getJsonToObject", (Throwable)e);
            }
        }
        return null;
    }

    public String toJson(Object object) {
        try {
            return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])features);
        }
        catch (Exception e) {
            logger.error("JsonUtil.getJsonToObject", (Throwable)e);
            return null;
        }
    }

    public static Object getResultObject(String json) {
        return json;
    }

    public static void main(String[] args) {
        String da = "2001-5-17";
        Date a = DateUtil.getDateToString(da, "yyyy-MM-dd");
        System.out.println(FastJsonUtil.buildNormalBinder().toJson(a));
    }

    static {
        config = new SerializeConfig();
        config.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        features = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty};
    }
}

