/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class QRCodeImgUtils {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public static BufferedImage buildQR(String imageContent, int width, int height, boolean logoFlag, String imgPath) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 1);
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = new MultiFormatWriter().encode(imageContent, BarcodeFormat.QR_CODE, width, height, hints);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        BufferedImage image = QRCodeImgUtils.toBufferedImage(bitMatrix, logoFlag, imgPath);
        return image;
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix, boolean insertFlag, String imgPath) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        if (insertFlag) {
            boolean needCompress = true;
            try {
                QRCodeImgUtils.insertImage(image, imgPath, needCompress);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    public static void insertImage(BufferedImage source, String imgPath, boolean needCompress) {
        URL url = null;
        Image src = null;
        try {
            url = new URL(imgPath);
            src = ImageIO.read(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int width = src.getWidth(null);
        int height = src.getHeight(null);
        if (needCompress) {
            if (width > 60) {
                width = 60;
            }
            if (height > 60) {
                height = 60;
            }
            Image image = src.getScaledInstance(width, height, 4);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            src = image;
        }
        Graphics2D graph = source.createGraphics();
        int x = (300 - width) / 2;
        int y = (300 - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }
}

