/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.Cipher;

public class RSAUtils {
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final String KEY_ALGORITHM = "RSA";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static byte[] sign(byte[] text, PrivateKey privateKey) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateKey);
        signature.update(text);
        return signature.sign();
    }

    public static boolean verify(byte[] text, byte[] sign, PublicKey publicKey) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicKey);
        signature.update(text);
        return signature.verify(sign);
    }

    public static byte[] encrypt(byte[] data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, key);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length << 1);
        int offSet = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache);
            offSet += 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static byte[] decrypt(byte[] encryptedData, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, key);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream(encryptedData.length);
        int offSet = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache);
            offSet += 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static KeyPair genKeyPair() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        return keyPairGen.generateKeyPair();
    }

    public static PrivateKey getPrivateKey(String privateKey) throws Exception {
        return KeyFactory.getInstance(KEY_ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKey)));
    }

    public static PublicKey getPublicKey(String publicKey) throws Exception {
        return KeyFactory.getInstance(KEY_ALGORITHM).generatePublic(new X509EncodedKeySpec(Base64.decodeBase64(publicKey)));
    }

    public static String getPrivateKey(KeyPair keyPair) throws Exception {
        return Base64.encodeBase64String(keyPair.getPrivate().getEncoded());
    }

    public static String getPublicKey(KeyPair keyPair) throws Exception {
        return Base64.encodeBase64String(keyPair.getPublic().getEncoded());
    }

    public static void main(String[] args) throws Exception {
        String privateKey = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAIYAvjoQp3a7AY2uIH8bLLD7vsuQelu/Ag86gLUb4vETYE6CGGi2Mq2FP57H3CjiCLL/f2VmSIeXNFiiPAxQrQL74miF3wZlc9OUgOgWTDXCcAG4DoN+/hwaCdXyh+7NjPP5k6Nci98+2++uaoB+UdWYuq3O7nQGWsdAAUp0wHs1AgMBAAECgYEAg7Z9RBOUlyZu+3TY6jaqsfdwbSRAsKdJffByDBIx+eWitug2182meFpN02L9Ko4qIM7zyJZF2kisIiaswSoXMzLV4ILVdUNVFmpQkd/ZZTho28cldFdqwlqpqIjGkizKvT7nVN6SZ8FTYBa2usXlBkn0r5vAjDTcnweFC9V6lgECQQDdBChidjHwBi2XScLZ6qvB4sYmNJdrjRGPHEFKK9i0rQ1UdXeKeLrTFfJ7qZUy4luIHXXxXixfbbegyPgaJ1uBAkEAmzazapb/KUuDBv3ky0fl2juo0WFhsbCo2n9fvJp30q4pMFgqjJ0/xZh62/ChW6Bz9fOzUsVzGnIunY33XFVJtQJAUjm/xJHwljnWMFjS0zwJVoLF8WTTiMHc7H84kx2o698N/IQPS0cLSoj5w6Qdy+aG4ycCwB+nJoGtNXZPR3upAQJAXNCrHXRKBVGoesfcx0qpQoUmgH6xQuaXMoG0qD3epVeMPeKbHxbxiaGS5m7QrtAWR9+BPl/gYtIg2gqI/ufpeQJBANeJ6FGcAJ2zsQrcSJYHV/lGRpxgpCis46xxWpITd8rCN8xuda2B3or24S7/xyBq8+q9Y0HgfhTHAi/T9TdR1FU=";
        String publickey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCGAL46EKd2uwGNriB/Gyyw+77LkHpbvwIPOoC1G+LxE2BOghhotjKthT+ex9wo4giy/39lZkiHlzRYojwMUK0C++Johd8GZXPTlIDoFkw1wnABuA6Dfv4cGgnV8ofuzYzz+ZOjXIvfPtvvrmqAflHVmLqtzu50BlrHQAFKdMB7NQIDAQAB";
        String tenantCode = "00000000";
        Date date = DateUtil.getDateToString("2022-09-30 13:47:13", "yyyy-MM-dd HH:mm:ss");
        System.out.println(date);
        String code = "1234567890";
        String text = "";
        String round = tenantCode.substring(tenantCode.length() - 1);
        String roundnum = code.substring(Integer.valueOf(round), Integer.valueOf(round) + 1);
        text = text + tenantCode;
        text = text + code;
        text = text + DateUtil.getDateString(date, "yyyyMMdd");
        text = text + roundnum;
        byte[] s = RSAUtils.sign(text.getBytes("utf-8"), RSAUtils.getPrivateKey(privateKey));
        String sign = Base64.encodeBase64String(s);
        System.out.println(text);
        System.out.println(sign);
    }
}

