/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Mandate;
import com.stripe.model.PaymentMethod;
import com.stripe.model.SetupAttemptCollection;
import com.stripe.model.SetupIntent;
import com.stripe.model.StripeError;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.SetupAttemptListParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SetupAttempt
extends ApiResource
implements HasId {
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="attach_to_self")
    Boolean attachToSelf;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="flow_directions")
    List<String> flowDirections;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="payment_method")
    ExpandableField<PaymentMethod> paymentMethod;
    @SerializedName(value="payment_method_details")
    PaymentMethodDetails paymentMethodDetails;
    @SerializedName(value="setup_error")
    StripeError setupError;
    @SerializedName(value="setup_intent")
    ExpandableField<SetupIntent> setupIntent;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="usage")
    String usage;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentMethod() {
        return this.paymentMethod != null ? this.paymentMethod.getId() : null;
    }

    public void setPaymentMethod(String id) {
        this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
    }

    public PaymentMethod getPaymentMethodObject() {
        return this.paymentMethod != null ? this.paymentMethod.getExpanded() : null;
    }

    public void setPaymentMethodObject(PaymentMethod expandableObject) {
        this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public String getSetupIntent() {
        return this.setupIntent != null ? this.setupIntent.getId() : null;
    }

    public void setSetupIntent(String id) {
        this.setupIntent = ApiResource.setExpandableFieldId(id, this.setupIntent);
    }

    public SetupIntent getSetupIntentObject() {
        return this.setupIntent != null ? this.setupIntent.getExpanded() : null;
    }

    public void setSetupIntentObject(SetupIntent expandableObject) {
        this.setupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
    }

    public static SetupAttemptCollection list(Map<String, Object> params) throws StripeException {
        return SetupAttempt.list(params, (RequestOptions)null);
    }

    public static SetupAttemptCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/setup_attempts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (SetupAttemptCollection)SetupAttempt.getGlobalResponseGetter().request(request, (Type)((Object)SetupAttemptCollection.class));
    }

    public static SetupAttemptCollection list(SetupAttemptListParams params) throws StripeException {
        return SetupAttempt.list(params, (RequestOptions)null);
    }

    public static SetupAttemptCollection list(SetupAttemptListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/setup_attempts";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (SetupAttemptCollection)SetupAttempt.getGlobalResponseGetter().request(request, (Type)((Object)SetupAttemptCollection.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.application, responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
        this.trySetResponseGetter(this.onBehalfOf, responseGetter);
        this.trySetResponseGetter(this.paymentMethod, responseGetter);
        this.trySetResponseGetter(this.paymentMethodDetails, responseGetter);
        this.trySetResponseGetter(this.setupError, responseGetter);
        this.trySetResponseGetter(this.setupIntent, responseGetter);
    }

    @Generated
    public Boolean getAttachToSelf() {
        return this.attachToSelf;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public List<String> getFlowDirections() {
        return this.flowDirections;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodDetails getPaymentMethodDetails() {
        return this.paymentMethodDetails;
    }

    @Generated
    public StripeError getSetupError() {
        return this.setupError;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public void setAttachToSelf(Boolean attachToSelf) {
        this.attachToSelf = attachToSelf;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setFlowDirections(List<String> flowDirections) {
        this.flowDirections = flowDirections;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodDetails(PaymentMethodDetails paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
    }

    @Generated
    public void setSetupError(StripeError setupError) {
        this.setupError = setupError;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetupAttempt)) {
            return false;
        }
        SetupAttempt other = (SetupAttempt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$attachToSelf = this.getAttachToSelf();
        Boolean other$attachToSelf = other.getAttachToSelf();
        if (this$attachToSelf == null ? other$attachToSelf != null : !((Object)this$attachToSelf).equals(other$attachToSelf)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        List<String> this$flowDirections = this.getFlowDirections();
        List<String> other$flowDirections = other.getFlowDirections();
        if (this$flowDirections == null ? other$flowDirections != null : !((Object)this$flowDirections).equals(other$flowDirections)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethodDetails this$paymentMethodDetails = this.getPaymentMethodDetails();
        PaymentMethodDetails other$paymentMethodDetails = other.getPaymentMethodDetails();
        if (this$paymentMethodDetails == null ? other$paymentMethodDetails != null : !((Object)this$paymentMethodDetails).equals(other$paymentMethodDetails)) {
            return false;
        }
        StripeError this$setupError = this.getSetupError();
        StripeError other$setupError = other.getSetupError();
        if (this$setupError == null ? other$setupError != null : !((Object)this$setupError).equals(other$setupError)) {
            return false;
        }
        String this$setupIntent = this.getSetupIntent();
        String other$setupIntent = other.getSetupIntent();
        if (this$setupIntent == null ? other$setupIntent != null : !this$setupIntent.equals(other$setupIntent)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !this$usage.equals(other$usage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetupAttempt;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $attachToSelf = this.getAttachToSelf();
        result = result * 59 + ($attachToSelf == null ? 43 : ((Object)$attachToSelf).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        List<String> $flowDirections = this.getFlowDirections();
        result = result * 59 + ($flowDirections == null ? 43 : ((Object)$flowDirections).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        PaymentMethodDetails $paymentMethodDetails = this.getPaymentMethodDetails();
        result = result * 59 + ($paymentMethodDetails == null ? 43 : ((Object)$paymentMethodDetails).hashCode());
        StripeError $setupError = this.getSetupError();
        result = result * 59 + ($setupError == null ? 43 : ((Object)$setupError).hashCode());
        String $setupIntent = this.getSetupIntent();
        result = result * 59 + ($setupIntent == null ? 43 : $setupIntent.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class PaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="amazon_pay")
        AmazonPay amazonPay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="card_present")
        CardPresent cardPresent;
        @SerializedName(value="cashapp")
        Cashapp cashapp;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="kakao_pay")
        KakaoPay kakaoPay;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="kr_card")
        KrCard krCard;
        @SerializedName(value="link")
        Link link;
        @SerializedName(value="paypal")
        Paypal paypal;
        @SerializedName(value="revolut_pay")
        RevolutPay revolutPay;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public AmazonPay getAmazonPay() {
            return this.amazonPay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public CardPresent getCardPresent() {
            return this.cardPresent;
        }

        @Generated
        public Cashapp getCashapp() {
            return this.cashapp;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public KakaoPay getKakaoPay() {
            return this.kakaoPay;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public KrCard getKrCard() {
            return this.krCard;
        }

        @Generated
        public Link getLink() {
            return this.link;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public RevolutPay getRevolutPay() {
            return this.revolutPay;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setAmazonPay(AmazonPay amazonPay) {
            this.amazonPay = amazonPay;
        }

        @Generated
        public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
            this.auBecsDebit = auBecsDebit;
        }

        @Generated
        public void setBacsDebit(BacsDebit bacsDebit) {
            this.bacsDebit = bacsDebit;
        }

        @Generated
        public void setBancontact(Bancontact bancontact) {
            this.bancontact = bancontact;
        }

        @Generated
        public void setBoleto(Boleto boleto) {
            this.boleto = boleto;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setCardPresent(CardPresent cardPresent) {
            this.cardPresent = cardPresent;
        }

        @Generated
        public void setCashapp(Cashapp cashapp) {
            this.cashapp = cashapp;
        }

        @Generated
        public void setIdeal(Ideal ideal) {
            this.ideal = ideal;
        }

        @Generated
        public void setKakaoPay(KakaoPay kakaoPay) {
            this.kakaoPay = kakaoPay;
        }

        @Generated
        public void setKlarna(Klarna klarna) {
            this.klarna = klarna;
        }

        @Generated
        public void setKrCard(KrCard krCard) {
            this.krCard = krCard;
        }

        @Generated
        public void setLink(Link link) {
            this.link = link;
        }

        @Generated
        public void setPaypal(Paypal paypal) {
            this.paypal = paypal;
        }

        @Generated
        public void setRevolutPay(RevolutPay revolutPay) {
            this.revolutPay = revolutPay;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public void setSofort(Sofort sofort) {
            this.sofort = sofort;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodDetails)) {
                return false;
            }
            PaymentMethodDetails other = (PaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            AmazonPay this$amazonPay = this.getAmazonPay();
            AmazonPay other$amazonPay = other.getAmazonPay();
            if (this$amazonPay == null ? other$amazonPay != null : !((Object)this$amazonPay).equals(other$amazonPay)) {
                return false;
            }
            AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
            AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
                return false;
            }
            BacsDebit this$bacsDebit = this.getBacsDebit();
            BacsDebit other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
                return false;
            }
            Bancontact this$bancontact = this.getBancontact();
            Bancontact other$bancontact = other.getBancontact();
            if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                return false;
            }
            Boleto this$boleto = this.getBoleto();
            Boleto other$boleto = other.getBoleto();
            if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            CardPresent this$cardPresent = this.getCardPresent();
            CardPresent other$cardPresent = other.getCardPresent();
            if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
                return false;
            }
            Cashapp this$cashapp = this.getCashapp();
            Cashapp other$cashapp = other.getCashapp();
            if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
                return false;
            }
            Ideal this$ideal = this.getIdeal();
            Ideal other$ideal = other.getIdeal();
            if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
                return false;
            }
            KakaoPay this$kakaoPay = this.getKakaoPay();
            KakaoPay other$kakaoPay = other.getKakaoPay();
            if (this$kakaoPay == null ? other$kakaoPay != null : !((Object)this$kakaoPay).equals(other$kakaoPay)) {
                return false;
            }
            Klarna this$klarna = this.getKlarna();
            Klarna other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                return false;
            }
            KrCard this$krCard = this.getKrCard();
            KrCard other$krCard = other.getKrCard();
            if (this$krCard == null ? other$krCard != null : !((Object)this$krCard).equals(other$krCard)) {
                return false;
            }
            Link this$link = this.getLink();
            Link other$link = other.getLink();
            if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                return false;
            }
            Paypal this$paypal = this.getPaypal();
            Paypal other$paypal = other.getPaypal();
            if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
                return false;
            }
            RevolutPay this$revolutPay = this.getRevolutPay();
            RevolutPay other$revolutPay = other.getRevolutPay();
            if (this$revolutPay == null ? other$revolutPay != null : !((Object)this$revolutPay).equals(other$revolutPay)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            Sofort this$sofort = this.getSofort();
            Sofort other$sofort = other.getSofort();
            if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            AmazonPay $amazonPay = this.getAmazonPay();
            result = result * 59 + ($amazonPay == null ? 43 : ((Object)$amazonPay).hashCode());
            AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
            BacsDebit $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
            Bancontact $bancontact = this.getBancontact();
            result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
            Boleto $boleto = this.getBoleto();
            result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            CardPresent $cardPresent = this.getCardPresent();
            result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
            Cashapp $cashapp = this.getCashapp();
            result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
            Ideal $ideal = this.getIdeal();
            result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
            KakaoPay $kakaoPay = this.getKakaoPay();
            result = result * 59 + ($kakaoPay == null ? 43 : ((Object)$kakaoPay).hashCode());
            Klarna $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
            KrCard $krCard = this.getKrCard();
            result = result * 59 + ($krCard == null ? 43 : ((Object)$krCard).hashCode());
            Link $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
            Paypal $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
            RevolutPay $revolutPay = this.getRevolutPay();
            result = result * 59 + ($revolutPay == null ? 43 : ((Object)$revolutPay).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            Sofort $sofort = this.getSofort();
            result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            return result;
        }

        public static class AcssDebit
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class AmazonPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AmazonPay)) {
                    return false;
                }
                AmazonPay other = (AmazonPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AmazonPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class AuBecsDebit
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuBecsDebit)) {
                    return false;
                }
                AuBecsDebit other = (AuBecsDebit)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuBecsDebit;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class BacsDebit
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebit)) {
                    return false;
                }
                BacsDebit other = (BacsDebit)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebit;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Bancontact
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="generated_sepa_debit")
            ExpandableField<PaymentMethod> generatedSepaDebit;
            @SerializedName(value="generated_sepa_debit_mandate")
            ExpandableField<Mandate> generatedSepaDebitMandate;
            @SerializedName(value="iban_last4")
            String ibanLast4;
            @SerializedName(value="preferred_language")
            String preferredLanguage;
            @SerializedName(value="verified_name")
            String verifiedName;

            public String getGeneratedSepaDebit() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getId() : null;
            }

            public void setGeneratedSepaDebit(String id) {
                this.generatedSepaDebit = ApiResource.setExpandableFieldId(id, this.generatedSepaDebit);
            }

            public PaymentMethod getGeneratedSepaDebitObject() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getExpanded() : null;
            }

            public void setGeneratedSepaDebitObject(PaymentMethod expandableObject) {
                this.generatedSepaDebit = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
            }

            public String getGeneratedSepaDebitMandate() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getId() : null;
            }

            public void setGeneratedSepaDebitMandate(String id) {
                this.generatedSepaDebitMandate = ApiResource.setExpandableFieldId(id, this.generatedSepaDebitMandate);
            }

            public Mandate getGeneratedSepaDebitMandateObject() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getExpanded() : null;
            }

            public void setGeneratedSepaDebitMandateObject(Mandate expandableObject) {
                this.generatedSepaDebitMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getIbanLast4() {
                return this.ibanLast4;
            }

            @Generated
            public String getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setIbanLast4(String ibanLast4) {
                this.ibanLast4 = ibanLast4;
            }

            @Generated
            public void setPreferredLanguage(String preferredLanguage) {
                this.preferredLanguage = preferredLanguage;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bancontact)) {
                    return false;
                }
                Bancontact other = (Bancontact)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$generatedSepaDebit = this.getGeneratedSepaDebit();
                String other$generatedSepaDebit = other.getGeneratedSepaDebit();
                if (this$generatedSepaDebit == null ? other$generatedSepaDebit != null : !this$generatedSepaDebit.equals(other$generatedSepaDebit)) {
                    return false;
                }
                String this$generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                String other$generatedSepaDebitMandate = other.getGeneratedSepaDebitMandate();
                if (this$generatedSepaDebitMandate == null ? other$generatedSepaDebitMandate != null : !this$generatedSepaDebitMandate.equals(other$generatedSepaDebitMandate)) {
                    return false;
                }
                String this$ibanLast4 = this.getIbanLast4();
                String other$ibanLast4 = other.getIbanLast4();
                if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                    return false;
                }
                String this$preferredLanguage = this.getPreferredLanguage();
                String other$preferredLanguage = other.getPreferredLanguage();
                if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bancontact;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $generatedSepaDebit = this.getGeneratedSepaDebit();
                result = result * 59 + ($generatedSepaDebit == null ? 43 : $generatedSepaDebit.hashCode());
                String $generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                result = result * 59 + ($generatedSepaDebitMandate == null ? 43 : $generatedSepaDebitMandate.hashCode());
                String $ibanLast4 = this.getIbanLast4();
                result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
                String $preferredLanguage = this.getPreferredLanguage();
                result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class Boleto
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Boleto)) {
                    return false;
                }
                Boleto other = (Boleto)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Boleto;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="checks")
            Checks checks;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="description")
            String description;
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="funding")
            String funding;
            @SerializedName(value="iin")
            String iin;
            @SerializedName(value="issuer")
            String issuer;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="three_d_secure")
            ThreeDSecure threeDSecure;
            @SerializedName(value="wallet")
            Wallet wallet;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public Checks getChecks() {
                return this.checks;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public String getIin() {
                return this.iin;
            }

            @Generated
            public String getIssuer() {
                return this.issuer;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public ThreeDSecure getThreeDSecure() {
                return this.threeDSecure;
            }

            @Generated
            public Wallet getWallet() {
                return this.wallet;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setChecks(Checks checks) {
                this.checks = checks;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public void setIin(String iin) {
                this.iin = iin;
            }

            @Generated
            public void setIssuer(String issuer) {
                this.issuer = issuer;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setThreeDSecure(ThreeDSecure threeDSecure) {
                this.threeDSecure = threeDSecure;
            }

            @Generated
            public void setWallet(Wallet wallet) {
                this.wallet = wallet;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                Checks this$checks = this.getChecks();
                Checks other$checks = other.getChecks();
                if (this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                    return false;
                }
                String this$iin = this.getIin();
                String other$iin = other.getIin();
                if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                    return false;
                }
                String this$issuer = this.getIssuer();
                String other$issuer = other.getIssuer();
                if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                ThreeDSecure this$threeDSecure = this.getThreeDSecure();
                ThreeDSecure other$threeDSecure = other.getThreeDSecure();
                if (this$threeDSecure == null ? other$threeDSecure != null : !((Object)this$threeDSecure).equals(other$threeDSecure)) {
                    return false;
                }
                Wallet this$wallet = this.getWallet();
                Wallet other$wallet = other.getWallet();
                return !(this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                Checks $checks = this.getChecks();
                result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                String $iin = this.getIin();
                result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
                String $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                ThreeDSecure $threeDSecure = this.getThreeDSecure();
                result = result * 59 + ($threeDSecure == null ? 43 : ((Object)$threeDSecure).hashCode());
                Wallet $wallet = this.getWallet();
                result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
                return result;
            }

            public static class Checks
            extends StripeObject {
                @SerializedName(value="address_line1_check")
                String addressLine1Check;
                @SerializedName(value="address_postal_code_check")
                String addressPostalCodeCheck;
                @SerializedName(value="cvc_check")
                String cvcCheck;

                @Generated
                public String getAddressLine1Check() {
                    return this.addressLine1Check;
                }

                @Generated
                public String getAddressPostalCodeCheck() {
                    return this.addressPostalCodeCheck;
                }

                @Generated
                public String getCvcCheck() {
                    return this.cvcCheck;
                }

                @Generated
                public void setAddressLine1Check(String addressLine1Check) {
                    this.addressLine1Check = addressLine1Check;
                }

                @Generated
                public void setAddressPostalCodeCheck(String addressPostalCodeCheck) {
                    this.addressPostalCodeCheck = addressPostalCodeCheck;
                }

                @Generated
                public void setCvcCheck(String cvcCheck) {
                    this.cvcCheck = cvcCheck;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Checks)) {
                        return false;
                    }
                    Checks other = (Checks)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$addressLine1Check = this.getAddressLine1Check();
                    String other$addressLine1Check = other.getAddressLine1Check();
                    if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                        return false;
                    }
                    String this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                    String other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
                    if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) {
                        return false;
                    }
                    String this$cvcCheck = this.getCvcCheck();
                    String other$cvcCheck = other.getCvcCheck();
                    return !(this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Checks;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $addressLine1Check = this.getAddressLine1Check();
                    result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
                    String $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                    result = result * 59 + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
                    String $cvcCheck = this.getCvcCheck();
                    result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
                    return result;
                }
            }

            public static class ThreeDSecure
            extends StripeObject {
                @SerializedName(value="authentication_flow")
                String authenticationFlow;
                @SerializedName(value="electronic_commerce_indicator")
                String electronicCommerceIndicator;
                @SerializedName(value="result")
                String result;
                @SerializedName(value="result_reason")
                String resultReason;
                @SerializedName(value="transaction_id")
                String transactionId;
                @SerializedName(value="version")
                String version;

                @Generated
                public String getAuthenticationFlow() {
                    return this.authenticationFlow;
                }

                @Generated
                public String getElectronicCommerceIndicator() {
                    return this.electronicCommerceIndicator;
                }

                @Generated
                public String getResult() {
                    return this.result;
                }

                @Generated
                public String getResultReason() {
                    return this.resultReason;
                }

                @Generated
                public String getTransactionId() {
                    return this.transactionId;
                }

                @Generated
                public String getVersion() {
                    return this.version;
                }

                @Generated
                public void setAuthenticationFlow(String authenticationFlow) {
                    this.authenticationFlow = authenticationFlow;
                }

                @Generated
                public void setElectronicCommerceIndicator(String electronicCommerceIndicator) {
                    this.electronicCommerceIndicator = electronicCommerceIndicator;
                }

                @Generated
                public void setResult(String result) {
                    this.result = result;
                }

                @Generated
                public void setResultReason(String resultReason) {
                    this.resultReason = resultReason;
                }

                @Generated
                public void setTransactionId(String transactionId) {
                    this.transactionId = transactionId;
                }

                @Generated
                public void setVersion(String version) {
                    this.version = version;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ThreeDSecure)) {
                        return false;
                    }
                    ThreeDSecure other = (ThreeDSecure)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$authenticationFlow = this.getAuthenticationFlow();
                    String other$authenticationFlow = other.getAuthenticationFlow();
                    if (this$authenticationFlow == null ? other$authenticationFlow != null : !this$authenticationFlow.equals(other$authenticationFlow)) {
                        return false;
                    }
                    String this$electronicCommerceIndicator = this.getElectronicCommerceIndicator();
                    String other$electronicCommerceIndicator = other.getElectronicCommerceIndicator();
                    if (this$electronicCommerceIndicator == null ? other$electronicCommerceIndicator != null : !this$electronicCommerceIndicator.equals(other$electronicCommerceIndicator)) {
                        return false;
                    }
                    String this$result = this.getResult();
                    String other$result = other.getResult();
                    if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                        return false;
                    }
                    String this$resultReason = this.getResultReason();
                    String other$resultReason = other.getResultReason();
                    if (this$resultReason == null ? other$resultReason != null : !this$resultReason.equals(other$resultReason)) {
                        return false;
                    }
                    String this$transactionId = this.getTransactionId();
                    String other$transactionId = other.getTransactionId();
                    if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
                        return false;
                    }
                    String this$version = this.getVersion();
                    String other$version = other.getVersion();
                    return !(this$version == null ? other$version != null : !this$version.equals(other$version));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ThreeDSecure;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $authenticationFlow = this.getAuthenticationFlow();
                    result = result * 59 + ($authenticationFlow == null ? 43 : $authenticationFlow.hashCode());
                    String $electronicCommerceIndicator = this.getElectronicCommerceIndicator();
                    result = result * 59 + ($electronicCommerceIndicator == null ? 43 : $electronicCommerceIndicator.hashCode());
                    String $result = this.getResult();
                    result = result * 59 + ($result == null ? 43 : $result.hashCode());
                    String $resultReason = this.getResultReason();
                    result = result * 59 + ($resultReason == null ? 43 : $resultReason.hashCode());
                    String $transactionId = this.getTransactionId();
                    result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
                    String $version = this.getVersion();
                    result = result * 59 + ($version == null ? 43 : $version.hashCode());
                    return result;
                }
            }

            public static class Wallet
            extends StripeObject {
                @SerializedName(value="apple_pay")
                ApplePay applePay;
                @SerializedName(value="google_pay")
                GooglePay googlePay;
                @SerializedName(value="type")
                String type;

                @Generated
                public ApplePay getApplePay() {
                    return this.applePay;
                }

                @Generated
                public GooglePay getGooglePay() {
                    return this.googlePay;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setApplePay(ApplePay applePay) {
                    this.applePay = applePay;
                }

                @Generated
                public void setGooglePay(GooglePay googlePay) {
                    this.googlePay = googlePay;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Wallet)) {
                        return false;
                    }
                    Wallet other = (Wallet)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    ApplePay this$applePay = this.getApplePay();
                    ApplePay other$applePay = other.getApplePay();
                    if (this$applePay == null ? other$applePay != null : !((Object)this$applePay).equals(other$applePay)) {
                        return false;
                    }
                    GooglePay this$googlePay = this.getGooglePay();
                    GooglePay other$googlePay = other.getGooglePay();
                    if (this$googlePay == null ? other$googlePay != null : !((Object)this$googlePay).equals(other$googlePay)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Wallet;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    ApplePay $applePay = this.getApplePay();
                    result = result * 59 + ($applePay == null ? 43 : ((Object)$applePay).hashCode());
                    GooglePay $googlePay = this.getGooglePay();
                    result = result * 59 + ($googlePay == null ? 43 : ((Object)$googlePay).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }

                public static class ApplePay
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ApplePay)) {
                            return false;
                        }
                        ApplePay other = (ApplePay)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof ApplePay;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }

                public static class GooglePay
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof GooglePay)) {
                            return false;
                        }
                        GooglePay other = (GooglePay)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof GooglePay;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }
            }
        }

        public static class CardPresent
        extends StripeObject {
            @SerializedName(value="generated_card")
            ExpandableField<PaymentMethod> generatedCard;
            @SerializedName(value="offline")
            Offline offline;

            public String getGeneratedCard() {
                return this.generatedCard != null ? this.generatedCard.getId() : null;
            }

            public void setGeneratedCard(String id) {
                this.generatedCard = ApiResource.setExpandableFieldId(id, this.generatedCard);
            }

            public PaymentMethod getGeneratedCardObject() {
                return this.generatedCard != null ? this.generatedCard.getExpanded() : null;
            }

            public void setGeneratedCardObject(PaymentMethod expandableObject) {
                this.generatedCard = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public Offline getOffline() {
                return this.offline;
            }

            @Generated
            public void setOffline(Offline offline) {
                this.offline = offline;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardPresent)) {
                    return false;
                }
                CardPresent other = (CardPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$generatedCard = this.getGeneratedCard();
                String other$generatedCard = other.getGeneratedCard();
                if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) {
                    return false;
                }
                Offline this$offline = this.getOffline();
                Offline other$offline = other.getOffline();
                return !(this$offline == null ? other$offline != null : !((Object)this$offline).equals(other$offline));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $generatedCard = this.getGeneratedCard();
                result = result * 59 + ($generatedCard == null ? 43 : $generatedCard.hashCode());
                Offline $offline = this.getOffline();
                result = result * 59 + ($offline == null ? 43 : ((Object)$offline).hashCode());
                return result;
            }

            public static class Offline
            extends StripeObject {
                @SerializedName(value="stored_at")
                Long storedAt;
                @SerializedName(value="type")
                String type;

                @Generated
                public Long getStoredAt() {
                    return this.storedAt;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setStoredAt(Long storedAt) {
                    this.storedAt = storedAt;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Offline)) {
                        return false;
                    }
                    Offline other = (Offline)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$storedAt = this.getStoredAt();
                    Long other$storedAt = other.getStoredAt();
                    if (this$storedAt == null ? other$storedAt != null : !((Object)this$storedAt).equals(other$storedAt)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Offline;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $storedAt = this.getStoredAt();
                    result = result * 59 + ($storedAt == null ? 43 : ((Object)$storedAt).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }
        }

        public static class Cashapp
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cashapp)) {
                    return false;
                }
                Cashapp other = (Cashapp)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cashapp;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Ideal
        extends StripeObject {
            @SerializedName(value="bank")
            String bank;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="generated_sepa_debit")
            ExpandableField<PaymentMethod> generatedSepaDebit;
            @SerializedName(value="generated_sepa_debit_mandate")
            ExpandableField<Mandate> generatedSepaDebitMandate;
            @SerializedName(value="iban_last4")
            String ibanLast4;
            @SerializedName(value="verified_name")
            String verifiedName;

            public String getGeneratedSepaDebit() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getId() : null;
            }

            public void setGeneratedSepaDebit(String id) {
                this.generatedSepaDebit = ApiResource.setExpandableFieldId(id, this.generatedSepaDebit);
            }

            public PaymentMethod getGeneratedSepaDebitObject() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getExpanded() : null;
            }

            public void setGeneratedSepaDebitObject(PaymentMethod expandableObject) {
                this.generatedSepaDebit = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
            }

            public String getGeneratedSepaDebitMandate() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getId() : null;
            }

            public void setGeneratedSepaDebitMandate(String id) {
                this.generatedSepaDebitMandate = ApiResource.setExpandableFieldId(id, this.generatedSepaDebitMandate);
            }

            public Mandate getGeneratedSepaDebitMandateObject() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getExpanded() : null;
            }

            public void setGeneratedSepaDebitMandateObject(Mandate expandableObject) {
                this.generatedSepaDebitMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getIbanLast4() {
                return this.ibanLast4;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setIbanLast4(String ibanLast4) {
                this.ibanLast4 = ibanLast4;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ideal)) {
                    return false;
                }
                Ideal other = (Ideal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$generatedSepaDebit = this.getGeneratedSepaDebit();
                String other$generatedSepaDebit = other.getGeneratedSepaDebit();
                if (this$generatedSepaDebit == null ? other$generatedSepaDebit != null : !this$generatedSepaDebit.equals(other$generatedSepaDebit)) {
                    return false;
                }
                String this$generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                String other$generatedSepaDebitMandate = other.getGeneratedSepaDebitMandate();
                if (this$generatedSepaDebitMandate == null ? other$generatedSepaDebitMandate != null : !this$generatedSepaDebitMandate.equals(other$generatedSepaDebitMandate)) {
                    return false;
                }
                String this$ibanLast4 = this.getIbanLast4();
                String other$ibanLast4 = other.getIbanLast4();
                if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ideal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $generatedSepaDebit = this.getGeneratedSepaDebit();
                result = result * 59 + ($generatedSepaDebit == null ? 43 : $generatedSepaDebit.hashCode());
                String $generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                result = result * 59 + ($generatedSepaDebitMandate == null ? 43 : $generatedSepaDebitMandate.hashCode());
                String $ibanLast4 = this.getIbanLast4();
                result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class KakaoPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KakaoPay)) {
                    return false;
                }
                KakaoPay other = (KakaoPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KakaoPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Klarna
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class KrCard
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KrCard)) {
                    return false;
                }
                KrCard other = (KrCard)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KrCard;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Link
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Link)) {
                    return false;
                }
                Link other = (Link)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Link;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Paypal
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class RevolutPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RevolutPay)) {
                    return false;
                }
                RevolutPay other = (RevolutPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RevolutPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class SepaDebit
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Sofort
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="generated_sepa_debit")
            ExpandableField<PaymentMethod> generatedSepaDebit;
            @SerializedName(value="generated_sepa_debit_mandate")
            ExpandableField<Mandate> generatedSepaDebitMandate;
            @SerializedName(value="iban_last4")
            String ibanLast4;
            @SerializedName(value="preferred_language")
            String preferredLanguage;
            @SerializedName(value="verified_name")
            String verifiedName;

            public String getGeneratedSepaDebit() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getId() : null;
            }

            public void setGeneratedSepaDebit(String id) {
                this.generatedSepaDebit = ApiResource.setExpandableFieldId(id, this.generatedSepaDebit);
            }

            public PaymentMethod getGeneratedSepaDebitObject() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getExpanded() : null;
            }

            public void setGeneratedSepaDebitObject(PaymentMethod expandableObject) {
                this.generatedSepaDebit = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
            }

            public String getGeneratedSepaDebitMandate() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getId() : null;
            }

            public void setGeneratedSepaDebitMandate(String id) {
                this.generatedSepaDebitMandate = ApiResource.setExpandableFieldId(id, this.generatedSepaDebitMandate);
            }

            public Mandate getGeneratedSepaDebitMandateObject() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getExpanded() : null;
            }

            public void setGeneratedSepaDebitMandateObject(Mandate expandableObject) {
                this.generatedSepaDebitMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getIbanLast4() {
                return this.ibanLast4;
            }

            @Generated
            public String getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setIbanLast4(String ibanLast4) {
                this.ibanLast4 = ibanLast4;
            }

            @Generated
            public void setPreferredLanguage(String preferredLanguage) {
                this.preferredLanguage = preferredLanguage;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sofort)) {
                    return false;
                }
                Sofort other = (Sofort)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$generatedSepaDebit = this.getGeneratedSepaDebit();
                String other$generatedSepaDebit = other.getGeneratedSepaDebit();
                if (this$generatedSepaDebit == null ? other$generatedSepaDebit != null : !this$generatedSepaDebit.equals(other$generatedSepaDebit)) {
                    return false;
                }
                String this$generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                String other$generatedSepaDebitMandate = other.getGeneratedSepaDebitMandate();
                if (this$generatedSepaDebitMandate == null ? other$generatedSepaDebitMandate != null : !this$generatedSepaDebitMandate.equals(other$generatedSepaDebitMandate)) {
                    return false;
                }
                String this$ibanLast4 = this.getIbanLast4();
                String other$ibanLast4 = other.getIbanLast4();
                if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                    return false;
                }
                String this$preferredLanguage = this.getPreferredLanguage();
                String other$preferredLanguage = other.getPreferredLanguage();
                if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sofort;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $generatedSepaDebit = this.getGeneratedSepaDebit();
                result = result * 59 + ($generatedSepaDebit == null ? 43 : $generatedSepaDebit.hashCode());
                String $generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                result = result * 59 + ($generatedSepaDebitMandate == null ? 43 : $generatedSepaDebitMandate.hashCode());
                String $ibanLast4 = this.getIbanLast4();
                result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
                String $preferredLanguage = this.getPreferredLanguage();
                result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }
    }
}

